/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractOrphanObjectTool;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.management.metadata.tools.OrphanObjectComponentInterface;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class OrphanedAces
extends AbstractOrphanObjectTool
implements OrphanObjectComponentInterface {
    private static final WAdminResource bundle = new WAdminResource(OrphanedAces.class);
    private static final String TOOLNAME = bundle.getString("OrphanedAces.tool.name");
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><AccessControlEntry Name=\"\"><Objects/><AccessControlTemplates/><Permissions/><Identities/></AccessControlEntry></TEMPLATES>";
    static AnalyzeTool _factoryInstance;
    private int _objectandactCount = 0;
    private int _permissionsCount = 0;
    private int _identitiesCount = 0;

    public static AnalyzeTool getInstance() {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanedAces(null, null);
        }
        return _factoryInstance;
    }

    private OrphanedAces(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalyzeTool newInstance(OMIRepositoryInterface repository, Logger log) {
        OrphanedAces newObject = new OrphanedAces(repository, log);
        return newObject;
    }

    @Override
    public String getDescription() {
        return bundle.getString("OrphanedAces.tool.desc");
    }

    @Override
    public String getMnemonic() {
        return "OrphAce";
    }

    @Override
    public String getName() {
        return TOOLNAME;
    }

    @Override
    public String getLabel() {
        return bundle.getString("OrphanedAces.tool.label");
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getXMLSelectString() {
        return null;
    }

    @Override
    public String getMetadataType() {
        return "AccessControlEntry";
    }

    @Override
    public String getRepairTemplate() {
        return null;
    }

    @Override
    public boolean isOrphan(Map objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        boolean orphan = false;
        List objectsAssocList = (List)objectMap.get("Objects");
        List actsAssocList = (List)objectMap.get("AccessControlTemplates");
        if (!(objectsAssocList != null && objectsAssocList.size() != 0 || actsAssocList != null && actsAssocList.size() != 0)) {
            if (this.isFinalSearch()) {
                ++this._objectandactCount;
            }
            orphan = true;
        } else {
            List permissionsAssocList = (List)objectMap.get("Permissions");
            List identitiesAssocList = (List)objectMap.get("Identities");
            if (permissionsAssocList == null || permissionsAssocList.size() == 0 || identitiesAssocList == null || identitiesAssocList.size() == 0) {
                if (this.isFinalSearch()) {
                    if (permissionsAssocList != null && permissionsAssocList.size() == 0) {
                        ++this._permissionsCount;
                    } else {
                        ++this._identitiesCount;
                    }
                }
                orphan = true;
            }
        }
        return orphan;
    }

    @Override
    public AnalyzeTool getParentAnalyzeTool() {
        return this;
    }

    @Override
    public void analysisSetup() {
        this._objectandactCount = 0;
        this._permissionsCount = 0;
        this._identitiesCount = 0;
    }

    @Override
    public void analysisTearDown() {
        if (this._objectandactCount > 0) {
            this._log.warn(bundle.formatString("OrphanedAces.Analyze.OrphanObjCount.txt", (Object)this._objectandactCount));
        }
        if (this._permissionsCount > 0) {
            this._log.warn(bundle.formatString("OrphanedAces.Analyze.OrphanPermissionCount.txt", (Object)this._permissionsCount));
        }
        if (this._identitiesCount > 0) {
            this._log.warn(bundle.formatString("OrphanedAces.Analyze.OrphanIdentitiesCount.txt", (Object)this._identitiesCount));
        }
    }
}

