/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.Logger;

public abstract class AbstractToolImpl
implements AnalyzeTool {
    private static final WAdminResource bundle = new WAdminResource(AbstractToolImpl.class);
    private static final ImageIcon ICON = bundle.getImageIcon("AbstractToolImpl.tool.image");
    OMIRepositoryInterface _repository;
    Logger _log;
    int _rc = -1;
    boolean _isRepairNeeded = false;
    boolean _cancelPending = false;
    MdFactory _factory;
    MdOMIUtil _OMIUtil;
    MdObjectStore _store;

    AbstractToolImpl() {
    }

    AbstractToolImpl(OMIRepositoryInterface repository, Logger log) {
        this._repository = repository;
        this._log = log;
    }

    @Override
    public int getReturnCode() {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        return this._rc;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public OMIRepositoryInterface getRepository() {
        return this._repository;
    }

    @Override
    public boolean isRepairNeeded() {
        return this._isRepairNeeded;
    }

    @Override
    public boolean isRepairSupported() {
        return false;
    }

    @Override
    public void repair() throws ServiceException {
        throw new UnsupportedOperationException("This tool does not support repair.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        AbstractToolImpl abstractToolImpl = this;
        synchronized (abstractToolImpl) {
            this._cancelPending = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acceptCancel() {
        AbstractToolImpl abstractToolImpl = this;
        synchronized (abstractToolImpl) {
            this._cancelPending = false;
            this._rc = 4;
        }
    }

    @Override
    public void fail() {
        this._rc = 8;
    }

    @Override
    public void release() {
        this.releaseObjectStore();
    }

    @Override
    public boolean requiresServices() {
        return false;
    }

    protected void createObjectStore() throws ServiceException, RemoteException {
        this._factory = ((OMIServer)this._repository.getServer()).getMdFactory();
        this._OMIUtil = this._factory.getOMIUtil();
        if (this._store == null) {
            this._store = this._factory.createObjectStore(null, "AnalyzeRepairStore: " + this.getName());
        }
    }

    protected void releaseObjectStore() {
        try {
            if (this._store != null) {
                this._store.dispose();
                this._store = null;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

