/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractToolImpl;
import com.sas.management.metadata.tools.OrphanObjectComponentInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public abstract class AbstractOrphanObjectTool
extends AbstractToolImpl {
    private static final WAdminResource bundle = new WAdminResource(AbstractOrphanObjectTool.class);
    protected int _processCount = 10000;
    private boolean _isSecondarySearchNeeded = false;
    private boolean _isSecondarySearch = false;
    private Map _componentMap = new LinkedHashMap(3);
    protected Map _exclusionMap;

    protected AbstractOrphanObjectTool(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
        if (this instanceof OrphanObjectComponentInterface) {
            this.addOrphanComponent((OrphanObjectComponentInterface)((Object)this));
        }
    }

    protected void addOrphanComponent(OrphanObjectComponentInterface comp) {
        this._componentMap.put(comp, null);
    }

    protected Set getOrphanComponents() {
        return this._componentMap.keySet();
    }

    @Override
    public String getGroup() {
        return "Usage";
    }

    @Override
    public boolean isRepairSupported() {
        return true;
    }

    public void setProcessCount(int count) {
        this._processCount = count;
    }

    public void analysisSetup() {
    }

    public void analysisTearDown() {
    }

    protected void addExclusions(OrphanObjectComponentInterface comp, Set exclusionSet) {
        if (this._exclusionMap == null) {
            this._exclusionMap = new HashMap();
        }
        if (this._exclusionMap.containsKey(comp)) {
            Set ids = (Set)this._exclusionMap.get(comp);
            ids.addAll(exclusionSet);
        } else {
            this._exclusionMap.put(comp, exclusionSet);
        }
    }

    private boolean canAnalyzeObject(OrphanObjectComponentInterface comp, String objectID) {
        if (this._exclusionMap == null) {
            return true;
        }
        Set exclusionSet = (Set)this._exclusionMap.get(comp);
        return exclusionSet == null ? true : !exclusionSet.contains(objectID);
    }

    @Override
    public void analyze() throws ServiceException {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        this._rc = 0;
        try {
            this.createObjectStore();
            this.analysisSetup();
            this.setSearchDetails();
            for (OrphanObjectComponentInterface comp : this._componentMap.keySet()) {
                this.analyzeOrphanComponent(comp);
            }
            this.analysisTearDown();
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this._log.error(bundle.getString("AbstractOrphanObjectTool.Analyze.OutOfMemory.txt"));
            this._rc |= 8;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            this.releaseObjectStore();
        }
    }

    private void analyzeOrphanComponent(OrphanObjectComponentInterface comp) throws MdException, RemoteException {
        long t0 = 0L;
        long t1 = 0L;
        if (this._log.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        this._log.info(bundle.formatString("AbstractOrphanObjectTool.Analyze.Objects.fmt.txt", (Object)comp.getLabel()));
        int flags = 0;
        String options = comp.getXMLSelectString();
        if (options == null) {
            options = "";
        } else {
            flags |= 0x80;
        }
        List objectList = this._factory.getOMIUtil().getMetadataObjectsNoCache(comp.getMetadataType(), this._repository.getDefaultRepositoryId(), options, flags);
        if (objectList == null || objectList.size() == 0) {
            String msg = bundle.formatString("AbstractOrphanObjectTool.Analyze.NotFound.fmt.txt", (Object)comp.getLabel());
            this._log.info(msg);
            this._rc |= 0;
            return;
        }
        int objectCount = objectList.size();
        this._log.info(bundle.formatString("AbstractOrphanObjectTool.Analyze.TotalFound.fmt.txt", (Object)new Integer(objectCount), (Object)comp.getLabel()));
        if (this._log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
            this._log.debug("Time to get all objects from server: " + (double)(t1 - t0) / 1000.0 + " seconds");
        }
        LinkedHashMap fetchList = new LinkedHashMap(Math.min(objectCount, this._processCount) + 1, 1.0f);
        int counter = 0;
        for (int index = 0; index < objectCount; ++index) {
            Map map = (Map)objectList.get(index);
            String objectID = (String)map.get("Id");
            if (!this.canAnalyzeObject(comp, objectID)) continue;
            fetchList.put(objectID, map.get("MetadataObjectType"));
            if (++counter != this._processCount) continue;
            List objects = this.analyzeObjects(comp, fetchList);
            this.addOrphanObjects(comp, objects);
            counter = 0;
            fetchList.clear();
        }
        if (fetchList.size() > 0) {
            List objects = this.analyzeObjects(comp, fetchList);
            this.addOrphanObjects(comp, objects);
        }
        if (this.hasOrphans(comp)) {
            Integer total = this.getOrphanCount(comp);
            String msg = bundle.formatString("AbstractOrphanObjectTool.Analyze.OrphansFound.fmt.txt", (Object)total, (Object)comp.getLabel(), (Object)this._repository.getDefaultRepositoryName());
            this._log.warn(msg);
            this._rc |= 2;
            this._isRepairNeeded = true;
        } else {
            String msg = bundle.formatString("AbstractOrphanObjectTool.Analyze.NoOrphans.fmt.txt", (Object)comp.getLabel(), (Object)this._repository.getDefaultRepositoryName());
            this._log.info(msg);
            this._rc |= 0;
        }
        fetchList.clear();
        objectList.clear();
        if (this._log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            this._log.debug("Total analysis time: " + (double)(end - t0) / 1000.0 + " seconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List analyzeObjects(OrphanObjectComponentInterface comp, Map objectMap) throws MdException, RemoteException {
        List orphans;
        long t0 = 0L;
        long t1 = 0L;
        if (this._log.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if ((orphans = this.searchForOrphans(comp, objectMap, false)).size() > 0 && this.isSecondarySearchNeeded()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Running secondary search to find orphans");
            }
            try {
                this._isSecondarySearch = true;
                LinkedHashMap<String, String> secObjectMap = new LinkedHashMap<String, String>(orphans.size());
                for (String orphanID : orphans) {
                    secObjectMap.put(orphanID, comp.getMetadataType());
                }
                orphans = this.searchForOrphans(comp, secObjectMap, true);
            }
            finally {
                this._isSecondarySearch = false;
            }
        }
        if (this._log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
            this._log.debug("Time to analyze " + objectMap.size() + " objects: " + (double)(t1 - t0) / 1000.0 + " seconds");
        }
        return orphans;
    }

    private List searchForOrphans(OrphanObjectComponentInterface comp, Map objectMap, boolean searchAllRepositories) throws MdException, RemoteException {
        String template;
        ArrayList<String> orphans = new ArrayList<String>();
        int flags = 526592;
        if (searchAllRepositories) {
            flags |= 0x4000;
        }
        if ((template = comp.getAnalyzeTemplate()) == null) {
            template = "";
            flags |= 1;
        } else {
            flags |= 4;
        }
        List objects = this._factory.getOMIUtil().getMetadataNoCache(objectMap, template, flags);
        if (objects != null && objects.size() > 0) {
            int length = objects.size();
            for (int i = 0; i < length; ++i) {
                String name;
                boolean orphaned;
                Map map = (Map)objects.get(i);
                String id = (String)map.get("Id");
                if (id == null || !(orphaned = comp.isOrphan(map))) continue;
                orphans.add(id);
                if (!this._log.isDebugEnabled() || this.getOrphanCount(comp) > 100 || orphans.size() > 100 || !this.isFinalSearch() || (name = (String)map.get("Name")) == null) continue;
                this._log.debug("Found orphaned " + comp.getLabel() + ": " + name + " (" + id + ")");
            }
            objects.clear();
            objects = null;
        }
        return orphans;
    }

    private void setSearchDetails() throws ServiceException, RemoteException {
        ServerInterface server;
        List reposList;
        if (!"PROJECT".equalsIgnoreCase(this._repository.getRepositoryType()) && (reposList = (server = this._repository.getServer()).getRepositories(true)) != null && reposList.size() > 1) {
            for (OMIRepositoryInterface repos : reposList) {
                if (!"PROJECT".equalsIgnoreCase(repos.getRepositoryType())) continue;
                this._isSecondarySearchNeeded = true;
                return;
            }
        }
        this._isSecondarySearchNeeded = false;
    }

    private boolean isSecondarySearchNeeded() {
        return this._isSecondarySearchNeeded;
    }

    protected boolean isFinalSearch() {
        return this.isSecondarySearchNeeded() ? this._isSecondarySearch : true;
    }

    public boolean containsAssociations(Map objectMap) {
        if (objectMap != null) {
            for (Object value : objectMap.values()) {
                List assoc;
                if (!(value instanceof List) || (assoc = (List)value).size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private void addOrphanObjects(OrphanObjectComponentInterface comp, List objects) {
        ArrayList totalOrphans = (ArrayList)this._componentMap.get(comp);
        if (totalOrphans == null) {
            totalOrphans = new ArrayList();
            this._componentMap.put(comp, totalOrphans);
        }
        totalOrphans.addAll(objects);
    }

    private boolean hasOrphans(OrphanObjectComponentInterface comp) {
        return this.getOrphanCount(comp) > 0;
    }

    private List getOrphans(OrphanObjectComponentInterface comp) {
        return (List)this._componentMap.get(comp);
    }

    private int getOrphanCount(OrphanObjectComponentInterface comp) {
        List totalOrphans = this.getOrphans(comp);
        return totalOrphans != null ? totalOrphans.size() : 0;
    }

    @Override
    public void repair() throws ServiceException {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        if (this._rc == -1) {
            this.analyze();
        } else {
            this._rc = 0;
        }
        try {
            if (!this._isRepairNeeded) {
                String msg = bundle.formatString("AbstractOrphanObjectTool.Repair.NoRepairRequired.fmt.txt", (Object)this.getName(), (Object)this._repository.getDefaultRepositoryName());
                this._log.info(msg);
                return;
            }
            for (OrphanObjectComponentInterface comp : this._componentMap.keySet()) {
                this.repairOrphanComponent(comp);
            }
        }
        catch (MdException e) {
            String msg = bundle.formatString("AbstractOrphanObjectTool.Repair.DeleteFailure.fmt.txt", (Object)this.getName(), (Object)e.getMessage());
            this._log.error(msg);
            this._rc |= 8;
            throw new ServiceException((Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this._log.error(bundle.getString("AbstractOrphanObjectTool.Repair.OutOfMemory.txt"));
            this._rc |= 8;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void repairOrphanComponent(OrphanObjectComponentInterface comp) throws MdException, RemoteException {
        if (!this.hasOrphans(comp)) return;
        ArrayList<ErrorCondition> conditions = new ArrayList<ErrorCondition>();
        int deletedCount = 0;
        this._log.info(bundle.formatString("AbstractOrphanObjectTool.Repair.Objects.fmt.txt", (Object)comp.getLabel()));
        String metadataType = comp.getMetadataType();
        String template = comp.getRepairTemplate();
        List orphans = this.getOrphans(comp);
        try {
            for (String orphanID : orphans) {
                if (orphanID == null) continue;
                try {
                    boolean deleted = this.deleteObject(orphanID, metadataType, template);
                    if (deleted) {
                        ++deletedCount;
                        continue;
                    }
                    if (!this._log.isDebugEnabled()) continue;
                    this._log.debug("The object " + orphanID + " (" + metadataType + ") was not deleted, probably because it wasn't found on the server.");
                }
                catch (Exception e) {
                    String name = this.getObjectName(orphanID, metadataType);
                    conditions.add(new ErrorCondition(orphanID, metadataType, name, e.getLocalizedMessage()));
                    if (conditions.size() <= 100) continue;
                    throw new IllegalStateException(bundle.getString("AbstractOrphanObjectTool.Repair.Abort.txt"));
                    return;
                }
            }
        }
        finally {
            String msg = bundle.formatString("AbstractOrphanObjectTool.Repair.Results.fmt.txt", (Object)comp.getLabel(), (Object)new Integer(deletedCount));
            this._log.info(msg);
            if (conditions.size() > 0) {
                this._log.warn(bundle.formatString("AbstractOrphanObjectTool.Repair.NumFailed.fmt.txt", (Object)new Integer(conditions.size())));
                for (ErrorCondition cond : conditions) {
                    String warnMsg = bundle.formatString("AbstractOrphanObjectTool.Repair.ObjectDeleteFailure.fmt.txt", (Object)cond.getMetadataType(), (Object)cond.getName(), (Object)cond.getObjectID(), (Object)cond.getReason());
                    this._log.warn(warnMsg);
                }
                this._rc |= 2;
            } else {
                this._rc |= 0;
            }
        }
    }

    private String getObjectName(String id, String metadataType) {
        ArrayList<String> attrs = new ArrayList<String>(1);
        attrs.add("Name");
        try {
            CMetadata meta = this._factory.getOMIUtil().getMetadataAllDepths((MdStore)this._store, metadataType, id, attrs, null, "", 0);
            return meta.getName();
        }
        catch (Exception e) {
            this._log.debug("Failure retrieving object name");
            return "";
        }
    }

    protected boolean deleteObject(String id, String metadataType, String template) throws RemoteException, MdException {
        List deletedList = this._factory.getOMIUtil().deleteMetadataObject(metadataType, id, template);
        return deletedList != null && deletedList.size() > 0;
    }

    class ErrorCondition {
        String id = null;
        String metadataType = null;
        String name = null;
        String reason = null;

        public ErrorCondition(String id, String type, String name, String reason) {
            this.id = id;
            this.metadataType = type;
            this.name = name;
            this.reason = reason;
        }

        public String getObjectID() {
            return this.id;
        }

        public String getMetadataType() {
            return this.metadataType;
        }

        public String getName() {
            return this.name;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

