/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.AbstractExtension;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Change;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.NumericExtension;
import com.sas.metadata.remote.Permission;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.TypeDefinition;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.services.deployment.ServiceDeploymentDeleter;
import com.sas.workspace.Repository;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.mgmt.RepositoryUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class UpgradeUtility {
    protected static WAdminResource bundle = new WAdminResource(UpgradeUtility.class);
    private static final String RMGR_ID = "A0000001.A0000001";
    private static final String RMGR_LIBREF = "rposmgr";
    private static final String LOGICAL_TABLESERVER_TYPE = "LogicalServer.TableServer";
    private static final String ANALYTICS_PARENT_TREE = "SAS Analytics Platform";
    static final int UPGRADEREQUEST = 0;
    static final int INPLACEUPGRADEREQUEST = 1;
    static final int CLEANUPREQUEST = 2;
    static final int FORCEINPLACEUPGRADEREQUEST = 4;
    private Logger _log = null;
    private MdFactory _factory = null;
    private MdOMIUtil _omiUtil = null;
    static final int SUCCESS = 0;
    static final int WARNING = 4;
    static final int ERROR = 8;
    static UpgradeUtility _theInstance = null;
    private static final String REPL_HEADER = "<ReplicateMetadata> \n  <Metadata>\n";
    private static final String REPL_TRAILER = "  </Metadata> \n  <NS>REPOS</NS>\n  <Flags>268435456</Flags>\n  <Options><UPGRADE/></Options>\n</ReplicateMetadata>\n";
    private static final String REPL_INPLACE_TRAILER = "  </Metadata> \n  <NS>REPOS</NS>\n  <Flags>268435456</Flags>\n  <Options><INPLACEUPGRADE/></Options>\n</ReplicateMetadata>\n";
    private static final String REPL_FORCE_INPLACE_TRAILER = "  </Metadata> \n  <NS>REPOS</NS>\n  <Flags>268435456</Flags>\n  <Options><FORCEUPGRADE/></Options>\n</ReplicateMetadata>\n";
    private static final String CLEANUP_TRAILER = "  </Metadata> \n  <NS>REPOS</NS>\n  <Flags>268435456</Flags>\n  <Options><CLEANUP/></Options>\n</ReplicateMetadata>\n";
    static final int ORACLE = 1;
    static final int DB2 = 2;
    static final int FIREBIRD = 3;

    private UpgradeUtility(MdFactory factory, Logger log) {
        this._log = log;
        this._factory = factory;
        try {
            this._omiUtil = factory.getOMIUtil();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static UpgradeUtility getInstance(MdFactory factory, Logger log) {
        if (_theInstance == null || factory != UpgradeUtility._theInstance._factory || log != UpgradeUtility._theInstance._log) {
            _theInstance = new UpgradeUtility(factory, log);
        }
        return _theInstance;
    }

    Repository[] getUpgradeableRepositories(MdOMRConnection metaWorkspace, IServer m_server, Repository[] reposArray) throws Exception {
        ArrayList<Repository> upgradeList = new ArrayList<Repository>();
        int modelVersion = this.convertModelVersionToInteger(metaWorkspace.getServerModelVersion(m_server));
        if (modelVersion == -1) {
            return null;
        }
        for (Repository rep : reposArray) {
            if (rep.getPauseState().equalsIgnoreCase("OFFLINE")) {
                this._log.warn(bundle.formatString("UpgradeUtility.SkippingOfflineRepository.fmt.txt", (Object)rep.getName(), (Object)rep.getFQID()));
                continue;
            }
            if (rep.getPauseState().equalsIgnoreCase("READONLY") && rep.getExtendedAccess() == 1) {
                this._log.warn(bundle.formatString("UpgradeUtility.SkippingReadOnlyRepository.fmt.txt", (Object)rep.getName(), (Object)rep.getFQID()));
                continue;
            }
            int reposVersion = 0;
            reposVersion = RepositoryUtil.getRepositoryFormatVersion((MdFactory)this._factory, (String)rep.getFQID());
            if (reposVersion >= modelVersion) continue;
            upgradeList.add(rep);
        }
        return upgradeList.toArray(new Repository[0]);
    }

    Repository[] getAllRepositoriesAllowedforUpgrade(Repository[] reposArray) {
        ArrayList<Repository> upgradeList = new ArrayList<Repository>();
        for (Repository rep : reposArray) {
            if (rep.getPauseState().equalsIgnoreCase("OFFLINE")) {
                this._log.warn(bundle.formatString("UpgradeUtility.SkippingOfflineRepository.fmt.txt", (Object)rep.getName(), (Object)rep.getFQID()));
                continue;
            }
            if (rep.getPauseState().equalsIgnoreCase("READONLY") && rep.getExtendedAccess() == 1) {
                this._log.warn(bundle.formatString("UpgradeUtility.SkippingReadOnlyRepository.fmt.txt", (Object)rep.getName(), (Object)rep.getFQID()));
                continue;
            }
            upgradeList.add(rep);
        }
        return upgradeList.toArray(new Repository[0]);
    }

    int convertModelVersionToInteger(String strVersion) {
        if (strVersion != null && strVersion.length() > 0) {
            int dotloc = strVersion.indexOf(46);
            StringBuffer sb = new StringBuffer();
            if (dotloc != -1) {
                sb.append(strVersion.substring(0, dotloc));
            } else {
                sb.append(strVersion);
            }
            return Integer.parseInt(sb.toString());
        }
        return -1;
    }

    boolean validateTargetServerisUpgradeable(String host, String port, String user, String password) throws Exception {
        MdFactoryImpl factory = new MdFactoryImpl(false);
        try {
            factory.getConnection().makeOMRConnection(host, port, user, password);
        }
        catch (MdException e) {
            this._log.error(bundle.getString("UpgradeUtility.TargetMetaConnectionHandleFailure.txt"));
            factory.dispose();
            return false;
        }
        List reposList = null;
        try {
            reposList = factory.getOMIUtil().getRepositories();
        }
        catch (Exception e) {
            factory.dispose();
            String error = e.getMessage();
            if (error == null) {
                this._log.error(bundle.formatString("UpgradeUtility.GetTargetServerRepositoriesError.txt", (Object)e.toString()));
            } else {
                this._log.error(bundle.formatString("UpgradeUtility.GetTargetServerRepositoriesError.txt", (Object)error));
            }
            return false;
        }
        factory.dispose();
        return reposList != null && reposList.size() > 0;
    }

    boolean buildUpgradeXMLRequest(StringBuffer xmlRequest, Map reposMgrMap, Repository[] upgradeReposArray, IServer server) {
        return this.buildUpgradeXMLRequest(xmlRequest, reposMgrMap, upgradeReposArray, server, 1, "MVA", "BASE", false, null, null, null, null, null, null, null, null);
    }

    boolean buildUpgradeXMLRequest(StringBuffer xmlRequest, Map reposMgrMap, Repository[] upgradeReposArray, IServer server, boolean forceUpgrade) {
        return this.buildUpgradeXMLRequest(xmlRequest, reposMgrMap, upgradeReposArray, server, forceUpgrade ? 4 : 1, "MVA", "BASE", false, null, null, null, null, null, null, null, null);
    }

    boolean buildUpgradeXMLRequest(StringBuffer xmlRequest, Map reposMgrMap, Repository[] upgradeReposArray, IServer m_server, int upgradeType, String mode, String engine, boolean crossHost, String targetHost, String targetPort, String targetUser, String targetPass, String fdbLocation, String dbUser, String dbPass, String dbDSN) {
        xmlRequest.append(REPL_HEADER);
        int repcount = upgradeReposArray.length;
        boolean rmgrUpgrade = true;
        if (upgradeType != 4) {
            try {
                rmgrUpgrade = this.checkRepositoryMgrNeedsUpgrade(m_server, RMGR_ID);
            }
            catch (Exception e) {
                String error = e.getMessage();
                if (error == null) {
                    this._log.error(bundle.formatString("UpgradeUtility.CheckRepositoryManagerUpgradeError.txt", (Object)e.toString()));
                }
                this._log.error(bundle.formatString("UpgradeUtility.CheckRepositoryManagerUpgradeError.txt", (Object)error));
            }
        }
        if (rmgrUpgrade) {
            this.buildReposMgrXML(xmlRequest, reposMgrMap, mode, engine, crossHost, targetHost, targetPort, targetUser, targetPass, fdbLocation, dbUser, dbPass, dbDSN);
            this._log.info(bundle.getString("UpgradeUtility.UpgradingRepositoryManager.txt"));
        }
        for (int i = 0; i < repcount; ++i) {
            Repository rep = upgradeReposArray[i];
            String srcTgtPair = null;
            if (mode.equalsIgnoreCase("MVA")) {
                srcTgtPair = this.createSourceTargetPair(mode, engine, rep.getName(), rep.getFQID(), rep.getName(), rep.getPath(), rep.getOptions(), crossHost, targetUser, targetPass);
                if (srcTgtPair == null) {
                    this._log.error(bundle.getString("UpgradeUtility.XMLRequestBuildFailure.txt"));
                    return false;
                }
            } else {
                String tgtOptions = null;
                String schemaName = null;
                if (engine.equalsIgnoreCase("FIREBIRD")) {
                    tgtOptions = this.createConnectString(3, dbUser, dbPass, fdbLocation, crossHost, targetHost, targetPort);
                    schemaName = rep.getFQID().substring(9, 17);
                } else if (engine.equalsIgnoreCase("ORACLE")) {
                    tgtOptions = this.createConnectString(1, dbUser, dbPass, dbDSN, crossHost, targetHost, targetPort);
                } else if (engine.equalsIgnoreCase("DB2")) {
                    tgtOptions = this.createConnectString(2, dbUser, dbPass, dbDSN, crossHost, targetHost, targetPort);
                }
                srcTgtPair = this.createSourceTargetPair(mode, engine, rep.getName(), rep.getFQID(), rep.getName(), schemaName, tgtOptions, crossHost, targetUser, targetPass);
                if (srcTgtPair == null) {
                    this._log.error(bundle.getString("UpgradeUtility.XMLRequestBuildFailure.txt"));
                    return false;
                }
            }
            xmlRequest.append(srcTgtPair);
        }
        this._log.info(bundle.formatString("UpgradeUtility.UpgradingRepositories.fmt.txt", (Object)new Integer(repcount)));
        if (upgradeType == 1) {
            xmlRequest.append(REPL_INPLACE_TRAILER);
        } else if (upgradeType == 4) {
            xmlRequest.append(REPL_FORCE_INPLACE_TRAILER);
        } else if (upgradeType == 2) {
            xmlRequest.append(CLEANUP_TRAILER);
        } else {
            xmlRequest.append(REPL_TRAILER);
        }
        return true;
    }

    private boolean buildReposMgrXML(StringBuffer xmlRequest, Map repmgrMap, String mode, String engine, boolean crossHost, String targetHost, String targetPort, String targetUser, String targetPass, String fdbLocation, String dbUser, String dbPass, String dbDSN) {
        String srcTgtPair = null;
        String tgtOptions = null;
        if (mode.equalsIgnoreCase("TKTS")) {
            if (engine.equalsIgnoreCase("FIREBIRD")) {
                tgtOptions = this.createConnectString(3, dbUser, dbPass, fdbLocation, crossHost, targetHost, targetPort);
            } else if (engine.equalsIgnoreCase("ORACLE")) {
                tgtOptions = this.createConnectString(1, dbUser, dbPass, dbDSN, crossHost, targetHost, targetPort);
            } else if (engine.equalsIgnoreCase("DB2")) {
                tgtOptions = this.createConnectString(2, dbUser, dbPass, dbDSN, crossHost, targetHost, targetPort);
            }
            String schemaName = RMGR_LIBREF;
            srcTgtPair = this.createSourceTargetPair(mode, engine, (String)repmgrMap.get("Name"), (String)repmgrMap.get("Id"), (String)repmgrMap.get("Name"), schemaName, tgtOptions, crossHost, targetUser, targetPass);
        } else {
            tgtOptions = (String)repmgrMap.get("Options");
            srcTgtPair = this.createSourceTargetPair(mode, engine, (String)repmgrMap.get("Name"), (String)repmgrMap.get("Id"), (String)repmgrMap.get("Name"), (String)repmgrMap.get("Path"), tgtOptions, crossHost, targetUser, targetPass);
        }
        if (srcTgtPair == null) {
            this._log.error(bundle.getString("UpgradeUtility.XMLRequestBuildFailure.txt"));
            return false;
        }
        xmlRequest.append(srcTgtPair);
        return true;
    }

    Map<String, String> getRepositoryMgrInfo() {
        HashMap<String, String> repMgrMap = new HashMap<String, String>();
        StringBuffer inXMLBuffer = new StringBuffer("<RepositoryMgrBase Id=\"A0000001.A0000001\" />");
        StringHolder outXML = new StringHolder();
        String inXML = inXMLBuffer.toString();
        try {
            IOMI omiConnection = this._factory.getConnection().getCMRHandle();
            omiConnection.GetMetadata(inXML, outXML, "REPOS", 1, "");
            String outXMLString = outXML.value.toString();
            StringBuffer sb = new StringBuffer(outXMLString.length() + 21);
            sb.append("<Metadata>");
            sb.append(outXMLString);
            sb.append("</Metadata>");
            org.w3c.dom.Document mainDoc = this._omiUtil.parseXML(sb.toString());
            if (mainDoc != null) {
                Node firstNode = mainDoc.getFirstChild();
                NodeList nodeList = firstNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node currentNode = nodeList.item(i);
                    NamedNodeMap nodeMap = currentNode.getAttributes();
                    if (nodeMap.getNamedItem("Id") != null) {
                        repMgrMap.put("Id", nodeMap.getNamedItem("Id").getNodeValue());
                    }
                    if (nodeMap.getNamedItem("Name") != null) {
                        repMgrMap.put("Name", nodeMap.getNamedItem("Name").getNodeValue());
                    }
                    if (nodeMap.getNamedItem("RepositoryPath") != null) {
                        repMgrMap.put("Path", nodeMap.getNamedItem("RepositoryPath").getNodeValue());
                    }
                    if (nodeMap.getNamedItem("RepositoryOptions") != null) {
                        repMgrMap.put("Options", nodeMap.getNamedItem("RepositoryOptions").getNodeValue());
                    }
                    if (nodeMap.getNamedItem("RepositoryEngine") != null) {
                        repMgrMap.put("Engine", nodeMap.getNamedItem("RepositoryEngine").getNodeValue());
                    }
                    if (nodeMap.getNamedItem("RepositoryFormat") == null) continue;
                    repMgrMap.put("RepositoryFormat", nodeMap.getNamedItem("RepositoryFormat").getNodeValue());
                }
            }
        }
        catch (Exception e) {
            String error = e.getMessage();
            if (error == null) {
                this._log.error(bundle.formatString("UpgradeUtility.GetRepositoryMgrInfo.Error.txt", (Object)e.toString()));
            } else {
                this._log.error(bundle.formatString("UpgradeUtility.GetRepositoryMgrInfo.Error.txt", (Object)e.getMessage()));
            }
            return null;
        }
        return repMgrMap;
    }

    boolean checkRepositoryMgrNeedsUpgrade(IServer m_server, String strReposMgrId) throws Exception {
        int modelVersion = -1;
        modelVersion = this.convertModelVersionToInteger(this._factory.getConnection().getServerModelVersion(m_server));
        if (modelVersion == -1) {
            this._log.warn(bundle.getString("UpgradeUtility.ModelVersionWarning.txt"));
            return true;
        }
        int reposMgrVersion = 0;
        reposMgrVersion = RepositoryUtil.getRepositoryFormatVersion((MdFactory)this._factory, (String)strReposMgrId);
        return reposMgrVersion < modelVersion;
    }

    int addPublicTypeUsageVersion(Repository repos) throws Exception {
        org.w3c.dom.Document doc;
        String publicObjectRulesStr = null;
        int rc = 0;
        try {
            publicObjectRulesStr = this.buildStringfromXMLfile("PublicObjectRules.xml");
        }
        catch (Exception exc) {
            this._log.error(bundle.formatString("UpgradeUtility.BuildPublicObjectRulesStr.Error.txt", (Object)exc.getMessage()));
            return 8;
        }
        if (publicObjectRulesStr == null) {
            this._log.error(bundle.getString("UpgradeUtility.PublicObjectRulesStr.Error.txt"));
            return 8;
        }
        try {
            doc = this._omiUtil.parseXML(publicObjectRulesStr);
        }
        catch (MdException exc) {
            this._factory.getUtil().printOutputln(exc.getMessage());
            this._log.error(bundle.formatString("UpgradeUtility.ParsingPublicObjectRules.Error.txt", (Object)exc.getMessage()));
            return 8;
        }
        if (doc != null) {
            Node firstNode = doc.getFirstChild();
            if (firstNode != null) {
                NodeList children = firstNode.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    boolean problemsFound = this.processTypeUsageRules(children.item(childIndex), repos);
                    if (!problemsFound) continue;
                    rc = 4;
                }
            }
        } else {
            this._log.error(bundle.getString("UpgradeUtility.ParsingPublicObjectRules.Error.txt"));
            rc = 8;
        }
        this.addPublicTypeForBIDashboard(repos, "Dashboard", "Dashboards");
        this.addPublicTypeForBIDashboard(repos, "Indicator", "Indicator Definitions");
        this.addPublicTypeForBIDashboard(repos, "IndicatorData", "Data Point Models");
        return rc;
    }

    boolean processTypeUsageRules(Node node, Repository repos) throws Exception {
        boolean warning = false;
        if (node.getNodeName().equals("Rule")) {
            NamedNodeMap childNodeMap = node.getAttributes();
            String publicType = childNodeMap.getNamedItem("PublicType").getNodeValue();
            String strMetadataType = childNodeMap.getNamedItem("MetadataType").getNodeValue();
            String usageVersion = childNodeMap.getNamedItem("UsageVersion").getNodeValue();
            String xmlMatchCriteria = childNodeMap.getNamedItem("Match").getNodeValue();
            String strSelect = "<XMLSELECT search=\"" + xmlMatchCriteria + "\"/>";
            int flags = 384;
            try {
                List objectList = this._omiUtil.getMetadataObjectsNoCache(strMetadataType, repos.getFQID(), strSelect, flags);
                StringBuffer updateXmlBuffer = new StringBuffer(1000);
                if (objectList != null && objectList.size() > 0) {
                    for (int i = 0; i < objectList.size(); ++i) {
                        HashMap obj = (HashMap)objectList.get(i);
                        updateXmlBuffer.append("<");
                        updateXmlBuffer.append((String)obj.get("MetadataObjectType"));
                        updateXmlBuffer.append(" Id=\"");
                        updateXmlBuffer.append((String)obj.get("Id"));
                        updateXmlBuffer.append("\" PublicType=\"");
                        updateXmlBuffer.append(publicType);
                        updateXmlBuffer.append("\" UsageVersion=\"");
                        updateXmlBuffer.append(usageVersion);
                        updateXmlBuffer.append("\" />");
                        if (i % 1000 != 0) continue;
                        this._omiUtil.updateMetadata(updateXmlBuffer.toString());
                        updateXmlBuffer.setLength(0);
                    }
                    if (updateXmlBuffer.length() > 1) {
                        this._omiUtil.updateMetadata(updateXmlBuffer.toString());
                    }
                    this._log.info(bundle.formatString("UpgradeMetadata.ObjectCount.fmt.txt", (Object)publicType, (Object)new Integer(objectList.size())));
                }
            }
            catch (Exception e) {
                this._log.warn(bundle.formatString("UpgradeUtility.ApplyingPublicObjectTypeUsageRules.Warning.txt", (Object)publicType, (Object)e.getMessage()));
                warning = true;
            }
        }
        return warning;
    }

    void addPublicTypeForBIDashboard(Repository repos, String publicType, String folderName) throws Exception {
        String strReposId = repos.getFQID();
        MdObjectStore store = this._factory.createObjectStore();
        String strOptions = "<XMLSELECT search=\"*[@Name='" + folderName + "' and @PublicType='Folder']\"/><Templates><Tree><Members/></Tree><File Name='' PublicType='' UsageVersion=''/></Templates>";
        int flags = 388;
        List trees = this._omiUtil.getMetadataObjectsSubset((MdStore)store, strReposId, "Tree", flags, strOptions, false);
        Iterator iter = trees.iterator();
        int objectCount = 0;
        while (iter.hasNext()) {
            Tree tree = (Tree)iter.next();
            AssociationList files = tree.getMembers(false);
            if (files == null) continue;
            for (Root object : files) {
                File file;
                if (!(object instanceof File) || (file = (File)object).getPublicType().length() > 0) continue;
                ++objectCount;
                file.setPublicType(publicType);
                file.setUsageVersion(1000000.0);
            }
        }
        if (objectCount > 0) {
            store.updatedMetadataAll();
            this._log.info(bundle.formatString("UpgradeMetadata.ObjectCount.fmt.txt", (Object)publicType, (Object)new Integer(objectCount)));
        }
    }

    private String buildStringfromXMLfile(String indexFile) throws Exception {
        String in;
        String xmlString = null;
        InputStream is = UpgradeUtility.class.getResourceAsStream(indexFile);
        if (is == null) {
            throw new IllegalStateException("InputStream for PublicObjectRules file is null");
        }
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((in = br.readLine()) != null) {
            sb.append(in);
        }
        xmlString = sb.toString();
        is.close();
        return xmlString;
    }

    boolean upgradePublicNotes(Repository repos) throws Exception {
        boolean error = false;
        List resultList = null;
        ArrayList<TextStore> upgradeTSlist = new ArrayList<TextStore>();
        String reposFQID = repos.getFQID();
        String reposId = reposFQID.substring(9, 17);
        String strSelect = "<XMLSELECT search=\"TextStore[@TextRole='Note']\"/>";
        String strTemplate = "<Templates><TextStore><Objects/><Extentions/><ResponsibleParties/></TextStore></Templates>";
        String strOptions = strTemplate + strSelect;
        int flags = 396;
        MdObjectStore store = this._factory.createObjectStore();
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, reposFQID, "TextStore", flags, strOptions, false);
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeUtility.UpgradePublicNotes.Error.txt", (Object)e.getMessage()));
            error = true;
            store.dispose();
            return error;
        }
        if (resultList != null && resultList.size() != 0) {
            TextStore ts;
            int i;
            for (i = 0; i < resultList.size(); ++i) {
                ts = (TextStore)resultList.get(i);
                if (ts.getName().equals("PrivateNote")) continue;
                AssociationList objectsList = ts.getObjects();
                if (objectsList != null) {
                    boolean publicDocumentFound = false;
                    for (int j = 0; j < objectsList.size(); ++j) {
                        Document doc;
                        Root obj = (Root)objectsList.get(j);
                        if (!obj.getCMetadataType().equalsIgnoreCase("Document") || !(doc = (Document)obj).getPublicType().equalsIgnoreCase("Note")) continue;
                        publicDocumentFound = true;
                        break;
                    }
                    if (publicDocumentFound) continue;
                    upgradeTSlist.add(ts);
                    continue;
                }
                upgradeTSlist.add(ts);
            }
            for (i = 0; i < upgradeTSlist.size(); ++i) {
                ts = (TextStore)upgradeTSlist.get(i);
                AssociationList objList = ts.getObjects();
                Document doc = (Document)this._factory.createComplexMetadataObject(store, ts.getName(), "Document", reposId);
                doc.setDesc(ts.getDesc());
                doc.setPublicType("Note");
                doc.setTextRole("Note");
                doc.setURI("");
                for (int j = 0; j < objList.size(); ++j) {
                    doc.getObjects().add(objList.get(j));
                }
                AssociationList extensionList = ts.getExtensions();
                for (AbstractExtension extension : extensionList) {
                    NumericExtension newExt = null;
                    if (extension instanceof NumericExtension) {
                        newExt = (NumericExtension)this._factory.createComplexMetadataObject(store, extension.getName(), "NumericExtension", reposId);
                        newExt.setExtensionType(extension.getExtensionType());
                        newExt.setDesc(extension.getDesc());
                        newExt.setNumericValue(((NumericExtension)extension).getNumericValue());
                    }
                    if (extension instanceof Extension) {
                        newExt = (Extension)this._factory.createComplexMetadataObject(store, extension.getName(), "Extension", reposId);
                        newExt.setExtensionType(extension.getExtensionType());
                        newExt.setDesc(extension.getDesc());
                        ((Extension)newExt).setValue(((Extension)extension).getValue());
                    }
                    if (newExt == null) continue;
                    doc.getExtensions().add(newExt);
                }
                this._factory.deleteMetadataObjects((List)extensionList);
                AssociationList rpList = ts.getResponsibleParties();
                for (ResponsibleParty rp : rpList) {
                    doc.getResponsibleParties().add((Object)rp);
                }
                rpList.removeAllElements();
                ts.getObjects().removeAllElements();
                doc.getNotes().add((Object)ts);
            }
            store.updatedMetadataAll();
        }
        store.dispose();
        return error;
    }

    boolean upgradeResponsibleParty(Repository repos) throws Exception {
        ResponsibleParty rp;
        int j;
        ArrayList resPartyList;
        Identity ident;
        int i;
        boolean error = false;
        List resultList = null;
        MdObjectStore store = this._factory.createObjectStore();
        String strTemplate = "<Templates><Identity><Responsibilities/></Identity></Templates>";
        int flags = 284;
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "Identity", flags, strTemplate, false);
        }
        catch (MdException e) {
            this._log.error(bundle.formatString("UpgradeUtility.UpgradeResponsibleParty.Error.txt", (Object)e.getMessage()));
            error = true;
            store.dispose();
            return error;
        }
        for (i = 0; i < resultList.size(); ++i) {
            ident = (Identity)resultList.get(i);
            AssociationList responsList = ident.getResponsibilities();
            if (responsList.size() <= 1) continue;
            HashMap<String, ResponsibleParty> roleMap = new HashMap<String, ResponsibleParty>();
            resPartyList = new ArrayList();
            resPartyList.addAll(responsList);
            int rSize = resPartyList.size();
            for (j = 0; j < rSize; ++j) {
                rp = (ResponsibleParty)resPartyList.get(j);
                if (roleMap.containsKey(rp.getRole())) {
                    ResponsibleParty existingRP = (ResponsibleParty)roleMap.get(rp.getRole());
                    existingRP.getObjects().addAll((Collection)rp.getObjects());
                    rp.delete();
                    continue;
                }
                roleMap.put(rp.getRole(), rp);
            }
            roleMap.clear();
            roleMap = null;
        }
        if (resultList.size() != 0) {
            store.updatedMetadataAll();
        }
        for (i = 0; i < resultList.size(); ++i) {
            ident = (Identity)resultList.get(i);
            String identReposId = ident.getFQID().substring(0, 8);
            AssociationList responsList = ident.getResponsibilities();
            if (responsList.size() <= 0) continue;
            resPartyList = new ArrayList();
            resPartyList.addAll(responsList);
            int resSize = resPartyList.size();
            for (j = 0; j < resSize; ++j) {
                rp = (ResponsibleParty)resPartyList.get(j);
                if (rp.getFQID().substring(0, 8).equalsIgnoreCase(identReposId)) continue;
                ResponsibleParty rpNew = (ResponsibleParty)this._factory.createComplexMetadataObject(store, rp.getName(), "ResponsibleParty", identReposId);
                rpNew.setRole(rp.getRole());
                rpNew.getPersons().addAll((Collection)rp.getPersons());
                rpNew.getObjects().addAll((Collection)rp.getObjects());
                rp.delete();
            }
        }
        if (resultList.size() != 0) {
            store.updatedMetadataAll();
        }
        String strTemplate2 = "<Templates><ResponsibleParty><Persons/></ResponsibleParty></Templates>";
        flags = 268;
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "ResponsibleParty", flags, strTemplate2, false);
        }
        catch (MdException e) {
            this._log.error(bundle.formatString("UpgradeUtility.UpgradeResponsibleParty.Error.txt", (Object)e.getMessage()));
            error = true;
            store.dispose();
            return error;
        }
        for (int i2 = 0; i2 < resultList.size(); ++i2) {
            ResponsibleParty rp2 = (ResponsibleParty)resultList.get(i2);
            AssociationList identityList = rp2.getPersons();
            if (identityList == null || identityList.size() <= 1) continue;
            for (int j2 = 1; j2 < identityList.size(); ++j2) {
                Identity ident2 = (Identity)identityList.get(j2);
                ResponsibleParty rpNew = (ResponsibleParty)this._factory.createComplexMetadataObject(store, ident2.getName(), "ResponsibleParty", repos.getFQID().substring(9, 17));
                rpNew.setRole(rp2.getRole());
                rpNew.getPersons().add((Object)ident2);
                rpNew.getObjects().addAll((Collection)rp2.getObjects());
                rp2.getPersons().removeElement((Object)ident2);
            }
        }
        if (resultList.size() != 0) {
            store.updatedMetadataAll();
        }
        store.dispose();
        return error;
    }

    boolean upgradeContentMappingDocuments(Repository repos) throws Exception {
        String strOptions;
        boolean error = false;
        String strReposId = repos.getFQID();
        MdObjectStore store = this._factory.createObjectStore();
        List comps = this._omiUtil.getMetadataObjectsSubset((MdStore)store, strReposId, "SoftwareComponent", 396, strOptions = "<XMLSelect search=\"*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']\"/><Templates><SoftwareComponent Name=\"\"><SoftwareTrees/><Documents/></SoftwareComponent><Tree><Documents/></Tree></Templates>", false);
        if (comps.size() != 1) {
            error = true;
            return error;
        }
        SoftwareComponent sc = (SoftwareComponent)comps.get(0);
        this.updateContentMappingDocument((Root)sc);
        for (Tree tree : sc.getSoftwareTrees()) {
            this.updateContentMappingDocument((Root)tree);
        }
        store.updatedMetadataAll();
        store.dispose();
        return error;
    }

    private void updateContentMappingDocument(Root folder) throws RemoteException, MdException {
        String uriField;
        Document rrcmRole = null;
        Document rrcmName = null;
        Document fldrName = null;
        for (Document doc : folder.getDocuments()) {
            if ("ReportRepositoryContentMapping".equals(doc.getTextRole())) {
                rrcmRole = doc;
                continue;
            }
            if ("Report Repository Content Mapping".equals(doc.getName())) {
                rrcmName = doc;
                continue;
            }
            if (!(folder instanceof Tree) || !folder.getName().equals(doc.getName())) continue;
            fldrName = doc;
        }
        Document rrcmDocument = null;
        if (rrcmRole != null) {
            rrcmDocument = rrcmRole;
            if (rrcmName != null) {
                this.deleteExtraContentMappingDocument(rrcmName);
            }
            if (fldrName != null) {
                this.deleteExtraContentMappingDocument(fldrName);
            }
        } else if (fldrName != null) {
            rrcmDocument = fldrName;
            if (rrcmName != null) {
                this.deleteExtraContentMappingDocument(rrcmName);
            }
        } else if (rrcmName != null) {
            rrcmDocument = rrcmName;
        }
        if (rrcmDocument == null) {
            return;
        }
        this._log.debug("Updating content mapping Document " + rrcmDocument.getId() + ".");
        if (folder instanceof SoftwareComponent) {
            if (!"Report Repository Content Mapping".equals(rrcmDocument.getName())) {
                rrcmDocument.setName("Report Repository Content Mapping");
            }
        } else if (!folder.getName().equals(rrcmDocument.getName())) {
            rrcmDocument.setName(folder.getName());
        }
        if (!rrcmDocument.getPublicType().equals("")) {
            rrcmDocument.setPublicType("");
        }
        if (rrcmDocument.getUsageVersion() != 0.0) {
            rrcmDocument.setUsageVersion(0.0);
        }
        if (!"ReportRepositoryContentMapping".equals(rrcmDocument.getTextRole())) {
            rrcmDocument.setTextRole("ReportRepositoryContentMapping");
        }
        if ((uriField = rrcmDocument.getURI()).startsWith("http:") || uriField.startsWith("https:")) {
            if (!"DAV".equals(rrcmDocument.getURIType())) {
                rrcmDocument.setURIType("DAV");
            }
        } else if (!"File".equals(rrcmDocument.getURIType())) {
            rrcmDocument.setURIType("File");
        }
        rrcmDocument.getTrees().clear();
    }

    void deleteExtraContentMappingDocument(Document doc) throws RemoteException {
        this._log.warn("Deleting extra content mapping document " + doc.getId() + ".");
        doc.delete();
    }

    boolean upgradeUsersFolderProperty(Repository repos) throws Exception {
        boolean error = false;
        String strReposId = repos.getFQID();
        MdObjectStore store = this._factory.createObjectStore();
        String strOptions = "<XMLSELECT search=\"Property[@PropertyName='Path to Users Root Folder']\"/>";
        int flags = 392;
        List props = this._omiUtil.getMetadataObjectsSubset((MdStore)store, strReposId, "Property", flags, strOptions, false);
        Property prop = null;
        if (props.size() <= 0) {
            error = true;
            return error;
        }
        prop = (Property)props.get(0);
        String pathValue = prop.getDefaultValue();
        if (pathValue.equalsIgnoreCase("") || pathValue.equals(null)) {
            prop.setDefaultValue("/" + bundle.getString("Common.DefaultFolderPolicy.txt"));
            prop.updateMetadataAll();
        }
        store.dispose();
        return error;
    }

    void adminMetadataPermissionCleanup(Repository repos) throws Exception {
        String strReposId = repos.getFQID();
        MdObjectStore store = this._factory.createObjectStore();
        String strOptions = "<XMLSELECT search=\"Permission[@Name='AdminMetadata']\"/>";
        int flags = 392;
        List permsList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, strReposId, "Permission", flags, strOptions, false);
        Permission perm = null;
        String inXML = "";
        IOMI omiConnection = this._factory.getConnection().getCMRHandle();
        for (int i = 0; i < permsList.size(); ++i) {
            perm = (Permission)permsList.get(i);
            inXML = inXML + "<Permission ID=\"" + perm.getFQID() + "\"></Permission>";
        }
        if (inXML != "") {
            try {
                StringHolder outXML = new StringHolder();
                omiConnection.DeleteMetadata(inXML, outXML, "SAS", 0x10000000, "");
            }
            catch (Exception e) {
                store.dispose();
                throw e;
            }
        }
        strOptions = "<XMLSELECT search=\"TextStore[@TextRole='Marker' and @Name='AdminMetadata Conversion']\"/>";
        flags = 392;
        List tStoreList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, strReposId, "TextStore", flags, strOptions, false);
        TextStore ts = null;
        for (int i = 0; i < tStoreList.size(); ++i) {
            ts = (TextStore)tStoreList.get(i);
            try {
                StringHolder outXML = new StringHolder();
                inXML = "";
                inXML = "<TextStore ID=\"" + ts.getFQID() + "\"></TextStore>";
                omiConnection.DeleteMetadata(inXML, outXML, "SAS", 0x10000000, "");
                continue;
            }
            catch (Exception e) {
                store.dispose();
                throw e;
            }
        }
        store.dispose();
    }

    boolean updateMetadataServerClassId(Repository repos) throws Exception {
        boolean error = false;
        String strReposId = repos.getFQID();
        MdObjectStore store = this._factory.createObjectStore();
        String strSelect = "<XMLSelect search=\"*[@ClassIdentifier='2887E7D7-4780-11D4-879F-00C04F38F0DB']\"/>";
        int flags = 408;
        List comps = this._omiUtil.getMetadataObjectsSubset((MdStore)store, strReposId, "SoftwareComponent", flags, strSelect, false);
        for (int i = 0; i < comps.size(); ++i) {
            SoftwareComponent sc = (SoftwareComponent)comps.get(i);
            sc.setClassIdentifier("0217e202-b560-11db-ad91-001083ff6836");
        }
        store.updatedMetadataAll();
        store.dispose();
        return error;
    }

    void updateChangeObjects(Repository repos) throws Exception {
        int flags = 396;
        String strReposId = null;
        if (repos == null) {
            strReposId = this._omiUtil.getFoundationReposID();
            flags |= 0x2000;
        } else {
            strReposId = repos.getFQID();
        }
        MdObjectStore store = this._factory.createObjectStore();
        String strSelect = "<XMLSelect search=\"*[Objects/*[@PublicType NE '']]\"/>";
        String strTemplate = "<Templates><Change Name=\"\"><ChangeIdentity/></Change></Templates>";
        String strOptions = strTemplate + strSelect;
        List changeList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, strReposId, "Change", flags, strOptions, false);
        int changedCount = 0;
        for (int i = 0; i < changeList.size(); ++i) {
            Change chObj = (Change)changeList.get(i);
            Identity idObj = chObj.getChangeIdentity();
            if (idObj == null) continue;
            String idName = idObj.getName();
            if (idName == null || idName.length() == 0) {
                idName = "unknown";
            }
            if (idName.equals(chObj.getChangeState())) continue;
            chObj.setChangeState(idName);
            ++changedCount;
        }
        store.updatedMetadataAll();
        if (changedCount > 0) {
            this._log.info(bundle.formatString("UpgradeUtility.UpdateChangeObjects.fmt.txt", (Object)new Integer(changedCount)));
        }
        String strSelect2 = "<XMLSelect search=\"*[@ChangeState='']]\"/>";
        flags = 392;
        List changeList2 = this._omiUtil.getMetadataObjectsSubset((MdStore)store, strReposId, "Change", flags, strSelect2, false);
        for (int j = 0; j < changeList2.size(); ++j) {
            Change chObj = (Change)changeList2.get(j);
            chObj.delete();
            store.updatedMetadataAll();
        }
        if (changeList2.size() > 0) {
            this._log.info(bundle.formatString("UpgradeUtility.DeleteChangeObjects.fmt.txt", (Object)new Integer(changeList2.size())));
        }
        store.dispose();
    }

    boolean upgradeLibraryDirectory(Repository repos) throws Exception {
        boolean error = false;
        List resultList = null;
        String strOptions = "<XMLSELECT search=\"*[UsedByPackages/SASLibrary]\"/><Templates><Property PropertyRole=\"\"/></Templates>";
        int flags = 2437;
        MdObjectStore store = this._factory.createObjectStore();
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "Directory", flags, strOptions, false);
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeUtility.UpgradeLibraryDirectory.Error.txt", (Object)e.getMessage()));
            error = true;
            store.dispose();
            return error;
        }
        if (resultList != null && resultList.size() != 0) {
            for (int i = 0; i < resultList.size(); ++i) {
                Directory dir = (Directory)resultList.get(i);
                Map assocMap = dir.getPopulatedAssocs();
                boolean spRepos = false;
                AssociationList props = dir.getProperties();
                if (props != null && props.size() > 0) {
                    for (Property prop : props) {
                        if (!prop.getPropertyRole().equalsIgnoreCase("SPSourceCodeRepository")) continue;
                        spRepos = true;
                    }
                }
                if (spRepos || dir.getName().equals("Base Path")) continue;
                AssociationList objList = dir.getUsedByPackages();
                if (objList != null && objList.size() > 1) {
                    Directory newdir;
                    int j;
                    ArrayList<Root> libList = new ArrayList<Root>();
                    for (j = 0; j < objList.size(); ++j) {
                        Root obj = (Root)objList.get(j);
                        if (!obj.getCMetadataType().equalsIgnoreCase("SASLibrary")) continue;
                        libList.add(obj);
                    }
                    if (libList != null && libList.size() > 1) {
                        for (j = 1; j < libList.size(); ++j) {
                            newdir = (Directory)this._factory.createComplexMetadataObject(store, dir.getName(), "Directory", repos.getShortRepositoryID());
                            newdir.setDirectoryRole("LibraryPath");
                            newdir.setDirectoryName(dir.getDirectoryName());
                            if (dir.getIsRelative() == 0) {
                                this.addUpgradeDirectoryNote(newdir, dir.getFQID(), store, repos.getShortRepositoryID());
                            } else {
                                newdir.setIsRelative(dir.getIsRelative());
                            }
                            SASLibrary lib = (SASLibrary)libList.get(j);
                            AssociationList pkgList = lib.getUsingPackages();
                            int idx = pkgList.indexOf((Object)dir);
                            if (idx <= -1) continue;
                            pkgList.remove((Object)dir);
                            pkgList.add(idx, (Object)newdir);
                        }
                    }
                    if (assocMap.size() > 1) {
                        SASLibrary lib = (SASLibrary)libList.get(0);
                        if (!lib.getCMetadataType().equalsIgnoreCase("SASLibrary")) continue;
                        newdir = (Directory)this._factory.createComplexMetadataObject(store, dir.getName(), "Directory", repos.getShortRepositoryID());
                        newdir.setDirectoryRole("LibraryPath");
                        newdir.setDirectoryName(dir.getDirectoryName());
                        if (dir.getIsRelative() == 0) {
                            this.addUpgradeDirectoryNote(newdir, dir.getFQID(), store, repos.getShortRepositoryID());
                        } else {
                            newdir.setIsRelative(dir.getIsRelative());
                        }
                        AssociationList pkgList = lib.getUsingPackages();
                        int idx = pkgList.indexOf((Object)dir);
                        if (idx <= -1) continue;
                        pkgList.remove((Object)dir);
                        pkgList.add(idx, (Object)newdir);
                        continue;
                    }
                    dir.setDirectoryRole("LibraryPath");
                    continue;
                }
                if (assocMap.size() > 1) {
                    Directory newdir = (Directory)this._factory.createComplexMetadataObject(store, dir.getName(), "Directory", repos.getShortRepositoryID());
                    newdir.setDirectoryRole("LibraryPath");
                    newdir.setDirectoryName(dir.getDirectoryName());
                    if (dir.getIsRelative() == 0) {
                        this.addUpgradeDirectoryNote(newdir, dir.getFQID(), store, repos.getShortRepositoryID());
                    } else {
                        newdir.setIsRelative(dir.getIsRelative());
                    }
                    SASLibrary lib = (SASLibrary)dir.getUsedByPackages().get(0);
                    AssociationList pkgList = lib.getUsingPackages();
                    int idx = pkgList.indexOf((Object)dir);
                    if (idx <= -1) continue;
                    pkgList.remove((Object)dir);
                    pkgList.add(idx, (Object)newdir);
                    continue;
                }
                dir.setDirectoryRole("LibraryPath");
            }
        }
        store.updatedMetadataAll();
        store.dispose();
        return error;
    }

    boolean upgradeLibrarySchema(Repository repos) throws Exception {
        DatabaseSchema schema;
        int i;
        boolean error = false;
        List resultList = null;
        String strOptions = "<XMLSELECT search=\"*[UsedByPackages/SASLibrary]\"/>";
        int flags = 2433;
        MdObjectStore store = this._factory.createObjectStore();
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "DatabaseSchema", flags, strOptions, false);
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeUtility.UpgradeLibrarySchema.Error.txt", (Object)e.getMessage()));
            error = true;
            store.dispose();
            return error;
        }
        if (resultList != null && resultList.size() != 0) {
            for (i = 0; i < resultList.size(); ++i) {
                int j;
                schema = (DatabaseSchema)resultList.get(i);
                AssociationList objList = schema.getUsedByPackages();
                if (objList == null || objList.size() <= 1) continue;
                ArrayList<Root> schemaList = new ArrayList<Root>();
                for (j = 0; j < objList.size(); ++j) {
                    Root obj = (Root)objList.get(j);
                    if (!obj.getCMetadataType().equals("SASLibrary")) continue;
                    schemaList.add(obj);
                }
                if (schemaList == null || schemaList.size() <= 1) continue;
                for (j = 1; j < schemaList.size(); ++j) {
                    AssociationList pkgList;
                    int idx;
                    SASLibrary lib = (SASLibrary)schemaList.get(j);
                    DatabaseSchema newSchema = (DatabaseSchema)this._factory.createComplexMetadataObject(store, schema.getName(), "DatabaseSchema", repos.getShortRepositoryID());
                    newSchema.setSchemaName(schema.getSchemaName());
                    AssociationList dcList = schema.getDeployedComponents(true);
                    if (dcList != null && dcList.size() >= 1) {
                        DeployedComponent dc = (DeployedComponent)dcList.get(0);
                        newSchema.getDeployedComponents().add((Object)dc);
                    }
                    if ((idx = (pkgList = lib.getUsingPackages()).indexOf((Object)schema)) > -1) {
                        pkgList.remove((Object)schema);
                        pkgList.add(idx, (Object)schema);
                    }
                    this._log.warn(bundle.formatString("UpgradeUtility.UpgradeLibrarySchema.Warn.txt", (Object)lib.getName()));
                }
            }
        }
        store.updatedMetadataAll();
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "DatabaseSchema", flags, null, false);
        }
        catch (Exception e) {
            this._log.warn(bundle.formatString("UpgradeUtility.CleanupLibrarySchemaOrphans.Warning.txt", (Object)e.getMessage()));
            store.dispose();
            return error;
        }
        try {
            if (resultList != null && resultList.size() > 0) {
                for (i = 0; i < resultList.size(); ++i) {
                    schema = (DatabaseSchema)resultList.get(i);
                    Map assocList = schema.getPopulatedAssocs();
                    if (assocList.size() >= 1) continue;
                    store.removeObjectFromStore((CMetadata)schema, null);
                }
            }
            store.updatedMetadataAll();
        }
        catch (Exception e) {
            this._log.warn(bundle.formatString("UpgradeUtility.CleanupLibrarySchemaOrphans.Warning.txt", (Object)e.getMessage()));
        }
        store.dispose();
        return error;
    }

    boolean upgradeOLAPDirectory(Repository repos) throws Exception {
        Root obj;
        CustomAssociation ca;
        ArrayList<CustomAssociation> custAssocs;
        AssociationList caList;
        Directory newdir;
        AssociationList cubeList;
        int j;
        Directory dir;
        int i;
        String OLAPPath = "OLAPPath";
        boolean error = false;
        List resultList = null;
        String strOptions = "<XMLSELECT search=\"*[Files/File/AssociatedCube/*]\"/>";
        int flags = 2433;
        MdObjectStore store = this._factory.createObjectStore();
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "Directory", flags, strOptions, false);
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeUtility.UpgradeOLAPDirectory.Error.txt", (Object)e.getMessage()));
            error = true;
            store.dispose();
            return error;
        }
        if (resultList != null && resultList.size() != 0) {
            for (i = 0; i < resultList.size(); ++i) {
                File file;
                dir = (Directory)resultList.get(i);
                AssociationList fileList = dir.getFiles();
                if (fileList == null || fileList.size() <= 0) continue;
                ArrayList<File> files = new ArrayList<File>();
                for (j = 0; j < fileList.size(); ++j) {
                    file = (File)fileList.get(j);
                    cubeList = file.getAssociatedCubes(true);
                    if (cubeList.size() <= 0) continue;
                    files.add(file);
                }
                if (files == null || files.size() <= 0) continue;
                for (j = 0; j < files.size(); ++j) {
                    file = (File)files.get(j);
                    file.getDirectories().remove((Object)dir);
                    newdir = (Directory)this._factory.createComplexMetadataObject(store, dir.getName(), "Directory", repos.getShortRepositoryID());
                    newdir.setDirectoryRole(OLAPPath);
                    newdir.setDirectoryName(dir.getDirectoryName());
                    file.getDirectories().add((Object)newdir);
                    if (dir.getIsRelative() == 0) {
                        this.addUpgradeDirectoryNote(newdir, dir.getFQID(), store, repos.getShortRepositoryID());
                        continue;
                    }
                    newdir.setIsRelative(dir.getIsRelative());
                }
            }
        }
        store.updatedMetadataAll();
        store.clearObjectsFromStore();
        strOptions = "<XMLSELECT search=\"*[ReferencedObjects/CustomAssociation/OwningObject/Cube]\"/>";
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "Directory", flags, strOptions, false);
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeUtility.UpgradeOLAPDirectory.Error.txt", (Object)e.getMessage()));
            error = true;
            store.dispose();
            return error;
        }
        if (resultList != null && resultList.size() != 0) {
            for (i = 0; i < resultList.size(); ++i) {
                dir = (Directory)resultList.get(i);
                caList = dir.getReferencedObjects();
                if (caList == null || caList.size() <= 0) continue;
                custAssocs = new ArrayList<CustomAssociation>();
                for (j = 0; j < caList.size(); ++j) {
                    ca = (CustomAssociation)caList.get(j);
                    cubeList = ca.getOwningObjects(true);
                    if (cubeList.size() <= 0 || !(obj = (Root)cubeList.get(0)).getCMetadataType().equals("Cube")) continue;
                    custAssocs.add(ca);
                }
                if (custAssocs == null || custAssocs.size() <= 0) continue;
                for (j = 0; j < custAssocs.size(); ++j) {
                    ca = (CustomAssociation)custAssocs.get(j);
                    ca.getAssociatedObjects().remove((Object)dir);
                    newdir = (Directory)this._factory.createComplexMetadataObject(store, dir.getName(), "Directory", repos.getShortRepositoryID());
                    newdir.setDirectoryRole(OLAPPath);
                    newdir.setDirectoryName(dir.getDirectoryName());
                    ca.getAssociatedObjects().add((Object)newdir);
                    ca.setisOwned(1);
                    if (dir.getIsRelative() == 0) {
                        this.addUpgradeDirectoryNote(newdir, dir.getFQID(), store, repos.getShortRepositoryID());
                        continue;
                    }
                    newdir.setIsRelative(dir.getIsRelative());
                }
            }
        }
        store.updatedMetadataAll();
        store.clearObjectsFromStore();
        strOptions = "<XMLSELECT search=\"*[ReferencedObjects/CustomAssociation/OwningObject/Aggregation]\"/>";
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "Directory", flags, strOptions, false);
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeUtility.UpgradeOLAPDirectory.Error.txt", (Object)e.getMessage()));
            error = true;
            store.dispose();
            return error;
        }
        if (resultList != null && resultList.size() != 0) {
            for (i = 0; i < resultList.size(); ++i) {
                dir = (Directory)resultList.get(i);
                caList = dir.getReferencedObjects();
                if (caList == null || caList.size() <= 0) continue;
                custAssocs = new ArrayList();
                for (j = 0; j < caList.size(); ++j) {
                    ca = (CustomAssociation)caList.get(j);
                    AssociationList aggList = ca.getOwningObjects(true);
                    if (aggList.size() <= 0 || !(obj = (Root)aggList.get(0)).getCMetadataType().equals("Aggregation")) continue;
                    custAssocs.add(ca);
                }
                if (custAssocs == null || custAssocs.size() <= 0) continue;
                for (j = 0; j < custAssocs.size(); ++j) {
                    ca = (CustomAssociation)custAssocs.get(j);
                    ca.getAssociatedObjects().remove((Object)dir);
                    newdir = (Directory)this._factory.createComplexMetadataObject(store, dir.getName(), "Directory", repos.getShortRepositoryID());
                    newdir.setDirectoryRole(OLAPPath);
                    newdir.setDirectoryName(dir.getDirectoryName());
                    ca.getAssociatedObjects().add((Object)newdir);
                    ca.setisOwned(1);
                    if (dir.getIsRelative() == 0) {
                        this.addUpgradeDirectoryNote(newdir, dir.getFQID(), store, repos.getShortRepositoryID());
                        continue;
                    }
                    newdir.setIsRelative(dir.getIsRelative());
                }
            }
        }
        store.updatedMetadataAll();
        store.dispose();
        return error;
    }

    private void addUpgradeDirectoryNote(Directory newDir, String origId, MdObjectStore store, String reposId) throws RemoteException, MdException {
        String upgradeNoteName = "UpgradeNote";
        String priorDirProp = "prior.directory.fqid=";
        TextStore note = (TextStore)this._factory.createComplexMetadataObject(store, upgradeNoteName, "TextStore", reposId);
        note.setStoredText(priorDirProp + origId);
        newDir.getNotes().add((Object)note);
    }

    boolean removeOrphanedDirectories(Repository repos) throws Exception {
        boolean error = false;
        List resultList = null;
        int flags = 2437;
        MdObjectStore store = this._factory.createObjectStore();
        String strOptions = "<XMLSELECT search=\"*[@Name ne 'Base Path' and @Name ne 'SP Source Directory']\"/>";
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "Directory", flags, strOptions, false);
        }
        catch (Exception e) {
            this._log.warn(bundle.formatString("UpgradeUtility.CleanupDirectoryOrphans.Warning.txt", (Object)e.getMessage()));
            store.dispose();
            return error;
        }
        try {
            if (resultList != null && resultList.size() > 0) {
                for (int i = 0; i < resultList.size(); ++i) {
                    Map assocMap;
                    Directory dir = (Directory)resultList.get(i);
                    String role = dir.getDirectoryRole();
                    if (role.equalsIgnoreCase("LibraryPath") || (assocMap = dir.getPopulatedAssocs()).size() >= 1) continue;
                    store.removeObjectFromStore((CMetadata)dir, null);
                }
            }
            store.updatedMetadataAll();
        }
        catch (Exception e) {
            this._log.warn(bundle.formatString("UpgradeUtility.CleanupDirectoryOrphans.Warning.txt", (Object)e.getMessage()));
        }
        store.dispose();
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean upgradeSAPServer(Repository repos) throws Exception {
        boolean error = false;
        List serverComponents = null;
        String strOptions = "<XMLSelect Search=\"@ProductName='SAPR3'\"/><Templates><ServerComponent><SourceConnections><SASClientConnection/></SourceConnections></ServerComponent><SASClientConnection><Properties/></SASClientConnection><Property Id=\"\" Name=\"\" DefaultValue=\"\" PropertyName=\"\"><OwningType/></Property></Templates>";
        int flags = 2437;
        String rfcServerPortPropertyPropertyName = "RFC_Server_Port";
        String rfcServerHostPropertyPropertyName = "RFC_Server_Host";
        MdObjectStore store = this._factory.createObjectStore();
        try {
            serverComponents = this._omiUtil.getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "ServerComponent", flags, "<XMLSelect Search=\"@ProductName='SAPR3'\"/><Templates><ServerComponent><SourceConnections><SASClientConnection/></SourceConnections></ServerComponent><SASClientConnection><Properties/></SASClientConnection><Property Id=\"\" Name=\"\" DefaultValue=\"\" PropertyName=\"\"><OwningType/></Property></Templates>", false);
            for (int i = 0; i < serverComponents.size(); ++i) {
                ServerComponent serverComponent = (ServerComponent)serverComponents.get(i);
                AssociationList sourceConnections = serverComponent.getSourceConnections();
                for (int j = 0; j < sourceConnections.size(); ++j) {
                    if (!(sourceConnections.get(j) instanceof SASClientConnection)) continue;
                    SASClientConnection clientConn = (SASClientConnection)sourceConnections.get(j);
                    AssociationList properties = clientConn.getProperties();
                    Property[] aProperties = properties.toArray(new Property[properties.size()]);
                    for (int k = 0; k < aProperties.length; ++k) {
                        Property property = aProperties[k];
                        if ("RFC_Server_Port".equals(property.getPropertyName())) {
                            store.removeObjectFromStore((CMetadata)property, null);
                            continue;
                        }
                        if (!"RFC_Server_Host".equals(property.getPropertyName())) continue;
                        store.removeObjectFromStore((CMetadata)property, null);
                    }
                }
            }
            store.updatedMetadataAll();
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeUtility.UpgradeSAPServerDefinition.Error.txt", (Object)e.getMessage()));
            boolean bl = error = true;
            return bl;
        }
        finally {
            store.dispose();
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean upgradeNetezzaServersandLibraries(Repository repos) throws Exception {
        boolean error = false;
        List serverComponents = null;
        String strSelect = "<XMLSelect search=\"*[@ClassIdentifier='Netezza']\"/>";
        String strTemplate = "<Templates><ServerComponent><SourceConnections/></ServerComponent> <SASClientConnection><Properties/><Libraries/></SASClientConnection><SASLibrary><Properties/></SASLibrary><Property><OwningType/></Property></Templates>";
        String strOptions = strSelect + strTemplate;
        int flags = 396;
        MdObjectStore store = this._factory.createObjectStore();
        try {
            serverComponents = this._omiUtil.getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "ServerComponent", flags, strOptions, false);
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeUtility.QueryNetezzaServers.Error.txt", (Object)e.getMessage()));
            error = true;
            store.dispose();
            return error;
        }
        try {
            if (serverComponents != null && serverComponents.size() > 0) {
                for (ServerComponent netServer : serverComponents) {
                    AssociationList connectList = netServer.getSourceConnections();
                    for (int i = 0; i < connectList.size(); ++i) {
                        if (!(connectList.get(i) instanceof SASClientConnection)) continue;
                        ArrayList<Property> propsToMoveList = new ArrayList<Property>();
                        SASClientConnection scc = (SASClientConnection)connectList.get(i);
                        AssociationList libsList = scc.getLibraries();
                        if (libsList == null || libsList.size() == 0) continue;
                        AssociationList propsList = scc.getProperties();
                        Property[] connectProperties = propsList.toArray(new Property[propsList.size()]);
                        for (int a = 0; a < connectProperties.length; ++a) {
                            Property prop = connectProperties[a];
                            if (!prop.getPropertyName().equalsIgnoreCase("DATABASE")) continue;
                            propsToMoveList.add(prop);
                        }
                        if (propsToMoveList == null || propsToMoveList.size() <= 0) continue;
                        for (int j = 0; j < libsList.size(); ++j) {
                            Property movingProperty;
                            int k;
                            SASLibrary lib = (SASLibrary)libsList.get(j);
                            if (!lib.getEngine().equalsIgnoreCase("NETEZZA")) continue;
                            boolean foundProp = false;
                            AssociationList libPropsList = lib.getProperties();
                            if (libPropsList != null && libPropsList.size() > 0) {
                                for (k = 0; k < propsToMoveList.size(); ++k) {
                                    movingProperty = (Property)propsToMoveList.get(k);
                                    for (Property existingProperty : libPropsList) {
                                        if (!movingProperty.getName().equalsIgnoreCase(existingProperty.getName())) continue;
                                        foundProp = true;
                                        break;
                                    }
                                    if (foundProp) continue;
                                    Property newProp = (Property)this._factory.createComplexMetadataObject(store, movingProperty.getName(), "Property", repos.getShortRepositoryID());
                                    newProp.setDefaultValue(movingProperty.getDefaultValue());
                                    newProp.setDelimiter(movingProperty.getDelimiter());
                                    newProp.setDesc(movingProperty.getDesc());
                                    newProp.setPropertyName(movingProperty.getPropertyName());
                                    newProp.setSQLType(movingProperty.getSQLType());
                                    newProp.getOwningTypes().add((Object)movingProperty.getOwningType());
                                    lib.getProperties().add((Object)newProp);
                                }
                                continue;
                            }
                            for (k = 0; k < propsToMoveList.size(); ++k) {
                                movingProperty = (Property)propsToMoveList.get(k);
                                Property newProp = (Property)this._factory.createComplexMetadataObject(store, movingProperty.getName(), "Property", repos.getShortRepositoryID());
                                newProp.setDefaultValue(movingProperty.getDefaultValue());
                                newProp.setDelimiter(movingProperty.getDelimiter());
                                newProp.setDesc(movingProperty.getDesc());
                                newProp.setPropertyName(movingProperty.getPropertyName());
                                newProp.setSQLType(movingProperty.getSQLType());
                                newProp.getOwningTypes().add((Object)movingProperty.getOwningType());
                                lib.getProperties().add((Object)newProp);
                            }
                        }
                        for (int l = 0; l < propsToMoveList.size(); ++l) {
                            Property deleteProperty = (Property)propsToMoveList.get(l);
                            deleteProperty.delete();
                        }
                    }
                }
            }
            store.updatedMetadataAll();
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeUtility.UpgradeNetezzaServers.Error.txt", (Object)e.getMessage()));
            boolean bl = error = true;
            return bl;
        }
        finally {
            store.dispose();
        }
        return error;
    }

    void removeTableServerMetadata(Repository repos) throws Exception {
        String strReposId = null;
        int flags = 2440;
        if (repos == null) {
            strReposId = this._omiUtil.getFoundationReposID();
            flags |= 0x2000;
        } else {
            strReposId = repos.getFQID();
        }
        MdObjectStore store = this._factory.createObjectStore();
        String publicTypeName = LOGICAL_TABLESERVER_TYPE;
        String strOptions = "<XMLSELECT search=\"*[@PublicType ='" + publicTypeName + "']\"/>";
        String metadataTypeName = "LogicalServer";
        int objCount = this.deleteObjects(store, strReposId, metadataTypeName, publicTypeName, flags, strOptions);
        if (objCount > 0) {
            this._log.info(bundle.formatString("UpgradeUtility.CleanupTableServerObjects.Info.txt", (Object)objCount, (Object)metadataTypeName));
        }
        if ((objCount = this.deleteObjects(store, strReposId, metadataTypeName = "DataSourceName", publicTypeName = "DataSourceName", flags, strOptions = "<XMLSELECT search=\"*[@PublicType ='" + publicTypeName + "']\"/>")) > 0) {
            this._log.info(bundle.formatString("UpgradeUtility.CleanupTableServerObjects.Info.txt", (Object)objCount, (Object)metadataTypeName));
        }
        if ((objCount = this.deleteObjects(store, strReposId, metadataTypeName = "Tree", publicTypeName = "TSSourceTree", flags, strOptions = "<XMLSELECT search=\"*[@PublicType ='" + publicTypeName + "']\"/>")) > 0) {
            this._log.info(bundle.formatString("UpgradeUtility.CleanupTableServerObjects.Info.txt", (Object)objCount, (Object)metadataTypeName));
        }
        if ((objCount = this.deleteObjects(store, strReposId, metadataTypeName = "TSNamespace", publicTypeName = "TSNameSpace", flags, strOptions = "<XMLSELECT search=\"*[@PublicType =:'" + publicTypeName + "']\"/>")) > 0) {
            this._log.info(bundle.formatString("UpgradeUtility.CleanupTableServerObjects.Info.txt", (Object)objCount, (Object)metadataTypeName));
        }
        if ((objCount = this.deleteObjects(store, strReposId, metadataTypeName = "TSNameObject", publicTypeName = "TSName", flags, strOptions = "<XMLSELECT search=\"*[@PublicType ='" + publicTypeName + "']\"/>")) > 0) {
            this._log.info(bundle.formatString("UpgradeUtility.CleanupTableServerObjects.Info.txt", (Object)objCount, (Object)metadataTypeName));
        }
        if ((objCount = this.deleteObjects(store, strReposId, metadataTypeName = "Tree", publicTypeName = "TSSourceTree", flags, strOptions = "<XMLSELECT search=\"*[@TreeType ='TS Config' OR @TreeType ='SSO Tree']\"/>")) > 0) {
            this._log.info(bundle.formatString("UpgradeUtility.CleanupTableServerOrphanedObjects.Info.txt", (Object)objCount, (Object)metadataTypeName));
        }
        if ((objCount = this.deleteObjects(store, strReposId, metadataTypeName = "AccessControlTemplate", null, flags, strOptions = "<XMLSELECT search=\"*[@Name =:'TS Data Source Administrator ACT' OR @Name ='TableServerACT']\"/>")) > 0) {
            this._log.info(bundle.formatString("UpgradeUtility.CleanupTableServerOrphanedObjects.Info.txt", (Object)objCount, (Object)metadataTypeName));
        }
        if ((objCount = this.deleteObjects(store, strReposId, metadataTypeName = "Group", null, flags, strOptions = "<XMLSELECT search=\"*[@Name ='TS Administrators']\"/>")) > 0) {
            this._log.info(bundle.formatString("UpgradeUtility.CleanupTableServerOrphanedObjects.Info.txt", (Object)objCount, (Object)metadataTypeName));
        }
        store.dispose();
    }

    private int deleteObjects(MdObjectStore store, String strReposId, String metadataType, String publicType, int flags, String strOptions) {
        List resultList = null;
        int deleteCount = 0;
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, strReposId, metadataType, flags, strOptions, false);
        }
        catch (Exception e) {
            if (publicType == null) {
                this._log.warn(bundle.formatString("UpgradeUtility.CleanupObjects.Warning.txt", (Object)"querying", (Object)metadataType, (Object)e.getMessage()));
            }
            this._log.warn(bundle.formatString("UpgradeUtility.CleanupTypeDefinitionObjects.Warning.txt", (Object)"querying", (Object)publicType, (Object)e.getMessage()));
        }
        if (resultList != null) {
            for (int i = 0; i < resultList.size(); ++i) {
                CMetadata obj = (CMetadata)resultList.get(i);
                try {
                    if (LOGICAL_TABLESERVER_TYPE.equals(publicType)) {
                        this._factory.deletePublicObject(obj, "<Template TemplateName=\"TSDeleteServer\" Type=\"TSServer\"><LogicalServer><UsingComponents/><Properties/><Keywords/><Extensions/><Notes/><Documents><Document TemplateExpand=\"connect\" AutoMap=\"Y\" /></Documents><AccessControls><AccessControlTemplate TemplateExpand=\"connect\" /><AccessControlEntry /></AccessControls><ServiceTypes /></LogicalServer><ServerComponent><PropertySets/><Properties/><Keywords/><Extensions/><Notes/><Documents><Document TemplateExpand=\"connect\" AutoMap=\"Y\" /></Documents><AccessControls><AccessControlTemplate TemplateExpand=\"connect\" /><AccessControlEntry /></AccessControls><InitProcesses><Transformation Match=\"@TransformRole='Initialization'\" TemplateExpand=\"yes\" /></InitProcesses><ServiceTypes /><Groups><Group Match=\"@name='TS Administrators'\" TemplateExpand=\"yes\" /></Groups><SoftwareTrees><Tree Match=\"@TreeType='TS Config'\" TemplateExpand=\"yes\" /><Tree Match=\"@TreeType='SSO Tree'\" TemplateExpand=\"yes\" /></SoftwareTrees><SourceConnections /><DataPackages/><UsingComponents><ServerComponent TemplateExpand=\"connect\" AutoMap=\"Y\" /><ServiceComponent TemplateExpand=\"yes\" /></UsingComponents></ServerComponent><ServiceComponent><AccessControls><AccessControlTemplate TemplateExpand=\"connect\" /><AccessControlEntry /></AccessControls><PropertySets/><Properties/><ServiceTypes/><DataPackages/></ServiceComponent><Tree><SubTrees/><Members><Identity TemplateExpand=\"connect\" ConnectionAction=\"W\" /><Group TemplateExpand=\"yes\" /><Directory/><File/><ConfiguredComponent/></Members><AccessControls><AccessControlTemplate TemplateExpand=\"connect\" /><AccessControlEntry /></AccessControls></Tree><Group><Members><Identity TemplateExpand=\"connect\" AutoMap=\"Y\" ConnectionAction=\"W\" /><Login TemplateExpand=\"connect\" AutoMap=\"Y\" ConnectionAction=\"W\" /></Members></Group><Directory><AccessControls><AccessControlTemplate TemplateExpand=\"connect\" /><AccessControlEntry /></AccessControls><SubDirectories /></Directory><AccessControlEntry><AssociatedCondition /><Permissions><Permission TemplateExpand=\"connect\" /></Permissions><Identities><Identity TemplateExpand=\"connect\" /></Identities></AccessControlEntry><PropertySet><SetProperties/></PropertySet><Property><OwningType><PropertyType TemplateExpand=\"yes\" /></OwningType></Property><PropertyType><StoredConfiguration /><Properties /></PropertyType><TCPIPConnection><Properties /></TCPIPConnection><COMConnection><Properties/></COMConnection><SASClientConnection><Properties/></SASClientConnection></Template>");
                    } else {
                        obj.delete();
                    }
                    ++deleteCount;
                    continue;
                }
                catch (Exception e) {
                    if (publicType == null) {
                        this._log.warn(bundle.formatString("UpgradeUtility.CleanupObjects.Warning.txt", (Object)"deleting", (Object)metadataType, (Object)e.getMessage()));
                        continue;
                    }
                    this._log.warn(bundle.formatString("UpgradeUtility.CleanupTypeDefinitionObjects.Warning.txt", (Object)"deleting", (Object)publicType, (Object)e.getMessage()));
                }
            }
            try {
                store.updatedMetadataAll();
            }
            catch (Exception e) {
                if (publicType == null) {
                    this._log.warn(bundle.formatString("UpgradeUtility.CleanupObjects.Warning.txt", (Object)"updating", (Object)metadataType, (Object)e.getMessage()));
                }
                this._log.warn(bundle.formatString("UpgradeUtility.CleanupTypeDefinitionObjects.Warning.txt", (Object)"updating", (Object)publicType, (Object)e.getMessage()));
            }
        }
        return deleteCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteTypeDefinitions(MdFactory m_Factory, Repository repos, List typesToDelete) throws MdException, RemoteException {
        List reposTypesList = null;
        String strReposId = repos.getFQID();
        if (strReposId != null) {
            MdObjectStore store = m_Factory.createObjectStore();
            int flags = 264;
            try {
                reposTypesList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "TypeDefinition", flags, "", false);
                if (reposTypesList == null) {
                    boolean bl = false;
                    return bl;
                }
                if (reposTypesList.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                StringBuffer sb = new StringBuffer();
                sb.append("<Template TemplateName=\"PublicTypeDelete\" Type=\"TypeDefinition\">");
                sb.append("<TypeDefinition>");
                sb.append("<AccessControls>");
                sb.append("<AccessControlTemplate TemplateExpand=\"connect\" />");
                sb.append("<AccessControlEntry/>");
                sb.append("</AccessControls>");
                sb.append("<Properties/>");
                sb.append("<Keywords/>");
                sb.append("<Extensions/>");
                sb.append("<Notes/>");
                sb.append("</TypeDefinition>");
                sb.append("<AccessControlEntry>");
                sb.append("<AssociatedCondition/>");
                sb.append("</AccessControlEntry>");
                sb.append("</Template>");
                String deleteTemplate = sb.toString();
                for (int index = 0; index < reposTypesList.size(); ++index) {
                    String typeName;
                    TypeDefinition item = (TypeDefinition)reposTypesList.get(index);
                    if (item == null || !typesToDelete.contains(typeName = item.getTypeName())) continue;
                    m_Factory.deletePublicObject((CMetadata)item, deleteTemplate);
                }
            }
            finally {
                store.dispose();
            }
            return true;
        }
        return false;
    }

    void removeAnalyticsPlatformMetadata(Repository repos) throws Exception {
        List resultList = null;
        String strReposId = null;
        String SASFSscName = null;
        int flags = 2440;
        if (repos == null) {
            strReposId = this._omiUtil.getFoundationReposID();
            flags |= 0x2000;
        } else {
            strReposId = repos.getFQID();
        }
        MdObjectStore store = this._factory.createObjectStore();
        String strSelect = "<XMLSELECT search=\"*[@PublicType ='Application' AND @ClassIdentifier='apcore']\"/>";
        String strTemplate = "<Templates><SoftwareComponent><Notes/><Trees/></SoftwareComponent></Templates>";
        String strOptions = strSelect + strTemplate;
        String metadataType = "SoftwareComponent";
        try {
            resultList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, strReposId, metadataType, flags, strOptions, false);
        }
        catch (MdException e) {
            this._log.warn(bundle.formatString("UpgradeUtility.QueryingObjects.Warning.txt", (Object)e.getMessage()));
        }
        if (resultList == null) {
            return;
        }
        for (int i = 0; i < resultList.size(); ++i) {
            SoftwareComponent scomp = (SoftwareComponent)resultList.get(i);
            SASFSscName = null;
            SASFSscName = this.getSASFoundationServicesDeploymentSoftwareComponentName(scomp);
            if (SASFSscName != null) {
                List scList = null;
                strOptions = "<XMLSELECT search=\"*[@Name ='" + SASFSscName + "']\"/>";
                metadataType = "SoftwareComponent";
                try {
                    scList = this._omiUtil.getMetadataObjectsSubset((MdStore)store, strReposId, metadataType, flags, strOptions, false);
                }
                catch (MdException e) {
                    this._log.warn(bundle.formatString("UpgradeUtility.QueryingObjects.Warning.txt", (Object)e.getMessage()));
                }
                if (scList != null && scList.size() > 0) {
                    SoftwareComponent sc2 = (SoftwareComponent)scList.get(0);
                    ServiceDeploymentDeleter sdd = new ServiceDeploymentDeleter(sc2);
                    if (sdd != null) {
                        sdd.delete();
                    }
                    this._log.info(bundle.formatString("UpgradeUtility.DeletedSoftwareComponent.Info.txt", (Object)sc2.getName()));
                }
            }
            AssociationList treeList = null;
            try {
                treeList = scomp.getTrees();
            }
            catch (MdException e) {
                this._log.warn(bundle.formatString("UpgradeUtility.QueryingObjects.Warning.txt", (Object)e.getMessage()));
            }
            Tree parentTree = null;
            if (treeList != null && treeList.size() > 0) {
                parentTree = (Tree)treeList.get(0);
            }
            scomp.delete();
            this._log.info(bundle.formatString("UpgradeUtility.DeletedSoftwareComponent.Info.txt", (Object)scomp.getName()));
            if (parentTree != null) {
                try {
                    this.deleteAnalyticsTrees(parentTree);
                }
                catch (MdException e) {
                    this._log.warn(bundle.formatString("UpgradeUtility.ExceptionDeletingAnalyticsTree.Warning.txt", (Object)parentTree.getName(), (Object)e.getMessage()));
                }
            }
            try {
                store.updatedMetadataAll();
                continue;
            }
            catch (MdException e) {
                this._log.warn(bundle.formatString("UpgradeUtility.CleanupObjects.Warning.txt", (Object)"updating", (Object)metadataType, (Object)e.getMessage()));
            }
        }
        store.dispose();
    }

    private String getSASFoundationServicesDeploymentSoftwareComponentName(SoftwareComponent scomp) throws RemoteException {
        String name = null;
        HashMap publicProperties = new HashMap();
        HashMap privateProperties = new HashMap();
        try {
            ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)scomp, publicProperties, privateProperties);
        }
        catch (MdException e) {
            this._log.warn(bundle.formatString("UpgradeUtility.RetrievingSCNotes.Warning.txt", (Object)e.getMessage()));
        }
        if (publicProperties != null && publicProperties.size() > 0) {
            Set ks = publicProperties.keySet();
            for (String propName : ks) {
                if (!propName.equalsIgnoreCase("server.apcore.services.deployment.name")) continue;
                name = (String)publicProperties.get(propName);
                break;
            }
        }
        return name;
    }

    private void deleteAnalyticsTrees(Tree tree) throws RemoteException, MdException {
        if (ANALYTICS_PARENT_TREE.equalsIgnoreCase(tree.getName())) {
            if (tree.getMembers().size() == 0 && tree.getSubTrees().size() == 0) {
                tree.delete();
                this._log.info(bundle.formatString("UpgradeUtility.DeletedAnalyticsTree.Info.txt", (Object)tree.getName()));
            } else {
                this._log.warn(bundle.formatString("UpgradeUtility.UnableToDeleteAnalyticsTree.Warning.txt", (Object)tree.getName()));
            }
            return;
        }
        Tree parentTree = tree.getParentTree();
        if (tree.getMembers().size() != 0 || tree.getSubTrees().size() != 0) {
            this._log.warn(bundle.formatString("UpgradeUtility.UnableToDeleteAnalyticsTree.Warning.txt", (Object)tree.getName()));
            return;
        }
        tree.delete();
        this._log.info(bundle.formatString("UpgradeUtility.DeletedAnalyticsTree.Info.txt", (Object)tree.getName()));
        if (parentTree != null) {
            this.deleteAnalyticsTrees(parentTree);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String createSourceTargetPair(String mode, String databaseEngine, String srcReposName, String srcReposId, String tgtReposName, String tgtReposPath, String tgtReposOptions, boolean isCrossHost, String tgtUser, String tgtPwd) {
        if (srcReposName == null || srcReposName.length() == 0 || srcReposId == null || srcReposId.length() == 0 || tgtReposName == null || tgtReposName.length() == 0) {
            this._log.error(bundle.getString("ReplicateXML.SourceRepositoryInfoNotFound.txt"));
            return null;
        }
        if (mode.equalsIgnoreCase("MVA")) {
            if (!databaseEngine.equalsIgnoreCase("BASE")) {
                this._log.error(bundle.getString("RepositoryUpgrade.InvalidEngineforMode.txt"));
                return null;
            }
            if (tgtReposPath == null || tgtReposPath.length() == 0) {
                this._log.error(bundle.formatString("ReplicateXML.TargetRepositoryPathNotFound.txt", (Object)tgtReposName));
                return null;
            }
            if (tgtReposOptions == null || tgtReposOptions.trim().length() == 0) {
                tgtReposOptions = "\"\"";
            }
        } else {
            if (databaseEngine.equalsIgnoreCase("BASE")) {
                this._log.error(bundle.getString("RepositoryUpgrade.InvalidEngineforMode.txt"));
                return null;
            }
            if (!(tgtReposOptions != null && tgtReposOptions.length() != 0 || tgtReposPath != null && tgtReposPath.length() != 0)) {
                this._log.error(bundle.formatString("ReplicateXML.TargetRepositoryPathorOptionsRequired.txt", (Object)tgtReposName));
                return null;
            }
        }
        if (isCrossHost && (tgtUser == null || tgtPwd == null)) {
            this._log.error(bundle.getString("ReplicateXML.TargetServerUserandPasswordRequired.txt"));
            return null;
        }
        return this.createSourceRepos(srcReposName, srcReposId) + this.createTargetRepos(tgtReposName, tgtReposPath, tgtReposOptions, isCrossHost, tgtUser, tgtPwd);
    }

    private String createSourceRepos(String srcReposName, String srcReposId) {
        StringBuffer source = new StringBuffer();
        source.append("     <RepositoryBase Name=\"" + srcReposName + "\" ID=\"" + srcReposId + "\">\n");
        return source.toString();
    }

    private String createTargetRepos(String tgtReposName, String tgtReposPath, String tgtReposOptions, boolean isCrossHost, String tgtUser, String tgtPwd) {
        StringBuffer target = new StringBuffer();
        target.append("       <CopyTarget>\n         <RepositoryBase Name=\"" + tgtReposName + "\" Path=\"" + tgtReposPath + "\" Options=" + tgtReposOptions + "/>\n       </CopyTarget>\n");
        if (isCrossHost) {
            target.append("       <LoginTarget>\n         <Login userid=\"" + tgtUser + "\" password=\"" + tgtPwd + "\"/>\n       </LoginTarget>\n");
        }
        target.append("     </RepositoryBase>\n");
        return target.toString();
    }

    private String createConnectString(int dbName, String user, String pwd, String dbPathOrDsn, boolean isCrossHost, String tgtServer, String tgtPort) {
        String connStr = new String();
        if (dbName == 3) {
            dbPathOrDsn = "default.fdb";
        }
        if (!isCrossHost) {
            switch (dbName) {
                case 3: {
                    connStr = "\"CATALOG=CATALOG_FIREBIRD;DRIVER=FIREBIRD;DATABASE=" + dbPathOrDsn + "\"";
                    break;
                }
                case 2: {
                    connStr = "\"DRIVER=SQL;CONOPTS=((CATALOG=CATALOG_DB2;DRIVER=DB2;UID=" + user + ";PWD=" + pwd + ";CONOPTS=(DSN=" + dbPathOrDsn + ");))\"";
                    break;
                }
                case 1: {
                    connStr = "\"DRIVER=SQL;CONOPTS=((CATALOG=CATALOG_ORACLE;DRIVER=ORACLE;UID=" + user + ";PWD=" + pwd + ";CONOPTS=(DSN=" + dbPathOrDsn + ");))\"";
                    break;
                }
            }
        } else {
            switch (dbName) {
                case 3: {
                    connStr = "\"DRIVER=REMTS;SERVER=" + tgtServer + ";PROTOCOL=BRIDGE;PORT=" + tgtPort + ";CONOPTS=(CATALOG=CATALOG_FIREBIRD;DRIVER=FIREBIRD;DATABASE=" + dbPathOrDsn + ")\"";
                    break;
                }
                case 2: {
                    connStr = "\"DRIVER=REMTS;SERVER=" + tgtServer + ";PROTOCOL=BRIDGE;PORT=" + tgtPort + ";CONOPTS=(CATALOG=CATALOG_DB2;DRIVER=DB2;UID=" + user + ";PWD=" + pwd + ";CONOPTS=(DSN=" + dbPathOrDsn + ");)\"";
                    break;
                }
                case 1: {
                    connStr = "\"DRIVER=REMTS;SERVER=" + tgtServer + ";PROTOCOL=BRIDGE;PORT=" + tgtPort + ";CONOPTS=(CATALOG=CATALOG_ORACLE;DRIVER=ORACLE;UID=" + user + ";PWD=" + pwd + ";CONOPTS=(DSN=" + dbPathOrDsn + ");)\"";
                    break;
                }
            }
        }
        return connStr;
    }
}

