/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata;

import com.sas.management.metadata.MetaMgrMain;
import com.sas.management.metadata.MetaUtility;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IServer;
import com.sas.meta.SASOMI.IServerHelper;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Property;
import com.sas.services.session.SessionContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Repository;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.mgmt.IdentityReposPair;
import com.sas.workspace.mgmt.RepositoryUtil;
import com.sas.workspace.mgmt.visuals.NewProjectReposWizard;
import com.sas.workspace.mgmt.visuals.NewReposWizard;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class RepositoryInitialization {
    protected static MdFactory m_MdFactory;
    protected static String m_storeUserDefinitions;
    protected static String m_pathToUsersRootFolder;
    protected static String m_createRepositoryPath;
    protected static String m_method;
    protected static String m_projOwner;
    protected static SessionContextInterface _session;
    protected static IServer m_server;
    protected static int m_platformVersion;
    protected static MdOMRConnection m_metadataWorkspace;
    protected static WAdminResource bundle;

    public RepositoryInitialization(MdFactory m_Factory) {
        m_method = null;
        m_MdFactory = m_Factory;
        try {
            m_metadataWorkspace = m_MdFactory.getConnection();
            m_platformVersion = m_metadataWorkspace.getPlatformVersion();
        }
        catch (MdException e) {
            String error = e.getLocalizedMessage();
            if (error != null) {
                MetaUtility.MessageSet(m_MdFactory, error);
            } else {
                e.printStackTrace();
            }
        }
        catch (RemoteException re) {
            String error = re.getLocalizedMessage();
            if (error != null) {
                MetaUtility.MessageSet(m_MdFactory, error);
            }
            re.printStackTrace();
        }
    }

    protected void setStoreUserDefinitions(String storeUsers) {
        m_storeUserDefinitions = storeUsers;
    }

    protected void setPathToUsersRootFolder(String usersPath) {
        m_pathToUsersRootFolder = usersPath;
    }

    protected void setProjectOwner(String projOwner) {
        m_projOwner = projOwner;
    }

    protected void setCreatePathLocation(String usersPath) {
        m_createRepositoryPath = usersPath;
    }

    protected void setMethod(String method) {
        m_method = method;
    }

    protected static String getProjectOwner() {
        return m_projOwner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean createRepository(MdObjectStore objectStore, Repository repos) {
        String repName = null;
        String repDesc = null;
        String repOptions = null;
        String repEngine = null;
        String repPath = null;
        try {
            String methodType;
            if (m_method.equalsIgnoreCase(MetaMgrMain.m_createMethod)) {
                methodType = "create";
            } else {
                if (!m_method.equalsIgnoreCase(MetaMgrMain.m_registerMethod)) {
                    MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.InvalidMethodType.Error.txt"));
                    return false;
                }
                methodType = "register";
            }
            boolean m_UserAllowed = RepositoryInitialization.isAuthorized(m_MdFactory, objectStore, repos, methodType);
            if (!m_UserAllowed) {
                String repositoryType = repos.getType();
                if (methodType.equalsIgnoreCase("create")) {
                    if (repositoryType.equalsIgnoreCase("Foundation")) {
                        MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.FoundationUserNotAuthorized1.Error.txt"));
                        return false;
                    }
                    MetaUtility.MessageSet(m_MdFactory, bundle.formatString("RepositoryInitialization.UserNotAuthorized1.Error.txt", (java.lang.Object)repositoryType));
                    return false;
                }
                if (!methodType.equalsIgnoreCase("register")) return false;
                if (repositoryType.equalsIgnoreCase("Foundation")) {
                    MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.FoundationUserNotAuthorized2.Error.txt"));
                    return false;
                }
                MetaUtility.MessageSet(m_MdFactory, bundle.formatString("RepositoryInitialization.UserNotAuthorized2.Error.txt", (java.lang.Object)repositoryType));
                return false;
            }
        }
        catch (Exception e) {
            MetaUtility.MessageSet(m_MdFactory, e.getLocalizedMessage());
            return false;
        }
        boolean ok = RepositoryInitialization.validateRepositoryData(repos);
        if (!ok) {
            return false;
        }
        try {
            repName = m_MdFactory.getOMIUtil().cleanStringForXML(repos.getName());
            repDesc = m_MdFactory.getOMIUtil().cleanStringForXML(repos.getDesc());
            repOptions = m_MdFactory.getOMIUtil().cleanStringForXML(repos.getOptions());
            repEngine = m_MdFactory.getOMIUtil().cleanStringForXML(repos.getEngine());
            repPath = m_MdFactory.getOMIUtil().cleanStringForXML(repos.getPath());
        }
        catch (RemoteException e) {
            String error = e.getLocalizedMessage();
            if (error != null) {
                MetaUtility.MessageSet(m_MdFactory, error);
            }
            e.printStackTrace();
        }
        repos.setName(repName);
        repos.setDesc(repDesc);
        repos.setOptions(repOptions);
        repos.setEngine(repEngine);
        repos.setPath(repPath);
        String existingReposId = null;
        try {
            existingReposId = RepositoryInitialization.doesRepositoryExistAtPath(repos);
        }
        catch (Exception e) {
            MetaUtility.MessageSet(m_MdFactory, e.getMessage());
            return false;
        }
        if (m_method.equalsIgnoreCase(MetaMgrMain.m_createMethod)) {
            if (existingReposId != null) {
                if (!existingReposId.equalsIgnoreCase("unknownpath")) {
                    MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.CreateRepository.RepositoryExists.Error.txt"));
                    return false;
                }
                if (!m_createRepositoryPath.equalsIgnoreCase("Yes")) {
                    MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.CreateRepository.InvalidPath.Error.txt"));
                    return false;
                }
            }
        } else if (m_method.equalsIgnoreCase(MetaMgrMain.m_registerMethod) && existingReposId == null) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.RegisterRepository.NotFound.Error.txt"));
            return false;
        }
        try {
            int reposVersion;
            if (m_method.equalsIgnoreCase(MetaMgrMain.m_registerMethod)) {
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.RegisterRepository.txt"));
            } else {
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.CreateRepository.txt"));
            }
            if (m_createRepositoryPath != null) {
                if (m_createRepositoryPath.equalsIgnoreCase("Yes")) {
                    repos.persist(true);
                } else {
                    repos.persist();
                }
            } else {
                repos.persist();
            }
            if (m_method.equalsIgnoreCase(MetaMgrMain.m_registerMethod) && (reposVersion = RepositoryUtil.getRepositoryFormatVersion((MdFactory)m_MdFactory, (String)repos.getFQID())) < 6) {
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.UnsupportedRepositoryVersion.Error.txt"));
                repos.deleteRepository(repos.getName(), repos.getFQID(), 0);
                return false;
            }
            if (!repos.getType().equalsIgnoreCase("PROJECT")) return true;
            if (RepositoryInitialization.associateIdentityToProjectRepos(objectStore, repos)) return true;
            return false;
        }
        catch (Exception e) {
            String error = e.getLocalizedMessage();
            if (error != null) {
                MetaUtility.MessageSet(m_MdFactory, error);
                return false;
            } else {
                e.printStackTrace();
            }
            return false;
        }
    }

    private static boolean isAuthorized(MdFactory m_Factory, MdObjectStore objectStore, Repository repos, String methodType) throws Exception {
        block18: {
            RepositoryUtil.ConnectedIdentityInfo connUserInfo = null;
            String repositoryType = repos.getType();
            try {
                connUserInfo = new RepositoryUtil.ConnectedIdentityInfo(m_Factory);
            }
            catch (Exception e) {
                if (methodType.equalsIgnoreCase("create")) {
                    throw new Exception(bundle.formatString("RepositoryInitializationUnableToDetermineAdminPermission1.Error.txt", (java.lang.Object)repositoryType));
                }
                throw new Exception(bundle.formatString("RepositoryInitializationUnableToDetermineAdminPermission2.Error.txt", (java.lang.Object)repositoryType));
            }
            if (connUserInfo.m_UserClass.indexOf("Unrestricted") != -1) {
                if (connUserInfo.m_UnrestrictedSource != null) {
                    if (connUserInfo.m_UnrestrictedSource.indexOf("ConfigFile") != -1) {
                        return true;
                    }
                    return !repositoryType.equalsIgnoreCase("Foundation");
                }
                return true;
            }
            if (repositoryType.equalsIgnoreCase("Foundation")) {
                return false;
            }
            if (connUserInfo.m_Name.equalsIgnoreCase("Public") && connUserInfo.m_Type.equalsIgnoreCase("IdentityGroup")) {
                throw new Exception(bundle.getString("RepositoryInitialization.PublicUserNotAuthorizedToInitialize.Error.txt"));
            }
            if (connUserInfo.m_UserClass.indexOf("Administrator") == -1 && connUserInfo.m_UserClass.indexOf("Operator") == -1) {
                return false;
            }
            if (repositoryType.equalsIgnoreCase("Custom")) {
                RepositoryUtil.isConnectedUserAuthorizedOnBIPService((MdFactory)m_Factory);
            }
            if (repositoryType.equalsIgnoreCase("Project")) {
                String projOwner = RepositoryInitialization.getProjectOwner();
                if (projOwner != null) {
                    IdentityReposPair projUser = RepositoryInitialization.getIdentityObjectfromOwnerName(objectStore, null, projOwner);
                    if (projUser != null) {
                        Identity ident = projUser.getOwner();
                        boolean allowed = RepositoryUtil.isConnectedUserAuthorizedOnIdentity((MdFactory)m_MdFactory, (Identity)ident);
                        if (!allowed) {
                            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.Identity.NotAuthorized.txt"));
                            return false;
                        }
                        break block18;
                    }
                    MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.ProjectOwnerNotFound.txt"));
                    return false;
                }
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.MissingProjectOwner.txt"));
                return false;
            }
        }
        return true;
    }

    private static String doesRepositoryExistAtPath(Repository repos) throws MdException {
        String reposID;
        block11: {
            reposID = null;
            String exists = null;
            IServer serverConn = null;
            try {
                serverConn = RepositoryInitialization.MakeIServerConnection(m_MdFactory.getConnection().getCMRHandle());
            }
            catch (RemoteException re) {
                throw new MdException((Throwable)re);
            }
            if (serverConn == null) {
                return null;
            }
            try {
                StringHolder output = new StringHolder();
                String path = repos.getPath();
                String engine = repos.getEngine();
                String options = repos.getOptions();
                String input = "<ReposId Path=\"" + path + "\" Engine=\"" + engine + "\" Options=\"" + options + "\"/>";
                serverConn.Status(input, output, "");
                String outputStr = output.value;
                int beginReposIdIndex = outputStr.lastIndexOf("ReposId=");
                if (beginReposIdIndex == -1) {
                    return null;
                }
                int beginQuoteIndex = beginReposIdIndex + 8;
                int endQuoteIndex = outputStr.indexOf(34, beginQuoteIndex + 1);
                if (endQuoteIndex - beginQuoteIndex > 1) {
                    reposID = outputStr.substring(beginQuoteIndex + 1, endQuoteIndex);
                    break block11;
                }
                if (m_method.equalsIgnoreCase(MetaMgrMain.m_registerMethod)) {
                    return null;
                }
                int beginExistsIndex = outputStr.indexOf("Exists=");
                if (beginExistsIndex == -1) {
                    return null;
                }
                beginQuoteIndex = beginExistsIndex + 7;
                endQuoteIndex = outputStr.indexOf(34, beginQuoteIndex + 1);
                if (endQuoteIndex - beginQuoteIndex > 1) {
                    exists = outputStr.substring(beginQuoteIndex + 1, endQuoteIndex);
                    if (!exists.equalsIgnoreCase("No")) {
                        return null;
                    }
                    reposID = "unknownpath";
                    break block11;
                }
                return null;
            }
            catch (Exception e) {
                throw new MdException((Throwable)e);
            }
        }
        return reposID;
    }

    protected static IServer MakeIServerConnection(IOMI OMRConnection) throws MdException {
        try {
            if (OMRConnection != null) {
                Object obj = OMRConnection._duplicate();
                IServer iServer = IServerHelper.narrow((Object)obj);
                if (iServer != null) {
                    return iServer;
                }
                throw new MdException("Unable to connect to server");
            }
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
        return null;
    }

    public static boolean initializeRepository(Repository repos, SessionContextInterface session) {
        _session = session;
        return RepositoryInitialization.initializeRepository(repos);
    }

    public static boolean initializeRepository(Repository repos) {
        String storeUsers = null;
        String usersPath = null;
        String reposId = null;
        boolean initResult = true;
        IOMI omiConnection = null;
        try {
            omiConnection = m_MdFactory.getConnection().getCMRHandle();
            reposId = RepositoryUtil.getReposIdForName((MdFactory)m_MdFactory, (String)repos.getName());
            storeUsers = m_storeUserDefinitions != null ? m_MdFactory.getOMIUtil().cleanStringForXML(m_storeUserDefinitions) : null;
            String string = usersPath = m_pathToUsersRootFolder != null ? m_MdFactory.getOMIUtil().cleanStringForXML(m_pathToUsersRootFolder) : null;
            if (reposId != null && repos.getIsChangeManaged()) {
                RepositoryUtil.setChangeManaged((MdFactory)m_MdFactory, (String)reposId);
            }
        }
        catch (Exception e) {
            String error = e.getLocalizedMessage();
            if (error != null) {
                MetaUtility.MessageSet(m_MdFactory, error);
            } else {
                e.printStackTrace();
            }
            return false;
        }
        if (reposId != null) {
            repos.setFQID(reposId);
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.InitializingRepository.txt"));
            initResult = repos.getType().equalsIgnoreCase("PROJECT") ? NewProjectReposWizard.initializeProjectRepository((MdFactory)m_MdFactory, (Repository)repos) : NewReposWizard.initializeRepository((MdFactory)m_MdFactory, (Repository)repos, (SessionContextInterface)_session);
        } else {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.ReposNotFound.txt"));
            return false;
        }
        if (initResult && (repos.getType().equalsIgnoreCase("FOUNDATION") || repos.getType().equalsIgnoreCase("CUSTOM"))) {
            try {
                int flags = 0x10000180;
                String options = "<XMLSELECT search=\"@Name = 'Store User Definitions' OR @Name = 'Path to Users Root Folder'\"/>";
                MdObjectStore store = m_MdFactory.createObjectStore();
                List policiesList = m_MdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "Property", flags, options, false);
                Property propertyPathToRoot = null;
                Property propertyStoreUsers = null;
                for (int i = 0; i < policiesList.size(); ++i) {
                    Property policy = (Property)policiesList.get(i);
                    if (policy.getPropertyName().equals("Store User Definitions")) {
                        propertyStoreUsers = policy;
                        continue;
                    }
                    if (!policy.getPropertyName().equals("Path to Users Root Folder")) continue;
                    propertyPathToRoot = policy;
                }
                boolean commitOutstandingChanges = false;
                if (storeUsers != null && propertyStoreUsers != null && !storeUsers.equals(propertyStoreUsers.getDefaultValue())) {
                    propertyStoreUsers.setDefaultValue(storeUsers);
                    commitOutstandingChanges = true;
                }
                if (usersPath != null && propertyPathToRoot != null && !usersPath.equals(propertyPathToRoot.getDefaultValue())) {
                    propertyPathToRoot.setDefaultValue(usersPath);
                    commitOutstandingChanges = true;
                }
                if (commitOutstandingChanges) {
                    store.updatedMetadataAll();
                }
                store.dispose();
            }
            catch (MdException e) {
                if (e.getMessage().length() > 0) {
                    MessageUtil.displayMessage((String)e.getMessage());
                } else {
                    e.printStackTrace();
                }
                initResult = false;
            }
            catch (RemoteException re) {
                String error = re.getLocalizedMessage();
                if (error != null) {
                    MetaUtility.MessageSet(m_MdFactory, error);
                }
                re.printStackTrace();
            }
            if (repos.getType().equalsIgnoreCase("FOUNDATION") && omiConnection != null) {
                RepositoryInitialization.refreshServer(omiConnection);
            }
        }
        return initResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean associateIdentityToProjectRepos(MdObjectStore objectStore, Repository repos) throws Exception {
        String reposId = repos.getFQID();
        String projOwner = RepositoryInitialization.getProjectOwner();
        if (projOwner == null) return false;
        IdentityReposPair projUser = RepositoryInitialization.getIdentityObjectfromOwnerName(objectStore, reposId, projOwner);
        if (projUser != null) {
            try {
                RepositoryUtil.associateIdentityToProjectRepos((MdFactory)m_MdFactory, (String)reposId, (Identity)projUser.getOwner());
                return true;
            }
            catch (Exception e) {
                MetaUtility.MessageSet(m_MdFactory, bundle.formatString("RepositoryInitialization.AssociateIdentitytoProjectFailed.Error.txt", (java.lang.Object)e.getMessage()));
                int deleteFlag = 32;
                if (m_method.equalsIgnoreCase(MetaMgrMain.m_registerMethod)) {
                    deleteFlag = 0;
                }
                repos.deleteRepository(repos.getName(), reposId, deleteFlag);
                return false;
            }
        } else {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.ProjectOwnerNotFound2.txt"));
            int deleteFlag = 32;
            if (m_method.equalsIgnoreCase(MetaMgrMain.m_registerMethod)) {
                deleteFlag = 0;
            }
            repos.deleteRepository(repos.getName(), reposId, deleteFlag);
            return false;
        }
    }

    private static IdentityReposPair getIdentityObjectfromOwnerName(MdObjectStore objectStore, String reposId, String projectOwner) throws Exception {
        IdentityReposPair projUser = null;
        if (projectOwner != null) {
            try {
                if (reposId == null) {
                    Repository repos = null;
                    Repository[] repositories = Repository.getRepositories((MdFactory)m_MdFactory);
                    for (int j = 0; j < repositories.length; ++j) {
                        if (!repositories[j].getType().equalsIgnoreCase("FOUNDATION")) continue;
                        repos = repositories[j];
                        break;
                    }
                    if (repos == null) {
                        return projUser;
                    }
                    reposId = repos.getFQID();
                }
                Vector tempIdList = RepositoryUtil.getIdentityObjects((MdObjectStore)objectStore, (MdFactory)m_MdFactory, (String)reposId);
                for (int j = 0; j < tempIdList.size(); ++j) {
                    IdentityReposPair obj = (IdentityReposPair)tempIdList.get(j);
                    Identity cmObj = obj.getOwner();
                    if (!(cmObj instanceof Person) || !cmObj.getName().equals(projectOwner)) continue;
                    projUser = new IdentityReposPair(cmObj, reposId);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return projUser;
    }

    private static boolean validateRepositoryData(Repository repos) {
        boolean okdependent;
        boolean okfoundation;
        String rType = repos.getType();
        if (rType == null || rType.length() == 0) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.MissingReposType.txt"));
            return false;
        }
        if (repos.getType().equalsIgnoreCase("FOUNDATION") && !(okfoundation = RepositoryInitialization.validateFoundationRepositoryData(repos))) {
            return false;
        }
        if ((repos.getType().equalsIgnoreCase("PROJECT") || repos.getType().equalsIgnoreCase("CUSTOM")) && !(okdependent = RepositoryInitialization.validateDependentRepositoryData(repos))) {
            return false;
        }
        boolean okcommon = RepositoryInitialization.validateCommonRepositoryData(repos);
        return okcommon;
    }

    private static boolean validateFoundationRepositoryData(Repository repos) {
        String rName = repos.getName();
        if (rName == null || rName.length() == 0) {
            repos.setName("Foundation");
        }
        if (repos.getEngine().equals("BASE") && (repos.getPath() == null || repos.getPath().length() == 0)) {
            repos.setPath("MetadataRepositories/Foundation");
        }
        boolean Fexists = false;
        Repository[] reposArray = null;
        try {
            reposArray = Repository.getRepositories((MdFactory)m_MdFactory);
        }
        catch (Exception e) {
            String strMessage = e.getMessage();
            if (strMessage != null) {
                MetaUtility.MessageSet(m_MdFactory, strMessage);
            }
            e.printStackTrace();
        }
        if (reposArray.length != 0 || reposArray != null) {
            int repcount = reposArray.length;
            for (int i = 0; i < repcount && !Fexists; ++i) {
                Repository rep = reposArray[i];
                String rType = rep.getType();
                if (!rType.equalsIgnoreCase("FOUNDATION")) continue;
                Fexists = true;
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.DuplicateFoundationError.txt"));
                return false;
            }
        }
        return true;
    }

    private static boolean validateDependentRepositoryData(Repository repos) {
        if (repos.getType().equalsIgnoreCase("PROJECT")) {
            repos.setIsChangeManaged(false);
            String projOwner = RepositoryInitialization.getProjectOwner();
            if (projOwner == null || projOwner.length() == 0) {
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.MissingProjectOwner.txt"));
                return false;
            }
        }
        return true;
    }

    private static boolean validateCommonRepositoryData(Repository repos) {
        String repType = repos.getType();
        if (repType == null || repType.length() == 0) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.MissingReposType.txt"));
            return false;
        }
        if (repType.equalsIgnoreCase("FOUNDATION")) {
            repos.setType("FOUNDATION");
        } else if (repType.equalsIgnoreCase("CUSTOM")) {
            repos.setType("CUSTOM");
        } else if (repType.equalsIgnoreCase("PROJECT")) {
            repos.setType("PROJECT");
        } else {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.InvalidReposType.txt"));
            return false;
        }
        String rName = repos.getName();
        if (rName == null || rName.length() == 0) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.MissingReposName.txt"));
            return false;
        }
        boolean valid = RepositoryUtil.validateRepositoryName((MdFactory)m_MdFactory, (String)rName, (String)repType);
        if (!valid) {
            MetaUtility.MessageSet(m_MdFactory, bundle.formatString("RepositoryInitialization.InvalidReposName.txt", (java.lang.Object)rName));
            return false;
        }
        if ((repos.getPath() == null || repos.getPath().length() == 0) && repos.getEngine().equalsIgnoreCase("BASE")) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.RequiredPath.txt"));
            return false;
        }
        if (!repos.getEngine().equalsIgnoreCase("BASE")) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.InvalidEngine2.txt"));
            return false;
        }
        switch (repos.getExtendedAccess()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                if (!repos.getType().equalsIgnoreCase("FOUNDATION")) break;
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.InvalidAccessMode2.txt"));
                return false;
            }
            default: {
                MetaUtility.MessageSet(m_MdFactory, bundle.getString(repos.getType().equalsIgnoreCase("FOUNDATION") ? "RepositoryInitialization.InvalidAccessMode2.txt" : "RepositoryInitialization.InvalidAccessMode.txt"));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshServer(IOMI omiConnection) {
        boolean paused = false;
        try {
            m_server = m_MdFactory.getConnection().MakeIServerConnection(omiConnection);
            paused = true;
            m_server.Refresh("<SERVER/> <CLUSTER/>");
            m_server.Resume("<SERVER/> <CLUSTER/>");
            paused = false;
        }
        catch (Exception exc) {
            String error = exc.getMessage();
            MetaUtility.MessageSet(m_MdFactory, error);
        }
        finally {
            if (paused) {
                try {
                    m_server.Resume("<SERVER/> <CLUSTER/>");
                }
                catch (Exception exc2) {
                    String error2 = exc2.getMessage();
                    MetaUtility.MessageSet(m_MdFactory, error2);
                }
            }
        }
    }

    static {
        m_storeUserDefinitions = null;
        m_pathToUsersRootFolder = null;
        m_createRepositoryPath = null;
        m_projOwner = null;
        _session = null;
        bundle = new WAdminResource(RepositoryInitialization.class);
    }
}

