/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata;

import com.sas.services.information.OMIRepositoryInterface;
import java.rmi.RemoteException;
import java.text.Collator;
import java.util.Comparator;

public class RepositoryComparator
implements Comparator<Object> {
    @Override
    public int compare(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        return this.runCompare(obj1, obj2);
    }

    private int runCompare(Object obj1, Object obj2) {
        OMIRepositoryInterface repos1 = null;
        OMIRepositoryInterface repos2 = null;
        if (!(obj1 instanceof OMIRepositoryInterface)) {
            return -1;
        }
        repos1 = (OMIRepositoryInterface)obj1;
        if (!(obj2 instanceof OMIRepositoryInterface)) {
            return 1;
        }
        repos2 = (OMIRepositoryInterface)obj2;
        try {
            String type1 = repos1.getRepositoryType();
            String type2 = repos2.getRepositoryType();
            if (type1 != null && type1.equalsIgnoreCase(type2)) {
                Collator collator = Collator.getInstance();
                return collator.compare(repos1.getDefaultRepositoryName(), repos2.getDefaultRepositoryName());
            }
            if ("FOUNDATION".equalsIgnoreCase(type1)) {
                return -1;
            }
            if ("FOUNDATION".equalsIgnoreCase(type2)) {
                return 1;
            }
            if ("CUSTOM".equalsIgnoreCase(type1)) {
                return -1;
            }
            return 1;
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }
}

