/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata;

import com.sas.management.metadata.UpgradeException;
import com.sas.management.metadata.UpgradeUtility;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.services.ServiceException;
import com.sas.services.deployment.PlatformServices;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.UpgradeInterface;
import com.sas.workspace.WAdminResource;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class ObjectUpgrade {
    protected static WAdminResource bundle = new WAdminResource(ObjectUpgrade.class);
    private boolean _upgradeCompleted = false;
    private int _upgradedObjectCount;
    private int _upgradeErrorCount;
    private int _objectCountByType;
    private int _upgradedObjectCountByType;
    private long _lastLogTime = 0L;
    private final long LOG_PROGRESS_MESSAGE_INTERVAL = 60000L;
    private boolean _warningsWrittenDuringObjectUpgrade;
    private Logger _log = null;
    private List<Logger> _allLoggers = null;
    private MdFactory _factory;
    private Document _rulesDoc;
    private SessionContextInterface _session;
    private OMIServer _parentServer;
    private String _publicTypeWithNoUpgradeInterface = null;
    private InformationServiceInterface _infoService = null;
    private Object _folderItemRefreshOption = null;
    private Object _folderSubfolderRefreshOption = null;
    private Object _metadataTreeRefreshOption = null;

    ObjectUpgrade(SessionContextInterface session, Logger log, List<Logger> allLoggers) {
        this._session = session;
        this._log = log;
        this._allLoggers = allLoggers;
    }

    int getUpgradedObjectCount() {
        if (!this._upgradeCompleted) {
            throw new IllegalStateException();
        }
        return this._upgradedObjectCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int upgrade() throws UpgradeException {
        int rc = 0;
        this._log.info(bundle.getString("ObjectUpgrade.Start.log"));
        this._upgradeCompleted = false;
        try {
            this._parentServer = (OMIServer)this._session.getUserContext().getAuthServer();
            this._factory = this._parentServer.getMdFactory();
        }
        catch (ServiceException e) {
            throw new UpgradeException(bundle.getString("ObjectUpgrade.InitError.log"), e);
        }
        catch (RemoteException e) {
            throw new UpgradeException(bundle.getString("ObjectUpgrade.InitError.log"), e);
        }
        MessageCounter messageCounter = new MessageCounter();
        try {
            this.setInformationServiceRefresh(60000);
            this.loadObjectUpgradeRules();
            NodeList rules = this._rulesDoc.getElementsByTagName("Rule");
            this._upgradedObjectCount = 0;
            for (int i = 0; i < rules.getLength(); ++i) {
                this.processRule(rules.item(i), messageCounter);
            }
            this._log.info(bundle.formatString("ObjectUpgrade.ObjectsUpgraded.fmt.log", (Object)new Integer(this._upgradedObjectCount), (Object)new Integer(this._upgradeErrorCount)));
            int ucoRC = this.upgradeChangeObjects();
            if (this._upgradeErrorCount > 0 || ucoRC == 8) {
                this._log.info(bundle.getString("ObjectUpgrade.Error.log"));
                rc = 8;
            } else if (this._warningsWrittenDuringObjectUpgrade) {
                this._log.info(bundle.getString("ObjectUpgrade.Warning.log"));
                rc = 4;
            } else if (this._upgradedObjectCount > 0) {
                this._log.info(bundle.getString("ObjectUpgrade.Success.log"));
            } else {
                this._log.info(bundle.getString("ObjectUpgrade.UpToDate.log"));
            }
        }
        finally {
            this.resetInformationServiceRefresh();
            messageCounter.close();
        }
        this._upgradeCompleted = true;
        return rc;
    }

    void dispose() {
    }

    private void loadObjectUpgradeRules() throws UpgradeException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            InputStream docStream = ObjectUpgrade.class.getResourceAsStream("ObjectUpgradeRules.xml");
            this._rulesDoc = docBuilder.parse(docStream);
        }
        catch (ParserConfigurationException e) {
            throw new UpgradeException(bundle.getString("ObjectUpgrade.ParseRulesError.log"), e);
        }
        catch (IOException e) {
            throw new UpgradeException(bundle.getString("ObjectUpgrade.ParseRulesError.log"), e);
        }
        catch (SAXException e) {
            throw new UpgradeException(bundle.getString("ObjectUpgrade.ParseRulesError.log"), e);
        }
    }

    private void processRule(Node rule, MessageCounter messageCounter) throws UpgradeException {
        NamedNodeMap childNodeMap = rule.getAttributes();
        String publicType = childNodeMap.getNamedItem("PublicType").getNodeValue();
        String strMetadataType = childNodeMap.getNamedItem("MetadataType").getNodeValue();
        double usageVersion = -1.0;
        if (childNodeMap.getNamedItem("UsageVersion") != null) {
            usageVersion = Double.parseDouble(childNodeMap.getNamedItem("UsageVersion").getNodeValue());
        }
        int batchCount = 100;
        if (childNodeMap.getNamedItem("BatchCount") != null) {
            batchCount = Integer.parseInt(childNodeMap.getNamedItem("BatchCount").getNodeValue());
        }
        String xmlMatchCriteria = childNodeMap.getNamedItem("Match").getNodeValue();
        Node labelNode = childNodeMap.getNamedItem("Label");
        String label = null;
        if (labelNode != null) {
            label = labelNode.getNodeValue();
        }
        String strSelect = "<XMLSELECT search=\"" + xmlMatchCriteria + "\"/>";
        int flags = 24968;
        try {
            MdOMIUtil OMIUtil = this._factory.getOMIUtil();
            List objects = OMIUtil.getMetadataObjectsNoCache(strMetadataType, OMIUtil.getFoundationReposID(), strSelect, flags);
            this._objectCountByType = objects.size();
            this._upgradedObjectCountByType = 0;
            this._lastLogTime = new Date().getTime();
            int initialErrorCount = this._upgradeErrorCount;
            Iterator<Map<String, String>> iter = objects.iterator();
            while (iter.hasNext()) {
                Map<String, String> objectsMap = this.makeUpgradeBatch(iter, strMetadataType, batchCount);
                this.processUpgradeBatch(objectsMap, publicType, usageVersion, messageCounter);
            }
            if (this._objectCountByType > 0) {
                this._log.info(bundle.formatString("ObjectUpgrade.ObjectCount.fmt.log", (Object)(label == null ? publicType : label), (Object)new Integer(this._objectCountByType), (Object)new Integer(this._upgradeErrorCount - initialErrorCount)));
            }
        }
        catch (MdException e) {
            throw new UpgradeException(bundle.getString("ObjectUpgrade.UpgradeError.log"), e);
        }
        catch (ServiceException e) {
            throw new UpgradeException(bundle.getString("ObjectUpgrade.UpgradeError.log"), e);
        }
        catch (RemoteException e) {
            throw new UpgradeException(bundle.getString("ObjectUpgrade.UpgradeError.log"), e);
        }
    }

    private Map<String, String> makeUpgradeBatch(Iterator<Map<String, String>> objectIterator, String metadataType, int batchCount) {
        HashMap<String, String> objectsToUpgradeMap = new HashMap<String, String>(batchCount * 3 / 2);
        int objectCount = 0;
        while (objectCount < batchCount && objectIterator.hasNext()) {
            try {
                Map<String, String> objectDescriptor = objectIterator.next();
                String objectId = objectDescriptor.get("Id");
                objectsToUpgradeMap.put(objectId, metadataType);
                ++objectCount;
            }
            catch (RuntimeException e) {}
        }
        return objectsToUpgradeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpgradeBatch(Map<String, String> objectsMap, String publicType, double usageVersion, MessageCounter messageCounter) throws MdException, ServiceException, RemoteException {
        ChildServerInterface batchTransaction = this._parentServer.newChild(true);
        try {
            List objects = this._factory.getOMIUtil().getMetadata((MdStore)((OMIServer)batchTransaction).getObjectStore(), objectsMap, null, 8);
            boolean noUpgradeInterface = this._publicTypeWithNoUpgradeInterface != null && this._publicTypeWithNoUpgradeInterface.equals(publicType);
            for (PrimaryType object : objects) {
                if (!publicType.equals(object.getPublicType())) {
                    object.setPublicType(publicType);
                }
                if (!(usageVersion > 0.0) || usageVersion == object.getUsageVersion()) continue;
                object.setUsageVersion(usageVersion);
            }
            ((PrimaryType)objects.get(0)).getObjectStore().updatedMetadataAll();
            for (PrimaryType object : objects) {
                String objectType;
                messageCounter.reset();
                try {
                    MetadataInterface smartObject = batchTransaction.factoryProcess((Object)object);
                    if (smartObject instanceof UpgradeInterface) {
                        if (this._log.isDebugEnabled()) {
                            String type;
                            String path;
                            PathUrl url = smartObject.getPathUrl();
                            if (url != null) {
                                path = url.getDisplayPath();
                                type = url.getType();
                            } else {
                                path = smartObject.getName();
                                type = smartObject.getType();
                            }
                            this._log.debug("Upgrading " + type + " " + path);
                        }
                        ((UpgradeInterface)smartObject).upgradeFromPreviousVersion();
                        if (messageCounter.getErrorCount() <= 0 && messageCounter.getFatalCount() <= 0) continue;
                        ++this._upgradeErrorCount;
                        continue;
                    }
                    ++this._upgradeErrorCount;
                    if (noUpgradeInterface) continue;
                    this._log.warn(bundle.formatString("ObjectUpgrade.UpgradeInterfaceNotFound.fmt.log", (Object)publicType));
                    noUpgradeInterface = true;
                }
                catch (ServiceException e) {
                    ++this._upgradeErrorCount;
                    objectType = object.getPublicType();
                    if (objectType == null || objectType.length() == 0) {
                        objectType = object.getCMetadataType();
                    }
                    this._log.error(bundle.formatString("ObjectUpgrade.ObjectError.fmt.log", (Object)objectType, (Object)object.getName(), (Object)object.getId()));
                    this._log.error("  " + e.toString());
                    if (!this._log.isDebugEnabled()) continue;
                    e.printStackTrace();
                }
                catch (RuntimeException e) {
                    ++this._upgradeErrorCount;
                    objectType = object.getPublicType();
                    if (objectType == null || objectType.length() == 0) {
                        objectType = object.getCMetadataType();
                    }
                    this._log.error(bundle.formatString("ObjectUpgrade.ObjectError.fmt.log", (Object)objectType, (Object)object.getName(), (Object)object.getId()));
                    this._log.error("  " + e.toString());
                    if (!this._log.isDebugEnabled()) continue;
                    e.printStackTrace();
                }
                finally {
                    if (messageCounter.getWarnCount() > 0) {
                        this._warningsWrittenDuringObjectUpgrade = true;
                    }
                    ++this._upgradedObjectCount;
                    ++this._upgradedObjectCountByType;
                    long curTime = new Date().getTime();
                    if (curTime - this._lastLogTime < 60000L) continue;
                    String objectType2 = object.getPublicType();
                    if (objectType2 == null || objectType2.length() == 0) {
                        objectType2 = object.getCMetadataType();
                    }
                    this._log.info(bundle.formatString("ObjectUpgrade.Progress.fmt.log", (Object)objectType2, (Object)new Integer(this._upgradedObjectCountByType), (Object)new Integer(this._objectCountByType)));
                    this._lastLogTime = curTime;
                }
            }
            this._publicTypeWithNoUpgradeInterface = noUpgradeInterface ? publicType : null;
        }
        finally {
            batchTransaction.commit();
        }
    }

    private int upgradeChangeObjects() throws UpgradeException {
        try {
            UpgradeUtility.getInstance(this._factory, this._log).updateChangeObjects(null);
            return 0;
        }
        catch (Exception e) {
            this._log.error(bundle.getString("ObjectUpgrade.UpdateChangeObjects.Error.log"));
            return 8;
        }
    }

    private void setInformationServiceRefresh(int timeout) {
        try {
            ServiceTemplate serviceTemplate = new ServiceTemplate(new Class[]{InformationServiceInterface.class});
            this._infoService = (InformationServiceInterface)PlatformServices.findService((ServiceTemplate)serviceTemplate);
            if (this._infoService != null) {
                this._folderItemRefreshOption = this._infoService.getOption(1);
                this._folderSubfolderRefreshOption = this._infoService.getOption(2);
                this._metadataTreeRefreshOption = this._infoService.getOption(0);
                Integer timeoutOption = new Integer(timeout);
                this._infoService.setOption(1, (Object)timeoutOption);
                this._infoService.setOption(2, (Object)timeoutOption);
                this._infoService.setOption(0, (Object)timeoutOption);
            }
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void resetInformationServiceRefresh() {
        if (this._infoService != null) {
            try {
                if (this._folderItemRefreshOption != null) {
                    this._infoService.setOption(1, this._folderItemRefreshOption);
                }
                if (this._folderSubfolderRefreshOption != null) {
                    this._infoService.setOption(2, this._folderSubfolderRefreshOption);
                }
                if (this._metadataTreeRefreshOption != null) {
                    this._infoService.setOption(0, this._metadataTreeRefreshOption);
                }
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Plugin(name="MessageCounter", category="Core", elementType="appender", printObject=true)
    class MessageCounter
    extends AbstractAppender {
        private int _warnCount;
        private int _errorCount;
        private int _fatalCount;

        protected MessageCounter() {
            super("MessageCounter", (Filter)ThresholdFilter.createFilter((Level)Level.WARN, null, null), null, false, null);
            this._warnCount = 0;
            this._errorCount = 0;
            this._fatalCount = 0;
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            for (Logger logger : ObjectUpgrade.this._allLoggers) {
                lc.getLogger(logger.getName()).addAppender((Appender)this);
            }
        }

        @PluginFactory
        public MessageCounter createAppender() {
            return new MessageCounter();
        }

        void reset() {
            this._warnCount = 0;
            this._errorCount = 0;
            this._fatalCount = 0;
        }

        int getWarnCount() {
            return this._warnCount;
        }

        int getErrorCount() {
            return this._errorCount;
        }

        int getFatalCount() {
            return this._fatalCount;
        }

        public void append(LogEvent event) {
            Level level = event.getLevel();
            if (Level.WARN.equals((Object)level)) {
                ++this._warnCount;
            } else if (Level.ERROR.equals((Object)level)) {
                ++this._errorCount;
            } else if (Level.FATAL.equals((Object)level)) {
                ++this._fatalCount;
            }
        }

        public void close() {
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = lc.getConfiguration();
            for (Logger logger : ObjectUpgrade.this._allLoggers) {
                LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
                loggerConfig.removeAppender(this.getName());
            }
            lc.updateLoggers();
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

