/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata;

import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.metadata.remote.MdFactory;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import org.omg.CORBA.Object;

public class MetaUtility {
    protected static WAdminResource bundle = new WAdminResource(MetaUtility.class);
    protected static String m_authId = null;
    private static boolean m_debugMsgsOn = false;

    protected static String getUserAuthId() {
        return m_authId;
    }

    protected static void setDebugOn(MdFactory m_MdFactory, boolean value) throws Exception {
        m_debugMsgsOn = value;
        m_MdFactory.setDebug(value);
        m_MdFactory.setLoggingEnabled(value);
    }

    protected static boolean isUnrestricted(MdFactory m_MdFactory) throws Exception {
        ISecurity_1_1 iSec = null;
        String[][] options = new String[0][0];
        VariableArray2dOfStringHolder returnAuthorizations = new VariableArray2dOfStringHolder();
        String userClass = null;
        String authId = null;
        try {
            iSec = ISecurity_1_1Helper.narrow((Object)m_MdFactory.getConnection().getCMRHandle());
            iSec.GetInfo("GetIdentityInfo", "", options, returnAuthorizations);
        }
        catch (Exception e) {
            throw new Exception("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        for (int i = 0; i < returnAuthorizations.value.length; ++i) {
            String key = returnAuthorizations.value[i][0];
            if ((key = key.trim()).equalsIgnoreCase("UserClass")) {
                userClass = returnAuthorizations.value[i][1];
                continue;
            }
            if (!key.equalsIgnoreCase("AuthenticatedUserid")) continue;
            authId = returnAuthorizations.value[i][1];
        }
        if (authId != null) {
            if (userClass.indexOf("Unrestricted") == -1) {
                return false;
            }
            m_authId = authId;
            return true;
        }
        throw new Exception(bundle.getString("UpgradeMetadata.UnableToDetermineUnrestricted.error.txt"));
    }

    protected static WorkspaceFile getWorkspaceFile(String strFile) {
        if (strFile.lastIndexOf(92) > -1) {
            return new WorkspaceFile(strFile);
        }
        WorkspaceFile wksp = new WorkspaceFile();
        String workspacePath = Workspace.getMetadataProfilePath();
        String separator = File.separator;
        String name = workspacePath + separator + strFile;
        File f = new File(name);
        if (f.exists()) {
            wksp.setFileName(name);
            wksp.openExisting(name);
            return wksp;
        }
        return null;
    }

    protected static void MessageSet(MdFactory m_MdFactory, String message) {
        try {
            m_MdFactory.setDebug(true);
            m_MdFactory.getUtil().printOutputln(message);
            if (!m_debugMsgsOn) {
                m_MdFactory.setDebug(false);
            }
        }
        catch (RemoteException e) {
            try {
                m_MdFactory.setDebug(true);
                m_MdFactory.getUtil().printStackTrace((Throwable)e);
                if (!m_debugMsgsOn) {
                    m_MdFactory.setDebug(false);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected static String getArgumentValue(int argIndex, int argMax, String[] args) {
        if (argIndex >= argMax) {
            return null;
        }
        return args[argIndex];
    }

    protected static FileOutputStream setOutputStream(MdFactory m_MdFactory, String log) {
        FileOutputStream logFile = null;
        try {
            logFile = new FileOutputStream(log);
            m_MdFactory.getUtil().setOutputStream((OutputStream)logFile);
            m_MdFactory.getUtil().setLogStream((OutputStream)logFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (RemoteException re) {
            try {
                m_MdFactory.setDebug(true);
                m_MdFactory.getUtil().printStackTrace((Throwable)re);
                if (!m_debugMsgsOn) {
                    m_MdFactory.setDebug(false);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readValueFromStandardIn(String optionName, String promptMessage, String charsetName) throws IOException {
        String metaPass = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(System.in, charsetName));
            for (int i = 0; i < 3; ++i) {
                String inData;
                if (promptMessage != null) {
                    System.out.print(promptMessage);
                }
                if ((inData = reader.readLine()) == null) {
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(inData.trim(), " ");
                    String token = null;
                    while (stringTokenizer.hasMoreTokens()) {
                        token = stringTokenizer.nextToken();
                        if (!optionName.equals(token) || (token = stringTokenizer.nextToken()) == null || (token = token.trim()).length() <= 0) continue;
                        metaPass = token;
                        break;
                    }
                    if (metaPass == null) continue;
                }
                break;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return metaPass;
    }
}

