/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.RemoteObject;
import com.sas.entities.AttributeDescriptor;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroup;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.AttributeTypeFactory;
import com.sas.entities.AttributeTypeFactoryInterface;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.AttributeTypeUtility;
import com.sas.entities.EntityDate;
import com.sas.entities.EntityKeyInterface;
import com.sas.entities.EntityRB;
import com.sas.entities.GUID;
import com.sas.entities.RemoteEntityInterface;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public class RemoteEntity
extends RemoteObject
implements RemoteEntityInterface,
Cloneable {
    private HashMap delegate;
    private RemoteEntityInterface prototype;
    private static AttributeTypeFactoryInterface atfi;
    private TreeMap attributes;
    private AttributeGroupInterface attributeGroup;
    private String customizer;
    private ArrayList attributesSet;
    private static String EMPTY_STRING;
    protected Map supplementalProperties;
    protected Map dynamicSupplementalProperties;
    protected VetoableChangeSupport vcs;
    protected static ArrayList classLoaders;
    private String guid;
    static Map propertyDescriptors;
    static final Object[] empty;
    public static final Object NULL_OBJECT_WRAPPER;
    public static final Object NO_SUCH_OBJECT;
    private static Class NULL_WRAPPER_CLASS;

    public RemoteEntity() throws RemoteException {
        this.initialize();
    }

    public RemoteEntity(Map supplementalProperties) throws RemoteException {
        if (supplementalProperties == null) {
            throw new IllegalArgumentException(EntityRB.getStringResource("emptyMap.ex.txt"));
        }
        this.supplementalProperties = supplementalProperties;
        this.initialize();
    }

    public RemoteEntity(AttributeTypeFactoryInterface atfi) throws RemoteException {
        if (atfi != null) {
            RemoteEntity.atfi = atfi;
        } else {
            atfi = new AttributeTypeFactory();
        }
        this.supplementalProperties = this.supplementalProperties;
        this.initialize();
    }

    public RemoteEntity(AttributeTypeFactoryInterface atfi, Map supplementalProperties) throws RemoteException {
        if (atfi != null) {
            RemoteEntity.atfi = atfi;
        } else {
            atfi = new AttributeTypeFactory();
        }
        this.initialize();
    }

    public RemoteEntity(RMIClientSocketFactory clientFactory, RMIServerSocketFactory serverFactory) throws RemoteException {
        super(0, clientFactory, serverFactory);
        this.initialize();
    }

    public RemoteEntity(int port, RMIClientSocketFactory clientFactory, RMIServerSocketFactory serverFactory) throws RemoteException {
        super(port, clientFactory, serverFactory);
        this.initialize();
    }

    protected void initialize() throws RemoteException {
        Map propDescriptors = this.getPropertyDescriptors();
        atfi = new AttributeTypeFactory();
        if (this.attributesSet == null) {
            this.attributesSet = new ArrayList();
        }
        if (this.delegate == null) {
            this.delegate = new HashMap();
        }
        if (this.attributes == null) {
            this.attributes = new TreeMap(Collator.getInstance());
        }
        if (this.attributeGroup == null) {
            this.attributeGroup = this.supplementalProperties != null && this.supplementalProperties.size() > 0 ? new AttributeGroup(this, propDescriptors) : new AttributeGroup((RemoteEntityInterface)this, propDescriptors, this.supplementalProperties);
        }
        AttributeDescriptorInterface[] attributes = this.getAttributeDescriptors();
        int numberOfAttributes = attributes.length;
        for (int i = 0; i < numberOfAttributes; ++i) {
            if (propDescriptors.containsKey(attributes[i].getName())) {
                attributes[i].setProperty(true);
            }
            if (this.supplementalProperties == null || this.supplementalProperties.size() <= 0) continue;
            attributes[i].setSupplementalProperties(this.supplementalProperties);
        }
        this.vcs = new VetoableChangeSupport(this);
    }

    @Override
    public synchronized String getEntityKey() throws RemoteException {
        if (this.guid == null) {
            this.setEntityKey(GUID.newGUID());
        }
        return this.guid;
    }

    @Override
    public synchronized void setEntityKey(String key) throws RemoteException, IllegalStateException {
        this.checkSetEntityKey();
        this.guid = key;
    }

    protected void checkSetEntityKey() throws RemoteException, IllegalStateException {
        if (this.guid != null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean sameEntity(EntityKeyInterface entity) throws RemoteException {
        return entity != null && this.getEntityKey().equals(entity.getEntityKey());
    }

    @Override
    public synchronized void removeAttribute(String attributeName) throws RemoteException {
        this.delegate.remove(attributeName);
        this.attributes.remove(attributeName);
        this.attributesSet.remove(attributeName);
    }

    @Override
    public synchronized void removeAllAttributes() throws RemoteException {
        String[] attributeNames = this.getAttributeGroup().getAttributeDescriptorNames(true);
        int arrayLength = attributeNames.length;
        for (int i = arrayLength - 1; i >= 0; --i) {
            this.removeAttribute(attributeNames[i]);
        }
    }

    @Override
    public Object getAttribute(String attributeName) throws RemoteException, NoSuchElementException {
        AttributeDescriptorInterface adi = this.getAttributeDescriptor(attributeName);
        if (adi == null) {
            throw new NoSuchElementException(attributeName);
        }
        Object val = this.getAttribute(attributeName, adi.getDefault(), this.getPropertyDescriptors(this.getClass()));
        if (attributeName.equals("entityKey")) {
            return val;
        }
        if (this.attributesSet.contains(attributeName)) {
            AttributeTypeInterface ati = adi.getType();
            if (ati != null) {
                Class componentClass = AttributeTypeUtility.getJavaClassToConstruct(ati.getSQLType(), ati.getName());
                if (componentClass != null) {
                    if (componentClass.getName().equals(AttributeTypeUtility.JAVA_AWT_COLOR)) {
                        return AttributeTypeUtility.convertValueToColor(val);
                    }
                    if (ati.getSQLType() == 91) {
                        return AttributeTypeUtility.convertValueToDate(val);
                    }
                    return AttributeTypeUtility.transformAttributeValue(val, adi);
                }
                return val;
            }
            return val;
        }
        return val;
    }

    @Override
    public synchronized Object getAttribute(String attributeName, Object defaultValue) {
        return this.getAttribute(attributeName, defaultValue, this.getPropertyDescriptors(this.getClass()));
    }

    protected Object getAttribute(String attributeName, Object defaultValue, Map propertyDescriptors) {
        Object value = defaultValue;
        PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptors.get(attributeName);
        if (pd == null) {
            Map delegateMap = (Map)this.getDelegate();
            value = ((HashMap)this.getDelegate()).get(attributeName);
            if ((value = RemoteEntity.unmap(value)) == null && defaultValue != null) {
                value = defaultValue;
            }
        } else {
            Method getter = pd.getReadMethod();
            if (getter != null) {
                value = this.invokeGetter(getter);
            }
        }
        return value;
    }

    public Object invokeGetter(Method getter) {
        Object o = null;
        try {
            o = getter.invoke((Object)this, new Object[0]);
            return o;
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException(ite.getLocalizedMessage());
        }
        catch (IllegalAccessException ite) {
            throw new IllegalArgumentException(ite.getLocalizedMessage());
        }
        finally {
            return o;
        }
    }

    @Override
    public Map getAttributes(Map query) {
        Set propertyNames = query.keySet();
        return this.getAttributes(query, propertyNames);
    }

    protected Map getAttributes(Map query, Set propertyNames) {
        Map propertyDescriptors = this.getPropertyDescriptors(this.getClass());
        for (String attributeName : propertyNames) {
            Object value = this.getAttribute(attributeName, NO_SUCH_OBJECT, propertyDescriptors);
            if (value == NO_SUCH_OBJECT) continue;
            query.put(attributeName, value);
        }
        return query;
    }

    @Override
    public String getStringAttribute(String attributeName, String defaultValue) throws RemoteException {
        Object value = defaultValue;
        AttributeDescriptorInterface adi = this.getAttributeDescriptor(attributeName);
        AttributeTypeInterface ati = adi.getType();
        PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptors.get(attributeName);
        if (pd == null) {
            value = this.delegate.get(attributeName);
            if ((value = RemoteEntity.unmap(value)) == null) {
                if (defaultValue != null) {
                    return defaultValue;
                }
                return adi.getStringDefault();
            }
            return AttributeTypeUtility.transformValueToSASFormat(value, ati);
        }
        Method getter = pd.getReadMethod();
        if (getter != null) {
            value = this.invokeGetter(getter);
        }
        return value;
    }

    @Override
    public String getCustomizer(String contextNotYetImplementedThusIGNORED) {
        return this.customizer;
    }

    @Override
    public List getCustomizerContexts() {
        return null;
    }

    @Override
    public synchronized void setAttribute(String attributeName, Object value) throws AttributeSetException, RemoteException {
        Map classDescriptors = this.getPropertyDescriptors(this.getClass());
        this.setAttribute(attributeName, classDescriptors, new Object[]{value});
    }

    protected boolean setAttribute(String attributeName, Map propertyDescriptors, Object[] args) throws AttributeSetException, RemoteException {
        Object oldValue = null;
        boolean returnType = false;
        PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptors.get(attributeName);
        if (pd == null) {
            oldValue = ((HashMap)this.getDelegate()).get(attributeName);
            if (!this.attributeGroup.containsAttributeDescriptorNamed(attributeName, true)) {
                AttributeDescriptor ad = new AttributeDescriptor(attributeName, this.dynamicSupplementalProperties != null ? this.dynamicSupplementalProperties : this.supplementalProperties);
                if (args[0] == null) {
                    ad.setType(AttributeTypeFactory.NULL_ATTRIBUTE_TYPE);
                } else {
                    Class<?> objectClass = args[0].getClass();
                    if (objectClass.isArray()) {
                        Class<?> componentClass = objectClass.getComponentType();
                        String componentType = componentClass.getName();
                        ad.setType(atfi.createAttributeType(null, 2003, componentType));
                    } else {
                        int sqlType = AttributeTypeUtility.NO_SQL_TYPE_DEFINED;
                        String objectClassName = objectClass.getName();
                        String objectType = null;
                        if (AttributeTypeUtility.isArrayPropertyType(objectClassName)) {
                            sqlType = 2003;
                            objectType = AttributeTypeUtility.getArrayComponentType(objectClassName);
                        } else {
                            ad.setType(AttributeTypeUtility.createAttributeTypeFromClassName(atfi, objectClassName));
                            ClassLoader objectClassLoader = objectClass.getClassLoader();
                            if (objectClassLoader != this.getSystemClassLoader() && objectClassLoader != null) {
                                classLoaders.add(objectClassLoader);
                            }
                        }
                    }
                }
                this.attributeGroup.addAttributeDescriptor(ad, -1);
                this.delegate.put(attributeName, RemoteEntity.map(args[0]));
                this.attributesSet.add(attributeName);
            } else {
                AttributeDescriptorInterface ad = this.getAttributeDescriptor(attributeName);
                if (!ad.isModifiable()) {
                    throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("attributeNotModifiable.ex.txt"), attributeName));
                }
                AttributeTypeInterface at = ad.getType();
                if (at == null) {
                    if (args[0] == null) {
                        ad.setType(AttributeTypeFactory.NULL_ATTRIBUTE_TYPE);
                    } else {
                        Class<?> objectClass = args[0].getClass();
                        if (objectClass.isArray()) {
                            Class<?> componentClass = objectClass.getComponentType();
                            String componentType = componentClass.getName();
                            ad.setType(atfi.createAttributeType(null, 2003, componentType));
                        } else {
                            int sqlType = AttributeTypeUtility.NO_SQL_TYPE_DEFINED;
                            String objectClassName = objectClass.getName();
                            String objectType = null;
                            if (AttributeTypeUtility.isArrayPropertyType(objectClassName)) {
                                sqlType = 2003;
                                objectType = AttributeTypeUtility.getArrayComponentType(objectClassName);
                            } else {
                                ad.setType(AttributeTypeUtility.createAttributeTypeFromClassName(atfi, objectClassName));
                                ClassLoader objectClassLoader = objectClass.getClassLoader();
                                if (objectClassLoader != this.getSystemClassLoader() && objectClassLoader != null) {
                                    classLoaders.add(objectClassLoader);
                                }
                            }
                        }
                    }
                    this.delegate.put(attributeName, RemoteEntity.map(args[0]));
                    if (!this.attributesSet.contains(attributeName)) {
                        this.attributesSet.add(attributeName);
                    }
                } else {
                    boolean goodAttributeType = true;
                    if (args != null && args[0] instanceof List) {
                        if (at != null && at.getSQLType() == 16) {
                            throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("illegalListForBoolean.ex.txt"), attributeName));
                        }
                        List valueItems = (List)args[0];
                        int listSize = valueItems.size();
                        for (int i = 0; i < listSize; ++i) {
                            goodAttributeType = this.verifyAttributeType(attributeName, new Object[]{valueItems.get(i)});
                        }
                    } else {
                        goodAttributeType = this.verifyAttributeType(attributeName, args);
                    }
                    if (goodAttributeType) {
                        ((HashMap)this.getDelegate()).put(attributeName, RemoteEntity.map(args[0]));
                        if (!this.attributesSet.contains(attributeName)) {
                            this.attributesSet.add(attributeName);
                        }
                    }
                }
                if (ad.isDefaultValueHasBeenSet()) {
                    if (at != null && at.getName() != null && at.getName().equals("Color")) {
                        AttributeTypeUtility.validateDefaultValue(ad.getStringDefault(), ad.getType(), true, attributeName);
                    } else {
                        AttributeTypeUtility.validateDefaultValue(ad.getDefault(), ad.getType(), true, attributeName);
                    }
                }
            }
        } else {
            if (!this.attributeGroup.containsAttributeDescriptorNamed(attributeName, true)) {
                throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("attributeNotFoundInAttributeGroup.ex.txt"), attributeName));
            }
            if (!this.attributeGroup.getAttributeDescriptor(attributeName, true).isModifiable()) {
                throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("attributeNotModifiable.ex.txt"), attributeName));
            }
            Method setter = pd.getWriteMethod();
            if (setter != null) {
                try {
                    Method getter = pd.getWriteMethod();
                    if (getter != null) {
                        oldValue = getter.invoke((Object)this, args);
                    }
                    setter.invoke((Object)this, args);
                    if (!this.attributesSet.contains(attributeName)) {
                        this.attributesSet.add(attributeName);
                    }
                }
                catch (InvocationTargetException ite) {
                    AttributeSetException ase = new AttributeSetException(ite.getMessage());
                    ase.initCause(ite);
                    throw ase;
                }
                catch (IllegalAccessException iae) {
                    AttributeSetException ase = new AttributeSetException(iae.getMessage());
                    ase.initCause(iae);
                    throw ase;
                }
            }
            returnType = true;
        }
        this.fireVetoableChange(attributeName, oldValue, args[0]);
        return returnType;
    }

    @Override
    public void setAttributes(Map update) throws AttributeSetException, RemoteException {
        Set entries = update.entrySet();
        Object[] args = new Object[1];
        this.setAttributes(update, entries, this.getPropertyDescriptors(this.getClass()), args);
    }

    protected void setAttributes(Map query, Set entries, Map propertyDescriptors, Object[] args) throws AttributeSetException, RemoteException {
        for (Map.Entry entry : entries) {
            String attributeName = (String)entry.getKey();
            args[0] = entry.getValue();
            this.setAttribute(attributeName, propertyDescriptors, args);
        }
    }

    @Override
    public void setCustomizer(String contextNotYetImplementedThusIGNORED, String customizer) {
        this.customizer = customizer;
    }

    public Map getPropertyDescriptors() {
        return this.getPropertyDescriptors(this.getClass());
    }

    protected Map getPropertyDescriptors(Class aClass) {
        HashMap<String, PropertyDescriptor> classDescriptors = (HashMap<String, PropertyDescriptor>)propertyDescriptors.get(aClass);
        if (classDescriptors != null) {
            return classDescriptors;
        }
        try {
            Class superClass = aClass.getSuperclass();
            if (superClass != null) {
                classDescriptors = this.getPropertyDescriptors(superClass);
            }
            classDescriptors = classDescriptors != null ? new HashMap(classDescriptors) : new HashMap<String, PropertyDescriptor>();
            propertyDescriptors.put(aClass, classDescriptors);
            if (Modifier.isPublic(aClass.getModifiers())) {
                BeanInfo info = Introspector.getBeanInfo(aClass, superClass);
                PropertyDescriptor[] attributes = info.getPropertyDescriptors();
                for (int i = 0; i < attributes.length; ++i) {
                    PropertyDescriptor prop = attributes[i];
                    if (!RemoteEntity.validEntityProperty(prop)) continue;
                    classDescriptors.put(prop.getName(), prop);
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return classDescriptors;
    }

    static boolean validEntityProperty(PropertyDescriptor prop) {
        return prop.getReadMethod() != null && prop.getWriteMethod() != null && (prop.getReadMethod().getModifiers() & 0) == 0 && (prop.getWriteMethod().getModifiers() & 0) == 0 && prop.getReadMethod().getParameterTypes().length == 0 && prop.getWriteMethod().getParameterTypes().length == 1;
    }

    @Override
    public boolean containsAttributeNamed(String attributeName) {
        Map propertyDescriptors = this.getPropertyDescriptors(this.getClass());
        PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptors.get(attributeName);
        if (pd != null) {
            return true;
        }
        return this.delegate.containsKey(attributeName);
    }

    public int getAttributeCount() {
        int count = this.delegate.size();
        return count + this.getPropertyDescriptors(this.getClass()).size();
    }

    @Override
    public synchronized String[] listAttributeNames() {
        Set propNames = this.delegate.keySet();
        Map propertyDescriptors = this.getPropertyDescriptors(this.getClass());
        String[] attributeNames = new String[this.delegate.size() + propertyDescriptors.size()];
        int i = 0;
        Iterator names = propNames.iterator();
        while (names.hasNext()) {
            attributeNames[i++] = (String)names.next();
        }
        propNames = propertyDescriptors.keySet();
        names = propNames.iterator();
        while (names.hasNext()) {
            attributeNames[i++] = (String)names.next();
        }
        return attributeNames;
    }

    public synchronized String[] listAttributeNames(boolean includeDynamicAttributes, boolean includeStaticAttributes) {
        String[] attNames = this.attributeGroup.getAttributeDescriptorNames(true);
        ArrayList<String> attributeNames = new ArrayList<String>();
        int numberOfAtrributes = attNames.length;
        String attributeName = null;
        AttributeDescriptorInterface attrDesc = null;
        for (int i = 0; i < numberOfAtrributes; ++i) {
            attributeName = attNames[i];
            attrDesc = this.attributeGroup.getAttributeDescriptor(attributeName, true);
            if (this.containsAttributeNamed(attributeName)) {
                if (!attrDesc.isProperty()) {
                    attributeNames.add(attributeName);
                    continue;
                }
                if (!includeStaticAttributes) continue;
                attributeNames.add(attributeName);
                continue;
            }
            if (!includeDynamicAttributes || !attrDesc.isDefaultValueHasBeenSet()) continue;
            attributeNames.add(attributeName);
        }
        int listSize = attributeNames.size();
        String[] returnAttrs = new String[listSize];
        for (int j = 0; j < listSize; ++j) {
            returnAttrs[j] = (String)attributeNames.get(j);
        }
        return returnAttrs;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RemoteEntity clone = (RemoteEntity)super.clone();
        clone.delegate = (HashMap)this.delegate.clone();
        clone.attributes = (TreeMap)this.attributes.clone();
        return clone;
    }

    public synchronized boolean equals(RemoteEntity p) {
        return this.getAttributeCount() == p.getAttributeCount() && this.delegate.equals(p.getDelegate());
    }

    @Override
    public synchronized boolean equals(Object o) {
        return o instanceof RemoteEntity && this.equals((RemoteEntity)o);
    }

    @Override
    public synchronized String toString() {
        return this.getClass().getName() + "#" + System.identityHashCode(this) + ":" + this.delegate.toString();
    }

    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public void addAttributeValidator(String attributeName, VetoableChangeListener listener) {
        this.addVetoableChangeListener(attributeName, listener);
    }

    @Override
    public void removeAttributeValidator(String attributeName, VetoableChangeListener listener) {
        this.removeVetoableChangeListener(attributeName, listener);
    }

    @Override
    public Map getAttributeValidators() throws RemoteException {
        return null;
    }

    @Override
    public AttributeGroupInterface getAttributeGroup() throws RemoteException {
        return this.attributeGroup;
    }

    @Override
    public RemoteEntityInterface getPrototype() {
        return this.prototype;
    }

    @Override
    public void setPrototype(RemoteEntityInterface prototype) {
        this.prototype = prototype;
    }

    @Override
    public AttributeTypeInterface getAttributeType(String attributeName) throws RemoteException, NoSuchElementException {
        if (this.attributeGroup.containsAttributeDescriptorNamed(attributeName, true)) {
            AttributeDescriptorInterface adi = this.attributeGroup.getAttributeDescriptor(attributeName, true);
            return adi.getType();
        }
        throw new NoSuchElementException(attributeName);
    }

    @Override
    public AttributeDescriptorInterface[] getAttributeDescriptors() throws RemoteException {
        return this.attributeGroup.getAttributeDescriptors(true);
    }

    @Override
    public AttributeDescriptorInterface getAttributeDescriptor(String attributeName) throws RemoteException, NoSuchElementException {
        if (this.attributeGroup.containsAttributeDescriptorNamed(attributeName, true)) {
            return this.attributeGroup.getAttributeDescriptor(attributeName, true);
        }
        return null;
    }

    @Override
    public boolean isAttributeAssigned(String attributeName) throws RemoteException, NoSuchElementException {
        if (!this.attributeGroup.containsAttributeDescriptorNamed(attributeName, true)) {
            throw new NoSuchElementException(attributeName);
        }
        if (this.attributesSet.contains(attributeName) || this.attributeGroup.getAttributeDescriptor(attributeName, true).isDefaultValueHasBeenSet()) {
            Object value = this.getAttribute(attributeName);
            return value != null && value.toString().trim().length() != 0;
        }
        return false;
    }

    @Override
    public boolean isAllRequiredAttributesAssigned() throws RemoteException {
        AttributeDescriptorInterface[] adi = this.attributeGroup.getAttributeDescriptors(true);
        int numberOfAttributes = adi.length;
        for (int i = 0; i < adi.length; ++i) {
            if (!adi[i].isRequired() || this.isAttributeAssigned(adi[i].getName())) continue;
            return false;
        }
        return true;
    }

    public List listAllRequiredAttributesNotAssigned() throws RemoteException {
        ArrayList<String> notAssigned = new ArrayList<String>();
        AttributeDescriptorInterface[] adi = this.attributeGroup.getAttributeDescriptors(true);
        int numberOfAttributes = adi.length;
        String attributeName = null;
        for (int i = 0; i < adi.length; ++i) {
            if (!adi[i].isRequired() || this.isAttributeAssigned(attributeName = adi[i].getName())) continue;
            notAssigned.add(attributeName);
        }
        return notAssigned;
    }

    @Override
    public void clear() throws RemoteException {
        String[] attributeNames = this.listAttributeNames();
        int arrayLength = attributeNames.length;
        for (int i = 0; i < arrayLength; ++i) {
            this.clearAttribute(attributeNames[i]);
        }
    }

    @Override
    public void clearAttribute(String attributeName) throws RemoteException {
        ((Map)this.getDelegate()).remove(attributeName);
        this.attributesSet.remove(attributeName);
    }

    @Override
    public AttributeDescriptorInterface[] getBooleanSpecifiedAttributeDescriptors(Map map) throws RemoteException, NoSuchMethodException {
        ArrayList<AttributeDescriptorInterface> descriptors = new ArrayList<AttributeDescriptorInterface>();
        int count = map.size();
        if (count == 0) {
            throw new IllegalArgumentException(EntityRB.getStringResource("emptyMap.txt"));
        }
        AttributeDescriptorInterface[] adi = this.attributeGroup.getAttributeDescriptors(true);
        int numberOfAttributes = adi.length;
        Class<?> attributeDescriptorClass = null;
        if (numberOfAttributes <= 0) {
            return new AttributeDescriptor[0];
        }
        attributeDescriptorClass = adi[0].getClass();
        boolean addDescriptor = true;
        for (int i = 0; i < numberOfAttributes; ++i) {
            HashMap copyMap = new HashMap(map);
            Set keySet = copyMap.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext() && addDescriptor) {
                String methodName = (String)iter.next();
                Method m = attributeDescriptorClass.getDeclaredMethod(methodName, new Class[0]);
                Class<?> returnType = m.getReturnType();
                if (!returnType.equals(Boolean.TYPE)) continue;
                Boolean b = (Boolean)map.get(methodName);
                try {
                    Boolean methodResult = (Boolean)m.invoke((Object)adi[i], new Object[0]);
                    if (methodResult.booleanValue() == b.booleanValue()) continue;
                    addDescriptor = false;
                }
                catch (InvocationTargetException ite) {
                    throw new IllegalArgumentException(ite.getLocalizedMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new IllegalArgumentException(iae.getLocalizedMessage());
                }
            }
            if (addDescriptor && !descriptors.contains(adi[i])) {
                descriptors.add(adi[i]);
            }
            addDescriptor = true;
        }
        return descriptors.toArray(new AttributeDescriptorInterface[descriptors.size()]);
    }

    protected static Object map(Object o) {
        return o == null ? NULL_OBJECT_WRAPPER : o;
    }

    protected static Object unmap(Object o) {
        return o == NULL_OBJECT_WRAPPER ? null : o;
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (this.vcs == null) {
            this.vcs = new VetoableChangeSupport(this);
        }
        this.vcs.addVetoableChangeListener(propertyName, listener);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (this.vcs != null) {
            this.vcs.removeVetoableChangeListener(propertyName, listener);
        }
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) {
        if (this.vcs == null) {
            this.vcs = new VetoableChangeSupport(this);
        }
        try {
            this.vcs.fireVetoableChange(propertyName, oldValue, newValue);
        }
        catch (PropertyVetoException pve) {
            pve.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean verifyAttributeType(String attributeName, Object[] args) throws AttributeSetException, RemoteException {
        boolean goodAttributeType = false;
        AttributeTypeInterface at = this.getAttributeDescriptor(attributeName).getType();
        if (at == null) {
            throw new AttributeSetException(EntityRB.getStringResource("attributeTypeNotDefined.ex.txt"));
        }
        int sqlType = at.getSQLType();
        if (sqlType == AttributeTypeUtility.NO_SQL_TYPE_DEFINED) {
            throw new AttributeSetException(EntityRB.getStringResource("attributeTypeNotDefined.ex.txt"));
        }
        if (args[0] == null) {
            if (AttributeTypeUtility.isNullValidForAttributeType(sqlType)) return true;
            throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), null, attributeName));
        }
        Class argsClass = null;
        argsClass = args[0] == null ? Object.class : RemoteEntity.map(args[0]).getClass();
        if (sqlType == 0) {
            ClassLoader argsClassLoader;
            if (argsClass.isArray()) {
                this.getAttributeDescriptor(attributeName).setType(atfi.createAttributeType(null, 2003, argsClass.getComponentType().getName()));
                return true;
            }
            Class<Object> objectClass = Object.class;
            if (args[0] == null) return goodAttributeType;
            goodAttributeType = true;
            String argsClassName = argsClass.getName();
            if (!AttributeTypeUtility.isWrapperType(argsClassName) && (argsClassLoader = argsClass.getClassLoader()) != this.getSystemClassLoader() && argsClassLoader != null) {
                classLoaders.add(argsClassLoader);
            }
            this.getAttributeDescriptor(attributeName).setType(AttributeTypeUtility.createAttributeTypeFromClassName(atfi, argsClass.getName()));
            return goodAttributeType;
        }
        if (sqlType == 2003) {
            if (!argsClass.isArray()) {
                throw new AttributeSetException(EntityRB.getStringResource("notArrayAttributeType.ex.txt"));
            }
            String componentType = at.getObjectType();
            if (!argsClass.getComponentType().getName().equals(componentType)) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("incorrectArrayType.ex.txt"), componentType));
            return true;
        }
        if (sqlType == 91) {
            if (args[0] instanceof Date) {
                if (args[0] instanceof EntityDate) return true;
                EntityDate componentType = new EntityDate(((Date)args[0]).getTime());
                return true;
            }
            if (!(args[0] instanceof String)) return goodAttributeType;
            try {
                return AttributeTypeUtility.isValidDate((String)args[0], attributeName, false);
            }
            catch (IllegalArgumentException iae) {
                AttributeSetException ase = new AttributeSetException(iae.getMessage());
                ase.initCause(iae);
                throw ase;
            }
        }
        if (sqlType == 92) {
            if (args[0] instanceof Time) return true;
            if (args[0] instanceof Date) {
                return true;
            }
            if (args[0] == null || !args[0].toString().equals(EMPTY_STRING)) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), args[0], attributeName));
            throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
        }
        if (sqlType == 93) {
            if (args[0] instanceof Timestamp) return true;
            if (args[0] instanceof Date) {
                return true;
            }
            if (args[0] == null || !args[0].toString().equals(EMPTY_STRING)) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), args[0], attributeName));
            throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
        }
        if (sqlType == 2000 || sqlType == 1111) {
            String componentType = at.getObjectType();
            try {
                Class componentClass;
                block39: {
                    componentClass = null;
                    if (componentType == null) {
                        componentClass = Object.class;
                    } else {
                        try {
                            componentClass = Class.forName(componentType);
                        }
                        catch (ClassNotFoundException e) {
                            for (int i = 0; i < classLoaders.size(); ++i) {
                                try {
                                    componentClass = Class.forName(componentType, false, (ClassLoader)classLoaders.get(i));
                                    break;
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    continue;
                                }
                            }
                            if (componentClass != null) break block39;
                            return false;
                        }
                    }
                }
                if (componentClass.isAssignableFrom(argsClass)) {
                    return true;
                }
                if (!argsClass.getName().equals("java.lang.String")) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("incorrectAttributeType.ex.txt"), componentClass.getName()));
                Class[] stringArgsClass = new Class[]{String.class};
                Object[] stringArgs = new Object[]{args[0]};
                try {
                    Constructor stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                    Object o = stringArgsConstructor.newInstance(stringArgs);
                    args[0] = o;
                    return true;
                }
                catch (Exception e) {
                    if (stringArgs[0] == null || !stringArgs[0].equals(EMPTY_STRING)) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), stringArgs[0], attributeName));
                    throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
                }
            }
            catch (Exception cnfe) {
                cnfe.printStackTrace();
            }
            return goodAttributeType;
        }
        Class c = AttributeTypeUtility.getJavaClass(at.getSQLType());
        if (c == null) {
            throw new AttributeSetException(EntityRB.getStringResource("attributeTypeNotDefined.ex.txt"));
        }
        String typeClassName = c.getName();
        String className = argsClass.getName();
        String primitiveClassName = AttributeTypeUtility.getPrimitiveTypeFromWrapper(className);
        if (primitiveClassName == null || !primitiveClassName.equals(typeClassName)) {
            if (AttributeTypeUtility.isColorStringClass(at)) {
                try {
                    return AttributeTypeUtility.isValidColor(args[0], attributeName, true);
                }
                catch (IllegalArgumentException iae) {
                    AttributeSetException ase = new AttributeSetException(iae.getMessage());
                    ase.initCause(iae);
                    throw ase;
                }
            }
            if (!AttributeTypeUtility.wrapperTypeHasStringArgConstructor(sqlType)) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("incorrectAttributeType.ex.txt"), typeClassName));
            Class[] stringArgsClass = new Class[]{String.class};
            Class componentClass = AttributeTypeUtility.getJavaClassToConstruct(at.getSQLType(), null);
            Object[] stringArgs = new Object[]{args[0]};
            try {
                Constructor stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                Object o = stringArgsConstructor.newInstance(stringArgs);
                return true;
            }
            catch (Exception e) {
                if (stringArgs[0] != null && stringArgs[0].equals(EMPTY_STRING)) {
                    throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
                }
                if (sqlType != 6 && sqlType != 8 || !className.equals("com.sas.MissingValues")) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), stringArgs[0], attributeName));
                return true;
            }
        }
        if (!AttributeTypeUtility.isColorStringClass(at)) return true;
        try {
            return AttributeTypeUtility.isValidColor(args[0], attributeName, true);
        }
        catch (IllegalArgumentException iae) {
            AttributeSetException ase = new AttributeSetException(iae.getMessage());
            ase.initCause(iae);
            throw ase;
        }
    }

    public void setDynamicSupplementalPropertiesDefaultMap(Map dynamicSupplementalProperties) {
        if (dynamicSupplementalProperties == null) {
            throw new IllegalArgumentException(EntityRB.getStringResource("emptyMap.ex.txt"));
        }
        this.dynamicSupplementalProperties = dynamicSupplementalProperties;
    }

    private ClassLoader getSystemClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static {
        EMPTY_STRING = "";
        classLoaders = new ArrayList();
        propertyDescriptors = new HashMap();
        empty = new Object[0];
        NULL_OBJECT_WRAPPER = new NullWrapper();
        NO_SUCH_OBJECT = new NullWrapper();
    }

    private static final class NullWrapper {
        private NullWrapper() {
        }

        public String toString() {
            return "null";
        }
    }
}

