/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.codepolicy.SASScope;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;

@SASScope
public class GUID {
    private static GUID defaultInstance = new GUID();
    private int timeLow;
    private int node;
    private String hexInetAddress;
    private String thisHashCode;
    private String midValue;
    private Random seeder;
    private StringBuffer hexFormat = new StringBuffer(8);

    private GUID() {
        byte[] bytes;
        StringBuffer tmpBuffer = new StringBuffer(36);
        this.seeder = new Random();
        try {
            InetAddress inet = InetAddress.getLocalHost();
            bytes = inet.getAddress();
        }
        catch (UnknownHostException uhe) {
            bytes = new byte[4];
            this.seeder.nextBytes(bytes);
        }
        this.hexInetAddress = this.hexFormat8(GUID.getInt(bytes));
        this.thisHashCode = this.hexFormat8(System.identityHashCode(this));
        tmpBuffer.append("-");
        tmpBuffer.append(this.hexInetAddress.substring(0, 4));
        tmpBuffer.append("-");
        tmpBuffer.append(this.hexInetAddress.substring(4));
        tmpBuffer.append("-");
        tmpBuffer.append(this.thisHashCode.substring(0, 4));
        tmpBuffer.append("-");
        tmpBuffer.append(this.thisHashCode.substring(4));
        this.midValue = tmpBuffer.toString();
        int node = this.seeder.nextInt();
    }

    public static String newGUID() {
        return defaultInstance.next();
    }

    public static GUID getInstance() {
        return defaultInstance;
    }

    public String next() {
        long timeNow = System.currentTimeMillis();
        this.timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = this.seeder.nextInt();
        return this.hexFormat8(this.timeLow) + this.midValue + this.hexFormat8(node);
    }

    private static int getInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < bytes.length; ++i) {
            result = (result << 8) + (bytes[i] & 0xFF);
        }
        return result;
    }

    private synchronized String hexFormat8(int i) {
        String hex = Integer.toHexString(i);
        this.hexFormat.setLength(0);
        for (int index = hex.length(); index < 8; ++index) {
            this.hexFormat.append('0');
        }
        this.hexFormat.append(hex);
        return this.hexFormat.toString();
    }
}

