/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.entities.BaseEntityInterface;
import com.sas.entities.EntityKeyInterface;
import com.sas.entities.EntityRB;
import com.sas.entities.GUID;
import com.sas.entities.RemoteEntity;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

@SASScope(value="ALL")
public class BaseEntity
implements BaseEntityInterface,
EntityKeyInterface,
Cloneable {
    private HashMap delegate;
    private TreeMap attributes;
    private Object[] _objectArray = new Object[1];
    private String guid;
    static Map propertyDescriptors = new HashMap();
    static final Object[] empty = new Object[0];

    public BaseEntity() {
        this.initialize();
    }

    private void initialize() {
        if (this.delegate == null) {
            this.delegate = new HashMap(1);
        }
    }

    @Override
    public synchronized String getEntityKey() {
        if (this.guid == null) {
            this.setEntityKey(GUID.newGUID());
        }
        return this.guid;
    }

    @Override
    public void setEntityKey(String guid) {
        this.guid = guid;
    }

    @Override
    public boolean sameEntity(EntityKeyInterface entity) {
        try {
            return entity != null && this.getEntityKey().equals(entity.getEntityKey());
        }
        catch (RemoteException re) {
            return false;
        }
    }

    @Override
    public synchronized void removeAttribute(String attributeName) {
        this.delegate.remove(attributeName);
        this.getAttributesMap().remove(attributeName);
    }

    @Override
    public synchronized void removeAllAttributes() {
        this.delegate.clear();
    }

    public void reset() {
        if (this.delegate != null) {
            this.delegate.clear();
        }
        if (this.attributes != null) {
            this.attributes.clear();
        }
        this._objectArray[0] = null;
    }

    @Override
    public Object getAttribute(String attributeName) throws NoSuchElementException {
        Object val = this.getAttribute(attributeName, RemoteEntity.NO_SUCH_OBJECT, this.getPropertyDescriptors(this.getClass()));
        if (val == RemoteEntity.NO_SUCH_OBJECT) {
            throw new NoSuchElementException(attributeName);
        }
        return val;
    }

    @Override
    public synchronized Object getAttribute(String attributeName, Object defaultValue) {
        return this.getAttribute(attributeName, defaultValue, this.getPropertyDescriptors(this.getClass()));
    }

    @SASScope
    protected Object getAttribute(String attributeName, Object defaultValue, Map propertyDescriptors) {
        Object value = defaultValue;
        PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptors.get(attributeName);
        if (pd == null) {
            value = this.delegate.get(attributeName);
            if (value != null) {
                value = RemoteEntity.unmap(value);
            }
        } else {
            Method getter = pd.getReadMethod();
            if (getter != null) {
                try {
                    value = getter.invoke((Object)this, empty);
                }
                catch (InvocationTargetException ite) {
                    throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("getAttribute.ex.txt"), attributeName));
                }
                catch (IllegalAccessException ite) {
                    throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("getAttribute.ex.txt"), attributeName));
                }
            }
        }
        return value;
    }

    @Override
    public Map getAttributes(Map query) {
        Set propertyNames = query.keySet();
        return this.getAttributes(query, propertyNames);
    }

    @SASScope
    protected Map getAttributes(Map query, Set propertyNames) {
        Map propertyDescriptors = this.getPropertyDescriptors(this.getClass());
        for (String attributeName : propertyNames) {
            Object value = this.getAttribute(attributeName, RemoteEntity.NO_SUCH_OBJECT, propertyDescriptors);
            if (value == RemoteEntity.NO_SUCH_OBJECT) continue;
            query.put(attributeName, value);
        }
        return query;
    }

    @Override
    public String getStringAttribute(String attributeName, String defaultValue) {
        Object val = defaultValue;
        val = this.getAttribute(attributeName, defaultValue);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public synchronized void setAttribute(String attributeName, Object value) throws AttributeSetException {
        this._objectArray[0] = value;
        Map classDescriptors = this.getPropertyDescriptors(this.getClass());
        this.setAttribute(attributeName, classDescriptors, this._objectArray);
        this._objectArray[0] = null;
    }

    @SASScope
    protected boolean setAttribute(String attributeName, Map propertyDescriptors, Object[] args) throws AttributeSetException {
        PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptors.get(attributeName);
        if (pd != null) {
            Method setter = pd.getWriteMethod();
            if (setter != null) {
                try {
                    setter.invoke((Object)this, args);
                }
                catch (InvocationTargetException ite) {
                    throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("setAttribute.ex.txt"), attributeName));
                }
                catch (IllegalAccessException ite) {
                    this.delegate.put(attributeName, RemoteEntity.map(args[0]));
                }
            }
            return true;
        }
        this.delegate.put(attributeName, RemoteEntity.map(args[0]));
        return false;
    }

    @Override
    public void setAttributes(Map update) throws AttributeSetException {
        Set entries = update.entrySet();
        Object[] args = new Object[1];
        this.setAttributes(update, entries, this.getPropertyDescriptors(this.getClass()), args);
    }

    @SASScope
    protected void setAttributes(Map query, Set entries, Map propertyDescriptors, Object[] args) throws AttributeSetException {
        for (Map.Entry entry : entries) {
            String attributeName = (String)entry.getKey();
            args[0] = entry.getValue();
            this.setAttribute(attributeName, propertyDescriptors, args);
        }
    }

    public Map getPropertyDescriptors() {
        return this.getPropertyDescriptors(this.getClass());
    }

    @SASScope
    protected Map getPropertyDescriptors(Class aClass) {
        HashMap<String, PropertyDescriptor> classDescriptors = (HashMap<String, PropertyDescriptor>)propertyDescriptors.get(aClass);
        if (classDescriptors != null) {
            return classDescriptors;
        }
        try {
            Class superClass = aClass.getSuperclass();
            if (superClass != null) {
                classDescriptors = this.getPropertyDescriptors(superClass);
            }
            classDescriptors = classDescriptors != null ? new HashMap(classDescriptors) : new HashMap<String, PropertyDescriptor>();
            if (Modifier.isPublic(aClass.getModifiers())) {
                BeanInfo info = Introspector.getBeanInfo(aClass, superClass);
                PropertyDescriptor[] attributes = info.getPropertyDescriptors();
                for (int i = 0; i < attributes.length; ++i) {
                    PropertyDescriptor prop = attributes[i];
                    if (!BaseEntity.validEntityProperty(prop)) continue;
                    classDescriptors.put(prop.getName(), prop);
                }
            }
            propertyDescriptors.put(aClass, classDescriptors);
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return classDescriptors;
    }

    static boolean validEntityProperty(PropertyDescriptor prop) {
        return prop.getReadMethod() != null && prop.getWriteMethod() != null && (prop.getReadMethod().getModifiers() & 0) == 0 && (prop.getWriteMethod().getModifiers() & 0) == 0 && prop.getReadMethod().getParameterTypes().length == 0 && prop.getWriteMethod().getParameterTypes().length == 1;
    }

    @Override
    public boolean containsAttributeNamed(String attributeName) {
        Map propertyDescriptors = this.getPropertyDescriptors(this.getClass());
        PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptors.get(attributeName);
        if (pd != null) {
            return true;
        }
        return this.delegate.containsKey(attributeName);
    }

    public int getAttributeCount() {
        int count = this.delegate.size();
        return count + this.getPropertyDescriptors(this.getClass()).size();
    }

    @Override
    public synchronized String[] listAttributeNames() {
        Set propNames = this.delegate.keySet();
        Map propertyDescriptors = this.getPropertyDescriptors(this.getClass());
        String[] attributeNames = new String[this.delegate.size() + propertyDescriptors.size()];
        int i = 0;
        Iterator names = propNames.iterator();
        while (names.hasNext()) {
            attributeNames[i++] = (String)names.next();
        }
        propNames = propertyDescriptors.keySet();
        names = propNames.iterator();
        while (names.hasNext()) {
            attributeNames[i++] = (String)names.next();
        }
        return attributeNames;
    }

    public Object clone() throws CloneNotSupportedException {
        BaseEntity clone = (BaseEntity)super.clone();
        clone.delegate = (HashMap)this.delegate.clone();
        if (this.attributes != null) {
            clone.attributes = (TreeMap)this.getAttributesMap().clone();
        }
        if (this._objectArray != null) {
            clone._objectArray = (Object[])this._objectArray.clone();
        }
        return clone;
    }

    public synchronized boolean equals(BaseEntity p) {
        return this.getAttributeCount() == p.getAttributeCount() && this.delegate.equals(p.getDelegate());
    }

    public synchronized boolean equals(Object o) {
        return o instanceof BaseEntity && this.equals((BaseEntity)o);
    }

    public synchronized String toString() {
        return this.getClass().getName() + "#" + System.identityHashCode(this) + ":" + this.delegate.toString();
    }

    @SASScope
    public Object getDelegate() {
        return this.delegate;
    }

    @SASScope
    protected TreeMap getAttributesMap() {
        if (this.attributes == null) {
            this.attributes = new TreeMap(Collator.getInstance());
        }
        return this.attributes;
    }
}

