/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.entities.BaseAttributeDescriptorInterface;
import com.sas.entities.EntityUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BaseAttributeDescriptor
implements Serializable,
BaseAttributeDescriptorInterface {
    static final long serialVersionUID = 4233132649438731517L;
    private String name;
    private String configurationXML;
    private Map labelMappings;
    private Map descriptionMappings;
    private Map customizerMappings;
    private Map smallIconURLMappings;
    private Map largeIconURLMappings;

    public BaseAttributeDescriptor() {
        this(null);
    }

    public BaseAttributeDescriptor(String name) {
        if (name != null) {
            this.setName(name);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLabel(Locale locale) {
        if (this.labelMappings != null) {
            if (this.labelMappings.containsKey(locale)) {
                return (String)this.labelMappings.get(locale);
            }
            if (this.labelMappings.containsKey(null)) {
                return (String)this.labelMappings.get(null);
            }
            return this.getName();
        }
        return this.getName();
    }

    @Override
    public void setLabel(Locale locale, String label) {
        this.getLabels().put(locale, label);
    }

    @Override
    public Map getLabels() {
        if (this.labelMappings == null) {
            this.labelMappings = EntityUtil.newMap();
        }
        return this.labelMappings;
    }

    @Override
    public String getDescription(Locale locale) {
        if (this.descriptionMappings != null) {
            if (this.descriptionMappings.containsKey(locale)) {
                return (String)this.descriptionMappings.get(locale);
            }
            if (this.descriptionMappings.containsKey(null)) {
                return (String)this.descriptionMappings.get(null);
            }
            return this.getLabel(locale);
        }
        return this.getLabel(locale);
    }

    @Override
    public void setDescription(Locale locale, String description) {
        this.getDescriptions().put(locale, description);
    }

    @Override
    public Map getDescriptions() {
        if (this.descriptionMappings == null) {
            this.descriptionMappings = EntityUtil.newMap();
        }
        return this.descriptionMappings;
    }

    @Override
    public String getCustomizer(String context) {
        if (this.customizerMappings != null) {
            return (String)this.customizerMappings.get(context);
        }
        return null;
    }

    @Override
    public void setCustomizer(String context, String customizer) {
        this.getAttributeCustomizers().put(context, customizer);
    }

    @Override
    public Map getAttributeCustomizers() {
        if (this.customizerMappings == null) {
            this.customizerMappings = EntityUtil.newMap();
        }
        return this.customizerMappings;
    }

    @Override
    public List getAttributeCustomizerContexts() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.customizerMappings != null) {
            Iterator iter = this.customizerMappings.keySet().iterator();
            String context = null;
            while (iter.hasNext()) {
                context = (String)iter.next();
                list.add(context);
            }
            return list;
        }
        return list;
    }

    @Override
    public String getConfigurationXML() {
        return this.configurationXML;
    }

    @Override
    public void setConfigurationXML(String configurationXML) {
        this.configurationXML = configurationXML;
    }

    @Override
    public String getSmallIconURL(Locale locale) {
        if (this.smallIconURLMappings != null) {
            if (this.smallIconURLMappings.containsKey(locale)) {
                return (String)this.smallIconURLMappings.get(locale);
            }
            return (String)this.smallIconURLMappings.get(null);
        }
        return null;
    }

    @Override
    public void setSmallIconURL(Locale locale, String smallIconURL) {
        this.getSmallIconURLs().put(locale, smallIconURL);
    }

    @Override
    public Map getSmallIconURLs() {
        if (this.smallIconURLMappings == null) {
            this.smallIconURLMappings = EntityUtil.newMap();
        }
        return this.smallIconURLMappings;
    }

    @Override
    public String getLargeIconURL(Locale locale) {
        if (this.largeIconURLMappings != null) {
            if (this.largeIconURLMappings.containsKey(locale)) {
                return (String)this.largeIconURLMappings.get(locale);
            }
            return (String)this.largeIconURLMappings.get(null);
        }
        return null;
    }

    @Override
    public void setLargeIconURL(Locale locale, String largeIconURL) {
        this.getLargeIconURLs().put(locale, largeIconURL);
    }

    @Override
    public Map getLargeIconURLs() {
        if (this.largeIconURLMappings == null) {
            this.largeIconURLMappings = EntityUtil.newMap();
        }
        return this.largeIconURLMappings;
    }
}

