/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.transaction.TransactionLogWriteFailedEvent;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.RecoverableCoordinator;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.publish.EventPublisher;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.OltpLog;
import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.TxState;
import com.atomikos.util.Assert;

public class StateRecoveryManagerImp
implements StateRecoveryManager,
FSMPreEnterListener {
    private static final Logger LOGGER = LoggerFactory.createLogger(StateRecoveryManagerImp.class);
    private OltpLog oltpLog;

    @Override
    public void register(RecoverableCoordinator staterecoverable) {
        TxState[] states;
        Assert.notNull((String)"illegal attempt to register null staterecoverable", (Object)staterecoverable);
        for (TxState txState : states = TxState.values()) {
            if (!txState.isRecoverableState()) continue;
            staterecoverable.addFSMPreEnterListener(this, txState);
        }
    }

    @Override
    public void preEnter(FSMEnterEvent event) throws IllegalStateException {
        TxState state = event.getState();
        RecoverableCoordinator source = (RecoverableCoordinator)event.getSource();
        PendingTransactionRecord pendingTransactionRecord = source.getPendingTransactionRecord(state);
        if (pendingTransactionRecord != null) {
            try {
                this.oltpLog.write(pendingTransactionRecord);
            }
            catch (Exception le) {
                TransactionLogWriteFailedEvent evt = new TransactionLogWriteFailedEvent(pendingTransactionRecord.id);
                EventPublisher.INSTANCE.publish((Event)evt);
                LOGGER.logFatal(evt.toString());
                throw new RuntimeException(evt.toString(), le);
            }
        }
    }

    @Override
    public void close() throws LogException {
        this.oltpLog.close();
    }

    public void setOltpLog(OltpLog oltpLog) {
        this.oltpLog = oltpLog;
    }
}

