/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.provider.imp;

import com.atomikos.icatch.TransactionServicePlugin;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.provider.ConfigProperties;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.Atomikos;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CheckForUpdatesTransactionServicePlugin
implements TransactionServicePlugin {
    public static final String COM_ATOMIKOS_MAVEN_USERNAME = "com.atomikos.maven.username";
    private static final Logger LOGGER = LoggerFactory.createLogger(CheckForUpdatesTransactionServicePlugin.class);
    Future<HttpResponse> future;

    public void beforeInit() {
        ConfigProperties properties = Configuration.getConfigProperties();
        if (!properties.getAsBoolean("com.atomikos.icatch.licensed")) {
            final String account = properties.getProperty(COM_ATOMIKOS_MAVEN_USERNAME);
            Callable<HttpResponse> checkUpdateTaks = new Callable<HttpResponse>(){

                @Override
                public HttpResponse call() throws Exception {
                    URL url = new URL("http://www.atomikos.com/Main/CheckForUpdates?account=" + account);
                    try {
                        String line;
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("GET");
                        connection.setRequestProperty("User-Agent", "Atomikos");
                        connection.connect();
                        InputStreamReader in = new InputStreamReader((InputStream)connection.getContent());
                        StringBuffer content = new StringBuffer();
                        BufferedReader buff = new BufferedReader(in);
                        do {
                            line = buff.readLine();
                            content.append(line + "\n");
                        } while (line != null);
                        int responseCode = connection.getResponseCode();
                        return new HttpResponse(responseCode, content.toString());
                    }
                    catch (IOException e) {
                        if (account.equals("unknown")) {
                            LOGGER.logWarning("Please configure com.atomikos.maven.username with your ");
                        }
                        throw e;
                    }
                }
            };
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            this.future = executorService.submit(checkUpdateTaks);
        }
    }

    public void afterInit() {
        try {
            HttpResponse response = this.future.get();
            if (response.responseCode == 200) {
                LOGGER.logInfo("You are using Atomikos version " + Atomikos.VERSION + " latest version is ...");
            } else if (response.responseCode == 403) {
                LOGGER.logWarning("Please configure com.atomikos.maven.username with your username for contact \nsuport@atomikos.com if you need help\nCAUTION : startup will fail after DD-MM-YYYY if not configured");
            } else {
                LOGGER.logError("Failed to check http://... contact suport@atomikos.com if you need help\nCAUTION : startup will fail after DD-MM-YYYY if not fixed");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.logError(e.getMessage(), (Throwable)e);
        }
    }

    public void afterShutdown() {
    }

    protected static class HttpResponse {
        final int responseCode;
        final String message;

        public HttpResponse(int responseCode, String message) {
            this.responseCode = responseCode;
            this.message = message;
        }
    }
}

