/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.TransactionStateHandler;
import com.atomikos.recovery.TxState;
import java.util.Stack;

class TxTerminatingStateHandler
extends TransactionStateHandler {
    private boolean committing;

    public TxTerminatingStateHandler(boolean committing, CompositeTransactionImp ct, TransactionStateHandler handler) {
        super(ct, handler);
        this.committing = committing;
    }

    private void reject() throws IllegalStateException {
        if (this.committing) {
            throw new IllegalStateException("Transaction is already committing");
        }
        throw new IllegalStateException("Transaction is already rolling back");
    }

    @Override
    protected TxState getState() {
        return TxState.ACTIVE;
    }

    @Override
    protected RecoveryCoordinator addParticipant(Participant p) {
        if (!this.committing) {
            this.reject();
        }
        return super.addParticipant(p);
    }

    @Override
    protected void addSubTxAwareParticipant(SubTxAwareParticipant p) {
        if (!this.committing) {
            this.reject();
        }
        super.addSubTxAwareParticipant(p);
    }

    @Override
    protected void addSynchronizations(Stack<Synchronization> s) {
        this.reject();
    }

    @Override
    protected void commit() {
        this.reject();
    }

    @Override
    protected CompositeTransaction createSubTransaction() {
        this.reject();
        return null;
    }

    protected void registerSynchronization() {
        this.reject();
    }

    @Override
    protected void rollbackWithStateCheck() {
        if (this.committing) {
            this.reject();
        }
    }

    @Override
    protected void setRollbackOnly() {
        if (this.committing) {
            super.setRollbackOnly();
        }
    }
}

