/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.finitestates.FSM;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.finitestates.FSMImp;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.finitestates.FSMTransitionEvent;
import com.atomikos.finitestates.FSMTransitionListener;
import com.atomikos.finitestates.Stateful;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.transaction.TransactionAbandonedEvent;
import com.atomikos.icatch.event.transaction.TransactionAbortedEvent;
import com.atomikos.icatch.event.transaction.TransactionCommittedEvent;
import com.atomikos.icatch.event.transaction.TransactionHeuristicEvent;
import com.atomikos.icatch.event.transaction.TransactionPreparingEvent;
import com.atomikos.icatch.event.transaction.TransactionReadOnlyEvent;
import com.atomikos.icatch.event.transaction.TransactionRollbackOnlyEvent;
import com.atomikos.icatch.event.transaction.TransactionTimeoutEvent;
import com.atomikos.icatch.imp.ActiveStateHandler;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.RollbackOnlyParticipant;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.logging.StackTrace;
import com.atomikos.persistence.RecoverableCoordinator;
import com.atomikos.publish.EventPublisher;
import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.TxState;
import com.atomikos.thread.TaskManager;
import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import com.atomikos.timing.PooledAlarmTimer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CoordinatorImp
implements CompositeCoordinator,
Participant,
RecoveryCoordinator,
RecoverableCoordinator,
AlarmTimerListener,
Stateful,
FSMPreEnterListener,
FSMTransitionListener {
    private static final Logger LOGGER = LoggerFactory.createLogger(CoordinatorImp.class);
    static long DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS = 150L;
    private static final int MAX_NUMBER_OF_TIMEOUT_TICKS_FOR_INDOUBTS = 30;
    private static final int MAX_NUMBER_OF_TIMEOUT_TICKS_BEFORE_ROLLBACK_OF_ACTIVES = 30;
    private int localSiblingsStarted = 0;
    private int localSiblingsTerminated = 0;
    private AlarmTimer timer_ = null;
    private long maxNumberOfTimeoutTicksBeforeHeuristicDecision_ = 30L;
    private long maxNumberOfTimeoutTicksBeforeRollback_ = 30L;
    private String root_ = null;
    private String coordinatorId = null;
    private FSM fsm_ = null;
    private Vector<Participant> participants_ = new Vector();
    private RecoveryCoordinator superiorCoordinator_ = null;
    private CoordinatorStateHandler stateHandler_;
    private boolean single_threaded_2pc_;
    private transient List<Synchronization> synchronizations;
    private Set<Thread> activeThreads = new HashSet<Thread>();
    private boolean timedout = false;
    private final long creationTime = System.currentTimeMillis();
    private String recoveryDomainName;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    protected CoordinatorImp(String root) {
        this.root_ = root;
        this.coordinatorId = root;
        this.initFsm(TxState.ACTIVE);
        this.setStateHandler(new ActiveStateHandler(this));
        this.startThreads(DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS);
        this.single_threaded_2pc_ = false;
        this.synchronizations = new ArrayList<Synchronization>();
    }

    private void initFsm(TxState initialState) {
        this.fsm_ = new FSMImp(this, initialState);
        this.fsm_.addFSMPreEnterListener(this, TxState.TERMINATED);
        this.fsm_.addFSMPreEnterListener(this, TxState.HEUR_COMMITTED);
        this.fsm_.addFSMPreEnterListener(this, TxState.HEUR_ABORTED);
        this.fsm_.addFSMPreEnterListener(this, TxState.HEUR_MIXED);
        this.fsm_.addFSMPreEnterListener(this, TxState.HEUR_HAZARD);
        this.fsm_.addFSMPreEnterListener(this, TxState.ABANDONED);
        this.fsm_.addFSMTransitionListener(this, TxState.ACTIVE, TxState.PREPARING);
        this.fsm_.addFSMTransitionListener(this, TxState.COMMITTING, TxState.TERMINATED);
        this.fsm_.addFSMTransitionListener(this, TxState.ABORTING, TxState.TERMINATED);
        this.fsm_.addFSMTransitionListener(this, TxState.PREPARING, TxState.TERMINATED);
    }

    protected CoordinatorImp(String recoveryDomainName, String coordinatorId, String root, RecoveryCoordinator coord, long timeout, boolean single_threaded_2pc) {
        this.root_ = root;
        this.coordinatorId = coordinatorId;
        this.recoveryDomainName = recoveryDomainName;
        this.single_threaded_2pc_ = single_threaded_2pc;
        this.initFsm(TxState.ACTIVE);
        this.superiorCoordinator_ = coord;
        if (timeout > DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS) {
            this.maxNumberOfTimeoutTicksBeforeRollback_ = this.maxNumberOfTimeoutTicksBeforeHeuristicDecision_ = timeout / DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS;
        }
        this.setStateHandler(new ActiveStateHandler(this));
        this.startThreads(DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS);
        this.synchronizations = new ArrayList<Synchronization>();
    }

    public CoordinatorImp() {
        this.initFsm(TxState.ACTIVE);
        this.single_threaded_2pc_ = false;
        this.synchronizations = new ArrayList<Synchronization>();
    }

    boolean prefersSingleThreaded2PC() {
        return this.single_threaded_2pc_;
    }

    void setCommitted() {
        this.stateHandler_.setCommitted();
    }

    void setStateHandler(CoordinatorStateHandler stateHandler) {
        TxState state = stateHandler.getState();
        this.stateHandler_ = stateHandler;
        this.setState(state);
    }

    RecoveryCoordinator getSuperiorRecoveryCoordinator() {
        return this.superiorCoordinator_;
    }

    public Vector<Participant> getParticipants() {
        return this.participants_;
    }

    int getLocalSiblingsStarted() {
        return this.localSiblingsStarted;
    }

    long getMaxIndoubtTicks() {
        return this.maxNumberOfTimeoutTicksBeforeHeuristicDecision_;
    }

    long getMaxRollbackTicks() {
        return this.maxNumberOfTimeoutTicksBeforeRollback_;
    }

    public boolean isCommitted() {
        return this.stateHandler_.isCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreads(long timeout) {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.timer_ == null) {
                this.stateHandler_.activate();
                this.timer_ = new PooledAlarmTimer(timeout);
                this.timer_.addAlarmTimerListener((AlarmTimerListener)this);
                this.submitTimer(this.timer_);
            }
        }
    }

    private void submitTimer(AlarmTimer timer) {
        TaskManager.SINGLETON.executeTask((Runnable)timer);
    }

    protected long getTimeOut() {
        return (this.maxNumberOfTimeoutTicksBeforeRollback_ - this.stateHandler_.getRollbackTicks()) * DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS;
    }

    void setState(TxState state) throws IllegalStateException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("Coordinator " + this.getCoordinatorId() + " entering state: " + state.toString());
        }
        this.fsm_.setState(state);
    }

    @Override
    public TxState getState() {
        return this.fsm_.getState();
    }

    void addFSMEnterListener(FSMEnterListener l, TxState state) {
        this.fsm_.addFSMEnterListener(l, state);
    }

    @Override
    public void addFSMPreEnterListener(FSMPreEnterListener l, TxState state) {
        this.fsm_.addFSMPreEnterListener(l, state);
    }

    public RecoveryCoordinator getRecoveryCoordinator() {
        return this;
    }

    public Participant getParticipant() throws UnsupportedOperationException {
        return this;
    }

    public String getCoordinatorId() {
        return this.coordinatorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException, RollbackException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.getState().equals((Object)TxState.ACTIVE)) {
                throw new IllegalStateException(this.getCoordinatorId() + " is no longer active but in state " + this.getState().toString());
            }
            if (!this.participants_.contains(participant)) {
                this.participants_.add(participant);
                this.registerActiveThread();
            }
            this.setState(TxState.ACTIVE);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerActiveThread() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            this.activeThreads.add(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incLocalSiblingsStarted() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ++this.localSiblingsStarted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incLocalSiblingsTerminated() throws HeurRollbackException, HeurMixedException, SysException, SecurityException, HeurCommitException, HeurHazardException, IllegalStateException, RollbackException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ++this.localSiblingsTerminated;
            if (this.hasTimedOut() && !this.hasActiveSiblings()) {
                this.terminate(false);
            }
        }
    }

    public boolean hasActiveSiblings() {
        return this.localSiblingsStarted > this.localSiblingsTerminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, UnsupportedOperationException, SysException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.getState().equals((Object)TxState.ACTIVE)) {
                throw new IllegalStateException("wrong state: " + this.getState());
            }
            this.rememberSychronizationForAfterCompletion(sync);
        }
    }

    private void rememberSychronizationForAfterCompletion(Synchronization sync) {
        this.getSynchronizations().add(sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Synchronization> getSynchronizations() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.synchronizations == null) {
                this.synchronizations = new ArrayList<Synchronization>();
            }
            return this.synchronizations;
        }
    }

    void notifySynchronizationsAfterCompletion(TxState ... successiveStates) {
        for (TxState state : successiveStates) {
            for (Synchronization s : this.getSynchronizations()) {
                try {
                    s.afterCompletion(state);
                }
                catch (Throwable t) {
                    LOGGER.logWarning("Unexpected error in afterCompletion", t);
                }
            }
        }
    }

    @Override
    public void preEnter(FSMEnterEvent event) throws IllegalStateException {
        TxState state = event.getState();
        if (state.isHeuristic() && this.requiresHeuristics()) {
            TransactionHeuristicEvent the = new TransactionHeuristicEvent(this.getCoordinatorId(), this.superiorCoordinatorId(), state);
            EventPublisher.INSTANCE.publish((Event)the);
        }
        if (state.isFinalStateForOltp()) {
            this.dispose();
        }
        if (state == TxState.ABANDONED) {
            TransactionAbandonedEvent tae = new TransactionAbandonedEvent(this.getCoordinatorId());
            EventPublisher.INSTANCE.publish((Event)tae);
        }
    }

    boolean requiresHeuristics() {
        boolean ret = false;
        if (this.recoveryDomainName != null) {
            String recoveryDomainName = Configuration.getConfigProperties().getTmUniqueName();
            PendingTransactionRecord record = this.getPendingTransactionRecord(this.getState());
            if (record != null) {
                ret = record.allowsHeuristicTermination(recoveryDomainName);
            }
        }
        return ret;
    }

    public String getURI() {
        return this.getCoordinatorId();
    }

    public void forget() {
        this.stateHandler_.forget();
    }

    public void setCascadeList(Map<String, Integer> allParticipants) throws SysException {
        this.stateHandler_.setCascadeList(allParticipants);
    }

    public void setGlobalSiblingCount(int count) {
        this.stateHandler_.setGlobalSiblingCount(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        if (this.getState().equals((Object)TxState.PREPARING)) {
            throw new RollbackException("Recursion detected");
        }
        int ret = 1;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.prepare();
            if (ret == 0) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("prepare() of Coordinator  " + this.getCoordinatorId() + " returning READONLY");
                }
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("prepare() of Coordinator  " + this.getCoordinatorId() + " returning YES vote");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            this.stateHandler_.commit(onePhase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        if (this.getState().equals((Object)TxState.ABORTING)) {
            return;
        }
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            this.stateHandler_.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackHeuristically() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            this.stateHandler_.rollbackHeuristically();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitHeuristically() throws HeurMixedException, SysException, HeurRollbackException, HeurHazardException, IllegalStateException, RollbackException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            this.stateHandler_.commitHeuristically();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean replayCompletion(Participant participant) throws IllegalStateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("replayCompletion ( " + participant + " ) received by coordinator " + this.getCoordinatorId() + " for participant " + participant.toString());
        }
        Boolean ret = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.replayCompletion(participant);
        }
        return ret;
    }

    private boolean excludedFromLogging(TxState state) {
        boolean ret = false;
        if (!state.isRecoverableState()) {
            ret = true;
        } else if (this.superiorCoordinator_ == null) {
            if (state.equals((Object)TxState.IN_DOUBT)) {
                ret = true;
            } else if (this.participants_.size() <= 1) {
                ret = true;
            }
        } else if (this.superiorCoordinator_ != null && state.equals((Object)TxState.COMMITTING) && TxState.ACTIVE.equals((Object)this.stateHandler_.getState())) {
            ret = true;
        }
        if (state.isHeuristic()) {
            ret = true;
        }
        if (state.isFinalState() && this.stateHandler_.wasOnePhaseCommitted()) {
            ret = true;
        }
        return ret;
    }

    public void alarm(AlarmTimer timer) {
        try {
            this.stateHandler_.onTimeout();
        }
        catch (Exception e) {
            LOGGER.logWarning("Exception on timeout of coordinator " + this.root_, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.timer_ != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("Coordinator " + this.getCoordinatorId() + " : stopping timer...");
                }
                this.timer_.stopTimer();
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("Coordinator " + this.getCoordinatorId() + " : disposing statehandler " + this.stateHandler_.getState() + "...");
            }
            this.stateHandler_.dispose();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("Coordinator " + this.getCoordinatorId() + " : disposed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminate(boolean commit) throws HeurRollbackException, HeurMixedException, SysException, SecurityException, HeurCommitException, HeurHazardException, RollbackException, IllegalStateException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (commit) {
                if (this.participants_.size() <= 1) {
                    this.commit(true);
                } else {
                    int prepareResult = this.prepare();
                    if (prepareResult != 0) {
                        this.commit(false);
                    }
                }
            } else {
                this.rollback();
            }
        }
    }

    void setRollbackOnly() {
        block4: {
            RollbackOnlyParticipant p = new RollbackOnlyParticipant();
            try {
                this.addParticipant(p);
            }
            catch (IllegalStateException alreadyTerminated) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("Error during setRollbackOnly", (Throwable)alreadyTerminated);
                }
            }
            catch (RollbackException e) {
                if (!LOGGER.isTraceEnabled()) break block4;
                LOGGER.logTrace("Error during setRollbackOnly", (Throwable)e);
            }
        }
        EventPublisher.INSTANCE.publish((Event)new TransactionRollbackOnlyEvent(this.getCoordinatorId()));
    }

    void printActiveStackTraces() {
        Map<String, StackTraceElement[]> threadNameToStackTraceMap = this.toThreadNameToStackTraceMap();
        String stackTraces = this.buildActiveStackTraceMessage(threadNameToStackTraceMap);
        LOGGER.logWarning(stackTraces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasTimedOut() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            return this.timedout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(boolean rollbackOnly) {
        Map<String, StackTraceElement[]> threadNameToStackTraceMap = null;
        String stackTraces = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            this.timedout = true;
            threadNameToStackTraceMap = this.toThreadNameToStackTraceMap();
            stackTraces = this.buildActiveStackTraceMessage(threadNameToStackTraceMap);
            LOGGER.logWarning(stackTraces);
            if (rollbackOnly) {
                this.setRollbackOnly();
            }
        }
        EventPublisher.INSTANCE.publish((Event)new TransactionTimeoutEvent(this.getCoordinatorId(), this.creationTime, stackTraces));
    }

    private Map<String, StackTraceElement[]> toThreadNameToStackTraceMap() {
        HashMap<String, StackTraceElement[]> threadNameToStackTraceMap = new HashMap<String, StackTraceElement[]>();
        for (Thread thread : this.activeThreads) {
            threadNameToStackTraceMap.put(thread.getName(), thread.getStackTrace());
        }
        return threadNameToStackTraceMap;
    }

    String buildActiveStackTraceMessage(Map<String, StackTraceElement[]> threadNameToStackTraceMap) {
        StringBuffer stackTraces = new StringBuffer();
        for (Map.Entry<String, StackTraceElement[]> thread : threadNameToStackTraceMap.entrySet()) {
            stackTraces.append("Transaction activity in thread ");
            stackTraces.append(thread.getKey());
            stackTraces.append(LINE_SEPARATOR);
            StackTraceElement[] stackTraceElement = thread.getValue();
            if (stackTraceElement == null) continue;
            stackTraces.append(StackTrace.toString((StackTraceElement[])stackTraceElement));
        }
        return stackTraces.toString();
    }

    public TxState getStateWithTwoPhaseCommitDecision() {
        TxState ret = this.getState();
        if (TxState.TERMINATED.equals((Object)this.getState())) {
            ret = this.isCommitted() ? TxState.COMMITTED : TxState.ABORTED;
        } else if (TxState.HEUR_ABORTED.equals((Object)this.getState())) {
            ret = TxState.ABORTED;
        } else if (TxState.HEUR_COMMITTED.equals((Object)this.getState())) {
            ret = TxState.COMMITTED;
        } else if (TxState.HEUR_HAZARD.equals((Object)this.getState())) {
            ret = this.isCommitted() ? TxState.COMMITTING : TxState.ABORTING;
        }
        return ret;
    }

    @Override
    public void transitionPerformed(FSMTransitionEvent e) {
        TxState fromState = e.fromState();
        TxState toState = e.toState();
        if (toState == TxState.TERMINATED) {
            switch (fromState) {
                case COMMITTING: {
                    this.publishDomainEvent((Event)new TransactionCommittedEvent(this.coordinatorId, this.creationTime));
                    break;
                }
                case ABORTING: {
                    this.publishDomainEvent((Event)new TransactionAbortedEvent(this.coordinatorId, this.creationTime));
                    break;
                }
                case PREPARING: {
                    this.publishDomainEvent((Event)new TransactionReadOnlyEvent(this.coordinatorId, this.creationTime));
                    break;
                }
            }
        } else if (toState == TxState.PREPARING) {
            if (this.superiorCoordinatorId() == null) {
                this.publishDomainEvent((Event)new TransactionPreparingEvent(this.coordinatorId, this.getParticipatingUniqueResourceNames(), this.getParticipantUris()));
            } else {
                this.publishDomainEvent((Event)new TransactionPreparingEvent(this.superiorCoordinatorId(), this.coordinatorId, this.getParticipatingUniqueResourceNames(), this.getParticipantUris()));
            }
        }
    }

    private String[] getParticipantUris() {
        String[] participantUris = new String[this.participants_.size()];
        for (int i = 0; i < participantUris.length; ++i) {
            participantUris[i] = this.participants_.get(i).getURI();
        }
        return participantUris;
    }

    private String[] getParticipatingUniqueResourceNames() {
        String[] resourceNames = new String[this.participants_.size()];
        for (int i = 0; i < resourceNames.length; ++i) {
            Participant p = this.participants_.get(i);
            String resourceName = p.getResourceName();
            if (resourceName == null) {
                resourceName = p.getClass().getSimpleName();
            }
            resourceNames[i] = resourceName;
        }
        return resourceNames;
    }

    private void publishDomainEvent(Event event) {
        EventPublisher.INSTANCE.publish(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingTransactionRecord getPendingTransactionRecord(TxState state) {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.excludedFromLogging(state)) {
                return null;
            }
            return new PendingTransactionRecord(this.getCoordinatorId(), state, this.getExpires(), this.recoveryDomainName, this.superiorCoordinatorId());
        }
    }

    private String superiorCoordinatorId() {
        String ret = null;
        if (this.getSuperiorRecoveryCoordinator() != null) {
            ret = this.getSuperiorRecoveryCoordinator().getURI();
        }
        return ret;
    }

    private long getExpires() {
        return System.currentTimeMillis() + this.getTimeOut();
    }

    public String getResourceName() {
        return null;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer();
        toString.append("Coordinator : ");
        toString.append(this.getCoordinatorId());
        toString.append(" [");
        toString.append(this.getState());
        toString.append("]");
        return toString.toString();
    }

    public String getRootId() {
        return this.root_;
    }

    public boolean isRoot() {
        return this.superiorCoordinator_ == null;
    }

    public String getRecoveryDomainName() {
        return this.recoveryDomainName;
    }
}

