/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class CompositeTransactionManagerImp
implements CompositeTransactionManager,
SubTxAwareParticipant {
    private static final Logger LOGGER = LoggerFactory.createLogger(CompositeTransactionManagerImp.class);
    private Map<Thread, Stack<CompositeTransaction>> threadtotxmap_ = new HashMap<Thread, Stack<CompositeTransaction>>();
    private Map<CompositeTransaction, Thread> txtothreadmap_ = new HashMap<CompositeTransaction, Thread>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getThread(CompositeTransaction ct) {
        Thread thread = null;
        Map<CompositeTransaction, Thread> map = this.txtothreadmap_;
        synchronized (map) {
            thread = this.txtothreadmap_.get(ct);
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stack<CompositeTransaction> removeThreadMappings(Thread thread) {
        Stack<CompositeTransaction> ret = null;
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            ret = this.threadtotxmap_.remove(thread);
            CompositeTransaction tx = ret.peek();
            this.txtothreadmap_.remove(tx);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setThreadMappings(CompositeTransaction ct, Thread thread) throws IllegalStateException, SysException {
        ct.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            if (TxState.ACTIVE.equals((Object)ct.getState())) {
                Stack<Object> txs = this.threadtotxmap_.get(thread);
                if (txs == null) {
                    txs = new Stack();
                }
                txs.push(ct);
                this.threadtotxmap_.put(thread, txs);
                this.txtothreadmap_.put(ct, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreThreadMappings(Stack<CompositeTransaction> stack, Thread thread) throws IllegalStateException {
        CompositeTransaction tx = stack.peek();
        tx.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            TxState state = tx.getState();
            if (state.isOneOf(new TxState[]{TxState.ACTIVE, TxState.MARKED_ABORT})) {
                Stack<CompositeTransaction> txs = this.threadtotxmap_.get(thread);
                if (txs != null) {
                    throw new IllegalStateException("Thread already has subtx stack");
                }
                this.threadtotxmap_.put(thread, stack);
                this.txtothreadmap_.put(tx, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeTransaction getCurrentTx() {
        Thread thread = Thread.currentThread();
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            Stack<CompositeTransaction> txs = this.threadtotxmap_.get(thread);
            if (txs == null) {
                return null;
            }
            return txs.peek();
        }
    }

    private TransactionService getTransactionService() {
        TransactionService ret = Configuration.getTransactionService();
        if (ret == null) {
            throw new IllegalStateException("Not initialized");
        }
        return ret;
    }

    public void committed(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    public void rolledback(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    public CompositeTransaction getCompositeTransaction() throws SysException {
        CompositeTransaction ct = null;
        ct = this.getCurrentTx();
        if (ct != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("getCompositeTransaction()  returning instance with id " + ct.getTid());
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("getCompositeTransaction() returning NULL!");
        }
        return ct;
    }

    public CompositeTransaction getCompositeTransaction(String tid) throws SysException {
        CompositeTransaction ret = this.getTransactionService().getCompositeTransaction(tid);
        if (ret != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("getCompositeTransaction ( " + tid + " ) returning instance with tid " + ret.getTid());
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("getCompositeTransaction ( " + tid + " ) returning null");
        }
        return ret;
    }

    public synchronized CompositeTransaction recreateCompositeTransaction(Propagation context) throws SysException {
        CompositeTransaction ct = null;
        ct = this.getCurrentTx();
        if (ct != null) {
            LOGGER.logWarning("Recreating a transaction with existing transaction: " + ct.getTid() + " - rolling back the latter...");
            this.rollbackTransaction(ct);
        }
        ct = this.getTransactionService().recreateCompositeTransaction(context);
        Thread t = Thread.currentThread();
        this.setThreadMappings(ct, t);
        return ct;
    }

    private void rollbackTransaction(CompositeTransaction ct) {
        try {
            ct.rollback();
        }
        catch (Exception e) {
            LOGGER.logWarning("Unexpected error during rollback of pending transaction", (Throwable)e);
        }
    }

    public CompositeTransaction suspend() throws SysException {
        CompositeTransaction ret = this.getCurrentTx();
        if (ret != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("suspend() for transaction " + ret.getTid());
            }
            Thread thread = Thread.currentThread();
            this.removeThreadMappings(thread);
            this.suspendInTransactionService(ret);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("suspend() called without a transaction context");
        }
        return ret;
    }

    private void suspendInTransactionService(CompositeTransaction ret) {
        try {
            this.getTransactionService().transactionSuspended(ret);
        }
        catch (Exception e) {
            LOGGER.logWarning("Unexpected error on suspend - ignoring...", (Throwable)e);
        }
    }

    private void resumeInTransactionService(CompositeTransaction ret) {
        try {
            this.getTransactionService().transactionResumed(ret);
        }
        catch (Exception e) {
            LOGGER.logWarning("Unexpected error on resume - ignoring...", (Throwable)e);
        }
    }

    public void resume(CompositeTransaction ct) throws IllegalStateException, SysException {
        Stack<CompositeTransaction> ancestors = new Stack<CompositeTransaction>();
        Stack<CompositeTransaction> tmp = new Stack<CompositeTransaction>();
        Stack lineage = (Stack)ct.getLineage().clone();
        boolean done = false;
        while (!lineage.isEmpty() && !done) {
            CompositeTransaction parent = (CompositeTransaction)lineage.pop();
            if (!parent.isLocal()) {
                done = true;
                continue;
            }
            tmp.push(parent);
        }
        while (!tmp.isEmpty()) {
            ancestors.push((CompositeTransaction)tmp.pop());
        }
        ancestors.push(ct);
        Thread thread = Thread.currentThread();
        this.restoreThreadMappings(ancestors, thread);
        this.resumeInTransactionService(ct);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("resume ( " + ct + " ) done for transaction " + ct.getTid());
        }
    }

    public void shutdown(boolean force) throws SysException, IllegalStateException {
        this.getTransactionService().shutdown(force);
    }

    protected void startlistening(CompositeTransaction transaction) throws SysException {
        transaction.addSubTxAwareParticipant((SubTxAwareParticipant)this);
    }

    private void removeTransaction(CompositeTransaction ct) {
        if (ct == null) {
            return;
        }
        Thread thread = this.getThread(ct);
        if (thread == null) {
            return;
        }
        Stack<CompositeTransaction> mappings = this.removeThreadMappings(thread);
        if (mappings != null && !mappings.empty()) {
            mappings.pop();
            if (!mappings.empty()) {
                this.restoreThreadMappings(mappings, thread);
            }
        }
    }

    public CompositeTransaction createCompositeTransaction(long timeout) throws SysException {
        CompositeTransaction ct = null;
        CompositeTransaction ret = null;
        ct = this.getCurrentTx();
        if (ct == null) {
            ret = this.getTransactionService().createCompositeTransaction(timeout);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("createCompositeTransaction ( " + timeout + " ): created new ROOT transaction with id " + ret.getTid());
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("createCompositeTransaction ( " + timeout + " )");
            }
            ret = ct.createSubTransaction();
        }
        Thread thread = Thread.currentThread();
        this.setThreadMappings(ret, thread);
        return ret;
    }
}

