/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.setinit;

import com.sas.util.setinit.LeasableProduct;
import com.sas.util.setinit.ProductLease;
import com.sas.util.setinit.ProductSetinitException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class FileProductLease
extends ProductLease {
    private Date expirationDate;

    public FileProductLease(LeasableProduct product, Date expirationDate) {
        super(product);
        this.expirationDate = expirationDate;
    }

    public FileProductLease(String productName, Date expirationDate) {
        super(productName);
        this.expirationDate = expirationDate;
    }

    @Override
    public void renew(long duration) throws ProductSetinitException {
    }

    @Override
    public void release() throws ProductSetinitException {
    }

    @Override
    public long getLeaseExpirationDuration() throws ProductSetinitException {
        if (this.expirationDate != null) {
            Date today = new Date();
            double todayDate = FileProductLease.javaDateToSASDate(today.getTime());
            double expireDate = FileProductLease.javaDateToSASDate(this.expirationDate.getTime());
            return (long)(expireDate - todayDate);
        }
        return -1L;
    }

    @Override
    public boolean isValid() throws ProductSetinitException {
        return this.getLeaseExpirationDuration() >= 0L;
    }

    private static double javaDateToSASDate(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(date));
        date = date + (long)TimeZone.getDefault().getRawOffset() + (long)cal.get(16);
        return Math.floor((double)date / 8.64E7 + 3653.0);
    }
}

