/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.security;

import com.sas.framework.commons.holders.SessionHolder;
import com.sas.svcs.remoting.RemoteInvocationProcessor;
import com.sas.svcs.remoting.security.ClientRemoteInvocationSecurityProcessor;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ServerRemoteInvocationSecurityProcessor
implements RemoteInvocationProcessor {
    private static final AnonymousAuthenticationToken ANONYMOUS_TOKEN = new AnonymousAuthenticationToken(ClientRemoteInvocationSecurityProcessor.class.getName(), (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    public static final String CREATED_ANON_ATTR = ServerRemoteInvocationSecurityProcessor.class.getName() + ".createAnonymousAuthentication";
    private final AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private boolean createAnonymousAuthentication = true;

    public void setCreateAnonymousAuthentication(boolean createAnonymousAuthentication) {
        this.createAnonymousAuthentication = createAnonymousAuthentication;
    }

    @Override
    public void process(RemoteInvocation ri) {
        Authentication auth;
        SecurityContext securityContext = (SecurityContext)ri.getAttribute(SecurityContextHolder.class.getName());
        if (null == securityContext || null == securityContext.getAuthentication() || this.trustResolver.isAnonymous(securityContext.getAuthentication())) {
            securityContext = SecurityContextHolder.getContext();
        }
        if (null == (auth = securityContext.getAuthentication()) && this.createAnonymousAuthentication) {
            auth = ANONYMOUS_TOKEN;
            Serializable alreadyCreatedAnon = ri.getAttribute(CREATED_ANON_ATTR);
            if (null == alreadyCreatedAnon) {
                ri.addAttribute(CREATED_ANON_ATTR, (Serializable)Boolean.TRUE);
            }
        }
        if (auth instanceof CasAuthenticationToken) {
            CasAuthenticationToken casToken = (CasAuthenticationToken)auth;
            String value = (String)casToken.getAssertion().getPrincipal().getAttributes().get("SAS_SESSION_IDENTIFIER");
            SessionHolder.set((String)value);
        }
        securityContext.setAuthentication(auth);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
    }

    @Override
    public void finish(RemoteInvocation ri) {
        SecurityContextHolder.clearContext();
        SessionHolder.clear();
    }
}

