/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker.stateful.management;

import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceHolderInterface;
import java.lang.ref.WeakReference;

public class StatefulSessionEntry {
    private final WeakReference<StatefulServiceHolderInterface> serviceHolder;
    private final String userInfo;

    public StatefulSessionEntry(StatefulServiceHolderInterface holder, String userInfo) {
        this.serviceHolder = new WeakReference<StatefulServiceHolderInterface>(holder);
        this.userInfo = userInfo;
    }

    public Object getService() {
        StatefulServiceHolderInterface holder = (StatefulServiceHolderInterface)this.serviceHolder.get();
        if (holder != null) {
            return holder.getStatefulService();
        }
        return null;
    }

    public String getServiceClassName() {
        Object service;
        StatefulServiceHolderInterface holder = (StatefulServiceHolderInterface)this.serviceHolder.get();
        if (holder != null && (service = holder.getStatefulService()) != null) {
            return service.getClass().getName();
        }
        return null;
    }

    public String getUserInfo() {
        return this.userInfo;
    }
}

