/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker.stateful.management;

import com.sas.framework.annotation.services.DeletesStateful;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceHolderInterface;
import com.sas.svcs.remoting.httpinvoker.stateful.management.StatefulSessionEntry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.Scope;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.ReflectionUtils;

@ManagedResource(description="Stateful Service Session Manager")
public final class StatefulServiceSessionManager {
    private static final Logger LOGGER = LogManager.getLogger(StatefulServiceSessionManager.class);
    private final Map<String, StatefulSessionEntry> beans = new ConcurrentHashMap<String, StatefulSessionEntry>();

    public void addNewObject(String key, Scope scope, Object service) {
        if (service instanceof StatefulServiceHolderInterface && key != null) {
            Authentication auth;
            SecurityContext securityContext = SecurityContextHolder.getContext();
            String userInfo = null;
            if (securityContext != null && null != (auth = securityContext.getAuthentication())) {
                userInfo = auth.getName();
            }
            StatefulSessionEntry entry = new StatefulSessionEntry((StatefulServiceHolderInterface)service, userInfo);
            this.beans.put(key, entry);
            scope.registerDestructionCallback(key, (Runnable)new ScopeCleanup(key, this));
        }
    }

    public void removeObjectByKey(String key) {
        this.beans.remove(key);
    }

    @ManagedOperation
    public synchronized void destroyAllSessions() {
        for (String key : this.beans.keySet()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Destroying session " + key);
            }
            this.destroySession(key);
        }
    }

    private Method findDelete(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(DeletesStateful.class)) continue;
            return method;
        }
        Method delete = null;
        for (Class<?> serviceInterface : clazz.getInterfaces()) {
            delete = this.findDelete(serviceInterface);
            if (delete == null) continue;
            return delete;
        }
        return null;
    }

    @ManagedOperation
    public void destroySession(String key) {
        StatefulSessionEntry session = this.beans.get(key);
        if (session != null) {
            Method deleteMethod;
            Object service = session.getService();
            if (service != null && (deleteMethod = this.findDelete(service.getClass())) != null) {
                ReflectionUtils.makeAccessible((Method)deleteMethod);
                try {
                    deleteMethod.invoke(service, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn((Object)e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn((Object)e);
                }
                catch (InvocationTargetException e) {
                    LOGGER.warn((Object)e);
                }
            }
            this.removeObjectByKey(key);
        }
    }

    public void removeStaleEntries() {
        for (Map.Entry<String, StatefulSessionEntry> entry : this.beans.entrySet()) {
            Object service = entry.getValue().getService();
            if (service != null) continue;
            this.removeObjectByKey(entry.getKey());
        }
    }

    @ManagedAttribute
    public String getSimpleSessionInfo() {
        this.removeStaleEntries();
        return StatefulServiceSessionManager.convertSessionMap(this.beans);
    }

    @ManagedAttribute
    public int getStatefulSessionCount() {
        this.removeStaleEntries();
        return this.beans.size();
    }

    @ManagedAttribute
    public TabularData getSessionInfo() throws OpenDataException {
        this.removeStaleEntries();
        String[] colNames = new String[]{"id", "instance class", "user"};
        CompositeType rowType = new CompositeType("SessionRowType", "A row of session data", colNames, new String[]{"The session id", "The class of the stateful service", "The user who instantiated the stateful service session"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
        TabularType type = new TabularType("SessionTableType", "A table of session entries", rowType, new String[]{"id"});
        TabularDataSupport tabularData = new TabularDataSupport(type);
        for (Map.Entry<String, StatefulSessionEntry> entry : this.beans.entrySet()) {
            StatefulSessionEntry session = entry.getValue();
            Object service = session.getService();
            if (service == null) continue;
            CompositeDataSupport row = new CompositeDataSupport(rowType, colNames, new String[]{entry.getKey(), session.getServiceClassName(), session.getUserInfo()});
            tabularData.put(row);
        }
        return tabularData;
    }

    private static String convertSessionMap(Map<String, StatefulSessionEntry> sessions) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, StatefulSessionEntry> entry : sessions.entrySet()) {
            StatefulSessionEntry session = entry.getValue();
            Object serviceObject = session.getService();
            if (serviceObject == null) continue;
            sb.append(String.format("%s=[%s, %s]\n", entry.getKey(), session.getServiceClassName(), session.getUserInfo()));
        }
        return sb.toString();
    }

    private static class ScopeCleanup
    implements Runnable {
        private final String name;
        private final StatefulServiceSessionManager manager;

        public ScopeCleanup(String name, StatefulServiceSessionManager manager) {
            this.name = name;
            this.manager = manager;
        }

        @Override
        public void run() {
            this.manager.destroySession(this.name);
        }
    }
}

