/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker.stateful;

import com.sas.svcs.remoting.MutableRemoteInvocationAttributeResult;
import com.sas.svcs.remoting.RemoteInvocationResultProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceHolderInterface;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceIdHolder;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.scope.ScopedObject;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public class StatefulServiceDeletionProcessor
implements RemoteInvocationResultProcessor {
    private static final Logger LOGGER = LogManager.getLogger(StatefulServiceDeletionProcessor.class);
    private Set<String> deleteStatefulMethodNames = new HashSet<String>(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(RemoteInvocationResult rir) {
        block11: {
            if (rir instanceof MutableRemoteInvocationAttributeResult && this.deleteStatefulMethodNames != null) {
                String methodName;
                MutableRemoteInvocationAttributeResult riar = (MutableRemoteInvocationAttributeResult)rir;
                RemoteInvocation ri = riar.getRemoteInvocation();
                String string = methodName = ri != null ? ri.getMethodName() : null;
                if (this.deleteStatefulMethodNames.contains(methodName)) {
                    String id = (String)((Object)ri.getAttribute("sasStatefulServiceId"));
                    id = "Delete" + id;
                    StatefulServiceIdHolder.setId(id);
                    try {
                        boolean proxyOk;
                        Object service;
                        block12: {
                            service = riar.getService();
                            if (service instanceof ScopedObject) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("remove from scope id: " + id);
                                }
                                ((ScopedObject)service).removeFromScope();
                                break block11;
                            }
                            if (!(service instanceof StatefulServiceHolderInterface)) break block11;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("remove from scope via holder, id: " + id);
                            }
                            try {
                                ((StatefulServiceHolderInterface)service).getStatefulService();
                                proxyOk = true;
                            }
                            catch (RuntimeException e) {
                                proxyOk = false;
                                if (!LOGGER.isDebugEnabled()) break block12;
                                LOGGER.debug("Proxy for stateful service is not ok. Probably already deleted. Don't call remove from scope", (Throwable)e);
                            }
                        }
                        if (proxyOk) {
                            ((StatefulServiceHolderInterface)service).removeStatefulServiceFromScope();
                        }
                    }
                    finally {
                        StatefulServiceIdHolder.clear();
                    }
                }
            }
        }
    }

    public void setDeleteStatefulMethodName(String deleteStatefulMethodName) {
        this.deleteStatefulMethodNames.add(deleteStatefulMethodName);
    }

    public void setDeleteStatefulMethodNames(Set<String> deleteStatefulMethodNames) {
        this.deleteStatefulMethodNames = deleteStatefulMethodNames;
    }
}

