/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker.stateful;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class SessionUtils {
    private SessionUtils() {
    }

    public static String putObjectInSession(Object obj) {
        String uuid = UUID.randomUUID().toString();
        SessionUtils.getSession(true).setAttribute(uuid, obj);
        return uuid;
    }

    public static String putObjectInSession(String uuid, Object obj) {
        SessionUtils.getSession(true).setAttribute(uuid, obj);
        return uuid;
    }

    public static Object getObjectFromSession(String uuid) {
        return SessionUtils.getSession(true).getAttribute(uuid);
    }

    public static void removeObjectFromSession(String uuid) {
        SessionUtils.getSession(true).removeAttribute(uuid);
    }

    public static void touchSessionIfExists() {
        String attr = "TOUCH_ATTR";
        HttpSession session = SessionUtils.getSession(false);
        if (session != null) {
            session.getAttribute("TOUCH_ATTR");
        }
    }

    public static HttpSession getSession(boolean create) {
        RequestAttributes requestAttr = RequestContextHolder.getRequestAttributes();
        if (!(requestAttr instanceof ServletRequestAttributes)) {
            throw new IllegalStateException("Current request is not a servlet request");
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttr).getRequest();
        return request.getSession(create);
    }
}

