/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker.stateful;

import com.sas.svcs.remoting.httpinvoker.stateful.ObjectDoesntExistException;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceIdHolder;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceResultIdHolder;
import com.sas.svcs.remoting.httpinvoker.stateful.management.StatefulServiceSessionManager;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.SessionScope;

public class IdBasedSessionScope
extends SessionScope {
    private static final Logger LOGGER = LogManager.getLogger(IdBasedSessionScope.class);
    public static final String DELETE_PREFIX = "Delete";
    private StatefulServiceSessionManager sessionManager;

    public String getConversationId() {
        String id = StatefulServiceIdHolder.getId();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("got id: " + id);
        }
        return id;
    }

    public void setSessionManager(StatefulServiceSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    private String createResultId() {
        String id = UUID.randomUUID().toString();
        StatefulServiceResultIdHolder.setId(id);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("created id: " + id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory objectFactory) {
        Object mutex;
        Object object = mutex = RequestContextHolder.currentRequestAttributes().getSessionMutex();
        synchronized (object) {
            String id = this.getConversationId();
            if (id != null) {
                if (id.startsWith(DELETE_PREFIX)) {
                    id = id.substring(DELETE_PREFIX.length());
                } else {
                    StatefulServiceIdHolder.clear();
                }
                String key = name + id;
                return this.getInternal(key, objectFactory);
            }
            id = this.createResultId();
            String key = name + id;
            return this.createInternal(key, objectFactory);
        }
    }

    public Object getInternal(String name, ObjectFactory objectFactory) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object scopedObject = attributes.getAttribute(name, this.getScope());
        if (scopedObject != null) {
            return scopedObject;
        }
        String msg = "Stateful service processing was unable to find an object matching the passed id: " + name + ". It is likely the backing session timed out or was otherwise destroyed. Or the object was previously deleted by the client.";
        LOGGER.error(msg);
        throw new ObjectDoesntExistException(msg);
    }

    public Object createInternal(String name, ObjectFactory objectFactory) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object scopedObject = objectFactory.getObject();
        attributes.setAttribute(name, scopedObject, this.getScope());
        if (this.sessionManager != null) {
            this.sessionManager.addNewObject(name, (Scope)this, scopedObject);
        }
        return scopedObject;
    }

    public Object removeByKey(String key) {
        return super.remove(key);
    }

    public Object remove(String name) {
        String id = this.getConversationId();
        if (id != null) {
            if (!id.startsWith(DELETE_PREFIX)) {
                LOGGER.error("System Error : Delete called without DELETE PREFIX");
                throw new RuntimeException("System Error : Delete called without DELETE PREFIX");
            }
            id = id.substring(DELETE_PREFIX.length());
            StatefulServiceIdHolder.clear();
            String key = name + id;
            if (this.sessionManager != null) {
                this.sessionManager.removeObjectByKey(key);
            }
            return super.remove(key);
        }
        LOGGER.warn("Trying to remove bean from idBasedSession scope without specifying id");
        return null;
    }
}

