/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.remoting.httpinvoker.HttpComponentsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;

public class ProxyAwareCommonsRequestExecutor
extends HttpComponentsHttpInvokerRequestExecutor {
    private static final Logger LOGGER = LogManager.getLogger(ProxyAwareCommonsRequestExecutor.class);
    protected ProxySelector proxySelector = ProxySelector.getDefault();
    protected ConcurrentMap<Proxy, HttpHost> proxyToHostMap = new ConcurrentHashMap<Proxy, HttpHost>(2);

    public ProxyAwareCommonsRequestExecutor() {
    }

    public ProxyAwareCommonsRequestExecutor(HttpClient httpClient) {
        super(httpClient);
    }

    protected HttpResponse executeHttpPost(HttpInvokerClientConfiguration config, HttpClient httpClient, HttpPost httpPost) throws IOException {
        HttpResponse httpResponse = null;
        HttpHost httpHost = null;
        try {
            URI uri = new URI(config.getServiceUrl());
            List<Proxy> proxies = this.proxySelector.select(uri);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Proxy selector returned " + proxies.size() + " potential proxies for " + config.getServiceUrl());
            }
            for (Proxy proxy : proxies) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Processing potential proxy " + proxy.toString() + " for " + config.getServiceUrl());
                }
                if (!Proxy.Type.HTTP.equals((Object)proxy.type()) || !(proxy.address() instanceof InetSocketAddress)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found proxy match for " + config.getServiceUrl());
                }
                if (null != (httpHost = (HttpHost)this.proxyToHostMap.get(proxy))) continue;
                String proxyHost = ((InetSocketAddress)proxy.address()).getHostName();
                int proxyPort = ((InetSocketAddress)proxy.address()).getPort();
                httpHost = new HttpHost(proxyHost, proxyPort, proxy.type().name());
                this.proxyToHostMap.putIfAbsent(proxy, httpHost);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Constructed new http host with proxy address " + proxyHost + " and port " + proxyPort);
                }
                break;
            }
        }
        catch (URISyntaxException e) {
            LOGGER.error("Error converting service url '" + config.getServiceUrl() + "' to URI", (Throwable)e);
            httpResponse = super.executeHttpPost(config, httpClient, httpPost);
        }
        RequestConfig.Builder builder = RequestConfig.copy((RequestConfig)super.createRequestConfig(config));
        if (null == httpHost) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No http host found for " + config.getServiceUrl());
            }
            httpPost.setConfig(builder.build());
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using http host " + httpHost.toString() + " to execute request for " + config.getServiceUrl());
            }
            httpPost.setConfig(builder.setProxy(httpHost).build());
        }
        httpResponse = super.executeHttpPost(config, httpClient, httpPost);
        return httpResponse;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public void setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
    }
}

