/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.client;

import com.sas.svcs.registry.client.RegisteredService;
import com.sas.svcs.registry.client.ServiceRegistryInterface;
import com.sas.svcs.remoting.client.SASClientTicketingProxy;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;

public class SASClientHttpServiceProxy
extends SASClientTicketingProxy {
    private static final String SERVICE_URL_PLACEHOLDER = "placeholder";
    private ServiceRegistryInterface registry;
    protected boolean useInterfaceClassLoader = true;

    public SASClientHttpServiceProxy() {
    }

    public SASClientHttpServiceProxy(ServiceRegistryInterface r) {
        this.setServiceRegistry(r);
    }

    public SASClientHttpServiceProxy(ServiceRegistryInterface r, Class<?> k) {
        if (!k.isInterface()) {
            throw new IllegalArgumentException("Class given to SASClientHttpServiceProxy must be an interface. " + k.getName() + "is not.");
        }
        this.setServiceRegistry(r);
        this.setServiceInterface(k);
    }

    public final void setServiceRegistry(ServiceRegistryInterface r) {
        this.registry = r;
    }

    public void setUseInterfaceClassLoader(boolean useInterfaceClassLoader) {
        this.useInterfaceClassLoader = useInterfaceClassLoader;
    }

    @Override
    protected synchronized void initialize(MethodInvocation mi) {
        Class k = this.getServiceInterface();
        RegisteredService registeredService = null;
        registeredService = this.registry.getServiceByInterface(k.getName());
        if (null == registeredService) {
            throw new IllegalStateException("Proxy was unable to find a backing service using criteria: serviceInterface=" + this.getServiceInterface().getName() + ", registry=" + this.registry);
        }
        this.setServiceUrl(registeredService.getUrl());
        super.initialize(mi);
    }

    public void afterPropertiesSet() {
        if (null == this.getServiceInterface()) {
            throw new IllegalStateException("Proxy requires a serviceInterface.");
        }
        if (null == this.registry) {
            throw new IllegalStateException("Proxy does not have required property serviceRegistry.");
        }
        this.setServiceUrl(SERVICE_URL_PLACEHOLDER);
        if (this.useInterfaceClassLoader) {
            ClassLoader interfaceClassLoader = this.getServiceInterface().getClassLoader();
            this.setBeanClassLoader(interfaceClassLoader);
            HttpInvokerRequestExecutor executor = this.getHttpInvokerRequestExecutor();
            if (executor instanceof BeanClassLoaderAware) {
                ((BeanClassLoaderAware)executor).setBeanClassLoader(interfaceClassLoader);
            }
        }
        super.afterPropertiesSet();
    }
}

