/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.context;

import com.sas.svcs.context.ClientApplicationInformation;
import com.sas.svcs.context.ContextInformationInterface;
import com.sas.svcs.context.SecurityContextInformation;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ContextInformation {
    private static final Logger LOGGER = LogManager.getLogger(ContextInformation.class);
    static Map<String, ContextInformationInterface> contextMap = new HashMap<String, ContextInformationInterface>();
    static ContextInformationInterface[] contexts;

    private ContextInformation() {
    }

    public static Object getContextInformation() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ContextInformationInterface memento : contexts) {
            String key = memento.getKey();
            Object o = memento.getContextInformation();
            if (null == o) continue;
            map.put(key, o);
        }
        return map;
    }

    public static void setContextInformation(Object object) {
        if (null == object) {
            throw new NullPointerException("Argument must not be null...");
        }
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("Provided object must be a java.util.Map implementation. It was: " + object);
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            ContextInformationInterface memento = contextMap.get(key);
            if (null != memento) {
                memento.setContextInformation(value);
                continue;
            }
            LOGGER.debug("");
        }
    }

    public static void clearContextInformation() {
        for (ContextInformationInterface memento : contexts) {
            memento.clearContextInformation();
        }
    }

    static {
        for (ContextInformationInterface memento : contexts = new ContextInformationInterface[]{new SecurityContextInformation(), new ClientApplicationInformation()}) {
            contextMap.put(memento.getKey(), memento);
        }
    }
}

