/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.olap;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;

class UpgradeUtil {
    private UpgradeUtil() {
    }

    public static boolean isUpgradeable(MetadataInterface smartObject, UsageVersion current) throws RemoteException, VersionIncompatibleException {
        boolean ret_val = true;
        UsageVersion myVersion = smartObject.getUsageVersion();
        if (!myVersion.isCompatible(new UsageVersion(0, 0), current)) {
            throw new VersionIncompatibleException(smartObject.getClass().getName(), current, myVersion);
        }
        if (myVersion.compareTo((Object)current) == 0) {
            ret_val = false;
        }
        return ret_val;
    }

    public static void setPublicType(PrimaryType jomaObject, String type) throws RemoteException {
        if (!jomaObject.getPublicType().equals(type)) {
            jomaObject.setPublicType(type);
        }
    }

    public static boolean setUsageVersion(MetadataInterface smartObject, PrimaryType jomaObject, UsageVersion version) throws MdException, RemoteException {
        boolean ret_val = false;
        if (smartObject.getUsageVersion().compareTo((Object)version) != 0) {
            jomaObject.setUsageVersion(version.encode());
            jomaObject.updateMetadataAll();
            ret_val = true;
        }
        return ret_val;
    }
}

