/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.olap;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.impl.OLAPSchemaImpl;
import com.sas.metadata.remote.impl.OLAPSchemaImpl_Stub;
import com.sas.publicobjects.olap.UpgradeUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.MetadataNameConstraint;
import com.sas.services.information.metadata.olap.OLAPSchemaInterface;
import com.sas.services.util.UpgradeInterface;
import com.sas.services.util.XMLUtil;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class OLAPSchema
extends Metadata
implements UpgradeInterface,
OLAPSchemaInterface,
LocalizableProperties {
    private static final long serialVersionUID = -1107133479654435095L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OLAPSchema() throws RemoteException {
        super(OLAPSchema.class);
    }

    public OLAPSchema(com.sas.metadata.remote.OLAPSchema olapSchema) throws RemoteException {
        super((Object)olapSchema, OLAPSchema.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OLAPSchema(OLAPSchemaImpl olapSchema) throws RemoteException {
        super((Object)olapSchema, OLAPSchema.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OLAPSchema(OLAPSchemaImpl_Stub olapSchema) throws RemoteException {
        super((Object)olapSchema, OLAPSchema.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public String getType() throws RemoteException {
        return "OLAPSchema";
    }

    public List getCubes() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(((Object)((Object)this)).getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> results = null;
        com.sas.metadata.remote.OLAPSchema schema = (com.sas.metadata.remote.OLAPSchema)this._repositoryObject;
        try {
            AssociationList cubes = schema.getCubes();
            results = new ArrayList<MetadataInterface>(cubes.size());
            for (Cube cube : cubes) {
                MetadataInterface mi = this._repository.factoryProcess((Object)cube);
                results.add(mi);
            }
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
        return results;
    }

    public PropertyList getLocalizableProperties() {
        return this.getDefaultLocalizableProperties();
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setDefaultLocalizableProperties(map);
    }

    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (!UpgradeUtil.isUpgradeable((MetadataInterface)this, CURRENT_VERSION)) {
            return;
        }
        com.sas.metadata.remote.OLAPSchema jomaObject = (com.sas.metadata.remote.OLAPSchema)this._repositoryObject;
        UpgradeUtil.setPublicType((PrimaryType)jomaObject, "OLAPSchema");
        try {
            if (UpgradeUtil.setUsageVersion((MetadataInterface)this, (PrimaryType)jomaObject, OLDEST_VERSION)) {
                this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
        boolean upgraded = false;
        try {
            FolderInterface sharedData;
            FolderInterface targetFolder = this.getParent();
            if (targetFolder != null && FolderUtil.isDIStudioUngroupedFolder((FolderInterface)targetFolder)) {
                targetFolder = null;
            }
            if (targetFolder == null && (sharedData = FolderUtil.makeSharedDataFolder((MetadataInterface)this)) != null && (targetFolder = sharedData.getSubfolder(this.getName())) == null) {
                targetFolder = sharedData.makeSubfolder(this.getName());
            }
            OLAPSchemaNameConstraint constraint = new OLAPSchemaNameConstraint(this);
            this.validateNameAndFolder(targetFolder, constraint);
            upgraded = UpgradeUtil.setUsageVersion((MetadataInterface)this, (PrimaryType)jomaObject, CURRENT_VERSION);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
        finally {
            if (!upgraded) {
                try {
                    UpgradeUtil.setUsageVersion((MetadataInterface)this, (PrimaryType)jomaObject, OLDEST_VERSION);
                }
                catch (MdException e) {
                    throw new ServiceException((Throwable)e, e.getLocalizedMessage());
                }
            }
        }
    }

    private class OLAPSchemaNameConstraint
    implements MetadataNameConstraint {
        OLAPSchema _schema;
        MetadataServerInterface _server;
        Filter _filter;

        OLAPSchemaNameConstraint(OLAPSchema schema) throws ServiceException, RemoteException {
            this._schema = schema;
            this._filter = new Filter();
            this._filter.setType("OLAPSchema");
            this._filter.setOMRFlags(16384);
            this._server = (MetadataServerInterface)this._schema.getRepository().getServer();
        }

        public boolean isNameValid(MetadataInterface object, String name) throws ServiceException, RemoteException {
            StringBuffer sb = new StringBuffer();
            sb.append("<XMLSelect search=\"*[@Name='");
            sb.append(XMLUtil.normalize((String)name));
            sb.append("']\"/>");
            this._filter.setExplicitSearchString("omi", sb.toString());
            int count = this._server.getCountNoSecurity(this._filter, null);
            if (count == 0) {
                return true;
            }
            if (count > 1) {
                return false;
            }
            return object.getName().equals(name);
        }
    }
}

