/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.graphics.html;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.commands.MapClearSelectionsCommand;
import com.sas.actionprovider.commands.MapFilterSelectionsCommand;
import com.sas.actionprovider.commands.MapIdentifyCommand;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.entities.AttributeSetException;
import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.NoteModel;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.esrimap.ESRIMapDataModel;
import com.sas.graphics.components.esrimap.ESRIMapModel;
import com.sas.graphics.components.esrimap.ESRIMapTableDataModel;
import com.sas.graphics.map.ESRIConnection;
import com.sas.graphics.map.ESRIException;
import com.sas.graphics.map.ESRIMap;
import com.sas.graphics.map.MapImageUtil;
import com.sas.graphics.util.FontManager;
import com.sas.servlet.tbeans.BaseActionTransformation;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.dataselectors.crossing.html.MapCrossingSelector;
import com.sas.servlet.tbeans.graphics.BaseESRIMapChart;
import com.sas.servlet.tbeans.graphics.BaseGraphics;
import com.sas.servlet.tbeans.graphics.html.RB;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.tableview.TableRowRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableRowRenderer;
import com.sas.servlet.tbeans.tableview.html.ResizingUtil;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.text.SASFormat;
import com.sas.util.MapWithDefaults;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.swing.table.TableModel;
import org.apache.logging.log4j.LogManager;

public class ESRIMapChart
extends BaseESRIMapChart
implements ContentsChangedListener,
PropertyChangeListener,
ComplexStyleInterface {
    public static String DEFAULT_TEMPLATE_FILE_NAME = "DefaultSelectorTemplate.html";
    private static final String INTERNAL_RB_KEY = "MapComponent.";
    private ESRIMapModel graphModel;
    private String formAction;
    private int nMiss = 0;
    private String geoString = null;

    public ESRIMapChart() {
        this.setActionSupportType("ESRIMAP_SUPPORT");
        this.graphModel = new ESRIMapModel();
        this.model = new ESRIMapTableDataModel();
        this.getGraph().setMinimumSize(new Dimension(400, 250));
        this.graphModel.addPropertyChangeListener(this);
        CategorizationModel cm = CategorizationModel.newCategorizationModel((int)12001, (int)5);
        try {
            this.setColorScheme("Default");
            this.logger = LogManager.getLogger(ESRIMapChart.class);
            if (this.logger.isDebugEnabled()) {
                this.debug = true;
                this.logger.debug("Debugging turned on for MapComponent");
            } else {
                this.debug = false;
            }
        }
        catch (Exception e) {
            this.debug = false;
        }
        this.setActionSupportType("ESRIMAP_SUPPORT");
        ESRIMapChart.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap(defaultStyleMap);
        this.recalculateGeoString();
    }

    public int performAction() {
        String outputMessage = null;
        boolean everythingWorked = true;
        ESRIMap myMap = this.getESRIMap();
        if (myMap == null) {
            outputMessage = RB.getStringResource(INTERNAL_RB_KEY, "GenericConnectionError.txt", this.getLocale());
            everythingWorked = false;
        } else {
            this.textMessage = null;
            try {
                if (this.clearSelectionsFlag) {
                    myMap.clearSelections();
                    this.clearSelectionsFlag = false;
                }
                MapCrossingSelector es = new MapCrossingSelector();
                es.setActionProvider(this.getActionProvider());
                ArrayList valueList = new ArrayList(6);
                ArrayList descriptorList = new ArrayList(6);
                ArrayList exceptionList = new ArrayList(6);
                this.setupMap(myMap, this.autoZoom, valueList, descriptorList, exceptionList);
                CategorizationModel cm = this.resolveCategorizationModel();
                if (this.useSavedMapExtents) {
                    myMap.setMapExtents(this.mapExtents[0], this.mapExtents[1], this.mapExtents[2], this.mapExtents[3]);
                }
                for (int i = 0; i < valueList.size(); ++i) {
                    if (!((String)descriptorList.get(i)).equalsIgnoreCase(".")) continue;
                    descriptorList.remove(i);
                    valueList.remove(i);
                    if (exceptionList != null && exceptionList.size() >= i) {
                        exceptionList.remove(i);
                    }
                    --i;
                }
                if (valueList.size() > 0) {
                    CategorizationModel cm2 = CategorizationModel.newCategorizationModel((int)cm.getCategorizationType(), (int)Math.min(cm.getParameter(), valueList.size() - this.nMiss));
                    myMap.classify(cm2, ((ESRIMapTableDataModel)this.model).getLayerName(), ((ESRIMapTableDataModel)this.model).getFieldName(), descriptorList.toArray(new String[0]), valueList.toArray(new Double[0]), exceptionList.toArray(new Boolean[0]));
                }
                this.mapImageMimeData = myMap.getImageMimeData();
                if (valueList.size() <= 0) {
                    String t = RB.getStringResource(INTERNAL_RB_KEY, "NoMapInfoForData.txt", this.getLocale());
                    this.mapImageMimeData = this.addNote(this.mapImageMimeData, t);
                }
                this.legendImageMimeData = myMap.getLegendMimeData(valueList.size() <= 0);
                this.mapDesc = myMap.getMapDescription();
                this.imageDesc = myMap.getImageDescription();
                this.mapExtents = myMap.getMapExtents();
                if (valueList.size() > 0) {
                    myMap.undoClassification(((ESRIMapTableDataModel)this.model).getLayerName());
                }
            }
            catch (Exception e) {
                outputMessage = RB.getStringResource(INTERNAL_RB_KEY, "MapCreationError.txt", this.getLocale());
                everythingWorked = false;
                this.printDebugInfo(myMap);
            }
        }
        if (!everythingWorked) {
            this.resetMapLegend();
            this.textMessage = outputMessage;
        }
        this.actionPerformed = true;
        if (this.graphModel.isDebug()) {
            this.printDebugInfo(myMap);
        }
        try {
            if (myMap != null) {
                myMap.disconnect();
            }
            myMap = null;
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return 1;
    }

    private void setupMap(ESRIMap myMap, boolean autoZoom, List valueList, List descriptorList, List exceptionList) throws ESRIException {
        boolean doZoom = false;
        myMap.setShowMissing(false);
        this.nMiss = 0;
        TableModel tm = this.getTableDataModel();
        if (tm == null) {
            return;
        }
        int geoCol = ((ESRIMapTableDataModel)this.model).getIdVariable().getColumnIndex();
        int responseCol = ((ESRIMapTableDataModel)this.model).getChoroVariable().getColumnIndex();
        int count = tm.getRowCount();
        Object[] geoArray = new Object[count];
        Double[] responseArray = new Double[count];
        for (int i = 0; i < count; ++i) {
            descriptorList.add(tm.getValueAt(i, geoCol));
            valueList.add((Double)tm.getValueAt(i, responseCol));
        }
        if (!descriptorList.isEmpty()) {
            myMap.setLayerVisibility(((ESRIMapTableDataModel)this.model).getLayerName(), "UseMapServiceRules");
            myMap.subset(((ESRIMapTableDataModel)this.model).getLayerName(), ((ESRIMapTableDataModel)this.model).getFieldName(), descriptorList.toArray(new String[0]));
            doZoom = true;
        }
        if (valueList.size() <= 0) {
            myMap.zoomFullExtent();
        } else if (autoZoom && doZoom) {
            double[] totalExtents = new double[4];
            totalExtents[2] = Double.MAX_VALUE;
            totalExtents[0] = Double.MAX_VALUE;
            totalExtents[3] = -1.7976931348623157E308;
            totalExtents[1] = -1.7976931348623157E308;
            double[] layerExtents = myMap.zoomFeatures(((ESRIMapTableDataModel)this.model).getLayerName(), ((ESRIMapTableDataModel)this.model).getFieldName(), descriptorList.toArray(new String[0]));
            myMap.setMapExtents(layerExtents[0], layerExtents[1], layerExtents[2], layerExtents[3]);
        }
    }

    @Override
    public void printDebugInfo(ESRIMap myMap) {
        ESRIConnection connection = this.getDataModel().getESRIConnection();
        System.out.println("----------------------------------------------------------------");
        System.out.println("ESRI Server Connection Information");
        System.out.println("   Server:" + connection.getGisServer());
        System.out.println("   Service:" + connection.getMapServiceName());
        System.out.println("   Domain:" + connection.getDomain());
        System.out.println("   UserName:" + connection.getUserName());
        System.out.println();
        System.out.println();
        System.out.println();
        if (myMap != null) {
            String[] s = null;
            try {
                s = myMap.getLayerNames();
            }
            catch (ESRIException eSRIException) {
                // empty catch block
            }
            if (s != null) {
                System.out.println();
                System.out.println("Map Layers");
                for (int i = 0; i < s.length; ++i) {
                    System.out.println("   " + s[i]);
                }
            }
        }
    }

    public void performAction(boolean internal) {
        this.performAction();
        this.actionPerformed = internal;
    }

    public ActionList getMapActions() {
        ActionSupportFilter supportFilter = new ActionSupportFilter("RELATIONALESRIMAP_SUPPORT", "MAP_AREA", (ActionProviderViewInterface)this, false);
        supportFilter.setPoolingOn(false);
        supportFilter.setSwing(false);
        supportFilter.setViewerId(this.getId() + "_MapActions");
        try {
            supportFilter.setAttribute("mapViewer", (Object)this);
        }
        catch (AttributeSetException e) {
            System.out.println("Couldn't set the mapViewer");
        }
        ActionList mapActions = this.getActionProvider().getActions(supportFilter);
        return mapActions;
    }

    public ActionList getOtherMapActions() {
        ActionSupportFilter supportFilter = new ActionSupportFilter("RELATIONALESRIMAP_SUPPORT", "MAP_OTHER_AREA", (ActionProviderViewInterface)this, false);
        supportFilter.setPoolingOn(false);
        supportFilter.setSwing(false);
        supportFilter.setViewerId(this.getId() + "_OtherActions");
        try {
            supportFilter.setAttribute("mapViewer", (Object)this);
        }
        catch (AttributeSetException e) {
            System.out.println("Couldn't set the mapViewer");
        }
        ActionList mapActions = this.getActionProvider().getActions(supportFilter);
        return mapActions;
    }

    public ActionList getToolbarActions() {
        ActionSupportFilter toolbarSupportFilter = new ActionSupportFilter("RELATIONALESRIMAP_TOOLBAR_SUPPORT", "MAP_TOOLBAR_AREA", (ActionProviderViewInterface)this.menuBar, false);
        try {
            toolbarSupportFilter.setAttribute("model", (Object)this.getTableDataModel());
            toolbarSupportFilter.setAttribute("geo", (Object)this.getGeoString());
            toolbarSupportFilter.setAttribute("mapViewer", (Object)this);
            toolbarSupportFilter.setViewerId(this.getId() + "_ToolbarActions");
        }
        catch (AttributeSetException e1) {
            e1.printStackTrace();
        }
        toolbarSupportFilter.setPoolingOn(false);
        toolbarSupportFilter.setSwing(false);
        ActionList toolbarActions = this.getActionProvider().getActions(toolbarSupportFilter);
        return toolbarActions;
    }

    public void write(PrintWriter out) throws IOException {
        super.write(out);
        if (this.isAllActionsVisible() && this.isResizable()) {
            new ResizingUtil((BaseActionTransformation)this).writeGraphResizingScript(out, (BaseGraphics)this);
        }
        ActionList mapActions = this.getMapActions();
        ActionList toolbarActions = this.getToolbarActions();
        ActionList otherActions = this.getOtherMapActions();
        HttpAction selectAction = (HttpAction)mapActions.get("SELECT_ACTION");
        HttpAction rectangularSelectAction = (HttpAction)mapActions.get("RECTANGULARSELECT_ACTION");
        HttpAction zoomInAction = (HttpAction)mapActions.get("ZOOMIN_ACTION");
        HttpAction zoomOutAction = (HttpAction)mapActions.get("ZOOMOUT_ACTION");
        HttpAction panAction = (HttpAction)mapActions.get("PAN_ACTION");
        HttpAction identifyAction = (HttpAction)mapActions.get("IDENTIFY_ACTION");
        HttpAction fullExtentsAction = (HttpAction)toolbarActions.get("FULLEXTENTS_ACTION");
        HttpAction filterSelectionsAction = (HttpAction)toolbarActions.get("FILTERSELECTIONS_ACTION");
        HttpAction clearSelectionsAction = (HttpAction)toolbarActions.get("CLEARSELECTIONS_ACTION");
        HttpAction reportLinkingAction = (HttpAction)mapActions.get("REPORTLINKING_ACTION");
        if (filterSelectionsAction != null) {
            this.filterCommand = (MapFilterSelectionsCommand)filterSelectionsAction.getCommand();
        }
        if (this.clearSelectionsCommand != null) {
            this.clearSelectionsCommand = (MapClearSelectionsCommand)clearSelectionsAction.getCommand();
        }
        HttpSession session = null;
        HttpServletRequest request = this.getRequest();
        if (this.useSession && request != null) {
            session = request.getSession();
        }
        if (this.redrawMap && !this.actionPerformed) {
            this.performAction(false);
        }
        if (this.isAllActionsVisible()) {
            JavaScriptIncludeHandler.writeIncludes((Writer)out, (Object)"MAP", (HttpServletRequest)this.getRequest());
            JavaScriptIncludeHandler.writeIncludes((Writer)out, (Object)"FASTCLICKPROTECTION", (HttpServletRequest)this.getRequest());
            if (request != null) {
                this.writeFastClickProtection(out, this.getRequest().isSecure());
            }
        }
        HashMap argumentMap = ActionProviderMapPool.getMap();
        String id = this.getId() + "ESRIMap";
        out.print("<div");
        out.print(" id=\"" + this.getId() + "overallLayer\"");
        if (this.isAllActionsVisible()) {
            out.print(" onmouseout=\"sas_mapMouseOut('" + id + "',event)\" ");
        }
        out.println(">");
        StyleInfo styleInfo = (StyleInfo)this.getStyleMap().get("MAPCOMPOSITE_BACKGROUNDLAYERSTYLE");
        if (this.isAllActionsVisible()) {
            out.print("<div");
            if (this.isDisabledImage()) {
                out.print(" disabled");
            }
            out.print(" id=\"" + this.getId() + "backgroundLayer\" style=\"position:absolute; z-index:0\" class=\"" + styleInfo.getClassid() + "\"");
            out.print(" onmousedown=\"sas_mapMouseDown('" + id + "',event)\" ");
            out.print(" onmouseup=\"sas_mapMouseUp('" + id + "',event)\" ");
            out.print(" onmousemove=\"sas_mapMouseMove('" + id + "',event)\" ");
            out.println(">");
            out.println("</div>");
            styleInfo = (StyleInfo)this.getStyleMap().get("MAPCOMPOSITE_ZOOMLAYERSTYLE");
            out.print("<div");
            if (this.isDisabledImage()) {
                out.print(" disabled");
            }
            out.print(" id=\"" + this.getId() + "zoomLayer\" style=\"position:absolute; visibility:hidden; z-index:1\" class=\"" + styleInfo.getClassid() + "\"");
            out.print(" onmousedown=\"sas_mapMouseDown('" + id + "',event)\" ");
            out.print(" onmouseup=\"sas_mapMouseUp('" + id + "',event)\" ");
            out.print(" onmousemove=\"sas_mapMouseMove('" + id + "',event)\" ");
            out.println(">");
            out.println("</div>");
            styleInfo = (StyleInfo)this.getStyleMap().get("MAPCOMPOSITE_SELECTLAYERSTYLE");
            out.print("<div");
            if (this.isDisabledImage()) {
                out.print(" disabled");
            }
            out.print(" id=\"" + this.getId() + "selectLayer\" style=\"position:absolute; visibility:hidden; z-index:1\" class=\"" + styleInfo.getClassid() + "\"");
            out.print(" onmousedown=\"sas_mapMouseDown('" + id + "',event)\" ");
            out.print(" onmouseup=\"sas_mapMouseUp('" + id + "',event)\" ");
            out.print(" onmousemove=\"sas_mapMouseMove('" + id + "',event)\" ");
            out.println(">");
            out.println("</div>");
        }
        styleInfo = (StyleInfo)this.getStyleMap().get("MAPCOMPOSITE_MAPLAYERSTYLE");
        out.print("<div");
        if (this.isDisabledImage()) {
            out.print(" disabled");
        }
        out.print(" id=\"" + this.getId() + "mapLayer\" style=\"position:absolute; z-index:0\" class=\"" + styleInfo.getClassid() + "\"");
        if (this.isAllActionsVisible()) {
            out.print(" onmousedown=\"sas_mapMouseDown('" + id + "',event)\" ");
            out.print(" onmouseup=\"sas_mapMouseUp('" + id + "',event)\" ");
            out.print(" onmousemove=\"sas_mapMouseMove('" + id + "',event)\" ");
            out.print(" onclick=\"sas_mapOnClick('" + id + "',event)\" ");
        }
        out.println(">");
        if (this.textMessage != null) {
            Label myLabel = new Label(this.textMessage);
            myLabel.write(out);
        } else {
            String url = null;
            if (this.getImage() != null) {
                url = this.getImage();
            } else if (this.useSession && session != null) {
                String contentServletURL = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/StreamContentServlet?" + "CONTENT_KEY" + "=" + this.getId() + "&SRCID=" + Math.round(Math.random() * 100000.0) + BaseUtil.getRemoteSessionParameters((HttpServletRequest)request, (boolean)false);
                HttpServletResponse response = this.getResponse();
                if (response != null) {
                    contentServletURL = response.encodeURL(contentServletURL);
                }
                url = contentServletURL;
                if (this.redrawMap) {
                    session.setAttribute("sas_StreamContentServlet_ContentBytes" + this.getId(), (Object)this.mapImageMimeData);
                } else {
                    Object d = session.getAttribute("sas_StreamContentServlet_ContentBytes" + this.getId());
                    if (d == null) {
                        this.performAction(false);
                        d = this.mapImageMimeData;
                    }
                    session.setAttribute("sas_StreamContentServlet_ContentBytes" + this.getId(), d);
                }
                session.setAttribute("sas_StreamContentServlet_ContentType" + this.getId(), (Object)"image/gif");
                session.setAttribute("sas_StreamContentServlet_ContentDisposition" + this.getId(), (Object)("inline;filename=" + this.getId()));
                session.setAttribute("sas_StreamContentServlet_DisposeContents" + this.getId(), (Object)"false");
            }
            out.print(" <input");
            if (this.isDisabledImage()) {
                out.print(" disabled");
            }
            out.print(" type=\"IMAGE\" width=\"" + this.mapSize.getWidth() + "\" height=\"" + this.mapSize.getHeight() + "\"");
            if (this.isAllActionsVisible()) {
                out.print(" onmouseover=\"sas_mapMouseOver('" + id + "',event)\" ");
            }
            if (!this.isGalleryImageVisible()) {
                out.print(" galleryimg=\"no\"");
            }
            out.print(" id=\"" + this.getId() + "ESRIMapImage\"  src=\"" + url + "\" name=\"map\" />");
        }
        out.println("</div>");
        out.println("</div>");
        out.println("<input type=\"HIDDEN\" name=\"" + this.getActionProvider().getParameterPrefix() + "clickX\"id=\"" + this.getId() + this.getActionProvider().getParameterPrefix() + "clickX\" value=\"\">");
        out.println("<input type=\"HIDDEN\" name=\"" + this.getActionProvider().getParameterPrefix() + "clickY\"id=\"" + this.getId() + this.getActionProvider().getParameterPrefix() + "clickY\" value=\"\">");
        out.println("<input type=\"HIDDEN\" name=\"" + this.getActionProvider().getParameterPrefix() + "width\"id=\"" + this.getId() + this.getActionProvider().getParameterPrefix() + "width\" value=\"\">");
        out.println("<input type=\"HIDDEN\" name=\"" + this.getActionProvider().getParameterPrefix() + "height\"id=\"" + this.getId() + this.getActionProvider().getParameterPrefix() + "height\" value=\"\">");
        out.println("<input type=\"HIDDEN\" name=\"" + this.getActionProvider().getParameterPrefix() + "controlPressed\"id=\"" + this.getId() + this.getActionProvider().getParameterPrefix() + "controlPressed\" value=\"\">");
        if (this.isAllActionsVisible()) {
            out.println("<script>");
            HttpAction zoomInModeAction = (HttpAction)toolbarActions.get("ZOOMINMODE_ACTION");
            HttpAction zoomOutModeAction = (HttpAction)toolbarActions.get("ZOOMOUTMODE_ACTION");
            HttpAction panModeAction = (HttpAction)toolbarActions.get("PANMODE_ACTION");
            HttpAction selectModeAction = (HttpAction)toolbarActions.get("SELECTMODE_ACTION");
            HttpAction rectangularSelectModeAction = (HttpAction)toolbarActions.get("RECTANGULARSELECTMODE_ACTION");
            HttpAction identifyModeAction = (HttpAction)toolbarActions.get("IDENTIFYMODE_ACTION");
            HttpAction reportLinkingModeAction = (HttpAction)toolbarActions.get("REPORTLINKINGMODE_ACTION");
            String zoomInSelectedImage = this.getSelectedImage(zoomInModeAction);
            String zoomOutSelectedImage = this.getSelectedImage(zoomOutModeAction);
            String panSelectedImage = this.getSelectedImage(panModeAction);
            String selectSelectedImage = this.getSelectedImage(selectModeAction);
            String rectangularSelectSelectedImage = this.getSelectedImage(rectangularSelectModeAction);
            String identifySelectedImage = this.getSelectedImage(identifyModeAction);
            String reportLinkingSelectedImage = this.getSelectedImage(reportLinkingModeAction);
            String zoomInImage = this.getImage(zoomInModeAction);
            String zoomOutImage = this.getImage(zoomOutModeAction);
            String panImage = this.getImage(panModeAction);
            String selectImage = this.getImage(selectModeAction);
            String rectangularSelectImage = this.getImage(rectangularSelectModeAction);
            String identifyImage = this.getImage(identifyModeAction);
            String reportLinkingImage = this.getImage(reportLinkingModeAction);
            out.println("var " + this.getId() + "ESRIMap= new sas_ESRIMap(\"" + this.getId() + "\");");
            out.println(this.getId() + "ESRIMap.imageLocation=\"" + this.getImageLocation() + "\"");
            out.println(this.getId() + "ESRIMap.zoomInSelectedImage=\"" + zoomInSelectedImage + "\"");
            out.println(this.getId() + "ESRIMap.zoomOutSelectedImage=\"" + zoomOutSelectedImage + "\"");
            out.println(this.getId() + "ESRIMap.panSelectedImage=\"" + panSelectedImage + "\"");
            out.println(this.getId() + "ESRIMap.selectSelectedImage=\"" + selectSelectedImage + "\"");
            out.println(this.getId() + "ESRIMap.rectangularSelectSelectedImage=\"" + rectangularSelectSelectedImage + "\"");
            out.println(this.getId() + "ESRIMap.identifySelectedImage=\"" + identifySelectedImage + "\"");
            out.println(this.getId() + "ESRIMap.reportLinkingSelectedImage=\"" + reportLinkingSelectedImage + "\"");
            out.println(this.getId() + "ESRIMap.zoomInImage=\"" + zoomInImage + "\"");
            out.println(this.getId() + "ESRIMap.zoomOutImage=\"" + zoomOutImage + "\"");
            out.println(this.getId() + "ESRIMap.panImage=\"" + panImage + "\"");
            out.println(this.getId() + "ESRIMap.selectImage=\"" + selectImage + "\"");
            out.println(this.getId() + "ESRIMap.rectangularSelectImage=\"" + rectangularSelectImage + "\"");
            out.println(this.getId() + "ESRIMap.identifyImage=\"" + identifyImage + "\"");
            out.println(this.getId() + "ESRIMap.reportLinkingImage=\"" + reportLinkingImage + "\"");
            out.println(this.getId() + "ESRIMap.menuId=\"" + this.getId() + "toolbarContainer\"");
            if (this.preOnClickFunctionName != null) {
                out.println(this.getId() + "ESRIMap.preOnClickFunctionName=\"" + this.preOnClickFunctionName + "\"");
            }
            if (this.postOnClickFunctionName != null) {
                out.println(this.getId() + "ESRIMap.postOnClickFunctionName=\"" + this.postOnClickFunctionName + "\"");
            }
            String menuStyle = ((StyleInfo)this.getStyleMap().get("MAPCOMPONENT_MENUSTYLE")).getClassid();
            String selectedMenuStyle = ((StyleInfo)this.getStyleMap().get("MAPCOMPONENT_SELECTEDMENUSTYLE")).getClassid();
            out.println(this.getId() + "ESRIMap.menuStyle=\"" + menuStyle + "\";");
            if (selectedMenuStyle != null && selectedMenuStyle.length() == 0) {
                out.println(this.getId() + "ESRIMap.selectedMenuStyle=null;");
            } else if (selectedMenuStyle != null) {
                out.println(this.getId() + "ESRIMap.selectedMenuStyle=\"" + selectedMenuStyle + "\";");
            }
            out.println(this.getId() + "ESRIMap.mapWidth=\"" + this.mapSize.width + "\";");
            out.println(this.getId() + "ESRIMap.mapHeight=\"" + this.mapSize.height + "\";");
            out.println(this.getId() + "ESRIMap.prefix=\"" + this.getActionProvider().getParameterPrefix() + "\";");
            out.println(this.getId() + "ESRIMap.mode=\"" + this.mode + "\";");
            String s = "";
            if (reportLinkingAction != null) {
                s = ", reportLinking:\"" + reportLinkingAction.getAttribute("URL") + "\" ";
            }
            out.println(this.getId() + "ESRIMap.urls={select:\"" + ESRIMapChart.getUrl(selectAction) + "\", rectangularSelect:\"" + ESRIMapChart.getUrl(rectangularSelectAction) + "\", fullExtents:\"" + ESRIMapChart.getUrl(fullExtentsAction) + "\", filterSelections:\"" + ESRIMapChart.getUrl(filterSelectionsAction) + "\", clearSelections:\"" + ESRIMapChart.getUrl(clearSelectionsAction) + "\", zoomIn:\"" + ESRIMapChart.getUrl(zoomInAction) + "\", zoomOut:\"" + ESRIMapChart.getUrl(zoomOutAction) + "\", pan:\"" + ESRIMapChart.getUrl(panAction) + "\", identify:\"" + ESRIMapChart.getUrl(identifyAction) + "\", " + s + "};");
            out.println(this.getId() + "ESRIMap.mapInit();");
            out.println("</script>");
        }
        this.setAutoZoom(true);
        this.redrawMap = false;
    }

    public byte[] getPrintImage() {
        NoteModel nm = this.getFootnote1();
        int noteHeight = 0;
        if (nm != null) {
            noteHeight = nm.getTextStyle().getFont().getSize();
        }
        Dimension totalSize = new Dimension(this.mapSize.width + this.legendSize.width, this.mapSize.height + noteHeight * 2);
        BufferedImage bimage = new BufferedImage(totalSize.width, totalSize.height, 1);
        Graphics2D g = bimage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, bimage.getWidth(), bimage.getHeight());
        this.performAction(false);
        if (this.mapImageMimeData == null) {
            this.getMapImageMimeData();
        }
        if (this.legendImageMimeData == null) {
            this.getLegendImageMimeData();
        }
        BufferedImage mi = MapImageUtil.getImageFromByteStream(this.mapImageMimeData, this.mapSize.width, this.mapSize.height);
        g.drawImage((Image)mi, 0, 0, null);
        BufferedImage li = MapImageUtil.getImageFromByteStream(this.legendImageMimeData, this.legendSize.width, this.legendSize.height);
        g.drawImage((Image)li, this.mapSize.width, this.mapSize.height - this.legendSize.height, null);
        String s = this.getLegendTitle();
        if (s != null) {
            Font bigFont;
            FontMetrics bigFontM;
            char[] measureString = s.toCharArray();
            g.setColor(Color.black);
            RectangularShape rect = null;
            for (int fontSize = 12; fontSize > 6 && !((rect = (bigFontM = g.getFontMetrics(bigFont = FontManager.getFont((String)FontManager.getDefaultFont().getFamily(), (int)0, (int)fontSize))).getStringBounds(measureString, 0, measureString.length, (Graphics)g)).getWidth() <= (double)this.legendSize.width); --fontSize) {
            }
            ((Graphics)g).drawString(s, this.mapSize.width + this.legendSize.width / 2 - (int)rect.getWidth() / 2, 10);
        }
        if (nm != null && nm.getText() != null) {
            g.setColor(nm.getTextStyle().getColor());
            Font f = nm.getTextStyle().getFont();
            FontMetrics fm = g.getFontMetrics(f);
            char[] footnoteString = nm.getText().toCharArray();
            Rectangle2D r = fm.getStringBounds(footnoteString, 0, footnoteString.length, (Graphics)g);
            int i = totalSize.height - noteHeight / 2;
            ((Graphics)g).drawString(nm.getText(), totalSize.width / 2 - (int)r.getWidth() / 2, i);
        }
        this.cleanUpImages();
        byte[] bs = null;
        try {
            bs = MapImageUtil.getPngByteStream(bimage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bs;
    }

    public String[] identify(int x, int y) {
        ESRIMap myMap = new ESRIMap(this.getDataModel().getESRIConnection());
        myMap.setLocale(this.getLocale());
        myMap.setMapImageSize(this.mapSize);
        try {
            myMap.connect();
            if (this.mapDesc != null && this.imageDesc != null) {
                myMap.getMap(this.mapDesc, this.imageDesc);
            } else {
                myMap.getMap();
            }
            ArrayList valueList = new ArrayList(6);
            ArrayList descriptorList = new ArrayList(6);
            ArrayList exceptionList = new ArrayList(6);
            this.setupMap(myMap, false, valueList, descriptorList, exceptionList);
            String[] sval = myMap.identify(x, y);
            String fieldValue = null;
            Object value = null;
            for (int i = 0; i < sval.length; i += 2) {
                if (!sval[i].equals(((ESRIMapTableDataModel)this.model).getFieldName())) continue;
                fieldValue = sval[i + 1];
                int index = descriptorList.indexOf(fieldValue);
                if (index == -1) break;
                value = valueList.get(index);
                break;
            }
            ArrayList<String> myArray = new ArrayList<String>();
            for (int i = 0; i < sval.length; i += 2) {
                myArray.add(sval[i]);
                myArray.add(sval[i + 1]);
            }
            if (value != null) {
                myArray.add(0, this.getLegendTitle());
                if (((Double)value).isNaN()) {
                    myArray.add(1, RB.getStringResource(INTERNAL_RB_KEY, "Missing.txt", this.getLocale()));
                } else if (value instanceof Double) {
                    SASFormat format = SASFormat.getInstance((String)this.getLegendFormat());
                    String s = format.format(value).trim();
                    myArray.add(1, s);
                } else {
                    myArray.add(1, value.toString());
                }
            }
            myMap.disconnect();
            return myArray.toArray(new String[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        String type = request.getParameter("ServletName");
        PrintWriter out = response.getWriter();
        if (type != null && type.equalsIgnoreCase("IdentifyWindow")) {
            DynamicAttributeCommandInterface command;
            String apName = request.getParameter("APNAME");
            HttpActionProvider ap = null;
            ap = (HttpActionProvider)session.getAttribute(apName);
            MapIdentifyCommand identifyCommand = null;
            if (ap != null && (command = ap.getExecutableCommand(request)) instanceof MapIdentifyCommand) {
                identifyCommand = (MapIdentifyCommand)command;
            }
            if (identifyCommand == null) {
                return;
            }
            ESRIMapChart map = (ESRIMapChart)identifyCommand.getMapViewer();
            Object crossingValues = null;
            Label crossingLabel = new Label(RB.getStringResource(INTERNAL_RB_KEY, "CrossingInformation.txt", request.getLocale()));
            Object crossingTableView = null;
            Object headers = null;
            ComponentPropertyManager propertyManager = ComponentPropertyManager.getInstance((HttpServletRequest)request);
            out.println("<html>");
            out.println("<head>");
            out.println("<title> " + RB.getStringResource(INTERNAL_RB_KEY, "MapInformation.txt", request.getLocale()) + "</title>");
            out.println("<link href=\" " + propertyManager.getStyleLocation() + "sasComponents.css\" rel=\"STYLESHEET\" type=\"text/css\">");
            out.println("<SCRIPT>\n");
            out.println("function sas_init_dialog() {");
            out.println("var container = document.getElementById(\"outerSelectorContainer\");");
            out.println("var w = container.scrollWidth;");
            out.println("var margin = eval(document.body.rightMargin)+eval(document.body.leftMargin)-8;");
            out.println("w += (margin | 2);");
            out.println("var h = container.scrollHeight;");
            out.println("margin = eval(document.body.topMargin)+eval(document.body.bottomMargin)+8;");
            out.println("h += (margin | 32);");
            out.println("window.resizeTo( w, h );");
            out.println("window.focus();");
            out.println("}");
            out.println("</SCRIPT>");
            out.println("</head>");
            out.println("<body onload=\"sas_init_dialog()\">");
            out.println("<div id=\"outerSelectorContainer\">");
            if (crossingTableView != null && (crossingValues).length > 1) {
                StyleInfo labelStyle = (StyleInfo)map.getStyleMap().get("MAPCOMPOSITE_IDENTIFYLABELSTYLE");
                crossingLabel.setStyleInfo(labelStyle);
                crossingLabel.write(out);
                out.println("<br>");
                crossingTableView.write(out);
                out.println("<br>");
            }
            out.println(map.writeIdentify(request));
            out.println("</div>");
            out.println("</body>");
            out.println("</html>");
        } else if (type != null && (type.equalsIgnoreCase("ZoomIn") || type.equalsIgnoreCase("ZoomOut") || type.equalsIgnoreCase("FullExtents") || type.equalsIgnoreCase("RectangularSelect") || type.equalsIgnoreCase("Select") || type.equalsIgnoreCase("Pan"))) {
            String apName = request.getParameter("APNAME");
            HttpActionProvider ap = null;
            ap = (HttpActionProvider)session.getAttribute(apName);
            ap.executeCommand(request, response, (Object)out);
        }
    }

    public String writeIdentify(HttpServletRequest request) {
        int zoomX = Integer.parseInt(request.getParameter("endx"));
        int zoomY = Integer.parseInt(request.getParameter("endy"));
        String[] identifyPairs = this.identify(zoomX, zoomY);
        Map styleMap = this.getStyleMap();
        StyleInfo labelStyle = (StyleInfo)styleMap.get("MAPCOMPOSITE_IDENTIFYLABELSTYLE");
        StyleInfo textStyle = (StyleInfo)styleMap.get("MAPCOMPOSITE_IDENTIFYTEXTSTYLE");
        StyleInfo containerStyle = (StyleInfo)styleMap.get("MAPCOMPOSITE_IDENTIFYCONTAINERSTYLE");
        Label mapLabel = new Label(RB.getStringResource(INTERNAL_RB_KEY, "RegionDetail.txt", request.getLocale()));
        mapLabel.setStyleInfo(labelStyle);
        Label measureLabel = null;
        Label measure = null;
        TableView mapTableView = null;
        Object[] mapInfoHeaders = null;
        String measureString = null;
        String measureName = null;
        if (measureString != null) {
            measureLabel = new Label(RB.getStringResource(INTERNAL_RB_KEY, "measure.txt", request.getLocale()));
            measureLabel.setStyleInfo(labelStyle);
            measure = new Label(measureString.substring(measureString.lastIndexOf("[") + 1, measureString.lastIndexOf("]")));
            measure.setStyleInfo(textStyle);
        } else {
            measureLabel = new Label(" ");
        }
        if (identifyPairs != null) {
            int numPairs = identifyPairs.length;
            mapInfoHeaders = new Object[]{RB.getStringResource(INTERNAL_RB_KEY, "Field.txt", request.getLocale()), " ", RB.getStringResource(INTERNAL_RB_KEY, "Value.txt", request.getLocale())};
            Object[][] values = new Object[numPairs / 2][3];
            int index = 0;
            for (int i = 0; i < identifyPairs.length; i += 2) {
                if (identifyPairs[i] != null && measureName != null && identifyPairs[i].equalsIgnoreCase(measureName)) {
                    measureLabel.setText(measureName + ":");
                    measure.setText(identifyPairs[i + 1]);
                    continue;
                }
                values[index][0] = identifyPairs[i];
                values[index][1] = "";
                values[index][2] = identifyPairs[i + 1];
                ++index;
            }
            mapTableView = new TableView(values, mapInfoHeaders);
            DefaultTableRowRenderer oddRowRenderer = new DefaultTableRowRenderer();
            DefaultTableRowRenderer evenRowRenderer = new DefaultTableRowRenderer();
            oddRowRenderer.setStyleInfo(new StyleInfo("tableOddRow"));
            evenRowRenderer.setStyleInfo(new StyleInfo("tableEvenRow"));
            mapTableView.getStyleMap().put("TABLEVIEW_DATA_STYLE", new StyleInfo("ESRIMapIdentifyTableData"));
            mapTableView.setAllActionsVisible(false);
            mapTableView.getStyleMap().put("TABLEVIEW_STYLE", new StyleInfo("ESRIMapIdentifyTableView"));
            mapTableView.setRowRenderer(1, -1, 2, (TableRowRenderer)oddRowRenderer);
            mapTableView.setRowRenderer(2, -1, 2, (TableRowRenderer)evenRowRenderer);
            mapTableView.setRowHeaderVisible(false);
            mapTableView.setColumnHeaderVisible(false);
        }
        StringBuffer out = new StringBuffer();
        if (measureLabel != null) {
            out.append("<table cellpadding=\"0\" cellspacing=\"0\" ><tr><td>");
            out.append(measureLabel.toString());
            out.append("</td>");
            out.append("<td><span style='width:5px;'></span></td>");
            out.append("<td>");
            if (measure != null) {
                out.append(measure.toString());
            }
            out.append("</td></tr></table>\n");
        }
        if (mapTableView != null && identifyPairs != null && identifyPairs.length > 0) {
            out.append(mapLabel.toString());
            out.append("<br>");
            out.append("<span class=\"").append(containerStyle.getClassid()).append("\">");
            mapTableView.setFormEnabled(false);
            out.append(mapTableView.toString());
            out.append("</span>");
        }
        out.append("<br><br>");
        return out.toString();
    }

    public void setFormAction(String action) {
        this.formAction = action;
    }

    public String getFormAction() {
        if (this.formAction != null) {
            return this.formAction;
        }
        HttpActionProvider ap = this.getActionProvider();
        if (ap != null && ap.getControllerURL() != null) {
            return ap.getControllerURL();
        }
        if (this.getRequest() != null) {
            return this.getRequest().getRequestURI();
        }
        return null;
    }

    public void contentsChanged(ContentsChangedEvent event) {
    }

    @Override
    public void setDataModel(ESRIMapDataModel model) {
        super.setDataModel(model);
        this.model = (ESRIMapTableDataModel)model;
        this.setAutoZoom(true);
        this.redrawMap = true;
    }

    private void recalculateGeoString() {
    }

    public boolean isMapEnabled() {
        return true;
    }

    public String getGeoString() {
        return this.geoString;
    }

    public void setGeoString(String geoString) {
        this.geoString = geoString;
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
    }

    private TableModel getTableDataModel() {
        return ((ESRIMapTableDataModel)this.model).getModel();
    }

    private String getLegendFormat() {
        return ((ESRIMapTableDataModel)this.model).getChoroVariable().getFormat();
    }

    private String getLegendTitle() {
        return ((ESRIMapTableDataModel)this.model).getChoroVariable().getLabel();
    }

    private CategorizationModel resolveCategorizationModel() {
        CategorizationModel cm = null;
        Variable v = ((ESRIMapTableDataModel)this.model).getChoroVariable();
        if (v != null) {
            cm = v.getCategorizationModel();
        }
        if (cm == null) {
            cm = CategorizationModel.newCategorizationModel((int)12001, (int)5);
        }
        return cm;
    }

    static {
        JavaScriptIncludeHandler.addAlias(ESRIMapChart.class, (String)"MAP");
    }
}

