/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.customizer.html;

import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.esrimap.ESRIMapOLAPDataModel;
import com.sas.graphics.components.esrimap.ESRIMapTableDataModel;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.crossing.html.MapCrossingSelector;
import com.sas.servlet.tbeans.dataselectors.customizer.html.MapPropertySelector;
import com.sas.servlet.tbeans.dataselectors.customizer.html.MapPropertySelectorKeysInterface;
import com.sas.servlet.tbeans.dataselectors.customizer.html.MapPropertySelectorStyleKeysInterface;
import com.sas.servlet.tbeans.dataselectors.customizer.html.RB;
import com.sas.servlet.tbeans.dataselectors.html.SelectorPanel;
import com.sas.servlet.tbeans.dualselector.html.TreeListSelector;
import com.sas.servlet.tbeans.form.html.CheckBox;
import com.sas.servlet.tbeans.form.html.CheckBoxList;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.graphics.BaseESRIMapChart;
import com.sas.servlet.tbeans.graphics.html.ESRIMapChart;
import com.sas.servlet.tbeans.html.ColorPicker;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.TabButton;
import com.sas.servlet.tbeans.html.TabMenu;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapChart;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.text.Message;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;

public class MapPropertySelectorPanel
extends SelectorPanel
implements MapPropertySelectorKeysInterface,
MapPropertySelectorStyleKeysInterface {
    protected String RB_KEY = "MapPropertySelectorPanel.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "MapPropertySelectorPanel.html";
    private BaseESRIMapChart mapComponent;
    protected static final HashMap defaultStyleMap;
    protected static final ImmutableStyleInfo SelectorTextStyle;
    protected static final ImmutableStyleInfo SelectorContainerStyle;
    protected TabMenu tabMenu;
    protected TabButton mapTab;
    protected TabButton layerTab;
    protected TabButton dataCrossingTab;
    protected Label titleTextLabel;
    protected TextEntry titleText;
    protected ChoiceBox sizeComboBox;
    protected Label sizeLabel;
    protected Label widthLabel;
    protected TextEntry widthTextEntry;
    protected Label wpixelsLabel;
    protected Label heightLabel;
    protected TextEntry heightTextEntry;
    protected Label hpixelsLabel;
    protected boolean tabMenuAdded = false;
    protected Label colorRegionsLabel;
    protected ChoiceBox colorRegionsCombo;
    protected Label numberOfColorsLabel;
    protected ChoiceBox numberOfColors;
    protected Label selectedRegionLabel;
    protected ColorPicker selectedRegionColor;
    protected CheckBoxList layersList;
    protected Label layersLabel;
    protected Label layersNoteLabel;
    protected MapCrossingSelector crossingSelector;
    protected CheckBox displayCrossingCheckBox;
    protected Form form;

    protected static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("MAPPROPERTY_LABEL_STYLE", SelectorTextStyle);
            defaultStyleMap.put("MAPPROPERTY_CONTAINER_STYLE", SelectorContainerStyle);
        }
    }

    public MapPropertySelectorPanel() {
        this(Util.getName((String)(MapPropertySelector.DEFAULT_ID + "_panel")));
    }

    public MapPropertySelectorPanel(String name) {
        this.setId(name);
        this.setTemplateFileName(DEFAULT_TEMPLATE_FILE_NAME);
        this.addComponents();
        MapPropertySelectorPanel.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        super.setLocaleDependentProperties(this.getLocale());
        this._setLocaleDependentProperties(this.getLocale());
    }

    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    protected void _setLocaleDependentProperties(Locale locale) {
        this.mapTab.setLabel(RB.getStringResource(this.RB_KEY, "map.txt", locale));
        this.layerTab.setLabel(RB.getStringResource(this.RB_KEY, "layer.txt", locale));
        this.dataCrossingTab.setLabel(RB.getStringResource(this.RB_KEY, "crossingTab.txt", locale));
        this.titleTextLabel.setText(RB.getStringResource(this.RB_KEY, "text.txt", locale));
        this.sizeLabel.setText(RB.getStringResource(this.RB_KEY, "size.txt", locale));
        this.widthLabel.setText(RB.getStringResource(this.RB_KEY, "width.txt", locale));
        this.wpixelsLabel.setText(RB.getStringResource(this.RB_KEY, "pixels.txt", locale));
        this.heightLabel.setText(RB.getStringResource(this.RB_KEY, "height.txt", locale));
        this.hpixelsLabel.setText(RB.getStringResource(this.RB_KEY, "pixels.txt", locale));
        this.colorRegionsLabel.setText(RB.getStringResource(this.RB_KEY, "colorRegion.txt", locale));
        this.numberOfColorsLabel.setText(RB.getStringResource(this.RB_KEY, "numberOfColors.txt", locale));
        this.selectedRegionLabel.setText(RB.getStringResource(this.RB_KEY, "selectedRegion.txt", locale));
        this.layersLabel.setText(RB.getStringResource(this.RB_KEY, "layersLabel.txt", locale));
        this.layersNoteLabel.setText(RB.getStringResource(this.RB_KEY, "layersNoteLabel.txt", locale));
        this.displayCrossingCheckBox.setText(RB.getStringResource(this.RB_KEY, "showCrossing.txt", locale));
    }

    protected void addComponents() {
        if (this.getComponents().isEmpty()) {
            this.createTabComponents();
            this.createTitleComponents();
            this.createSizeComponents();
            this.createColorsComponents();
            this.createLayersComponent();
            this.createLayersLabels();
            this.createCrossingSelector();
        }
    }

    protected void createCrossingSelector() {
        this.crossingSelector = new MapCrossingSelector();
        this.crossingSelector.getFormObject().setVisible(false);
        this.crossingSelector.setId(this.getId() + "CrossingSelector");
        this.setComponent("MAPPROPERTY_CROSSING_SELECTOR", (TransformationInterface)this.crossingSelector);
        this.displayCrossingCheckBox = new CheckBox();
        this.displayCrossingCheckBox.setStyleInfo((StyleInfo)SelectorTextStyle);
        StringBuffer name = new StringBuffer(this.getId()).append("_").append("displayCrossingCheckBox");
        this.displayCrossingCheckBox.setId(name.toString());
        this.displayCrossingCheckBox.setSubmitUncheckedValue(true);
        this.setComponent("MAPPROPERTY_DISPLAY_CROSSING_CHECKBOX", (TransformationInterface)this.displayCrossingCheckBox);
    }

    protected void createTabComponents() {
        StringBuffer name = null;
        this.tabMenu = new TabMenu();
        name = new StringBuffer(this.getId()).append("_").append("TabMenu");
        this.tabMenu.setId(name.toString());
        this.mapTab = new TabButton();
        name = new StringBuffer(this.getId()).append("_").append("MapTab");
        this.mapTab.setId(name.toString());
        this.mapTab.setOnClick("sas_mapPropertySelector_showMap();");
        this.tabMenu.add(this.mapTab);
        this.layerTab = new TabButton();
        name = new StringBuffer(this.getId()).append("_").append("LayerTab");
        this.layerTab.setId(name.toString());
        this.layerTab.setOnClick("sas_mapPropertySelector_showLayer();");
        this.tabMenu.add(this.layerTab);
        this.dataCrossingTab = new TabButton();
        name = new StringBuffer(this.getId()).append("_").append("DataCrossingTab");
        this.dataCrossingTab.setId(name.toString());
        this.dataCrossingTab.setOnClick("sas_mapPropertySelector_showCrossing();");
        this.tabMenu.setActiveTab(this.mapTab);
        this.setComponent("EHS_TAB_MENU", (TransformationInterface)this.tabMenu);
    }

    protected void createLayersLabels() {
        StringBuffer name = null;
        this.layersLabel = new Label();
        this.layersLabel.setStyleInfo((StyleInfo)SelectorTextStyle);
        name = new StringBuffer(this.getId()).append("_").append("LayersLabel");
        this.layersLabel.setId(name.toString());
        this.setComponent("MAPPROPERTY_LAYERS_LABEL", (TransformationInterface)this.layersLabel);
        this.layersNoteLabel = new Label();
        this.layersNoteLabel.setStyleInfo((StyleInfo)SelectorTextStyle);
        name = new StringBuffer(this.getId()).append("_").append("LayersNoteLabel");
        this.layersNoteLabel.setId(name.toString());
        this.setComponent("MAPPROPERTY_LAYERS_NOTE_LABEL", (TransformationInterface)this.layersNoteLabel);
    }

    protected void createTitleComponents() {
        this.titleTextLabel = new Label();
        this.titleTextLabel.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.setComponent("MAPPROPERTY_TITLE_TEXT_LABEL", (TransformationInterface)this.titleTextLabel);
        this.titleText = new TextEntry();
        this.titleText.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.setComponent("MAPPROPERTY_TITLE_TEXT", (TransformationInterface)this.titleText);
    }

    protected void createSizeComponents() {
        this.sizeLabel = new Label();
        this.sizeLabel.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.setComponent("MAPPROPERTY_SIZE_LABEL", (TransformationInterface)this.sizeLabel);
        this.sizeComboBox = new ChoiceBox();
        this.setComponent("MAPPROPERTY_SIZE_COMBOBOX", (TransformationInterface)this.sizeComboBox);
        this.widthLabel = new Label();
        this.widthLabel.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.setComponent("MAPPROPERTY_WIDTH_LABEL", (TransformationInterface)this.widthLabel);
        this.widthTextEntry = new TextEntry();
        this.widthTextEntry.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.widthTextEntry.setSize(3);
        this.widthTextEntry.setEnabled(false);
        this.setComponent("MAPPROPERTY_WIDTH_TEXT", (TransformationInterface)this.widthTextEntry);
        this.wpixelsLabel = new Label();
        this.wpixelsLabel.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.setComponent("MAPPROPERTY_WIDTH_PIXELS", (TransformationInterface)this.wpixelsLabel);
        this.heightLabel = new Label();
        this.heightLabel.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.setComponent("MAPPROPERTY_HEIGHT_LABEL", (TransformationInterface)this.heightLabel);
        this.heightTextEntry = new TextEntry();
        this.heightTextEntry.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.heightTextEntry.setEnabled(false);
        this.heightTextEntry.setSize(3);
        this.setComponent("MAPPROPERTY_HEIGHT_TEXT", (TransformationInterface)this.heightTextEntry);
        this.hpixelsLabel = new Label();
        this.hpixelsLabel.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.setComponent("MAPPROPERTY_HEIGHT_PIXELS", (TransformationInterface)this.hpixelsLabel);
    }

    protected void createColorsComponents() {
        this.colorRegionsLabel = new Label();
        this.colorRegionsLabel.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.setComponent("MAPPROPERTY_COLOR_REGIONS_LABEL", (TransformationInterface)this.colorRegionsLabel);
        this.colorRegionsCombo = new ChoiceBox();
        this.setComponent("MAPPROPERTY_COLOR_REGIONS_COMBOBOX", (TransformationInterface)this.colorRegionsCombo);
        this.numberOfColorsLabel = new Label();
        this.numberOfColorsLabel.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.setComponent("MAPPROPERTY_NUMBER_OF_COLORS_LABEL", (TransformationInterface)this.numberOfColorsLabel);
        this.numberOfColors = new ChoiceBox();
        this.setComponent("MAPPROPERTY_NUMBER_OF_COLORS_COMBOBOX", (TransformationInterface)this.numberOfColors);
        this.selectedRegionLabel = new Label();
        this.selectedRegionLabel.setStyleInfo((StyleInfo)SelectorTextStyle);
        this.setComponent("MAPPROPERTY_SELECTED_REGION_COLORS_LABEL", (TransformationInterface)this.selectedRegionLabel);
        this.selectedRegionColor = new ColorPicker();
        this.selectedRegionColor.setId(this.getId() + "_selectedRegion");
        this.setComponent("MAPPROPERTY_SELECTED_REGION_COLORS", (TransformationInterface)this.selectedRegionColor);
    }

    protected void createLayersComponent() {
        this.layersList = new CheckBoxList();
        this.layersList.setId(this.getId() + "layers");
        this.layersList.setSize(10);
        this.setComponent("MAPPROPERTY_LAYERS_LIST", (TransformationInterface)this.layersList);
    }

    protected void updateLayersListModel(CheckBoxList layersList) {
        BaseESRIMapChart mc = this.getMapComponent();
        DefaultListModel<JavaScriptNode> layerModel = new DefaultListModel<JavaScriptNode>();
        DefaultListModel<JavaScriptNode> layerSelectedModel = new DefaultListModel<JavaScriptNode>();
        HashMap layersMap = mc.getLayerVisibilities();
        if (layersMap == null) {
            return;
        }
        Set keys = layersMap.keySet();
        for (Object key : keys) {
            Object value = layersMap.get(key);
            JavaScriptNode node = new JavaScriptNode();
            node.setText(key.toString());
            node.setValue(key.toString());
            if (value.equals("UseMapServiceRules") || value.equals("AlwaysOn")) {
                layerSelectedModel.addElement(node);
            }
            layerModel.addElement(node);
        }
        layersList.setModel(layerModel);
        try {
            layersList.setSelectedItems(layerSelectedModel);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected DefaultComboBoxModel getLocalizedSizeModel() {
        DefaultComboBoxModel<Item> sizeModel = new DefaultComboBoxModel<Item>();
        Item item = new Item();
        item.setText(RB.getStringResource(this.RB_KEY, "small.txt", this.getLocale()));
        item.setValue("SMALL");
        sizeModel.addElement(item);
        item = new JavaScriptNode();
        item.setText(RB.getStringResource(this.RB_KEY, "medium.txt", this.getLocale()));
        item.setValue("MEDIUM");
        sizeModel.addElement(item);
        item = new Item();
        item.setText(RB.getStringResource(this.RB_KEY, "large.txt", this.getLocale()));
        item.setValue("LARGE");
        sizeModel.addElement(item);
        item = new Item();
        item.setText(RB.getStringResource(this.RB_KEY, "custom.txt", this.getLocale()));
        item.setValue("CUSTOM");
        sizeModel.addElement(item);
        return sizeModel;
    }

    protected DefaultComboBoxModel getLocalizedColorRegions() {
        DefaultComboBoxModel<Item> colorRegionModel = new DefaultComboBoxModel<Item>();
        Item item = new Item();
        item.setText(RB.getStringResource(this.RB_KEY, "colorRegionIntervals.txt", this.getLocale()));
        item.setValue(Integer.toString(12001));
        colorRegionModel.addElement(item);
        item = new Item();
        item.setText(RB.getStringResource(this.RB_KEY, "naturalBreaks.txt", this.getLocale()));
        item.setValue(Integer.toString(12002));
        colorRegionModel.addElement(item);
        item = new Item();
        item.setText(RB.getStringResource(this.RB_KEY, "quantiles.txt", this.getLocale()));
        item.setValue(Integer.toString(12000));
        colorRegionModel.addElement(item);
        item = new Item();
        item.setText(RB.getStringResource(this.RB_KEY, "standardDeviations.txt", this.getLocale()));
        item.setValue(Integer.toString(12003));
        colorRegionModel.addElement(item);
        return colorRegionModel;
    }

    protected DefaultComboBoxModel getLocalizedNumberOfColors() {
        DefaultComboBoxModel<String> numberOfColors = new DefaultComboBoxModel<String>();
        numberOfColors.addElement("1");
        numberOfColors.addElement("2");
        numberOfColors.addElement("3");
        numberOfColors.addElement("4");
        numberOfColors.addElement("5");
        numberOfColors.addElement("6");
        numberOfColors.addElement("7");
        numberOfColors.addElement("8");
        numberOfColors.addElement("9");
        numberOfColors.addElement("10");
        numberOfColors.addElement("11");
        numberOfColors.addElement("12");
        return numberOfColors;
    }

    protected void setActionComponentIds() {
        String prefix = this.getActionProvider().getParameterPrefix();
        this.sizeComboBox.setId(prefix + "size");
        this.widthTextEntry.setId(prefix + "width");
        this.heightTextEntry.setId(prefix + "height");
        this.colorRegionsCombo.setId(prefix + "colorRegions");
        this.numberOfColors.setId(prefix + "numberOfColors");
        this.displayCrossingCheckBox.setId(prefix + "showCrossingCheckbox");
    }

    private String valueOf(int num) {
        String hex = Integer.toHexString(num);
        hex = "00" + hex;
        int len = hex.length();
        hex = hex.substring(len - 2, len);
        return hex;
    }

    protected void setDefaultValues() {
        BaseESRIMapChart mc = this.getMapComponent();
        int height = mc.getHeight() == -1 ? 300 : mc.getHeight();
        int width = mc.getWidth() == -1 ? 800 : mc.getWidth();
        CategorizationModel cm = null;
        if (mc instanceof OLAPESRIMapChart) {
            cm = ((ESRIMapOLAPDataModel)mc.getDataModel()).getCategorizationModel();
        } else if (mc instanceof ESRIMapChart) {
            cm = ((ESRIMapTableDataModel)mc.getDataModel()).getChoroVariable().getCategorizationModel();
        }
        int interval = cm.getParameter();
        int algorithm = cm.getCategorizationType();
        boolean showCrossing = false;
        if (mc instanceof OLAPESRIMapChart) {
            showCrossing = ((OLAPESRIMapChart)mc).isShowCrossing();
        }
        try {
            this.colorRegionsCombo.setSelectedItem(Integer.toString(algorithm));
            this.numberOfColors.setSelectedItem(Integer.toString(interval));
            if (algorithm == 12003) {
                this.numberOfColors.setEnabled(false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.displayCrossingCheckBox.setSelected(showCrossing);
        this.widthTextEntry.setText(Integer.toString(width));
        this.heightTextEntry.setText(Integer.toString(height));
        try {
            if (height == 300 && width == 800) {
                this.sizeComboBox.setSelectedItem("MEDIUM");
            } else if (height == 250 && width == 400) {
                this.sizeComboBox.setSelectedItem("SMALL");
            } else if (height == 600 && width == 800) {
                this.sizeComboBox.setSelectedItem("LARGE");
            } else {
                this.sizeComboBox.setSelectedItem("CUSTOM");
                this.widthTextEntry.setEnabled(true);
                this.heightTextEntry.setEnabled(true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.colorRegionsCombo.setOnChange(this.getId() + ".regionColorChanged(this)");
        Color selectedColor = mc.getGraphModel().getSelectionColor();
        StringBuffer color = new StringBuffer();
        color = color.append("#").append(this.valueOf(selectedColor.getRed())).append(this.valueOf(selectedColor.getGreen())).append(this.valueOf(selectedColor.getBlue()));
        this.selectedRegionColor.setDefaultColor(color.toString());
        this.sizeComboBox.setOnChange(this.getId() + ".sizeChanged(this)");
    }

    public void write(PrintWriter out) {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        try {
            this.writeJSIncludes(out);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        this.setActionComponentIds();
        this.crossingSelector.setActionProvider(this.getActionProvider());
        HashMap dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap();
            this.setTemplateDictionary(dictionary);
        }
        this.getTemplateDictionary().put("MP_TITLE_LABEL", RB.getStringResource(this.RB_KEY, "title.txt", this.getLocale()));
        this.getTemplateDictionary().put("MP_SIZE_LABEL", RB.getStringResource(this.RB_KEY, "size.txt", this.getLocale()));
        this.getTemplateDictionary().put("MP_COLOR_LABEL", RB.getStringResource(this.RB_KEY, "colors.txt", this.getLocale()));
        this.sizeComboBox = (ChoiceBox)this.getComponent("MAPPROPERTY_SIZE_COMBOBOX");
        this.sizeComboBox.setModel((ComboBoxModel)this.getLocalizedSizeModel());
        this.colorRegionsCombo = (ChoiceBox)this.getComponent("MAPPROPERTY_COLOR_REGIONS_COMBOBOX");
        this.colorRegionsCombo.setModel((ComboBoxModel)this.getLocalizedColorRegions());
        this.numberOfColors = (ChoiceBox)this.getComponent("MAPPROPERTY_NUMBER_OF_COLORS_COMBOBOX");
        this.numberOfColors.setModel((ComboBoxModel)this.getLocalizedNumberOfColors());
        this.layersList = (CheckBoxList)this.getComponent("MAPPROPERTY_LAYERS_LIST");
        this.updateLayersListModel(this.layersList);
        this.layersList.setMultipleSelections(true);
        this.setDefaultValues();
        this.form = this.getFormObject();
        this.form.setName(this.getId() + "_Form");
        this.form.setId(this.getId() + "_Form");
        this.form.setRequest(this.getRequest());
        this.form.setResponse(this.getResponse());
        this.form.setLocale(this.getLocale());
        this.form.setValidationEnabled(true);
        TransformationInterface validationComponent = this.getComponent("MAPPROPERTY_WIDTH_TEXT");
        if (!this.form.getComponents().contains(validationComponent)) {
            this.form.addComponent(validationComponent);
        }
        validationComponent = this.getComponent("MAPPROPERTY_HEIGHT_TEXT");
        if (!this.form.getComponents().contains(validationComponent)) {
            this.form.addComponent(validationComponent);
        }
        try {
            this.writeSelectorPanelHeader(out);
            String apName = "";
            String commandId = "";
            String apPrefix = "";
            if (this.getActionProvider() != null) {
                apName = this.getActionProvider().getName();
                commandId = this.getCommandId();
                apPrefix = this.getActionProvider().getParameterPrefix();
            }
            if (commandId == null) {
                commandId = this.getRequest().getParameter("CMDID");
            }
            out.println(new StringBuffer().append("<input type=hidden name=\"APNAME\" value=\"").append(apName).append("\">").toString());
            out.println(new StringBuffer("<input type=hidden name=\"CMDID\" value=\"").append(commandId).append("\">").toString());
            out.println(new StringBuffer().append("<input type=hidden name=\"").append(apPrefix).append("mode\" value=\"COMMIT\">").toString());
            out.println(new StringBuffer().append("<input type=hidden name=\"").append(apPrefix).append("selectedRegionColor\" value=\"\">").toString());
            out.println(new StringBuffer().append("<input type=hidden name=\"").append(apPrefix).append("showCrossing\" value=\"\">").toString());
            out.println(new StringBuffer().append("<input type=hidden name=\"").append(apPrefix).append("referringURI\" value=\"" + this.getActionProvider().getControllerURL() + "\">").toString());
            this.writeTemplate((BaseTransformation)this, null, out);
            this.writeSelectorPanelFooter(out);
            this.writeJavaScript(out);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        this.cleanUpResources();
    }

    protected void writeJavaScript(PrintWriter out) throws IOException {
        out.println("<script>");
        String panelId = this.getId();
        BaseESRIMapChart mc = this.getMapComponent();
        out.println(new StringBuffer("var ").append(panelId).append("= new sas_MapPropertySelectorPanel('" + this.getId() + "','" + this.getActionProvider().getParameterPrefix() + "','" + this.getFormObject().getName() + "');"));
        int height = mc.getHeight() == -1 ? 300 : mc.getHeight();
        int width = mc.getWidth() == -1 ? 800 : mc.getWidth();
        int maxHeight = (int)mc.getGraph().getMaximumSize().getHeight();
        int maxWidth = (int)mc.getGraph().getMaximumSize().getWidth();
        int minHeight = (int)mc.getGraph().getMinimumSize().getHeight();
        int minWidth = (int)mc.getGraph().getMinimumSize().getWidth();
        out.println(new StringBuffer(panelId).append(".defaultWidth = " + width + ";"));
        out.println(new StringBuffer(panelId).append(".defaultHeight = " + height + ";"));
        String message = Message.format((String)RB.getStringResource(this.RB_KEY, "widthRange.fmt.txt", this.getLocale()), (Object)new Integer(minWidth), (Object)new Integer(maxWidth));
        out.println(new StringBuffer(panelId).append(".widthErrorMessage = \"" + message + "\";"));
        message = Message.format((String)RB.getStringResource(this.RB_KEY, "heightRange.fmt.txt", this.getLocale()), (Object)new Integer(minHeight), (Object)new Integer(maxHeight));
        out.println(new StringBuffer(panelId).append(".heightErrorMessage = \"" + message + "\";"));
        TreeListSelector tls = (TreeListSelector)this.crossingSelector.getDataSelectorPanel().getComponent("MAPPROPERTIESDATA_TREE_LIST");
        out.println(new StringBuffer(panelId).append(".crossingList = " + tls.getId() + ";"));
        out.println(new StringBuffer(panelId).append(".maximumHeight = " + maxHeight + ";"));
        out.println(new StringBuffer(panelId).append(".maximumWidth = " + maxWidth + ";"));
        out.println(new StringBuffer(panelId).append(".minimumHeight = " + minHeight + ";"));
        out.println(new StringBuffer(panelId).append(".minimumWidth = " + minWidth + ";"));
        out.println("</script>");
    }

    protected void writeJSIncludes(PrintWriter out) throws IOException {
        JavaScriptIncludeHandler.writeIncludes((Writer)out, (Object)"MAPPROPERTYSELECTOR", (HttpServletRequest)this.getRequest());
    }

    public BaseESRIMapChart getMapComponent() {
        return this.mapComponent;
    }

    public void setMapComponent(BaseESRIMapChart mc) {
        this.mapComponent = mc;
        if (mc instanceof OLAPESRIMapChart) {
            if (!this.tabMenuAdded) {
                this.tabMenu.add(this.dataCrossingTab);
            }
            this.tabMenuAdded = true;
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(MapPropertySelectorPanel.class, (String)"MAPPROPERTYSELECTOR");
        defaultStyleMap = new HashMap();
        SelectorTextStyle = new ImmutableStyleInfo("selectorText");
        SelectorContainerStyle = new ImmutableStyleInfo("mapPropertyContainer");
    }
}

