/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.map;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.ImageFormatException;
import com.sas.visuals.image.encoder.GifEncoder;
import com.sas.visuals.image.encoder.ImageAdaptor;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

@SASScope
public class MapImageUtil {
    private static final int IMAGE_TYPE_PNG = 1;
    private static final int IMAGE_TYPE_GIF = 2;

    public static BufferedImage getImageFromByteStream(byte[] imageData, int w, int h) {
        Image image = Toolkit.getDefaultToolkit().createImage(imageData);
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = bi.createGraphics();
        g.drawImage(image, 0, 0, null);
        return bi;
    }

    public static byte[] getPngByteStream(BufferedImage bimage) throws IOException {
        return MapImageUtil.getByteStream(bimage, 1);
    }

    public static byte[] getGifByteStream(BufferedImage bimage) throws IOException {
        return MapImageUtil.getByteStream(bimage, 2);
    }

    private static byte[] getByteStream(BufferedImage bimage, int type) throws IOException {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        if (type == 1) {
            MapImageUtil.encodePng(byteArrayStream, bimage);
        } else {
            MapImageUtil.encodeGif(byteArrayStream, bimage);
        }
        int n = byteArrayStream.size();
        byte[] imageBytes = new byte[n];
        imageBytes = byteArrayStream.toByteArray();
        return imageBytes;
    }

    public static void encodePng(OutputStream outputStream, BufferedImage bimage) throws IOException {
        ImageIO.setUseCache(false);
        ImageIO.write((RenderedImage)bimage, "png", new BufferedOutputStream(outputStream));
    }

    public static void encodeGif(OutputStream outputStream, BufferedImage bimage) throws IOException {
        ImageAdaptor iAdp = new ImageAdaptor((Image)bimage);
        boolean rc = false;
        try {
            rc = iAdp.setup();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ImageFormatException imgE) {
            BufferedImage bi = new BufferedImage(bimage.getWidth(null), bimage.getHeight(null), 13);
            bi.createGraphics().drawImage((Image)bimage, 0, 0, null);
            iAdp = new ImageAdaptor((Image)bi);
            try {
                rc = iAdp.setup();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ImageFormatException imageFormatException) {
                // empty catch block
            }
        }
        if (rc) {
            GifEncoder gifWriter = new GifEncoder(iAdp, outputStream);
            try {
                gifWriter.encode();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

