/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.map;

import com.esri.arcgis.carto.ClassBreaksRenderer;
import com.esri.arcgis.carto.FeatureLayer;
import com.esri.arcgis.carto.GraphicElements;
import com.esri.arcgis.carto.GroupLayer;
import com.esri.arcgis.carto.IClassBreaksRendererProxy;
import com.esri.arcgis.carto.IFeatureLayerProxy;
import com.esri.arcgis.carto.IFeatureRenderer;
import com.esri.arcgis.carto.IFeatureRendererProxy;
import com.esri.arcgis.carto.IGeoFeatureLayer;
import com.esri.arcgis.carto.IGeoFeatureLayerProxy;
import com.esri.arcgis.carto.IGraphicElement;
import com.esri.arcgis.carto.IGraphicElements;
import com.esri.arcgis.carto.IGraphicElementsProxy;
import com.esri.arcgis.carto.IImageDescription;
import com.esri.arcgis.carto.IImageDescriptionProxy;
import com.esri.arcgis.carto.IImageDisplay;
import com.esri.arcgis.carto.IImageDisplayProxy;
import com.esri.arcgis.carto.IImageType;
import com.esri.arcgis.carto.IImageTypeProxy;
import com.esri.arcgis.carto.ILayer;
import com.esri.arcgis.carto.ILayerDescription;
import com.esri.arcgis.carto.ILayerDescriptions;
import com.esri.arcgis.carto.ILineElementProxy;
import com.esri.arcgis.carto.IMap;
import com.esri.arcgis.carto.IMapArea;
import com.esri.arcgis.carto.IMapAreaProxy;
import com.esri.arcgis.carto.IMapDescription;
import com.esri.arcgis.carto.IMapDescriptionProxy;
import com.esri.arcgis.carto.IMapExtentProxy;
import com.esri.arcgis.carto.IMapImage;
import com.esri.arcgis.carto.IMapLayerInfos;
import com.esri.arcgis.carto.IMapProxy;
import com.esri.arcgis.carto.IMapServer;
import com.esri.arcgis.carto.IMapServerIdentifyResult;
import com.esri.arcgis.carto.IMapServerIdentifyResults;
import com.esri.arcgis.carto.IMapServerObjects;
import com.esri.arcgis.carto.IMapServerObjectsProxy;
import com.esri.arcgis.carto.IMapServerProxy;
import com.esri.arcgis.carto.IMarkerElementProxy;
import com.esri.arcgis.carto.IPolygonElementProxy;
import com.esri.arcgis.carto.ISimpleRendererProxy;
import com.esri.arcgis.carto.ITextElementProxy;
import com.esri.arcgis.carto.IUniqueValueRendererProxy;
import com.esri.arcgis.carto.ImageDescription;
import com.esri.arcgis.carto.ImageDisplay;
import com.esri.arcgis.carto.ImageType;
import com.esri.arcgis.carto.LineElement;
import com.esri.arcgis.carto.MapDescription;
import com.esri.arcgis.carto.MapExtent;
import com.esri.arcgis.carto.MarkerElement;
import com.esri.arcgis.carto.PolygonElement;
import com.esri.arcgis.carto.SimpleRenderer;
import com.esri.arcgis.carto.TextElement;
import com.esri.arcgis.carto.UniqueValueRenderer;
import com.esri.arcgis.display.AlgorithmicColorRamp;
import com.esri.arcgis.display.ArrowMarkerSymbol;
import com.esri.arcgis.display.IAlgorithmicColorRampProxy;
import com.esri.arcgis.display.IArrowMarkerSymbolProxy;
import com.esri.arcgis.display.IColor;
import com.esri.arcgis.display.IColorRamp;
import com.esri.arcgis.display.IEnumColors;
import com.esri.arcgis.display.IFillSymbol;
import com.esri.arcgis.display.ILineSymbol;
import com.esri.arcgis.display.ILineSymbolProxy;
import com.esri.arcgis.display.IMarkerSymbol;
import com.esri.arcgis.display.IMarkerSymbolProxy;
import com.esri.arcgis.display.IMultiLayerFillSymbolProxy;
import com.esri.arcgis.display.IMultiPartColorRampProxy;
import com.esri.arcgis.display.IRgbColor;
import com.esri.arcgis.display.IRgbColorProxy;
import com.esri.arcgis.display.ISimpleFillSymbolProxy;
import com.esri.arcgis.display.ISimpleLineSymbolProxy;
import com.esri.arcgis.display.ISimpleMarkerSymbolProxy;
import com.esri.arcgis.display.ISymbol;
import com.esri.arcgis.display.ISymbolProxy;
import com.esri.arcgis.display.MultiLayerFillSymbol;
import com.esri.arcgis.display.MultiPartColorRamp;
import com.esri.arcgis.display.RgbColor;
import com.esri.arcgis.display.SimpleFillSymbol;
import com.esri.arcgis.display.SimpleLineSymbol;
import com.esri.arcgis.display.SimpleMarkerSymbol;
import com.esri.arcgis.geodatabase.EnumFeatureGeometry;
import com.esri.arcgis.geodatabase.IFIDSet;
import com.esri.arcgis.geodatabase.IFeature;
import com.esri.arcgis.geodatabase.IFeatureClass;
import com.esri.arcgis.geodatabase.IFeatureCursor;
import com.esri.arcgis.geodatabase.IFields;
import com.esri.arcgis.geodatabase.IQueryFilter;
import com.esri.arcgis.geodatabase.IQueryFilterProxy;
import com.esri.arcgis.geodatabase.ISelectionSet;
import com.esri.arcgis.geodatabase.ISpatialFilterProxy;
import com.esri.arcgis.geodatabase.QueryFilter;
import com.esri.arcgis.geodatabase.SpatialFilter;
import com.esri.arcgis.geometry.Envelope;
import com.esri.arcgis.geometry.GeometryEnvironment;
import com.esri.arcgis.geometry.IEnumGeometry;
import com.esri.arcgis.geometry.IEnvelope;
import com.esri.arcgis.geometry.IEnvelopeProxy;
import com.esri.arcgis.geometry.IGeometry;
import com.esri.arcgis.geometry.IPoint;
import com.esri.arcgis.geometry.IPointCollection;
import com.esri.arcgis.geometry.IPointProxy;
import com.esri.arcgis.geometry.IPolygonProxy;
import com.esri.arcgis.geometry.IPolylineProxy;
import com.esri.arcgis.geometry.IRingProxy;
import com.esri.arcgis.geometry.Point;
import com.esri.arcgis.geometry.Polygon;
import com.esri.arcgis.geometry.Polyline;
import com.esri.arcgis.geometry.Ring;
import com.esri.arcgis.server.IEnumServerObjectConfigurationInfo;
import com.esri.arcgis.server.IServerContext;
import com.esri.arcgis.server.IServerObjectConfigurationInfo;
import com.esri.arcgis.server.IServerObjectManager;
import com.esri.arcgis.server.ServerConnection;
import com.esri.arcgis.system.ILongArray;
import com.esri.arcgis.system.ILongArrayProxy;
import com.esri.arcgis.system.IPropertySet;
import com.esri.arcgis.system.IXMLSerializeProxy;
import com.esri.arcgis.system.LongArray;
import com.esri.arcgis.system.ServerInitializer;
import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.SegmentedRangeModel;
import com.sas.graphics.map.AnnotationArrow;
import com.sas.graphics.map.AnnotationMarker;
import com.sas.graphics.map.AnnotationPolygon;
import com.sas.graphics.map.AnnotationPolyline;
import com.sas.graphics.map.AnnotationText;
import com.sas.graphics.map.ESRIConnection;
import com.sas.graphics.map.ESRIException;
import com.sas.graphics.map.MapAnnotation;
import com.sas.graphics.map.MapImageUtil;
import com.sas.graphics.map.RB;
import com.sas.graphics.util.ContinuousTickSpacer;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.categorization.Categorizor;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.gl.JLegend;
import com.sas.graphics.util.gtk.gl.Legend;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import com.sas.util.SasPasswordString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
public class ESRIMap {
    @SASScope
    public static final String RB_KEY = "ESRIMap.";
    @SASScope
    private ESRIConnection connection = null;
    @SASScope
    private IServerContext m_context = null;
    @SASScope
    private IMapServer m_mapServer = null;
    @SASScope
    private IMapServerObjects m_mapServerObj = null;
    @SASScope
    private IMapDescription m_mapDesc = null;
    @SASScope
    private IImageDescription m_imageDesc = null;
    @SASScope
    private IImageType m_imageType = null;
    @SASScope
    private IImageDisplay m_imageDisplay = null;
    @SASScope
    private String m_strMapDesc = null;
    @SASScope
    private String m_strImageDesc = null;
    @SASScope
    private IMap m_map = null;
    @SASScope
    private IMapImage mapImage = null;
    @SASScope
    private double m_markerSymbolSize = 12.0;
    @SASScope
    private double m_polygonSymbolOutlineWidth = 0.4;
    @SASScope
    private int m_polygonSymbolStyle = 0;
    @SASScope
    private int m_lineSymbolStyle = 0;
    @SASScope
    private int m_markerSymbolStyle = 0;
    @SASScope
    private IRgbColor startColor;
    @SASScope
    private IRgbColor midColor = null;
    @SASScope
    private IRgbColor endColor;
    @SASScope
    private IRgbColor overFlowColor;
    @SASScope
    private IRgbColor underFlowColor;
    @SASScope
    private IRgbColor outlineColor;
    @SASScope
    private IRgbColor defaultMapColor;
    @SASScope
    private IRgbColor missingColor;
    @SASScope
    private IRgbColor defaultOutlineColor;
    @SASScope
    private IRgbColor selectionColor;
    @SASScope
    private Locale locale;
    @SASScope
    private String legendTitle = "";
    @SASScope
    private boolean showLegendTitle = false;
    @SASScope
    private String legendFormat = "Best12";
    @SASScope
    private boolean showMissing = false;
    @SASScope
    private boolean useTwoColorRamp = true;
    @SASScope
    private boolean showAlternateLegend = false;
    @SASScope
    private boolean useBoundsColors = true;
    private boolean debug = false;
    @SASScope
    private Logger logger = LogManager.getLogger(ESRIMap.class);
    @SASScope
    private Dimension size = new Dimension(600, 300);
    @SASScope
    private Dimension legendSize = new Dimension(200, 300);
    private String[] breakPointLabels = null;
    @SASScope
    private Color[] breakPointColors = null;
    @SASScope
    private Font legendLabelFont = FontManager.getDefaultFont();
    @SASScope
    private Color legendLabelColor = Color.BLACK;
    @SASScope
    private Color legendBackgroundColor = Color.WHITE;
    @SASScope
    private Color legendBorderColor = Color.BLACK;
    @SASScope
    private HashMap savedRenderers = new HashMap();

    public ESRIMap() {
        Font f;
        new ServerInitializer().initializeServer("'", "", "");
        this.legendLabelFont = f = FontManager.getFont((String)this.legendLabelFont.getName(), (int)1, (int)this.legendLabelFont.getSize());
    }

    public ESRIMap(ESRIConnection connection) {
        Font f;
        char[] decodedPassword;
        if (this.logger.isDebugEnabled()) {
            this.debug = true;
            this.logger.debug("Debugging turned on for ESRIMap");
        }
        try {
            decodedPassword = SasPasswordString.decode((String)connection.getUserPwd()).toCharArray();
        }
        catch (Exception e) {
            System.out.println(RB.getStringResource(RB_KEY, "PasswordCouldNotBeDecoded.txt", this.locale));
            return;
        }
        this.connection = connection;
        new ServerInitializer().initializeServer(connection.getDomain(), connection.getUserName(), String.valueOf(decodedPassword));
        this.legendLabelFont = f = FontManager.getFont((String)this.legendLabelFont.getName(), (int)1, (int)this.legendLabelFont.getSize());
        Arrays.fill(decodedPassword, '\u0000');
    }

    public void connect() throws ESRIException {
        ServerConnection connection = null;
        try {
            connection = new ServerConnection();
            connection.connect(this.connection.getGisServer());
        }
        catch (UnknownHostException e) {
            String s = Message.format((String)RB.getStringResource(RB_KEY, "ServerConnectionError.fmt.txt", this.locale), (Object)this.connection.getGisServer());
            throw new ESRIException(s, e);
        }
        catch (IOException e) {
            String s = Message.format((String)RB.getStringResource(RB_KEY, "ServerConnectionError.fmt.txt", this.locale), (Object)this.connection.getGisServer());
            throw new ESRIException(s, e);
        }
        try {
            IServerObjectManager mgr = connection.getServerObjectManager();
            this.m_context = mgr.createServerContext(this.connection.getMapServiceName(), "MapServer");
            this.m_mapServer = new IMapServerProxy((Object)this.m_context.getServerObject());
            this.m_mapServerObj = new IMapServerObjectsProxy((Object)this.m_context.getServerObject());
            this.createColorDefaults();
            if (this.m_mapServer.getDefaultMapName() == null) {
                throw new ESRIException(RB.getStringResource(RB_KEY, "NoDefaultMapService.txt", this.locale), null);
            }
            this.m_map = new IMapProxy((Object)this.m_mapServerObj.getMap(this.m_mapServer.getDefaultMapName()));
        }
        catch (IOException e) {
            String s = Message.format((String)RB.getStringResource(RB_KEY, "ConnectionError.fmt.txt", this.locale), (Object)this.connection.getMapServiceName(), (Object)this.connection.getGisServer());
            throw new ESRIException(s, e);
        }
    }

    public void disconnect() throws ESRIException {
        this.resetRenderers();
        try {
            if (this.m_context != null) {
                this.m_context.removeAll();
                this.m_context.releaseContext();
            }
            this.m_mapDesc = null;
            this.m_imageDesc = null;
        }
        catch (IOException e) {
            String s = Message.format((String)RB.getStringResource(RB_KEY, "ConnectionError.fmt.txt", this.locale), (Object)this.connection.getMapServiceName(), (Object)this.connection.getGisServer());
            throw new ESRIException(s, e);
        }
    }

    public String getMapDescription() {
        return this.m_strMapDesc;
    }

    public String getImageDescription() {
        return this.m_strImageDesc;
    }

    public void getMap(String strMapDesc, String strImageDesc) throws ESRIException {
        try {
            this.m_mapDesc = new IMapDescriptionProxy(this.m_context.loadObject(strMapDesc));
            this.m_imageDesc = new IImageDescriptionProxy(this.m_context.loadObject(strImageDesc));
            this.m_imageType = new IImageTypeProxy(this.m_context.createObject(ImageType.getClsid()));
            this.m_imageDesc.getDisplay().setWidth(this.size.width);
            this.m_imageDesc.getDisplay().setHeight(this.size.height);
            this.m_imageDesc.setDisplay(this.m_imageDesc.getDisplay());
            this.saveRenderers();
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public void getMap() throws ESRIException {
        try {
            this.m_mapDesc = new IMapDescriptionProxy(this.m_context.createObject(MapDescription.getClsid()));
            if (this.m_mapServer.getDefaultMapName() == null) {
                throw new ESRIException(RB.getStringResource(RB_KEY, "NoDefaultMapService.txt", this.locale), null);
            }
            this.m_mapDesc = this.m_mapServer.getServerInfo(this.m_mapServer.getDefaultMapName()).getDefaultMapDescription();
            this.m_imageType = new IImageTypeProxy(this.m_context.createObject(ImageType.getClsid()));
            this.m_imageType.setFormat(4);
            this.m_imageType.setReturnType(1);
            this.m_imageDisplay = new IImageDisplayProxy(this.m_context.createObject(ImageDisplay.getClsid()));
            this.m_imageDisplay.setDeviceResolution(96.0);
            this.m_imageDisplay.setWidth(this.size.width);
            this.m_imageDisplay.setHeight(this.size.height);
            this.m_imageDesc = new IImageDescriptionProxy(this.m_context.createObject(ImageDescription.getClsid()));
            this.m_imageDesc.setDisplay(this.m_imageDisplay);
            this.m_imageDesc.setType(this.m_imageType);
            this.saveRenderers();
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    @SASScope
    private void saveRenderers() {
        try {
            ArrayList layerList = this.getAllLayers();
            for (int i = 0; i < layerList.size(); ++i) {
                try {
                    IGeoFeatureLayerProxy glayer = new IGeoFeatureLayerProxy((Object)((ILayer)layerList.get(i)));
                    IFeatureRenderer renderer = glayer.getRenderer();
                    this.savedRenderers.put(glayer, renderer);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (ESRIException eSRIException) {
            // empty catch block
        }
    }

    @SASScope
    private void resetRenderers() {
        Set set = this.savedRenderers.keySet();
        Object[] layers = set.toArray();
        for (int i = 0; i < layers.length; ++i) {
            try {
                ((IGeoFeatureLayer)layers[i]).setRendererByRef((IFeatureRenderer)this.savedRenderers.get(layers[i]));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getImageURL() throws ESRIException {
        try {
            if (this.m_imageDesc == null) {
                throw new ESRIException(RB.getStringResource(RB_KEY, "ImageDescNull.txt", this.locale), null);
            }
            this.m_imageDesc.getType().setReturnType(0);
            this.mapImage = this.m_mapServer.exportMapImage(this.m_mapDesc, this.m_imageDesc);
            this.m_strMapDesc = this.m_context.saveObject((Object)new IXMLSerializeProxy((Object)this.m_mapDesc));
            this.m_strImageDesc = this.m_context.saveObject((Object)new IXMLSerializeProxy((Object)this.m_imageDesc));
            return this.mapImage.getURL();
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public byte[] getImageMimeData() throws ESRIException {
        try {
            if (this.m_imageDesc == null) {
                throw new ESRIException(RB.getStringResource(RB_KEY, "ImageDescNull.txt", this.locale), null);
            }
            this.m_imageDesc.getType().setReturnType(1);
            IImageDisplay imageDisplay = this.m_imageDesc.getDisplay();
            imageDisplay.setWidth(this.size.width);
            imageDisplay.setHeight(this.size.height);
            this.m_imageDesc.setDisplay(imageDisplay);
            this.mapImage = this.m_mapServer.exportMapImage(this.m_mapDesc, this.m_imageDesc);
            this.m_strMapDesc = this.m_context.saveObject((Object)new IXMLSerializeProxy((Object)this.m_mapDesc));
            this.m_strImageDesc = this.m_context.saveObject((Object)new IXMLSerializeProxy((Object)this.m_imageDesc));
            byte[] imageMimeData = this.mapImage.getMimeData();
            if (imageMimeData == null) {
                System.out.println(RB.getStringResource(RB_KEY, "ImageMimeDataNull.txt", this.locale));
                return null;
            }
            return imageMimeData;
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), null);
        }
    }

    public byte[] getLegendMimeData(boolean noDataToDisplay) {
        BufferedImage bimage = new BufferedImage(this.legendSize.width, this.legendSize.height, 1);
        if (this.showAlternateLegend || noDataToDisplay) {
            Graphics g = bimage.getGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.legendSize.width, this.legendSize.height);
            g.setColor(Color.black);
            g.drawString(RB.getStringResource(RB_KEY, "NoCorrespondingMapValues.txt", this.locale), 10, 150);
        } else {
            JLegend jlegend = new JLegend();
            StringVector stringVec = new StringVector();
            ColorVector colorVec = new ColorVector();
            NumericVector markerVec = null;
            for (int i = 0; this.breakPointLabels != null && i < this.breakPointLabels.length; ++i) {
                stringVec.addValue(this.breakPointLabels[i]);
                colorVec.addValue(this.breakPointColors[i]);
            }
            if (this.showMissing) {
                try {
                    Color c = new Color(this.defaultMapColor.getRGB());
                    colorVec.addValue(new Color(c.getBlue(), c.getGreen(), c.getRed()));
                    stringVec.addValue(RB.getStringResource(RB_KEY, "Missing.txt", this.locale));
                }
                catch (Exception c) {
                    // empty catch block
                }
                int hatchMarker = ESRIMap.setupMarkers(jlegend.getNetworkRoot().getChannel());
                markerVec = new NumericVector();
                for (int i = 0; i < colorVec.size() - 1; ++i) {
                    markerVec.addValue(-1.0);
                }
                markerVec.addValue((double)hatchMarker);
            }
            Legend legend = new Legend();
            jlegend.setLegend(legend);
            jlegend.setMaximumSize(new Dimension(this.legendSize.width, this.legendSize.height));
            legend.labels.connectFrom((StringPipe)stringVec);
            legend.colors.connectFrom((ColorPipe)colorVec);
            if (markerVec != null) {
                legend.markerTypes.connectFrom((NumericPipe)markerVec);
            }
            legend.getStyle().setBackgroundOn(true);
            legend.getStyle().setBackgroundColor(this.legendBackgroundColor);
            if (this.showLegendTitle) {
                legend.getStyle().setTitleOn(true);
                legend.title.setValue(this.legendTitle);
            } else {
                legend.getStyle().setTitleOn(false);
            }
            TextStyle ts = new TextStyle();
            ts.setFont(this.legendLabelFont);
            ts.setColor(this.legendLabelColor);
            legend.getStyle().setLabelStyle(ts);
            legend.getStyle().getTitleStyle().setFont(this.legendLabelFont);
            legend.getStyle().setMinimumLabelFontSize(6);
            legend.getStyle().setBorderOn(false);
            Dimension mSize = new Dimension(this.legendSize.width, this.legendSize.height);
            jlegend.setMaximumSize(mSize);
            Dimension prefSize = jlegend.getPreferredSize();
            jlegend.addNotify();
            jlegend.setSize(prefSize);
            Graphics g = bimage.getGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.legendSize.width, this.legendSize.height);
            if (prefSize.width <= this.legendSize.width + 2) {
                jlegend.paint(g);
            } else {
                Font gf = FontManager.getFont((String)this.legendLabelFont.getName(), (int)this.legendLabelFont.getStyle(), (int)9);
                g.setFont(gf);
                g.setColor(Color.black);
                g.drawString(RB.getStringResource(RB_KEY, "LegendTooLarge1.txt", this.locale), 10, this.legendSize.height / 2 - 21);
                g.drawString(RB.getStringResource(RB_KEY, "LegendTooLarge2.txt", this.locale), 10, this.legendSize.height / 2 - 7);
                g.drawString(RB.getStringResource(RB_KEY, "LegendTooLarge3.txt", this.locale), 10, this.legendSize.height / 2 + 7);
                g.drawString(RB.getStringResource(RB_KEY, "LegendTooLarge4.txt", this.locale), 10, this.legendSize.height / 2 + 21);
            }
        }
        byte[] bs = null;
        try {
            bs = MapImageUtil.getPngByteStream(bimage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bs;
    }

    @SASScope
    private void findInGroupLayer(GroupLayer clayer, String layerName, LayerInfo layerInfo) throws ESRIException {
        try {
            int count = clayer.getCount();
            for (int j = 0; j < count; ++j) {
                ILayer newLayer = clayer.getLayer(j);
                if (this.isGroupLayer(newLayer)) {
                    GroupLayer glayer = new GroupLayer((Object)newLayer);
                    this.findInGroupLayer(glayer, layerName, layerInfo);
                    if (!layerInfo.found) continue;
                    return;
                }
                if (!newLayer.getName().equalsIgnoreCase(layerName)) continue;
                layerInfo.layer = newLayer;
                layerInfo.found = true;
                return;
            }
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    @SASScope
    private ArrayList getLayersInGroupLayer(GroupLayer clayer, ArrayList layerList, boolean includeGroupLayers) throws ESRIException {
        try {
            int count = clayer.getCount();
            for (int j = 0; j < count; ++j) {
                ILayer newLayer = clayer.getLayer(j);
                if (this.isGroupLayer(newLayer)) {
                    GroupLayer glayer = new GroupLayer((Object)newLayer);
                    if (includeGroupLayers) {
                        layerList.add(newLayer);
                    }
                    this.getLayersInGroupLayer(glayer, layerList, includeGroupLayers);
                    continue;
                }
                layerList.add(newLayer);
            }
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
        return layerList;
    }

    @SASScope
    private boolean isGroupLayer(ILayer layer) {
        try {
            GroupLayer glayer = new GroupLayer((Object)layer);
            glayer.getCount();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @SASScope
    private ArrayList getAllLayers() throws ESRIException {
        return this.getAllLayers(false);
    }

    @SASScope
    private ArrayList getAllLayers(boolean includeGroupLayers) throws ESRIException {
        ArrayList<ILayer> layerList = new ArrayList<ILayer>();
        try {
            int layerCount = this.m_map.getLayerCount();
            for (int i = 0; i < layerCount; ++i) {
                ILayer layer = this.m_map.getLayer(i);
                if (this.isGroupLayer(layer)) {
                    GroupLayer glayer = new GroupLayer((Object)layer);
                    if (includeGroupLayers) {
                        layerList.add(layer);
                    }
                    this.getLayersInGroupLayer(glayer, layerList, includeGroupLayers);
                    continue;
                }
                layerList.add(layer);
            }
        }
        catch (Exception e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
        return layerList;
    }

    @SASScope
    private LayerInfo findLayer(String layerName) throws ESRIException {
        LayerInfo layerInfo = new LayerInfo();
        try {
            int layerCount = this.m_map.getLayerCount();
            for (int i = 0; i < layerCount; ++i) {
                ILayer layer = this.m_map.getLayer(i);
                if (this.isGroupLayer(layer)) {
                    GroupLayer glayer = new GroupLayer((Object)layer);
                    this.findInGroupLayer(glayer, layerName, layerInfo);
                    if (!layerInfo.found) continue;
                    return layerInfo;
                }
                if (!this.m_map.getLayer(i).getName().equalsIgnoreCase(layerName)) continue;
                layerInfo.layer = this.m_map.getLayer(i);
                layerInfo.found = true;
                return layerInfo;
            }
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
        return layerInfo;
    }

    @SASScope
    private static int setupMarkers(Channel ch) {
        CustomMarkerInterface cm = new CustomMarkerInterface(){
            private TexturePaint hatch45;

            public void paint(Graphics g, Color color, Color edgeColor, int x, int y, int w, int h) {
                Graphics2D g2 = (Graphics2D)g;
                g.setColor(color);
                g.fillRect(x - 1, y, w, h);
                g.setColor(edgeColor);
                g.drawRect(x - 1, y, w, h);
                this.createHatch45(edgeColor);
                g2.setPaint(this.hatch45);
                g.fillRect(x - 1, y, w, h);
            }

            private void createHatch45(Color color) {
                if (this.hatch45 == null) {
                    int imageSize = 7;
                    BufferedImage image = new BufferedImage(imageSize, imageSize, 2);
                    Graphics2D ig = (Graphics2D)image.getGraphics();
                    ig.setColor(new Color(1, 100, 1, 0));
                    ig.fillRect(0, 0, imageSize, imageSize);
                    ig.setColor(color);
                    ig.drawLine(0, imageSize - 1, imageSize - 1, 0);
                    ig.drawLine(0, 0, imageSize - 1, imageSize - 1);
                    this.hatch45 = new TexturePaint(image, new Rectangle2D.Float(0.0f, 0.0f, imageSize, imageSize));
                }
            }
        };
        return ch.addCustomMarker(cm);
    }

    public void zoomIn(int x, int y, double factor) throws ESRIException {
        try {
            ILongArrayProxy longArrayX = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayX.insert(0, x);
            ILongArrayProxy longArrayY = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayY.insert(0, y);
            IPointCollection pointColl = this.m_mapServer.toMapPoints(this.m_mapDesc, this.m_imageDesc.getDisplay(), (ILongArray)longArrayX, (ILongArray)longArrayY);
            IPoint point = null;
            if (pointColl.getPointCount() > 0) {
                point = pointColl.getPoint(0);
            }
            IEnvelope env = this.m_mapDesc.getMapArea().getExtent();
            env.centerAt(point);
            env.expand(factor, factor, true);
            IMapExtentProxy mapExtent = new IMapExtentProxy(this.m_context.createObject(MapExtent.getClsid()));
            mapExtent.setExtent(env);
            IMapAreaProxy mapArea = new IMapAreaProxy((Object)mapExtent);
            this.m_mapDesc.setMapArea((IMapArea)mapArea);
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public void resetMapDescription() {
        try {
            this.m_strMapDesc = this.m_context.saveObject((Object)new IXMLSerializeProxy((Object)this.m_mapDesc));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void zoomTo(int startx, int starty, int endx, int endy) throws ESRIException {
        try {
            ILongArrayProxy longArrayX = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayX.add(startx);
            longArrayX.add(endx);
            ILongArrayProxy longArrayY = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayY.add(starty);
            longArrayY.add(endy);
            IPointCollection pointColl = this.m_mapServer.toMapPoints(this.m_mapDesc, this.m_imageDesc.getDisplay(), (ILongArray)longArrayX, (ILongArray)longArrayY);
            this.zoomTo(pointColl.getPoint(0), pointColl.getPoint(1));
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public void zoomTo(long startx, long starty, long endx, long endy) throws ESRIException {
        try {
            IPointProxy iPointUL = new IPointProxy(this.m_context.createObject(Point.getClsid()));
            iPointUL.setX((double)startx);
            iPointUL.setY((double)starty);
            IPointProxy iPointLR = new IPointProxy(this.m_context.createObject(Point.getClsid()));
            iPointLR.setX((double)endx);
            iPointLR.setY((double)endy);
            this.zoomTo((IPoint)iPointUL, (IPoint)iPointLR);
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    @SASScope
    private void zoomTo(IPoint ul, IPoint lr) throws ESRIException {
        try {
            IEnvelope env = this.m_mapDesc.getMapArea().getExtent();
            env.setUpperLeft(ul);
            env.setLowerRight(lr);
            IMapExtentProxy mapExtent = new IMapExtentProxy(this.m_context.createObject(MapExtent.getClsid()));
            mapExtent.setExtent(env);
            IMapAreaProxy mapArea = new IMapAreaProxy((Object)mapExtent);
            this.m_mapDesc.setMapArea((IMapArea)mapArea);
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public double[] zoomFeatures(String layerName, String fieldName, String[] values) throws ESRIException {
        try {
            if (values == null || values.length == 0) {
                return null;
            }
            ILayer layer = this.findLayer(layerName).getLayer();
            if (layer == null) {
                System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)layerName));
                return null;
            }
            IFeatureLayerProxy fLayer = new IFeatureLayerProxy((Object)layer);
            IFeatureClass fClass = fLayer.getFeatureClass();
            int fieldNumber = fClass.findField(fieldName);
            if (fieldNumber == -1) {
                System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "MissingField.fmt.txt", this.locale), (Object)fieldName, (Object)layer.getName()));
                throw new ESRIException(Message.format((String)RB.getStringResource(RB_KEY, "MissingField.fmt.txt", this.locale), (Object)fieldName, (Object)layer.getName()), null);
            }
            int fieldType = fClass.getFields().getField(fieldNumber).getType();
            String query = this.buildQueryString(fieldName, fieldType, values);
            IEnvelope env = this.zoomToLayer(layerName, query);
            if (env == null) {
                env = fLayer.getAreaOfInterest();
            }
            double[] darray = new double[4];
            if (env != null) {
                darray[0] = env.getXMin();
                darray[1] = env.getXMax();
                darray[2] = env.getYMin();
                darray[3] = env.getYMax();
            } else {
                darray = null;
            }
            return darray;
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public void subset(String layerName, String fieldName, String[] values) throws ESRIException {
        try {
            LayerInfo layerInfo = this.findLayer(layerName);
            if (layerInfo.getLayer() == null) {
                System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)layerName));
                return;
            }
            IFeatureLayerProxy fLayer = new IFeatureLayerProxy((Object)layerInfo.getLayer());
            IFeatureClass fClass = fLayer.getFeatureClass();
            int fieldNumber = fClass.findField(fieldName);
            if (fieldNumber == -1) {
                System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "MissingField.fmt.txt", this.locale), (Object)fieldName, (Object)layerInfo.getLayer().getName()));
                throw new ESRIException(Message.format((String)RB.getStringResource(RB_KEY, "MissingField.fmt.txt", this.locale), (Object)fieldName, (Object)layerInfo.getLayer().getName()), null);
            }
            int fieldType = fClass.getFields().getField(fieldNumber).getType();
            String query = this.buildQueryString(fieldName, fieldType, values);
            ILayerDescription ild = this.getLayerDescription(layerName);
            if (ild == null) {
                String s = Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)layerName);
                throw new ESRIException(s, null);
            }
            if (this.debug) {
                this.logger.debug("Query length: " + query.length());
                this.logger.debug(query);
            }
            ild.setDefinitionExpression(query);
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public void clearAllSubsets() throws ESRIException {
        try {
            for (int i = 0; i < this.m_map.getLayerCount(); ++i) {
                ILayerDescription ild = this.m_mapDesc.getLayerDescriptions().getElement(i);
                ild.setDefinitionExpression(null);
            }
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    @SASScope
    private String buildQueryString(String fieldName, int fieldType, String[] values) {
        if (values == null) {
            return null;
        }
        StringBuffer query = new StringBuffer();
        query.append(fieldName + " in (");
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            if (fieldType == 4) {
                if (values[i].indexOf("'") != -1) {
                    query.append("'" + values[i].replaceAll("'", "''") + "'");
                } else {
                    query.append("'" + values[i] + "'");
                }
            } else {
                query.append(values[i]);
            }
            if (i >= values.length - 1) continue;
            query.append(",");
        }
        query.append(")");
        return query.toString();
    }

    public void clearSubset(String layerName) throws ESRIException {
        try {
            ILayerDescription ild = this.getLayerDescription(layerName);
            if (ild == null) {
                String s = Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)layerName);
                throw new ESRIException(s, null);
            }
            ild.setDefinitionExpression(null);
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public String[] identify(int x, int y) throws ESRIException {
        return this.identify(x, y, null);
    }

    public String[] identify(int x, int y, String[] fieldIds) throws ESRIException {
        try {
            int tolerance = 3;
            ILongArrayProxy layerids = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            ILongArrayProxy longArrayX = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            ArrayList<Object> valueList = new ArrayList<Object>(6);
            longArrayX.insert(0, x);
            ILongArrayProxy longArrayY = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayY.insert(0, y);
            IPointCollection pointColl = this.m_mapServer.toMapPoints(this.m_mapDesc, this.m_imageDesc.getDisplay(), (ILongArray)longArrayX, (ILongArray)longArrayY);
            IPoint point = null;
            if (pointColl.getPointCount() > 0) {
                point = pointColl.getPoint(0);
                point.project(this.m_map.getSpatialReference());
            }
            int layerCount = this.m_map.getLayerCount();
            for (int i = 0; i < layerCount; ++i) {
                layerids.add(i);
            }
            IMapServerIdentifyResults identifyResults = this.m_mapServer.identify(this.m_mapDesc, this.m_imageDesc.getDisplay(), (IGeometry)point, tolerance, -3, (ILongArray)layerids);
            if (identifyResults != null && identifyResults.getCount() > 0) {
                IMapServerIdentifyResult result;
                Object[] objkeys = new Object[]{new Object()};
                Object[] objvalues = new Object[]{new Object()};
                int lid = -1;
                HashSet<String> idHash = null;
                if (fieldIds != null) {
                    idHash = new HashSet<String>(Arrays.asList(fieldIds));
                }
                if ((lid = (result = identifyResults.getElement(0)).getLayerID()) != -1) {
                    IPropertySet pset = result.getProperties();
                    pset.getAllProperties(objkeys, objvalues);
                    String[] keys = (String[])objkeys[0];
                    Object[] vals = (Object[])objvalues[0];
                    for (int j = 0; j < keys.length; ++j) {
                        if (idHash != null && !idHash.contains(keys[j])) continue;
                        valueList.add(keys[j]);
                        valueList.add(vals[j]);
                    }
                }
            }
            return valueList.toArray(new String[0]);
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public void zoomOut(int x, int y, double factor) throws ESRIException {
        try {
            ILongArrayProxy longArrayX = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayX.insert(0, x);
            ILongArrayProxy longArrayY = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayY.insert(0, y);
            IPointCollection pointColl = this.m_mapServer.toMapPoints(this.m_mapDesc, this.m_imageDesc.getDisplay(), (ILongArray)longArrayX, (ILongArray)longArrayY);
            IPoint point = null;
            if (pointColl.getPointCount() > 0) {
                point = pointColl.getPoint(0);
            }
            IEnvelope env = this.m_mapDesc.getMapArea().getExtent();
            env.centerAt(point);
            env.expand(factor, factor, true);
            IMapExtentProxy mapExtent = new IMapExtentProxy(this.m_context.createObject(MapExtent.getClsid()));
            mapExtent.setExtent(env);
            IMapAreaProxy mapArea = new IMapAreaProxy((Object)mapExtent);
            this.m_mapDesc.setMapArea((IMapArea)mapArea);
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public void zoomFullExtent() throws ESRIException {
        try {
            IMapExtentProxy mapExtent = new IMapExtentProxy(this.m_context.createObject(MapExtent.getClsid()));
            IEnvelope env = this.m_mapServer.getServerInfo(this.m_mapServer.getDefaultMapName()).getExtent();
            mapExtent.setExtent(env);
            IMapAreaProxy mapArea = new IMapAreaProxy((Object)mapExtent);
            this.m_mapDesc.setMapArea((IMapArea)mapArea);
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public void pan(int startx, int starty, int endx, int endy) throws ESRIException {
        try {
            ILongArrayProxy longArrayX = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayX.add(startx);
            longArrayX.add(endx);
            ILongArrayProxy longArrayY = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayY.add(starty);
            longArrayY.add(endy);
            IPointCollection pointColl = this.m_mapServer.toMapPoints(this.m_mapDesc, this.m_imageDesc.getDisplay(), (ILongArray)longArrayX, (ILongArray)longArrayY);
            IEnvelope env = this.m_mapDesc.getMapArea().getExtent();
            double xoffset = pointColl.getPoint(0).getX() - pointColl.getPoint(1).getX();
            double yoffset = pointColl.getPoint(0).getY() - pointColl.getPoint(1).getY();
            env.offset(xoffset, yoffset);
            IMapExtentProxy mapExtent = new IMapExtentProxy(this.m_context.createObject(MapExtent.getClsid()));
            mapExtent.setExtent(env);
            IMapAreaProxy mapArea = new IMapAreaProxy((Object)mapExtent);
            this.m_mapDesc.setMapArea((IMapArea)mapArea);
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public String[] getLayerNames() throws ESRIException {
        if (this.m_mapDesc == null) {
            return null;
        }
        try {
            ArrayList layerList = this.getAllLayers();
            String[] s = new String[layerList.size()];
            for (int i = 0; i < s.length; ++i) {
                s[i] = ((ILayer)layerList.get(i)).getName();
            }
            return s;
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public void setLayerVisibilities(HashMap map) throws ESRIException {
        if (map == null || map.size() == 0) {
            return;
        }
        String[] s = map.values().toArray(new String[0]);
        String[] o = map.keySet().toArray(new String[0]);
        for (int i = 0; i < s.length; ++i) {
            this.setLayerVisibility(o[i], s[i]);
        }
    }

    public void setLayerVisibility(String layerName, String visible) throws ESRIException {
        if (layerName == null || visible == null) {
            return;
        }
        try {
            if (this.m_mapDesc == null) {
                return;
            }
            ILayerDescription layerDesc = this.getLayerDescription(layerName);
            if (layerDesc == null) {
                String s = Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)layerName);
                throw new ESRIException(s, null);
            }
            if (visible.equalsIgnoreCase("UseMapServiceRules")) {
                layerDesc.setVisible(true);
            } else {
                layerDesc.setVisible(false);
            }
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public void clearSelections() throws ESRIException {
        try {
            ILayerDescriptions ilds = this.m_mapDesc.getLayerDescriptions();
            for (int i = 0; i < ilds.getCount(); ++i) {
                ILayerDescription ild = ilds.getElement(i);
                if (ild == null || ild.getSelectionFeatures() == null) continue;
                ild.getSelectionFeatures().setEmpty();
            }
        }
        catch (IOException e) {
            throw new ESRIException(RB.getStringResource(RB_KEY, "Exception.txt", this.locale), e);
        }
    }

    public void classify(CategorizationModel cm, String layerName, String fieldName, String[] descriptorList, Double[] valueList, Boolean[] exceptionList) throws ESRIException {
        int i;
        if (layerName == null || descriptorList == null || valueList == null) {
            return;
        }
        double[] vlist = new double[valueList.length];
        double minSize = 0.0;
        double maxSize = 0.0;
        double markerSize = this.m_markerSymbolSize;
        boolean varySizes = false;
        if (this.debug) {
            this.logger.debug("doUniqueClassification called on layer -" + layerName + "- field -" + fieldName + "- with " + cm.getParameter() + " breaks");
            this.logger.debug("Region/Value Pairs:");
            for (i = 0; i < descriptorList.length; ++i) {
                this.logger.debug("   " + descriptorList[i] + " - " + valueList[i]);
            }
        }
        for (i = 0; i < valueList.length; ++i) {
            vlist[i] = valueList[i];
        }
        try {
            SASFormat format;
            String[] myLabelList;
            Color c;
            Color[] mycolorList;
            ISymbol exceptionSymbol;
            ISymbol missingSymbol;
            SegmentedRangeModel srm;
            ILayer layer = this.findLayer(layerName).getLayer();
            if (layer == null) {
                String s = Message.format((String)RB.getStringResource(RB_KEY, "MissingClassificationLayer.fmt.txt", this.locale), (Object)layerName);
                throw new ESRIException(s, null);
            }
            IGeoFeatureLayerProxy glayer = new IGeoFeatureLayerProxy((Object)layer);
            int geometryType = glayer.getDisplayFeatureClass().getShapeType();
            double[] arrBreaks = null;
            Vector legendLabels = new Vector();
            if (cm.getCategorizationType() == 12001) {
                arrBreaks = Categorizor.getEqualIntervalRanges((double[])vlist, (int)cm.getParameter());
            } else if (cm.getCategorizationType() == 12003) {
                arrBreaks = Categorizor.getStandardDeviationRanges((double[])vlist, legendLabels, (int)1, (Locale)this.locale);
            } else if (cm.getCategorizationType() == 12000) {
                arrBreaks = Categorizor.getQuantileRanges((double[])vlist, (int)cm.getParameter());
            } else if (cm.getCategorizationType() == 12002) {
                arrBreaks = Categorizor.getNaturalBreaksRanges((double[])vlist, (int)cm.getParameter());
            } else if (cm.getCategorizationType() == 10200 && (srm = cm.getSegmentedRangeModel()) != null) {
                arrBreaks = srm.getSegmentedRange();
            }
            int breaks = arrBreaks.length - 1;
            if (breaks < 0) {
                breaks = 0;
            }
            if (breaks > 0 && cm.getCategorizationType() == 12001) {
                this.roundBreakValues(arrBreaks, breaks);
            }
            ArrayList<IColor> colorList = new ArrayList<IColor>(breaks);
            ISymbol[] symbols = new ISymbol[breaks];
            IEnumColors enumColors = this.getColors(this.startColor, this.midColor, this.endColor, breaks);
            enumColors.reset();
            for (i = 0; i < breaks; ++i) {
                colorList.add(enumColors.next());
            }
            this.breakPointColors = new Color[breaks];
            switch (geometryType) {
                case 4: {
                    break;
                }
                case 1: {
                    ISymbol symbol;
                    ISimpleRendererProxy sRenderer2;
                    IMarkerSymbolProxy ms2;
                    ISymbol maxSymbol;
                    IMarkerSymbolProxy ms;
                    ISymbol minSymbol;
                    IClassBreaksRendererProxy cbRenderer2;
                    try {
                        cbRenderer2 = new IClassBreaksRendererProxy((Object)glayer.getRenderer());
                        cbRenderer2.getBreakCount();
                        minSymbol = cbRenderer2.getSymbol(0);
                        ms = new IMarkerSymbolProxy((Object)minSymbol);
                        minSize = ms.getSize();
                        maxSymbol = cbRenderer2.getSymbol(cbRenderer2.getBreakCount() - 1);
                        ms2 = new IMarkerSymbolProxy((Object)maxSymbol);
                        maxSize = ms2.getSize();
                        varySizes = true;
                    }
                    catch (Exception cbRenderer2) {
                        // empty catch block
                    }
                    try {
                        sRenderer2 = new ISimpleRendererProxy((Object)glayer.getRenderer());
                        symbol = sRenderer2.getSymbol();
                        ms = new IMarkerSymbolProxy((Object)symbol);
                        markerSize = ms.getSize();
                        varySizes = false;
                    }
                    catch (Exception sRenderer2) {}
                    break;
                }
                default: {
                    ISymbol symbol;
                    ISimpleRendererProxy sRenderer2;
                    IMarkerSymbolProxy ms2;
                    ISymbol maxSymbol;
                    IMarkerSymbolProxy ms;
                    ISymbol minSymbol;
                    IClassBreaksRendererProxy cbRenderer2;
                    try {
                        cbRenderer2 = new IClassBreaksRendererProxy((Object)glayer.getRenderer());
                        cbRenderer2.getBreakCount();
                        minSymbol = cbRenderer2.getSymbol(0);
                        ms = new ILineSymbolProxy((Object)minSymbol);
                        minSize = ms.getWidth();
                        maxSymbol = cbRenderer2.getSymbol(cbRenderer2.getBreakCount() - 1);
                        ms2 = new ILineSymbolProxy((Object)maxSymbol);
                        maxSize = ms2.getWidth();
                        varySizes = true;
                    }
                    catch (Exception cbRenderer) {
                        // empty catch block
                    }
                    try {
                        sRenderer2 = new ISimpleRendererProxy((Object)glayer.getRenderer());
                        symbol = sRenderer2.getSymbol();
                        ms = new ILineSymbolProxy((Object)symbol);
                        markerSize = ms.getWidth();
                        varySizes = false;
                        break;
                    }
                    catch (Exception sRenderer) {
                        // empty catch block
                    }
                }
            }
            for (i = 0; i < breaks; ++i) {
                Color c2 = new Color(((IColor)colorList.get(i)).getRGB());
                this.breakPointColors[i] = new Color(c2.getBlue(), c2.getGreen(), c2.getRed());
                double size = markerSize;
                if (varySizes) {
                    size = breaks > 1 ? minSize + (double)i * (maxSize - minSize) / (double)(breaks - 1) : (minSize + maxSize) / 2.0;
                }
                symbols[i] = this.getSymbol(geometryType, (IColor)colorList.get(i), size);
            }
            ISymbol underflowSymbol = this.getSymbol(geometryType, (IColor)this.underFlowColor, this.m_markerSymbolSize);
            ISymbol overflowSymbol = this.getSymbol(geometryType, (IColor)this.overFlowColor, this.m_markerSymbolSize);
            ISymbol defaultSymbol = this.getSymbol(geometryType, (IColor)this.defaultMapColor, this.m_markerSymbolSize);
            if (legendLabels != null && legendLabels.size() > 0) {
                this.breakPointLabels = new String[legendLabels.size()];
                for (i = 0; i < legendLabels.size(); ++i) {
                    this.breakPointLabels[i] = (String)legendLabels.get(i);
                }
            } else {
                this.breakPointLabels = new String[breaks];
                SASFormat format2 = SASFormat.getInstance((String)this.legendFormat);
                for (i = 0; i < breaks; ++i) {
                    this.breakPointLabels[i] = breaks == 1 && valueList.length <= 1 ? format2.format((Object)new Double(arrBreaks[i])).trim() : format2.format((Object)new Double(arrBreaks[i])).trim() + " - " + format2.format((Object)new Double(arrBreaks[i + 1])).trim();
                }
            }
            IFeatureRendererProxy featureRenderer = new IFeatureRendererProxy(this.m_context.createObject(UniqueValueRenderer.getClsid()));
            IUniqueValueRendererProxy uvRenderer = new IUniqueValueRendererProxy((Object)featureRenderer);
            uvRenderer.setFieldCount(1);
            uvRenderer.setField(0, fieldName);
            if (geometryType == 1) {
                missingSymbol = this.getSymbol(geometryType, (IColor)this.missingColor, this.m_markerSymbolSize);
                exceptionSymbol = this.getSymbol(geometryType, (IColor)this.selectionColor, this.m_markerSymbolSize);
            } else {
                missingSymbol = this.getCrosshatchSymbol((IColor)this.missingColor, (IColor)this.defaultMapColor, 7);
                exceptionSymbol = this.getCrosshatchSymbol((IColor)this.outlineColor, (IColor)this.selectionColor, 5);
            }
            boolean addUnderflowColorAndLabel = false;
            boolean addOverflowColorAndLabel = false;
            for (i = 0; i < descriptorList.length; ++i) {
                if (exceptionList != null && exceptionList.length >= i + 1 && exceptionList[i].booleanValue()) {
                    uvRenderer.addValue(descriptorList[i], fieldName, exceptionSymbol);
                    continue;
                }
                if (valueList[i].isNaN()) {
                    uvRenderer.addValue(descriptorList[i], fieldName, missingSymbol);
                    continue;
                }
                int index = this.getRangeIndex(vlist[i], arrBreaks, breaks);
                if (index == -1) {
                    uvRenderer.addValue(descriptorList[i], fieldName, this.useBoundsColors ? underflowSymbol : defaultSymbol);
                    if (!this.useBoundsColors) continue;
                    addUnderflowColorAndLabel = true;
                    continue;
                }
                if (index == -2) {
                    uvRenderer.addValue(descriptorList[i], fieldName, this.useBoundsColors ? overflowSymbol : defaultSymbol);
                    if (!this.useBoundsColors) continue;
                    addOverflowColorAndLabel = true;
                    continue;
                }
                uvRenderer.addValue(descriptorList[i], fieldName, symbols[index]);
            }
            if (addUnderflowColorAndLabel) {
                mycolorList = new Color[this.breakPointColors.length + 1];
                c = new Color(this.underFlowColor.getRGB());
                mycolorList[0] = new Color(c.getBlue(), c.getGreen(), c.getRed());
                System.arraycopy(this.breakPointColors, 0, mycolorList, 1, this.breakPointColors.length);
                this.breakPointColors = mycolorList;
                myLabelList = new String[this.breakPointLabels.length + 1];
                format = SASFormat.getInstance((String)this.legendFormat);
                myLabelList[0] = Message.format((String)RB.getStringResource(RB_KEY, "LessThan.fmt.txt", this.locale), (Object)format.format((Object)new Double(arrBreaks[0])).trim());
                System.arraycopy(this.breakPointLabels, 0, myLabelList, 1, this.breakPointLabels.length);
                this.breakPointLabels = myLabelList;
            }
            if (addOverflowColorAndLabel) {
                mycolorList = new Color[this.breakPointColors.length + 1];
                c = new Color(this.overFlowColor.getRGB());
                mycolorList[this.breakPointColors.length] = new Color(c.getBlue(), c.getGreen(), c.getRed());
                System.arraycopy(this.breakPointColors, 0, mycolorList, 0, this.breakPointColors.length);
                this.breakPointColors = mycolorList;
                myLabelList = new String[this.breakPointLabels.length + 1];
                format = SASFormat.getInstance((String)this.legendFormat);
                myLabelList[this.breakPointLabels.length] = Message.format((String)RB.getStringResource(RB_KEY, "GreaterThan.fmt.txt", this.locale), (Object)format.format((Object)new Double(arrBreaks[arrBreaks.length - 1])).trim());
                System.arraycopy(this.breakPointLabels, 0, myLabelList, 0, this.breakPointLabels.length);
                this.breakPointLabels = myLabelList;
            }
            glayer.setRendererByRef((IFeatureRenderer)featureRenderer);
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "UnableToDoClassification.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private boolean isClassBreaksRenderer(IFeatureRenderer renderer) {
        try {
            ClassBreaksRenderer cbRenderer = new ClassBreaksRenderer((Object)renderer);
            cbRenderer.getBreakCount();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void undoClassification(String layerName) throws ESRIException {
        if (layerName == null) {
            return;
        }
        try {
            ILayer layer = this.findLayer(layerName).getLayer();
            ISymbolProxy symbol = null;
            ILineSymbol outline = null;
            IGeoFeatureLayerProxy gLayer = new IGeoFeatureLayerProxy((Object)layer);
            ISimpleFillSymbolProxy fillSymbol = new ISimpleFillSymbolProxy(this.m_context.createObject(SimpleFillSymbol.getClsid()));
            fillSymbol.setColor((IColor)this.defaultMapColor);
            outline = fillSymbol.getOutline();
            outline.setColor((IColor)this.defaultOutlineColor);
            fillSymbol.setOutline(outline);
            IFeatureRendererProxy featureRenderer = new IFeatureRendererProxy(this.m_context.createObject(SimpleRenderer.getClsid()));
            ISimpleRendererProxy simpleRenderer = new ISimpleRendererProxy((Object)featureRenderer);
            symbol = new ISymbolProxy((Object)fillSymbol);
            simpleRenderer.setSymbolByRef((ISymbol)symbol);
            gLayer.setRendererByRef((IFeatureRenderer)featureRenderer);
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "UnableToGetClassification.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private void roundBreakValues(double[] arrBreaks, int numBreaks) {
        ContinuousTickSpacer cts = new ContinuousTickSpacer();
        cts.getPreference().setAutoInterval(false);
        cts.setTickCount(numBreaks + 1);
        cts.setDataMin(arrBreaks[0]);
        cts.setDataMax(arrBreaks[numBreaks]);
        cts.doTickSpacing();
        double[] values = cts.getTickValues();
        for (int i = 0; i < values.length; ++i) {
            arrBreaks[i] = values[i];
        }
    }

    @SASScope
    private int getRangeIndex(double val, double[] breakArray, int breaks) {
        if (val == Double.NaN) {
            return 0;
        }
        if (val < breakArray[0]) {
            return -1;
        }
        for (int i = 0; i < breaks; ++i) {
            if (!(val <= breakArray[i + 1])) continue;
            return i;
        }
        return -2;
    }

    private IEnumColors getColors(IRgbColor fromColor, IRgbColor toColor, int breaks) throws ESRIException {
        try {
            if (breaks <= 1) {
                breaks = 2;
            }
            AlgorithmicColorRamp ramp = new AlgorithmicColorRamp(this.m_context.createObject(AlgorithmicColorRamp.getClsid()));
            ramp.setAlgorithm(1);
            ramp.setFromColor((IColor)fromColor);
            ramp.setToColor((IColor)toColor);
            ramp.setSize(breaks);
            boolean[] r_ok = new boolean[]{false};
            ramp.createRamp(r_ok);
            if (r_ok[0]) {
                return ramp.getColors();
            }
            return null;
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    private IEnumColors getColors(IRgbColor fromColor, IRgbColor midColor, IRgbColor toColor, int breaks) throws ESRIException {
        try {
            if (this.useTwoColorRamp) {
                return this.getColors(fromColor, toColor, breaks);
            }
            if (breaks < 1) {
                breaks = 2;
            }
            int numFirstColors = breaks / 2;
            int numSecondColors = breaks - numFirstColors;
            IMultiPartColorRampProxy cRamp = new IMultiPartColorRampProxy(this.m_context.createObject(MultiPartColorRamp.getClsid()));
            IAlgorithmicColorRampProxy ramp1 = new IAlgorithmicColorRampProxy(this.m_context.createObject(AlgorithmicColorRamp.getClsid()));
            ramp1.setAlgorithm(1);
            ramp1.setFromColor((IColor)fromColor);
            ramp1.setToColor((IColor)midColor);
            ramp1.setSize(numFirstColors);
            IAlgorithmicColorRampProxy ramp2 = new IAlgorithmicColorRampProxy(this.m_context.createObject(AlgorithmicColorRamp.getClsid()));
            ramp2.setAlgorithm(1);
            ramp2.setFromColor((IColor)midColor);
            ramp2.setToColor((IColor)toColor);
            ramp2.setSize(numSecondColors);
            cRamp.addRamp((IColorRamp)ramp1);
            cRamp.addRamp((IColorRamp)ramp2);
            cRamp.setSize(breaks);
            boolean[] r_ok = new boolean[]{false};
            cRamp.createRamp(r_ok);
            if (r_ok[0]) {
                return cRamp.getColors();
            }
            return null;
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private ISymbol getCrosshatchSymbol(IColor hatchColor, IColor backgroundColor, int type) throws ESRIException {
        try {
            ISymbolProxy symbol = null;
            ILineSymbol outline = null;
            IMultiLayerFillSymbolProxy imlfs = new IMultiLayerFillSymbolProxy(this.m_context.createObject(MultiLayerFillSymbol.getClsid()));
            SimpleFillSymbol hatchSymbol = new SimpleFillSymbol(this.m_context.createObject(SimpleFillSymbol.getClsid()));
            hatchSymbol.setColor(hatchColor);
            hatchSymbol.setStyle(type);
            outline = hatchSymbol.getOutline();
            outline.setWidth(this.m_polygonSymbolOutlineWidth);
            outline.setColor((IColor)this.outlineColor);
            hatchSymbol.setOutline(outline);
            SimpleFillSymbol backgroundSymbol = new SimpleFillSymbol(this.m_context.createObject(SimpleFillSymbol.getClsid()));
            backgroundSymbol.setColor(backgroundColor);
            backgroundSymbol.setStyle(0);
            outline = backgroundSymbol.getOutline();
            outline.setWidth(this.m_polygonSymbolOutlineWidth);
            outline.setColor((IColor)this.outlineColor);
            backgroundSymbol.setOutline(outline);
            imlfs.addLayer((IFillSymbol)backgroundSymbol);
            imlfs.addLayer((IFillSymbol)hatchSymbol);
            symbol = new ISymbolProxy((Object)imlfs);
            return symbol;
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private ISymbol getSymbol(int shapeType, IColor color, double size) throws ESRIException {
        try {
            ISymbolProxy symbol = null;
            ILineSymbol outline = null;
            switch (shapeType) {
                case 4: {
                    SimpleFillSymbol pFillSymbol = new SimpleFillSymbol(this.m_context.createObject(SimpleFillSymbol.getClsid()));
                    pFillSymbol.setColor(color);
                    pFillSymbol.setStyle(this.m_polygonSymbolStyle);
                    outline = pFillSymbol.getOutline();
                    outline.setWidth(this.m_polygonSymbolOutlineWidth);
                    outline.setColor((IColor)this.outlineColor);
                    pFillSymbol.setOutline(outline);
                    symbol = new ISymbolProxy((Object)pFillSymbol);
                    break;
                }
                case 1: {
                    SimpleMarkerSymbol pMarkerSymbol = new SimpleMarkerSymbol(this.m_context.createObject(SimpleMarkerSymbol.getClsid()));
                    pMarkerSymbol.setColor(color);
                    pMarkerSymbol.setStyle(this.m_markerSymbolStyle);
                    pMarkerSymbol.setSize(size);
                    symbol = new ISymbolProxy((Object)pMarkerSymbol);
                    break;
                }
                default: {
                    SimpleLineSymbol pLineSymbol = new SimpleLineSymbol(this.m_context.createObject(SimpleLineSymbol.getClsid()));
                    pLineSymbol.setColor(color);
                    pLineSymbol.setStyle(this.m_lineSymbolStyle);
                    pLineSymbol.setWidth(size);
                    symbol = new ISymbolProxy((Object)pLineSymbol);
                }
            }
            return symbol;
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private IEnvelope zoomToLayer(String layerName, String query) throws ESRIException {
        try {
            LayerInfo layerInfo = this.findLayer(layerName);
            IQueryFilterProxy pQueryFilter = new IQueryFilterProxy(this.m_context.createObject(QueryFilter.getClsid()));
            pQueryFilter.setWhereClause(query);
            ISelectionSet set = new FeatureLayer((Object)layerInfo.getLayer()).select((IQueryFilter)pQueryFilter, 1, 1, null);
            if (set != null && set.getCount() == 0) {
                return layerInfo.getLayer().getAreaOfInterest();
            }
            GeometryEnvironment ge = new GeometryEnvironment(this.m_context.createObject(GeometryEnvironment.getClsid()));
            EnumFeatureGeometry efg = new EnumFeatureGeometry(this.m_context.createObject(EnumFeatureGeometry.getClsid()));
            efg.bindGeometrySource(null, (Object)set);
            IGeometry geometry = ge.createGeometryFromEnumerator((IEnumGeometry)efg);
            IEnvelopeProxy env = new IEnvelopeProxy(this.m_context.createObject(Envelope.getClsid()));
            IEnvelopeProxy env2 = new IEnvelopeProxy(this.m_context.createObject(Envelope.getClsid()));
            env.setSpatialReferenceByRef(geometry.getSpatialReference());
            env2 = geometry.getEnvelope();
            env.setXMin(env2.getXMin());
            env.setXMax(env2.getXMax());
            env.setYMin(env2.getYMin());
            env.setYMax(env2.getYMax());
            env.project(this.m_map.getSpatialReference());
            return env;
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public void setMapExtents(double xmin, double xmax, double ymin, double ymax) throws ESRIException {
        try {
            double w;
            IEnvelope env = this.m_mapDesc.getMapArea().getExtent();
            IEnvelope defenv = this.m_mapServer.getServerInfo(this.m_mapServer.getDefaultMapName()).getExtent();
            if (xmin == xmax) {
                w = defenv.getWidth() / 100.0;
                xmin -= w;
                xmax += w;
            }
            if (ymin == ymax) {
                w = defenv.getHeight() / 100.0;
                ymin -= w;
                ymax += w;
            }
            env.setXMin(xmin);
            env.setXMax(xmax);
            env.setYMin(ymin);
            env.setYMax(ymax);
            IMapExtentProxy mapExtent = new IMapExtentProxy(this.m_context.createObject(MapExtent.getClsid()));
            mapExtent.setExtent(env);
            IMapAreaProxy mapArea = new IMapAreaProxy((Object)mapExtent);
            this.m_mapDesc.setMapArea((IMapArea)mapArea);
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public double[] getMapExtents() throws ESRIException {
        double[] darray = new double[4];
        try {
            IEnvelope env = this.m_mapDesc.getMapArea().getExtent();
            darray[0] = env.getXMin();
            darray[1] = env.getXMax();
            darray[2] = env.getYMin();
            darray[3] = env.getYMax();
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
        return darray;
    }

    public String[] getSelectList(Map layerToFieldMap) throws ESRIException {
        try {
            int[] myInts = new int[1];
            ArrayList<String> valueList = new ArrayList<String>(6);
            String[] layerNames = layerToFieldMap.keySet().toArray(new String[0]);
            String[] layerList = this.getLayerNames();
            for (int i = 0; i < layerList.length; ++i) {
                for (int j = 0; j < layerNames.length; ++j) {
                    if (!layerList[i].equalsIgnoreCase(layerNames[j])) continue;
                    LayerInfo layerInfo = this.findLayer(layerList[i]);
                    IFeatureLayerProxy fLayer = new IFeatureLayerProxy((Object)layerInfo.getLayer());
                    ILayerDescription ild = this.getLayerDescription(layerList[i]);
                    if (ild == null) {
                        String s = Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)layerList[i]);
                        throw new ESRIException(s, null);
                    }
                    IFIDSet ifidset = ild.getSelectionFeatures();
                    ifidset.reset();
                    for (int c = 0; c < ifidset.count(); ++c) {
                        ifidset.next(myInts);
                        int featureID = myInts[0];
                        IFeature feature = fLayer.getFeatureClass().getFeature(featureID);
                        int fieldNum = feature.getFields().findField((String)layerToFieldMap.get(layerNames[j].toLowerCase()));
                        String fieldValue = feature.getValue(fieldNum).toString();
                        valueList.add(layerNames[j]);
                        valueList.add(fieldValue);
                    }
                }
            }
            return valueList.toArray(new String[0]);
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public String[] selectLayerAndField(int x, int y, Map layerToFieldMap) throws ESRIException {
        try {
            int tolerance = 1;
            ILongArrayProxy layerids = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            ILongArrayProxy longArrayX = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayX.insert(0, x);
            ILongArrayProxy longArrayY = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayY.insert(0, y);
            IPointCollection pointColl = this.m_mapServer.toMapPoints(this.m_mapDesc, this.m_imageDesc.getDisplay(), (ILongArray)longArrayX, (ILongArray)longArrayY);
            IPoint point = null;
            if (pointColl.getPointCount() > 0) {
                point = pointColl.getPoint(0);
                point.project(this.m_map.getSpatialReference());
            }
            String[] layerNames = layerToFieldMap.keySet().toArray(new String[0]);
            String[] foundLayerNames = this.getLayerNames();
            for (int i = 0; i < foundLayerNames.length; ++i) {
                for (int j = 0; j < layerNames.length; ++j) {
                    if (!foundLayerNames[i].equalsIgnoreCase(layerNames[j])) continue;
                    ILayerDescription layerDesc = this.getLayerDescription(foundLayerNames[i]);
                    if (layerDesc == null) {
                        String s = Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)foundLayerNames[i]);
                        throw new ESRIException(s, null);
                    }
                    layerids.add(layerDesc.getID());
                }
            }
            IMapServerIdentifyResults identifyResults = this.m_mapServer.identify(this.m_mapDesc, this.m_imageDesc.getDisplay(), (IGeometry)point, tolerance, -3, (ILongArray)layerids);
            if (identifyResults != null && identifyResults.getCount() > 0) {
                int lid = -1;
                IMapServerIdentifyResult result = identifyResults.getElement(0);
                lid = result.getLayerID();
                if (lid == -1) {
                    return null;
                }
                String layerName = ((ILayer)this.getAllLayers(true).get(lid)).getName();
                IPropertySet pset = result.getProperties();
                String fieldValue = (String)pset.getProperty((String)layerToFieldMap.get(layerName.toLowerCase()));
                String[] returnStringArr = new String[]{layerName, fieldValue};
                return returnStringArr;
            }
            return null;
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public int rectangularSelect(int startx, int starty, int endx, int endy, boolean controlPressed, String classifiedLayer) throws ESRIException {
        try {
            ILongArrayProxy longArrayX = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            ILongArrayProxy longArrayY = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayX.add(startx);
            longArrayX.add(endx);
            longArrayY.add(starty);
            longArrayY.add(endy);
            IPointCollection pointColl = this.m_mapServer.toMapPoints(this.m_mapDesc, this.m_imageDesc.getDisplay(), (ILongArray)longArrayX, (ILongArray)longArrayY);
            IEnvelopeProxy env = new IEnvelopeProxy(this.m_context.createObject(Envelope.getClsid()));
            if (pointColl.getPointCount() > 0) {
                env.setUpperLeft(pointColl.getPoint(0));
                env.setLowerRight(pointColl.getPoint(1));
                env.project(this.m_map.getSpatialReference());
            }
            return this.selectGeom((IGeometry)env, controlPressed, classifiedLayer, false);
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public int select(int x, int y, boolean controlPressed, String classifiedLayer) throws ESRIException {
        try {
            ILongArrayProxy longArrayX = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            ILongArrayProxy longArrayY = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayX.add(x);
            longArrayY.add(y);
            IPointCollection pointColl = this.m_mapServer.toMapPoints(this.m_mapDesc, this.m_imageDesc.getDisplay(), (ILongArray)longArrayX, (ILongArray)longArrayY);
            IPoint point = null;
            if (pointColl.getPointCount() > 0) {
                point = pointColl.getPoint(0);
                point.project(this.m_map.getSpatialReference());
            }
            return this.selectGeom((IGeometry)point, controlPressed, classifiedLayer, true);
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private int selectGeom(IGeometry geom, boolean controlPressed, String classifiedLayer, boolean singular) throws ESRIException {
        try {
            ILayerDescription ild2;
            int tolerance = 1;
            ILongArrayProxy layerids = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            if (!controlPressed) {
                this.clearSelections();
            }
            if ((ild2 = this.getLayerDescription(classifiedLayer)) == null) {
                String s = Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)classifiedLayer);
                throw new ESRIException(s, null);
            }
            int id = ild2.getID();
            layerids.add(id);
            IMapServerIdentifyResults identifyResults = this.m_mapServer.identify(this.m_mapDesc, this.m_imageDesc.getDisplay(), geom, tolerance, -3, (ILongArray)layerids);
            if (identifyResults != null && identifyResults.getCount() > 0) {
                int layerID = identifyResults.getElement(0).getLayerID();
                ISpatialFilterProxy filter = new ISpatialFilterProxy(this.m_context.createObject(SpatialFilter.getClsid()));
                filter.setGeometryByRef(geom);
                filter.setGeometryField("Shape");
                filter.setSpatialRel(1);
                ILayerDescription ild = this.m_mapDesc.getLayerDescriptions().getElement(layerID);
                String s = ild.getDefinitionExpression();
                filter.setWhereClause(s);
                IFIDSet ifidset = this.m_mapServer.queryFeatureIDs(this.m_mapDesc.getName(), layerID, (IQueryFilter)filter);
                IFIDSet ifidset2 = ild.getSelectionFeatures();
                int[] myInts = new int[1];
                ifidset.reset();
                for (int c = 0; c < ifidset.count(); ++c) {
                    ifidset.next(myInts);
                    boolean[] isFound = new boolean[1];
                    ifidset2.find(myInts[0], isFound);
                    if (isFound[0]) {
                        if (!controlPressed) continue;
                        ifidset2.delete(myInts[0]);
                        continue;
                    }
                    ifidset2.add(myInts[0]);
                }
                ild.setSetSelectionSymbol(false);
                ild.setSelectionColorByRef((IColor)this.selectionColor);
                ild.setSelectionFeatures(ifidset2);
                return ild.getSelectionFeatures().count();
            }
            return 0;
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public double calculateDistance(int startx, int starty, int endx, int endy) throws ESRIException {
        double distance = -1.0;
        try {
            ILongArrayProxy longArrayX = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            ILongArrayProxy longArrayY = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayX.add(startx);
            longArrayX.add(endx);
            longArrayY.add(starty);
            longArrayY.add(endy);
            IPointCollection pointColl = this.m_mapServer.toMapPoints(this.m_mapDesc, this.m_imageDesc.getDisplay(), (ILongArray)longArrayX, (ILongArray)longArrayY);
            IEnvelopeProxy env = new IEnvelopeProxy(this.m_context.createObject(Envelope.getClsid()));
            if (pointColl.getPointCount() > 0) {
                env.setUpperLeft(pointColl.getPoint(0));
                env.setLowerRight(pointColl.getPoint(1));
                env.project(this.m_map.getSpatialReference());
            }
            distance = this.m_map.computeDistance(pointColl.getPoint(0), pointColl.getPoint(1));
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
        return distance;
    }

    public int selectByField(String[] values, boolean controlPressed, String classifiedLayer, String fieldName) throws ESRIException {
        try {
            LayerInfo layerInfo;
            if (values == null || values.length == 0) {
                return 0;
            }
            if (!controlPressed) {
                this.clearSelections();
            }
            if (!(layerInfo = this.findLayer(classifiedLayer)).isFound()) {
                System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)classifiedLayer));
                return 0;
            }
            IFeatureLayerProxy fLayer = new IFeatureLayerProxy((Object)layerInfo.getLayer());
            IFeatureClass fClass = fLayer.getFeatureClass();
            int fieldNumber = fClass.findField(fieldName);
            if (fieldNumber == -1) {
                System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "MissingField.fmt.txt", this.locale), (Object)fieldName, (Object)classifiedLayer));
                throw new ESRIException(Message.format((String)RB.getStringResource(RB_KEY, "MissingField.fmt.txt", this.locale), (Object)fieldName, (Object)classifiedLayer), null);
            }
            int fieldType = fClass.getFields().getField(fieldNumber).getType();
            String query = this.buildQueryString(fieldName, fieldType, values);
            IQueryFilterProxy filter = new IQueryFilterProxy(this.m_context.createObject(QueryFilter.getClsid()));
            filter.setWhereClause(query);
            ILayerDescription ild = this.getLayerDescription(classifiedLayer);
            if (ild == null) {
                String s = Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)classifiedLayer);
                throw new ESRIException(s, null);
            }
            IFIDSet ifidset = this.m_mapServer.queryFeatureIDs(this.m_mapDesc.getName(), ild.getID(), (IQueryFilter)filter);
            IFIDSet ifidset2 = ild.getSelectionFeatures();
            int[] myInts = new int[1];
            ifidset.reset();
            for (int c = 0; c < ifidset.count(); ++c) {
                ifidset.next(myInts);
                boolean[] isFound = new boolean[1];
                ifidset2.find(myInts[0], isFound);
                if (isFound[0]) {
                    if (!controlPressed) continue;
                    ifidset2.delete(myInts[0]);
                    continue;
                }
                ifidset2.add(myInts[0]);
            }
            ild.setSetSelectionSymbol(false);
            ild.setSelectionColorByRef((IColor)this.selectionColor);
            ild.setSelectionFeatures(ifidset2);
            return ild.getSelectionFeatures().count();
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public void setMapImageSize(Dimension d) {
        this.size = d;
    }

    public void setLegendImageSize(Dimension d) {
        this.legendSize = d;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isShowMissing() {
        return this.showMissing;
    }

    public void setShowMissing(boolean showMissing) {
        this.showMissing = showMissing;
    }

    public boolean isUseTwoColorRamp() {
        return this.useTwoColorRamp;
    }

    public void setUseTwoColorRamp(boolean useTwoColorRamp) {
        this.useTwoColorRamp = useTwoColorRamp;
    }

    public String getLegendValueFormat() {
        return this.legendFormat;
    }

    public void setLegendValueFormat(String legendFormat) {
        this.legendFormat = legendFormat;
    }

    public HashMap getLayerVisibilities() throws ESRIException {
        HashMap<String, String> hash = new HashMap<String, String>();
        try {
            ArrayList layerList = this.getAllLayers();
            for (int i = 0; i < layerList.size(); ++i) {
                String s = ((ILayer)layerList.get(i)).getName();
                hash.put(s, this.getLayerVisibility(s));
            }
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
        return hash;
    }

    public HashMap getDefaultLayerVisibilities() throws ESRIException {
        HashMap<String, String> hash = new HashMap<String, String>();
        try {
            ArrayList layerList = this.getAllLayers();
            for (int i = 0; i < layerList.size(); ++i) {
                ILayer layer = (ILayer)layerList.get(i);
                String s = layer.isVisible() ? "UseMapServiceRules" : "AlwaysOff";
                hash.put(layer.getName(), s);
            }
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
        return hash;
    }

    public String getLayerVisibility(String layerName) throws ESRIException {
        try {
            ILayerDescription ild = this.getLayerDescription(layerName);
            if (ild != null) {
                String s = ild.isVisible() ? "UseMapServiceRules" : "AlwaysOff";
                return s;
            }
            String s = Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)layerName);
            throw new ESRIException(s, null);
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public boolean isValidLayer(String layerName) throws ESRIException {
        if (this.m_map == null) {
            return false;
        }
        ILayer layer = this.findLayer(layerName).getLayer();
        return layer != null;
    }

    public boolean isValidLayerAndField(String layerName, String fieldName) throws ESRIException {
        if (layerName == null || fieldName == null) {
            return false;
        }
        try {
            ILayer layer = this.findLayer(layerName).getLayer();
            if (layer == null) {
                return false;
            }
            IFeatureLayerProxy fLayer = new IFeatureLayerProxy((Object)layer);
            return fLayer.getFeatureClass().findField(fieldName) != -1;
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    public Color getLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    @SASScope
    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        this.legendBackgroundColor = legendBackgroundColor;
    }

    @SASScope
    public Color getLegendBorderColor() {
        return this.legendBorderColor;
    }

    @SASScope
    public void setLegendBorderColor(Color legendBorderColor) {
        this.legendBorderColor = legendBorderColor;
    }

    @SASScope
    public Font getLegendValueFont() {
        return this.legendLabelFont;
    }

    @SASScope
    public void setLegendValueFont(Font legendValueFont) {
        this.legendLabelFont = legendValueFont;
    }

    @SASScope
    public Color getLegendValueColor() {
        return this.legendLabelColor;
    }

    @SASScope
    public void setLegendValueColor(Color newColor) {
        this.legendLabelColor = newColor;
    }

    public String getLegendTitle() {
        return this.legendTitle;
    }

    public void setLegendTitle(String legendTitle) {
        this.legendTitle = legendTitle;
    }

    public boolean isShowLegendTitle() {
        return this.showLegendTitle;
    }

    public void setShowLegendTitle(boolean showLegendTitle) {
        this.showLegendTitle = showLegendTitle;
    }

    @SASScope
    private void setStartColor(Color c) throws ESRIException {
        try {
            this.startColor = new RgbColor(this.m_context.createObject(RgbColor.getClsid()));
            this.startColor.setRed(c.getRed());
            this.startColor.setGreen(c.getGreen());
            this.startColor.setBlue(c.getBlue());
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private void setOverFlowColor(Color c) throws ESRIException {
        try {
            this.overFlowColor = new RgbColor(this.m_context.createObject(RgbColor.getClsid()));
            this.overFlowColor.setRed(c.getRed());
            this.overFlowColor.setGreen(c.getGreen());
            this.overFlowColor.setBlue(c.getBlue());
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private void setUnderFlowColor(Color c) throws ESRIException {
        try {
            this.underFlowColor = new RgbColor(this.m_context.createObject(RgbColor.getClsid()));
            this.underFlowColor.setRed(c.getRed());
            this.underFlowColor.setGreen(c.getGreen());
            this.underFlowColor.setBlue(c.getBlue());
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private void setMidColor(Color c) throws ESRIException {
        try {
            this.midColor = new RgbColor(this.m_context.createObject(RgbColor.getClsid()));
            this.midColor.setRed(c.getRed());
            this.midColor.setGreen(c.getGreen());
            this.midColor.setBlue(c.getBlue());
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private void setEndColor(Color c) throws ESRIException {
        try {
            this.endColor = new RgbColor(this.m_context.createObject(RgbColor.getClsid()));
            this.endColor.setRed(c.getRed());
            this.endColor.setGreen(c.getGreen());
            this.endColor.setBlue(c.getBlue());
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private void setOutlineColor(Color c) throws ESRIException {
        try {
            this.outlineColor = new RgbColor(this.m_context.createObject(RgbColor.getClsid()));
            this.outlineColor.setRed(c.getRed());
            this.outlineColor.setGreen(c.getGreen());
            this.outlineColor.setBlue(c.getBlue());
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    public void setDefaultMapColor(Color c) throws ESRIException {
        try {
            this.defaultMapColor = new RgbColor(this.m_context.createObject(RgbColor.getClsid()));
            this.defaultMapColor.setRed(c.getRed());
            this.defaultMapColor.setGreen(c.getGreen());
            this.defaultMapColor.setBlue(c.getBlue());
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    public void setMissingColor(Color c) throws ESRIException {
        try {
            this.missingColor = new RgbColor(this.m_context.createObject(RgbColor.getClsid()));
            this.missingColor.setRed(c.getRed());
            this.missingColor.setGreen(c.getGreen());
            this.missingColor.setBlue(c.getBlue());
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    public void setDefaultOutlineColor(Color c) throws ESRIException {
        try {
            this.defaultOutlineColor = new RgbColor(this.m_context.createObject(RgbColor.getClsid()));
            this.defaultOutlineColor.setRed(c.getRed());
            this.defaultOutlineColor.setGreen(c.getGreen());
            this.defaultOutlineColor.setBlue(c.getBlue());
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    public void setSelectionColor(Color c) throws ESRIException {
        try {
            this.selectionColor = new RgbColor(this.m_context.createObject(RgbColor.getClsid()));
            this.selectionColor.setRed(c.getRed());
            this.selectionColor.setGreen(c.getGreen());
            this.selectionColor.setBlue(c.getBlue());
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public IMap getIMap() {
        return this.m_map;
    }

    public IMapServer getIMapServer() {
        return this.m_mapServer;
    }

    public Object[] getFieldValues(String layerName, String fieldName, int numValues) throws ESRIException {
        try {
            ArrayList<Object> myArray = new ArrayList<Object>();
            ILayer layer = this.findLayer(layerName).getLayer();
            if (layer == null) {
                String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
                throw new ESRIException(s, null);
            }
            IFeatureLayerProxy fLayer = new IFeatureLayerProxy((Object)layer);
            IFeatureClass fClass = fLayer.getFeatureClass();
            int fieldNumber = fClass.findField(fieldName);
            IQueryFilterProxy pQueryFilter = new IQueryFilterProxy(this.m_context.createObject(QueryFilter.getClsid()));
            IFeatureCursor pFeatureCursor = fLayer.search((IQueryFilter)pQueryFilter, true);
            IFeature pFeature = pFeatureCursor.nextFeature();
            for (int i = 0; pFeature != null && (numValues == -1 || i < numValues); ++i) {
                myArray.add(pFeature.getValue(fieldNumber));
                pFeature = pFeatureCursor.nextFeature();
            }
            return myArray.toArray();
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public double[] testData(Object[] data, String layerName, String fieldName) throws ESRIException {
        if (data == null || layerName == null || fieldName == null) {
            return null;
        }
        Object[] l = this.getFieldValues(layerName, fieldName, -1);
        return ESRIMap.compare(data, l);
    }

    @SASScope
    private static double[] compare(Object[] a1, Object[] b1) {
        double percentAMatches;
        int i;
        if (a1 == null || b1 == null) {
            return null;
        }
        Object[] a = new Object[a1.length];
        Object[] b = new Object[b1.length];
        System.arraycopy(a1, 0, a, 0, a1.length);
        System.arraycopy(b1, 0, b, 0, b1.length);
        double[] retVal = new double[]{0.0, 0.0};
        Arrays.sort(a);
        Arrays.sort(b);
        int numBMatches = 0;
        int numAMatches = 0;
        for (i = 0; i < a.length; ++i) {
            if (Arrays.binarySearch(b, a[i]) < 0) continue;
            ++numAMatches;
        }
        for (i = 0; i < b.length; ++i) {
            if (Arrays.binarySearch(a, b[i]) < 0) continue;
            ++numBMatches;
        }
        double percentBMatches = (double)numBMatches / (double)b.length;
        retVal[0] = percentAMatches = (double)numAMatches / (double)a.length;
        retVal[1] = percentBMatches;
        return retVal;
    }

    public String[] getFieldNames(String layerName) throws ESRIException {
        try {
            String[] retVal = null;
            ILayer layer = this.findLayer(layerName).getLayer();
            if (layer == null) {
                String s = Message.format((String)RB.getStringResource(RB_KEY, "MissingLayer.fmt.txt", this.locale), (Object)layerName);
                throw new ESRIException(s, null);
            }
            IFeatureLayerProxy fLayer = new IFeatureLayerProxy((Object)layer);
            IFeatureClass fClass = fLayer.getFeatureClass();
            IFields fFields = fClass.getFields();
            int count = fFields.getFieldCount();
            retVal = new String[count];
            for (int i = 0; i < count; ++i) {
                retVal[i] = fFields.getField(i).getName();
            }
            return retVal;
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    public String chooseField(Object[] data, String layerName, String[] fieldNames, int numToCheck) throws ESRIException {
        int numVisited = 0;
        ArrayList<Object[]> featureFieldValues = new ArrayList<Object[]>();
        try {
            int i;
            ILayer layer = this.findLayer(layerName).getLayer();
            IFeatureLayerProxy fLayer = new IFeatureLayerProxy((Object)layer);
            IFeatureClass fClass = fLayer.getFeatureClass();
            IFields fFields = fClass.getFields();
            IQueryFilterProxy pQueryFilter = new IQueryFilterProxy(this.m_context.createObject(QueryFilter.getClsid()));
            IFeatureCursor pFeatureCursor = fLayer.search((IQueryFilter)pQueryFilter, true);
            IFeature pFeature = pFeatureCursor.nextFeature();
            ArrayList<Integer> fieldIDArray = new ArrayList<Integer>();
            if (fieldNames == null) {
                int count = fFields.getFieldCount();
                for (i = 0; i < count; ++i) {
                    fieldIDArray.add(new Integer(i));
                }
            } else {
                for (int i2 = 0; i2 < fieldNames.length; ++i2) {
                    try {
                        int id = fFields.findField(fieldNames[i2]);
                        if (id == -1) continue;
                        fieldIDArray.add(new Integer(id));
                        continue;
                    }
                    catch (Exception id) {
                        // empty catch block
                    }
                }
            }
            while (pFeature != null && (numToCheck == -1 || numVisited < numToCheck)) {
                Object[] values = new Object[fieldIDArray.size()];
                for (i = 0; i < values.length; ++i) {
                    values[i] = pFeature.getValue(((Integer)fieldIDArray.get(i)).intValue());
                }
                featureFieldValues.add(values);
                pFeature = pFeatureCursor.nextFeature();
                ++numVisited;
            }
            Object[][] matrix = (Object[][])featureFieldValues.toArray((T[])new Object[0][0]);
            matrix = this.transpose(matrix);
            double[][] d = new double[matrix.length][2];
            for (int i3 = 0; i3 < matrix.length; ++i3) {
                d[i3] = ESRIMap.compare(data, matrix[i3]);
            }
            int highest = 0;
            double highestP = -1.0;
            for (int i4 = 0; i4 < d.length; ++i4) {
                if (!(d[i4][1] > highestP)) continue;
                highest = i4;
                highestP = d[i4][0];
            }
            String name = null;
            if (highestP > 0.0) {
                name = fFields.getField(((Integer)fieldIDArray.get(highest)).intValue()).getName();
            }
            return name;
        }
        catch (IOException e) {
            String s = RB.getStringResource(RB_KEY, "Exception.txt", this.locale);
            throw new ESRIException(s, e);
        }
    }

    @SASScope
    private Object[][] transpose(Object[][] entry) {
        int rows = entry.length;
        int columns = entry[0].length;
        Object[][] transpose = new Object[columns][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                transpose[j][i] = entry[i][j];
            }
        }
        return transpose;
    }

    @SASScope
    private void createColorDefaults() {
        this.startColor = this.createRgbColor(255, 255, 255);
        this.endColor = this.createRgbColor(255, 0, 0);
        this.outlineColor = this.createRgbColor(150, 150, 150);
        this.defaultMapColor = this.createRgbColor(125, 125, 125);
        this.missingColor = this.createRgbColor(0, 0, 0);
        this.defaultOutlineColor = this.createRgbColor(0, 0, 0);
        this.selectionColor = this.createRgbColor(255, 255, 255);
        this.underFlowColor = this.createRgbColor(0, 255, 0);
        this.overFlowColor = this.createRgbColor(0, 0, 0);
    }

    @SASScope
    private IRgbColor createRgbColor(int r, int g, int b) {
        try {
            IRgbColorProxy color = new IRgbColorProxy(this.m_context.createObject(RgbColor.getClsid()));
            color.setRed(r);
            color.setGreen(g);
            color.setBlue(b);
            return color;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String[] getMapServiceNames() throws ESRIException {
        ServerConnection connection = null;
        ArrayList<String> nameArray = new ArrayList<String>();
        try {
            connection = new ServerConnection();
            connection.connect(this.connection.getGisServer());
            IServerObjectManager mgr = connection.getServerObjectManager();
            IEnumServerObjectConfigurationInfo serverList = mgr.getConfigurationInfos();
            if (serverList == null) {
                return null;
            }
            int count = serverList.getCount();
            for (int i = 0; i < count; ++i) {
                IServerObjectConfigurationInfo ci = serverList.next();
                if (!ci.getTypeName().equalsIgnoreCase("MapServer")) continue;
                nameArray.add(ci.getName());
            }
        }
        catch (IOException e) {
            String s = Message.format((String)RB.getStringResource(RB_KEY, "ConnectionError.fmt.txt", this.locale), (Object)this.connection.getMapServiceName(), (Object)this.connection.getGisServer());
            throw new ESRIException(s, e);
        }
        return nameArray.toArray(new String[0]);
    }

    public void applyGraphStyle(GraphStyle style) {
        try {
            DataElementStyles des = style.getDataElementStyles();
            this.setStartColor(des.getContinuousFillThreeColorStartColor());
            this.setMidColor(des.getContinuousFillThreeColorNeutralColor());
            this.setEndColor(des.getContinuousFillThreeColorEndColor());
            this.setOutlineColor(des.getOutlineLineStyle().getColor());
            this.setDefaultOutlineColor(des.getOutlineLineStyle().getColor());
            this.setDefaultMapColor(new Color(207, 207, 207));
            this.setOverFlowColor(des.getOverFlowFillStyle().getSolidFillColor());
            this.setUnderFlowColor(des.getUnderFlowFillStyle().getSolidFillColor());
            this.setMissingColor(new Color(0, 0, 0));
            this.setLegendValueFont(style.getValueTextStyle().getFont());
            this.setLegendValueColor(Color.BLACK);
            this.setLegendBackgroundColor(Color.WHITE);
            this.setLegendBorderColor(Color.BLACK);
        }
        catch (ESRIException eSRIException) {
            // empty catch block
        }
    }

    public boolean isUseBoundsColors() {
        return this.useBoundsColors;
    }

    public void setUseBoundsColors(boolean useBoundsColors) {
        this.useBoundsColors = useBoundsColors;
    }

    public void setAnnotations(ArrayList annotations) {
        if (annotations == null || annotations.size() <= 0) {
            return;
        }
        try {
            IGraphicElementsProxy ige = new IGraphicElementsProxy(this.m_context.createObject(GraphicElements.getClsid()));
            for (int i = 0; i < annotations.size(); ++i) {
                IRgbColor eColor;
                IRgbColor eColor2;
                IPointProxy iPointUL;
                MarkerElement me;
                IMarkerElementProxy imep;
                MapAnnotation anno = (MapAnnotation)annotations.get(i);
                if (anno instanceof AnnotationMarker) {
                    imep = new IMarkerElementProxy(this.m_context.createObject(MarkerElement.getClsid()));
                    me = new MarkerElement((Object)imep);
                    iPointUL = new IPointProxy(this.m_context.createObject(Point.getClsid()));
                    iPointUL.setX(((AnnotationMarker)anno).getX());
                    iPointUL.setY(((AnnotationMarker)anno).getY());
                    me.setGeometry((IGeometry)iPointUL);
                    eColor2 = this.getESRIColor(anno.getColor());
                    ISimpleMarkerSymbolProxy iSimpleMarker = new ISimpleMarkerSymbolProxy(this.m_context.createObject(SimpleMarkerSymbol.getClsid()));
                    switch (((AnnotationMarker)anno).getSymbol()) {
                        case 0: {
                            iSimpleMarker.setStyle(0);
                            break;
                        }
                        case 1: {
                            iSimpleMarker.setStyle(2);
                            break;
                        }
                        case 2: {
                            iSimpleMarker.setStyle(4);
                            break;
                        }
                        case 3: {
                            iSimpleMarker.setStyle(1);
                            break;
                        }
                        case 4: {
                            iSimpleMarker.setStyle(3);
                        }
                    }
                    iSimpleMarker.setColor((IColor)eColor2);
                    iSimpleMarker.setSize(((AnnotationMarker)anno).getSize());
                    iSimpleMarker.setOutline(((AnnotationMarker)anno).isShowOutline());
                    iSimpleMarker.setOutlineColor((IColor)this.getESRIColor(((AnnotationMarker)anno).getOutlineColor()));
                    iSimpleMarker.setOutlineSize(((AnnotationMarker)anno).getOutlineWidth());
                    me.setSymbol((IMarkerSymbol)iSimpleMarker);
                    ige.add((IGraphicElement)me);
                } else if (anno instanceof AnnotationArrow) {
                    imep = new IMarkerElementProxy(this.m_context.createObject(MarkerElement.getClsid()));
                    me = new MarkerElement((Object)imep);
                    iPointUL = new IPointProxy(this.m_context.createObject(Point.getClsid()));
                    iPointUL.setX(((AnnotationArrow)anno).getX());
                    iPointUL.setY(((AnnotationArrow)anno).getY());
                    me.setGeometry((IGeometry)iPointUL);
                    eColor2 = this.getESRIColor(anno.getColor());
                    IArrowMarkerSymbolProxy iArrow = new IArrowMarkerSymbolProxy(this.m_context.createObject(ArrowMarkerSymbol.getClsid()));
                    iArrow.setColor((IColor)eColor2);
                    iArrow.setLength(((AnnotationArrow)anno).getLength());
                    iArrow.setWidth(((AnnotationArrow)anno).getWidth());
                    iArrow.setAngle(((AnnotationArrow)anno).getAngle());
                    me.setSymbol((IMarkerSymbol)iArrow);
                    ige.add((IGraphicElement)me);
                } else if (anno instanceof AnnotationPolyline) {
                    ILineElementProxy line = new ILineElementProxy(this.m_context.createObject(LineElement.getClsid()));
                    LineElement le = new LineElement((Object)line);
                    IPolylineProxy pline = new IPolylineProxy(this.m_context.createObject(Polyline.getClsid()));
                    Polyline ple = new Polyline((Object)pline);
                    for (int j = 0; j < ((AnnotationPolyline)anno).getPoints().size(); ++j) {
                        Point2D p = (Point2D)((AnnotationPolyline)anno).getPoints().get(j);
                        IPointProxy iPoint = new IPointProxy(this.m_context.createObject(Point.getClsid()));
                        iPoint.setX(p.getX());
                        iPoint.setY(p.getY());
                        ple.addPoint((IPoint)iPoint, null, null);
                    }
                    le.setGeometry((IGeometry)ple);
                    eColor = this.getESRIColor(anno.getColor());
                    ISimpleLineSymbolProxy isls = new ISimpleLineSymbolProxy(this.m_context.createObject(SimpleLineSymbol.getClsid()));
                    isls.setColor((IColor)eColor);
                    isls.setWidth(((AnnotationPolyline)anno).getWidth());
                    isls.setStyle(this.getESRIStyle(((AnnotationPolyline)anno).getStyle()));
                    le.setSymbol((ILineSymbol)isls);
                    ige.add((IGraphicElement)le);
                } else if (anno instanceof AnnotationPolygon) {
                    IPolygonElementProxy ipe = new IPolygonElementProxy(this.m_context.createObject(PolygonElement.getClsid()));
                    PolygonElement pe = new PolygonElement((Object)ipe);
                    IPolygonProxy ipoly = new IPolygonProxy(this.m_context.createObject(Polygon.getClsid()));
                    Polygon poly = new Polygon((Object)ipoly);
                    ArrayList pathList = ((AnnotationPolygon)anno).getPathList();
                    if (pathList != null && pathList.size() > 0) {
                        for (int j = 0; j < pathList.size(); ++j) {
                            ArrayList path = (ArrayList)pathList.get(j);
                            if (path == null || path.size() <= 0) continue;
                            IRingProxy iring = new IRingProxy(this.m_context.createObject(Ring.getClsid()));
                            Ring ring = new Ring((Object)iring);
                            for (int k = 0; k < path.size(); ++k) {
                                Point2D p = (Point2D)path.get(k);
                                IPointProxy iPoint = new IPointProxy(this.m_context.createObject(Point.getClsid()));
                                iPoint.setX(p.getX());
                                iPoint.setY(p.getY());
                                ring.addPoint((IPoint)iPoint, null, null);
                            }
                            poly.addGeometry((IGeometry)ring, null, null);
                        }
                        pe.setGeometry((IGeometry)poly);
                        IRgbColor fColor = this.getESRIColor(anno.getColor());
                        IRgbColor lColor = this.getESRIColor(((AnnotationPolygon)anno).getOutlineColor());
                        ISimpleFillSymbolProxy isfs = new ISimpleFillSymbolProxy(this.m_context.createObject(SimpleFillSymbol.getClsid()));
                        isfs.setColor((IColor)fColor);
                        if (((AnnotationPolygon)anno).isShowOutline()) {
                            ISimpleLineSymbolProxy isls = new ISimpleLineSymbolProxy(this.m_context.createObject(SimpleLineSymbol.getClsid()));
                            isls.setColor((IColor)lColor);
                            isls.setWidth(((AnnotationPolygon)anno).getOutlineWidth());
                            isls.setStyle(this.getESRIStyle(((AnnotationPolygon)anno).getOutlineStyle()));
                            isfs.setOutline((ILineSymbol)isls);
                        }
                        pe.setSymbol((IFillSymbol)isfs);
                    }
                    ige.add((IGraphicElement)pe);
                }
                if (!(anno instanceof AnnotationText)) continue;
                AnnotationText at = (AnnotationText)anno;
                ITextElementProxy ite = new ITextElementProxy(this.m_context.createObject(TextElement.getClsid()));
                TextElement te = new TextElement((Object)ite);
                IPointProxy iPointUL2 = new IPointProxy(this.m_context.createObject(Point.getClsid()));
                iPointUL2.setX(at.getX());
                iPointUL2.setY(at.getY());
                te.setGeometry((IGeometry)iPointUL2);
                eColor = this.getESRIColor(anno.getColor());
                te.setColor((IColor)eColor);
                switch (at.getHorizontalAlignment()) {
                    case 3: {
                        te.setHorizontalAlignment(1);
                        break;
                    }
                    case 7: {
                        te.setHorizontalAlignment(3);
                        break;
                    }
                    case 6: {
                        te.setHorizontalAlignment(2);
                        break;
                    }
                    default: {
                        te.setHorizontalAlignment(0);
                    }
                }
                switch (at.getVerticalAlignment()) {
                    case 4: {
                        te.setHorizontalAlignment(0);
                        break;
                    }
                    case 2: {
                        te.setHorizontalAlignment(3);
                        break;
                    }
                    case 3: {
                        te.setHorizontalAlignment(1);
                        break;
                    }
                    default: {
                        te.setHorizontalAlignment(2);
                    }
                }
                te.setText(at.getText());
                te.setFontName(at.getFontName());
                te.setScaleText(at.isScaleText());
                te.setSize(at.getPointSize());
                te.setItalic(at.isItalic());
                te.setBold(at.isBold());
                te.setUnderline(at.isUnderline());
                te.setFlipAngle(at.getFlipAngle());
                te.setCharacterWidth(at.getCharacterWidth());
                te.setCharacterSpacing(at.getCharacterSpacing());
                ige.add((IGraphicElement)te);
            }
            this.m_mapDesc.setCustomGraphics((IGraphicElements)ige);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void clearAnnotations() {
        try {
            this.m_mapDesc.setCustomGraphics(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SASScope
    private int getESRIStyle(int style) {
        switch (style) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
        }
        return 1;
    }

    public double[] convertToMapCoord(int x, int y) {
        try {
            ILongArrayProxy longArrayX = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayX.insert(0, x);
            ILongArrayProxy longArrayY = new ILongArrayProxy(this.m_context.createObject(LongArray.getClsid()));
            longArrayY.insert(0, y);
            IPointCollection pointColl = this.m_mapServer.toMapPoints(this.m_mapDesc, this.m_imageDesc.getDisplay(), (ILongArray)longArrayX, (ILongArray)longArrayY);
            IPoint point = null;
            if (pointColl.getPointCount() > 0) {
                point = pointColl.getPoint(0);
                return new double[]{point.getX(), point.getY()};
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @SASScope
    private IRgbColor getESRIColor(Color c) {
        if (c == null) {
            c = Color.white;
        }
        try {
            RgbColor color = new RgbColor(this.m_context.createObject(RgbColor.getClsid()));
            color.setRed(c.getRed());
            color.setGreen(c.getGreen());
            color.setBlue(c.getBlue());
            return color;
        }
        catch (IOException e) {
            return null;
        }
    }

    @SASScope
    private ILayerDescription getLayerDescription(String layerName) {
        try {
            int layerID = this.getLayerID(layerName);
            if (layerID == -1 || layerName == null) {
                return null;
            }
            ILayerDescriptions ilds = this.m_mapDesc.getLayerDescriptions();
            for (int i = 0; i < ilds.getCount(); ++i) {
                ILayerDescription ild = ilds.getElement(i);
                if (layerID != ild.getID()) continue;
                return ild;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @SASScope
    private int getLayerID(String layerName) {
        if (layerName == null) {
            return -1;
        }
        try {
            IMapLayerInfos imlis = this.m_mapServer.getServerInfo(this.m_mapServer.getDefaultMapName()).getMapLayerInfos();
            int count = imlis.getCount();
            for (int i = 0; i < count; ++i) {
                if (!layerName.equals(imlis.getElement(i).getName())) continue;
                return imlis.getElement(i).getID();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    @SASScope
    private class LayerInfo {
        private boolean found;
        private int totalLayers;
        private ILayer layer;

        private LayerInfo() {
        }

        public boolean isFound() {
            return this.found;
        }

        public void setFound(boolean found) {
            this.found = found;
        }

        public ILayer getLayer() {
            return this.layer;
        }

        public void setLayer(ILayer layer) {
            this.layer = layer;
        }

        public int getTotalLayers() {
            return this.totalLayers;
        }

        public void setTotalLayers(int totalLayers) {
            this.totalLayers = totalLayers;
        }
    }
}

