/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.map;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.map.ESRIException;
import com.sas.graphics.map.ESRIMap;
import com.sas.net.crypto.SealedString;
import java.util.HashMap;

@SASScope(value="ALL")
public class ESRIConnection {
    public static final String ESRI_LAYER_ALWAYSON = "AlwaysOn";
    public static final String ESRI_LAYER_ALWAYSOFF = "AlwaysOff";
    public static final String ESRI_LAYER_USEMAPSERVICERULES = "UseMapServiceRules";
    @SASScope
    private String gisServer;
    @SASScope
    private String userName;
    @SASScope
    private SealedString userPwd;
    @SASScope
    private String domain;
    @SASScope
    private String mapServiceName;

    public ESRIConnection() {
    }

    public ESRIConnection(String server, String domainName, String userid, String password) {
        this.setConnectionProperties(server, domainName, userid, password);
    }

    public void setConnectionProperties(String server, String domainName, String userid, String password) {
        this.gisServer = server;
        this.userName = userid;
        this.userPwd = new SealedString(password.toCharArray());
        this.domain = domainName;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getGisServer() {
        return this.gisServer;
    }

    public void setGisServer(String gisServer) {
        this.gisServer = gisServer;
    }

    public String getMapServiceName() {
        return this.mapServiceName;
    }

    public void setMapServiceName(String mapServiceName) {
        this.mapServiceName = mapServiceName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPwd() {
        return String.valueOf(this.userPwd.getCharacters());
    }

    public void setUserPwd(String userPwd) {
        this.userPwd = new SealedString(userPwd.toCharArray());
    }

    public HashMap getLayerVisibilities(HashMap levelToLayerMap) throws ESRIException {
        ESRIMap myMap = null;
        myMap = this.getESRIMap();
        HashMap hash = new HashMap();
        if (myMap != null) {
            hash = this.getLayerVisibilities(myMap, levelToLayerMap);
            this.disconnectESRIMap(myMap);
        }
        return hash;
    }

    @SASScope
    private HashMap getLayerVisibilities(ESRIMap map, HashMap levelToLayerMap) throws ESRIException {
        HashMap hash = map.getLayerVisibilities();
        String[] s = levelToLayerMap.values().toArray(new String[0]);
        for (int i = 0; i < s.length; ++i) {
            hash.remove(s[i]);
        }
        return hash;
    }

    @SASScope
    private ESRIMap getESRIMap() throws ESRIException {
        ESRIMap myMap = null;
        myMap = new ESRIMap(this);
        myMap.connect();
        myMap.getMap();
        return myMap;
    }

    @SASScope
    private void disconnectESRIMap(ESRIMap map) throws ESRIException {
        map.disconnect();
    }

    public Object[] getFieldValues(String layerName, String fieldName, int numValues) throws ESRIException {
        ESRIMap myMap = this.getESRIMap();
        Object[] o = null;
        if (myMap != null) {
            o = myMap.getFieldValues(layerName, fieldName, numValues);
            this.disconnectESRIMap(myMap);
        }
        return o;
    }

    public String chooseField(Object[] data, String layerName, String[] fieldNames, int numToCheck) throws ESRIException {
        ESRIMap myMap = this.getESRIMap();
        String s = null;
        if (myMap != null) {
            s = myMap.chooseField(data, layerName, fieldNames, numToCheck);
            this.disconnectESRIMap(myMap);
        }
        return s;
    }

    public double[] testData(Object[] data, String layerName, String fieldName) throws ESRIException {
        ESRIMap myMap = this.getESRIMap();
        double[] d = null;
        if (myMap != null) {
            d = myMap.testData(data, layerName, fieldName);
            this.disconnectESRIMap(myMap);
        }
        return d;
    }

    public String[] getMapServiceNames() throws ESRIException {
        ESRIMap myMap = this.getESRIMap();
        String[] names = null;
        if (myMap != null) {
            names = myMap.getMapServiceNames();
            this.disconnectESRIMap(myMap);
        }
        return names;
    }
}

