/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.commands;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.graphics.map.ESRIMap;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapChart;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.util.Util;
import javax.servlet.http.HttpServletRequest;

public class MapSetMeasureCommand
extends BaseCommand {
    private String measure;
    private Object mapViewer;

    public MapSetMeasureCommand(String name) {
        super(name);
    }

    public void execute(Object o) {
        OLAPESRIMapChart map = (OLAPESRIMapChart)this.getMapViewer();
        if (map == null) {
            return;
        }
        map.setRequest((HttpServletRequest)this.getAttribute("request"));
        ESRIMap esriMap = map.getESRIMap();
        try {
            this.setMeasure(map, esriMap);
            map.setAutoZoom(false);
            map.setRedrawMap(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            esriMap.disconnect();
            esriMap = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setMeasure(OLAPESRIMapChart map, ESRIMap myMap) {
        String[] crossing = null;
        try {
            crossing = map.getCrossing();
            TupleElementInterface measureElement = map.getOLAPUtil().getMeasureElement();
            String measureName = measureElement.getName();
            for (int i = 0; i < crossing.length; ++i) {
                if (!Util.equal((Object)crossing[i], (Object)measureName)) continue;
                crossing[i] = this.measure;
                break;
            }
            map.setCrossing(crossing);
        }
        catch (Exception e) {
            return;
        }
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        return 0;
    }

    public Object getMapViewer() {
        return this.mapViewer;
    }

    public void setMapViewer(Object mapViewer) {
        this.mapViewer = mapViewer;
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }
}

