/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.commands;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.commands.MapBaseCommand;
import com.sas.graphics.components.esrimap.ESRIMapTableDataModel;
import com.sas.graphics.map.ESRIMap;
import com.sas.servlet.tbeans.graphics.BaseESRIMapChart;
import com.sas.servlet.tbeans.graphics.html.ESRIMapChart;
import com.sas.servlet.tbeans.olapgraphics.html.ESRIElement;
import com.sas.servlet.tbeans.olapgraphics.html.MapOLAPUtil;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapChart;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MapRectangularSelectCommand
extends MapBaseCommand {
    private int clickX;
    private int clickY;
    private int width;
    private int height;
    private int controlPressed;
    private Object mapViewer;

    public MapRectangularSelectCommand(String name) {
        super(name);
    }

    @Override
    public void execute(Object o) {
        BaseESRIMapChart map = (BaseESRIMapChart)((Object)this.getMapViewer());
        if (map == null) {
            return;
        }
        map.setRequest((HttpServletRequest)this.getAttribute("request"));
        ESRIMap esriMap = map.getESRIMap();
        try {
            if (this.width < 0) {
                this.clickX += this.width;
                this.width = 0 - this.width;
            }
            if (this.height < 0) {
                this.clickY += this.height;
                this.height = 0 - this.height;
            }
            if (this.width != 0 && this.height != 0) {
                this.select(this.clickX, this.clickY, this.controlPressed == 1, map, esriMap);
                map.setAutoZoom(false);
                map.setMode(13);
                esriMap.resetMapDescription();
                map.resetToMap(esriMap);
                map.setRedrawMap(true);
                this.contentsChanged = true;
                this.eventInfo.clear();
                this.eventInfo.put("ESRIMAP", "RECTANGULARSELECT");
                this.setEventSource((Object)map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            esriMap.disconnect();
            esriMap = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void select(int x, int y, boolean control, BaseESRIMapChart map, ESRIMap myMap) {
        ArrayList valueList = new ArrayList(6);
        ArrayList descriptorList = new ArrayList(6);
        try {
            String classifiedLayer = null;
            classifiedLayer = map instanceof OLAPESRIMapChart ? this.getTopmostLayer((OLAPESRIMapChart)map, valueList, descriptorList) : ((ESRIMapTableDataModel)((ESRIMapChart)map).getDataModel()).getLayerName();
            int totalNumSelected = 0;
            if (classifiedLayer != null) {
                totalNumSelected = myMap.rectangularSelect(this.clickX, this.clickY, this.clickX + this.width, this.clickY + this.height, control, classifiedLayer);
                map.setShowFilter(totalNumSelected >= 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getTopmostLayer(OLAPESRIMapChart map, List valueList, List descriptorList) throws Exception {
        int i;
        MapOLAPUtil olapUtil = map.getOLAPUtil();
        Map layerMap = olapUtil.getLevelToLayerMap();
        List elemList = olapUtil.getElements();
        String[] layerNames = map.getLayerNames(layerMap);
        ESRIElement e = null;
        for (i = 0; i < layerNames.length; ++i) {
            ArrayList<String> l = new ArrayList<String>(6);
            for (int k = 0; k < elemList.size(); ++k) {
                String tempStr;
                e = (ESRIElement)elemList.get(k);
                if (!e.layer.equals(layerNames[i]) || (tempStr = e.uniqueID) == null || tempStr.length() <= 0) continue;
                l.add(tempStr);
                if (i != layerNames.length - 1) continue;
            }
        }
        String topVisibleLayer = null;
        if (--i >= 0 && layerNames != null && layerNames.length >= i - 1) {
            topVisibleLayer = layerNames[i];
        }
        return topVisibleLayer;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        return 0;
    }

    public Object getMapViewer() {
        return this.mapViewer;
    }

    public void setMapViewer(Object mapViewer) {
        this.mapViewer = mapViewer;
    }

    public int getClickX() {
        return this.clickX;
    }

    public void setClickX(int clickX) {
        this.clickX = clickX;
    }

    public int getClickY() {
        return this.clickY;
    }

    public void setClickY(int clickY) {
        this.clickY = clickY;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getControlPressed() {
        return this.controlPressed;
    }

    public void setControlPressed(int control) {
        this.controlPressed = control;
    }
}

