/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.commands;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.CollapseCommand;
import com.sas.graphics.components.esrimap.ESRIMapOLAPDataModel;
import com.sas.graphics.map.ESRIMap;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.step.StepFilterInterface;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.servlet.tbeans.olapgraphics.html.MapOLAPUtil;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapChart;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class MapCollapseCommand
extends CollapseCommand {
    private int clickX;
    private int clickY;
    private Object mapViewer;

    public MapCollapseCommand(String name) {
        super(name);
    }

    public MapCollapseCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        OLAPESRIMapChart map = (OLAPESRIMapChart)this.getMapViewer();
        if (map == null) {
            return;
        }
        map.setRequest((HttpServletRequest)this.getAttribute("request"));
        ESRIMap esriMap = map.getESRIMap();
        try {
            boolean retVal = this.setupParms(this.clickX, this.clickY, map, esriMap);
            if (retVal) {
                super.execute(o);
                map.clearSelections(esriMap);
                map.setAutoZoom(true);
                map.setRedrawMap(true);
                map.setMode(8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            esriMap.disconnect();
            esriMap = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        return super.getCommandStatus(filter);
    }

    private boolean setupParms(int x, int y, OLAPESRIMapChart map, ESRIMap myMap) {
        String[] layerAndField = null;
        try {
            layerAndField = myMap.selectLayerAndField(x, y, ((ESRIMapOLAPDataModel)map.getDataModel()).getLayerToFieldMap());
            if (layerAndField == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        MapOLAPUtil olapUtil = map.getOLAPUtil();
        String layer = layerAndField[0];
        String uniqueID = layerAndField[1];
        try {
            OLAPDataSetInterface dsi = olapUtil.getDataModel();
            if (dsi != null && dsi instanceof BusinessQueryProviderInterface) {
                TupleElementInterface te = olapUtil.getTupleElement(layer, uniqueID);
                TupleInterface ctuple = te.getTuple();
                TupleElementInterface cte = ctuple.getElements(te.getTupleElementIndex() - 1, 1)[0];
                super.setTupleElement(cte);
                super.setModel(dsi);
                super.setTupleIndex(new Integer(cte.getTuple().getTupleIndex()));
                super.setTupleElementIndex(new Integer(cte.getTupleElementIndex()));
                super.setAxisIndex(new Integer(cte.getTuple().getAxis().getAxisNumber()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void collapse(int x, int y, OLAPESRIMapChart map, ESRIMap myMap) throws Exception {
        String[] layerAndField = myMap.selectLayerAndField(x, y, ((ESRIMapOLAPDataModel)map.getDataModel()).getLayerToFieldMap());
        if (layerAndField != null) {
            this.collapse(map.getOLAPUtil(), layerAndField[0], layerAndField[1]);
        }
    }

    private boolean collapse(MapOLAPUtil olapUtil, String layer, String uniqueID) {
        try {
            int stepIndex;
            List steps;
            int size;
            TupleElementInterface te;
            TupleInterface ctuple;
            TupleElementInterface cte;
            BusinessQuery businessQuery;
            DataItem dataItem;
            OLAPDataSetInterface dsi = olapUtil.getDataModel();
            if (dsi != null && dsi instanceof BusinessQueryProviderInterface && (dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)(businessQuery = ((BusinessQueryProviderInterface)dsi).getBusinessQuery()), null, (Object)(cte = (ctuple = (te = olapUtil.getTupleElement(layer, uniqueID)).getTuple()).getElements(te.getTupleElementIndex() - 1, 1)[0]), (int)1)) != null && (size = (steps = dataItem.getSteps()).size()) > 0 && (stepIndex = this.isExpandPresent(steps, cte.getName())) >= 0) {
                dataItem.removeStep(stepIndex);
                ((BusinessQueryProviderInterface)dsi).refreshBusinessQuery(businessQuery);
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    protected int isExpandPresent(List steps, String elementName) {
        if (steps != null && steps.size() > 0) {
            int lastStepIndex;
            for (int i = lastStepIndex = steps.size() - 1; i >= 0; --i) {
                StepInterface lastStep = (StepInterface)steps.get(i);
                if (!(lastStep instanceof DataItemNavigationFilter)) continue;
                int actionType = ((StepFilterInterface)lastStep).getActionType();
                if (((DataItemNavigationFilter)lastStep).getNavigationFilterType() == 4 && actionType == 6 && elementName.equals(((DataItemNavigationFilter)lastStep).getNavigationName())) {
                    return i;
                }
                if (actionType == 0) break;
            }
        }
        return -1;
    }

    public Object getMapViewer() {
        return this.mapViewer;
    }

    public void setMapViewer(Object mapViewer) {
        this.mapViewer = mapViewer;
    }

    public int getClickX() {
        return this.clickX;
    }

    public void setClickX(int clickX) {
        this.clickX = clickX;
    }

    public int getClickY() {
        return this.clickY;
    }

    public void setClickY(int clickY) {
        this.clickY = clickY;
    }
}

