/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.batchsec.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.olapadmin.batchsec.model.GenerateCode;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.utilities.ExportCodeDialog;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.models.ISimpleObjectHierarchyElement;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectHierarchyModel;
import com.sas.workspace.models.tree.inventory.CubeElement;
import com.sas.workspace.models.tree.inventory.OLAPSchemaElement;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;

public class PermTableImportTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(PermTableImportTab.class);
    private ObjectSelectorPanel selector;
    private MdObjectStore m_store;

    public PermTableImportTab() {
        super(bundle.getString("NewPermTableWizard.Import.instructions.txt"));
        this.setHelpProduct("shared");
        this.setHelpTopic("security_batch_import");
        this._layoutWidgets();
    }

    private void _layoutWidgets() {
        this.setLayout(new GridBagLayout());
        UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
        this.selector = new ObjectSelectorPanel(userContext, -1);
        String[] visibleTypes = new String[]{"Cube", "OLAPSchema", "Folder"};
        String[] selectableTypes = new String[]{"Cube", "OLAPSchema"};
        this.selector.setVisibleTypes(visibleTypes);
        this.selector.setInventoryTypes(selectableTypes);
        this.selector.setSelectableTypes(selectableTypes);
        try {
            SimpleObjectHierarchyModel hierarchyModel = new SimpleObjectHierarchyModel(userContext.getAuthServer());
            hierarchyModel.addElement((ISimpleObjectHierarchyElement)new OLAPSchemaElement(), "OLAPSchema");
            hierarchyModel.addElement((ISimpleObjectHierarchyElement)new CubeElement(), "Cube");
            this.selector.setAdditionalHierarchyModel((ISimpleObjectHierarchyModel)hierarchyModel);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
        this.add((Component)this.selector, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    public String createFinishString() {
        StringBuffer temp = new StringBuffer();
        SimpleObject item = this.selector.getSelectedObject();
        if (item != null) {
            String name = item.getName();
            String type = item.getMetadataType();
            if (type.equals("Cube")) {
                String schemaName = this.getOLAPSchemaName();
                temp.append(bundle.formatString("NewPermTableWizard.OLAPSch.fmt.txt", (Object)schemaName));
                temp.append(GenerateCode.newline);
                temp.append(bundle.formatString("NewPermTableWizard.FIcubex.fmt.txt", (Object)name));
            } else if (type.equals("OLAPSchema")) {
                temp.append(bundle.formatString("NewPermTableWizard.FIschem.fmt.txt", (Object)name));
            }
        }
        return temp.toString();
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        this.m_store = (MdObjectStore)parent.getWizardData("OBJECTSTORE");
        this.selector.doDataExchange(saveToModel);
        if (saveToModel) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            PhysicalTable table = (PhysicalTable)parent.getWizardData("MASTEROBJECT");
            this.addCustomAssociation(table);
            String str1 = bundle.getString("NewPermTableWizard.RegisterProgress.window.title");
            String str2 = bundle.getString("NewPermTableWizard.RegisterProgress.txt");
            UpdateMetadata updateMetadata = new UpdateMetadata(table);
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str2, str1);
            request.setProgressShownOnStatusBar(false);
            request.execute((Runnable)updateMetadata);
            boolean metadataOK = updateMetadata.getStatus();
            parent.removeWizardData("MASTEROBJECT");
            if (metadataOK) {
                String tableName = table.getSASTableName();
                SASLibrary lib = LibraryUtil.getLibrary((DataTable)table, null);
                WsAppServer server = WsRunCode.getServer();
                if (server == null) {
                    StringBuffer code = GenerateCode.getExportCode((SASLibrary)lib, (String)tableName, (String)this.getCubeName(), (String)this.getOLAPSchemaName(), ((Object)((Object)this)).getClass(), (boolean)false);
                    this.handleNoServer(code);
                } else {
                    WsRunCode runCode = new WsRunCode(server);
                    if (runCode.hasSubmitError) {
                        StringBuffer code = GenerateCode.getExportCode((SASLibrary)lib, (String)tableName, (String)this.getCubeName(), (String)this.getOLAPSchemaName(), ((Object)((Object)this)).getClass(), (boolean)false);
                        this.handleNoServer(code);
                    } else {
                        StringBuffer code = GenerateCode.getExportCode((SASLibrary)lib, (String)tableName, (String)this.getCubeName(), (String)this.getOLAPSchemaName(), ((Object)((Object)this)).getClass(), (boolean)true);
                        runCode.showLogMessagesInDetails(true);
                        str1 = bundle.getString("NewPermTableWizard.CreateProgress.window.title");
                        str2 = bundle.getString("NewPermTableWizard.CreateProgress.txt");
                        boolean submitError = runCode.executeCode(code, str2, str1);
                        if (submitError) {
                            Utilities.displayNonCriticalMessage((String)bundle.getString("NewPermTableWizard.TableCreationError.txt"));
                        } else {
                            Utilities.displayNonCriticalMessage((String)bundle.getString("NewPermTableWizard.Import.CodeRanSuccessfully.txt"));
                        }
                    }
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        return true;
    }

    private void addCustomAssociation(PhysicalTable table) throws RemoteException {
        try {
            String id = table.getRepositoryID();
            AssociationList listOfCustomAssociations = table.getCustomAssociations();
            CustomAssociation custAssociation = (CustomAssociation)MetadataTemplate.createMetadata((MdObjectStore)this.m_store, (String)"CustomAssociation", (String)id);
            custAssociation.setName(table.getSASTableName());
            custAssociation.setisOwned(0);
            custAssociation.setPartnerName("PermissionTableObject");
            custAssociation.setDesc("PermissionTableObject");
            listOfCustomAssociations.add((Object)custAssociation);
            AssociationList listOfAssociatedObjects = custAssociation.getAssociatedObjects();
            SimpleObject item = this.selector.getSelectedObject();
            if (item != null) {
                String type = item.getMetadataType();
                if (type.equals("Cube")) {
                    Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(this.m_store, item);
                    listOfAssociatedObjects.add((Object)cube);
                } else if (type.equals("OLAPSchema")) {
                    OLAPSchema schema = (OLAPSchema)ObjectConverter.getInstance().convertToJOMAObject(this.m_store, item);
                    listOfAssociatedObjects.add((Object)schema);
                }
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
    }

    private void handleNoServer(StringBuffer code) {
        String message = null;
        message = this.selector.getSelectedObject() == null ? bundle.getString("NewPermTableWizard.Import.Finish.NoServer.NoObject.txt") : bundle.getString("NewPermTableWizard.Import.Finish.NoServer.Object.txt");
        int optionSelected = MessageUtil.displayMessage((String)message, (String)Utilities.getMessageWindowTitle(), (int)1, (int)0);
        if (optionSelected == 0) {
            ExportCodeDialog dialog = new ExportCodeDialog(bundle.getString("Common.ExportCodePanel.instructions.txt"), code, null);
            dialog.show();
        }
    }

    public String getCubeName() {
        SimpleObject item = this.selector.getSelectedObject();
        String cubeName = null;
        if (item != null) {
            String name = item.getName();
            String type = item.getMetadataType();
            if (type.equals("Cube")) {
                cubeName = name;
            }
        }
        return cubeName;
    }

    public String getOLAPSchemaName() {
        SimpleObject item = this.selector.getSelectedObject();
        String schemaName = null;
        if (item != null) {
            String name = item.getName();
            String type = item.getMetadataType();
            if (type.equals("Cube")) {
                try {
                    Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(this.m_store, item);
                    OLAPSchema schema = cube.getAssociatedOLAPSchema();
                    if (schema != null) {
                        schemaName = schema.getName();
                    }
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                }
            } else if (type.equals("OLAPSchema")) {
                schemaName = name;
            }
        }
        return schemaName;
    }

    public boolean validateData() {
        return true;
    }

    class UpdateMetadata
    implements Runnable {
        private PhysicalTable table;
        private boolean status;

        public UpdateMetadata(PhysicalTable metadata) {
            this.table = metadata;
        }

        @Override
        public void run() {
            try {
                this.table.updateMetadataAll();
                this.status = true;
            }
            catch (RemoteException e) {
                this.status = false;
            }
            catch (MdException e) {
                this.status = false;
            }
        }

        public boolean getStatus() {
            return this.status;
        }
    }
}

