/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.batchsec.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.batchsec.model.GenerateCode;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.utilities.ComparableObject;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.services.information.metadata.OMRPhysicalTable;
import com.sas.services.information.metadata.PathUrl;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public class PermTableGeneralTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static final String MEMBER_TYPE = "DATA";
    private static final WAdminResource bundle = new WAdminResource(PermTableGeneralTab.class);
    private MdObjectStore store;
    private WATextField name;
    private WATextArea description;
    private WATextField location;
    private WAComboBox library;
    private WATextField sasTableName;
    private Tree folder;
    private String selectedID;
    protected static final Filter m_browseFilter = new Filter();

    public PermTableGeneralTab() {
        super(bundle.getString("NewPermTableWizard.General.instructions.txt"));
        this.setHelpProduct("shared");
        this.setHelpTopic("security_batch_add");
        this._layoutWidgets();
    }

    public String createFinishString() {
        StringBuffer temp = new StringBuffer();
        temp.append(bundle.formatString("NewPermTableWizard.FIgroup.fmt.txt", (Object)this.location.getText()));
        temp.append(GenerateCode.newline);
        temp.append(bundle.formatString("NewPermTableWizard.FInamex.fmt.txt", (Object)this.name.getText()));
        temp.append(GenerateCode.newline);
        temp.append(bundle.formatString("NewPermTableWizard.FIsasds.fmt.txt", (Object)this.sasTableName.getText()));
        temp.append(GenerateCode.newline);
        try {
            temp.append(bundle.formatString("NewPermTableWizard.FIlbnam.fmt.txt", (Object)this.getLib().getName()));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        temp.append(GenerateCode.newline);
        return temp.toString();
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (!saveToModel) {
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public SASLibrary getLib() {
        SASLibrary lib = null;
        ComparableObject selectedObj = (ComparableObject)this.library.getSelectedItem();
        if (selectedObj == null) {
            return lib;
        }
        SimpleBrowseObject simpleObj = selectedObj.getObject();
        try {
            lib = (SASLibrary)ObjectConverter.getInstance().convertToJOMAObject(this.store, (SimpleObject)simpleObj);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return lib;
    }

    public String getTableName() {
        return this.sasTableName.getText();
    }

    private void _layoutWidgets() {
        this.name = new WATextField();
        this.name.setMaxCharacters(60);
        JLabel lblName = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)lblName, (String)bundle.getString("NewPermTableWizard.General.name.control.label"));
        lblName.setLabelFor((Component)this.name);
        this.listenForDataChangesTo((JTextComponent)this.name);
        this.description = new WATextArea();
        this.description.setMaxCharacters(200);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setRows(5);
        this.description.setColumns(30);
        JLabel lblDescription = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)lblDescription, (String)bundle.getString("NewPermTableWizard.General.description.control.label"));
        lblDescription.setLabelFor((Component)this.description);
        JScrollPane scrDescription = new JScrollPane((Component)this.description, 20, 31);
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)scrDescription);
        this.listenForDataChangesTo((JTextComponent)this.description);
        this.location = new WATextField();
        this.location.setBehavior(2);
        JLabel lblLocation = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)lblLocation, (String)bundle.getString("NewPermTableWizard.General.location.control.label"));
        lblLocation.setLabelFor((Component)this.location);
        JButton selectLocation = new JButton();
        Utilities.setButtonTextAndMnemonic((AbstractButton)selectLocation, (String)bundle.getString("NewPermTableWizard.General.selectLocation.action.label"));
        selectLocation.addActionListener(new SelectFolderButtonsListener());
        JLabel libLabel = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)libLabel, (String)bundle.getString("NewPermTableWizard.General.library.control.label"));
        this.library = new WAComboBox();
        libLabel.setLabelFor((Component)this.library);
        JButton newLibrary = new JButton();
        Utilities.setButtonTextAndMnemonic((AbstractButton)newLibrary, (String)bundle.getString("NewPermTableWizard.General.newLibrary.action.label"));
        newLibrary.addActionListener(new NewLibraryButtonListener());
        this.sasTableName = new WATextField();
        this.name.setMaxCharacters(32);
        JLabel lblsasTableName = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)lblsasTableName, (String)bundle.getString("NewPermTableWizard.General.sasTableName.control.label"));
        lblsasTableName.setLabelFor((Component)this.sasTableName);
        this.listenForDataChangesTo((JTextComponent)this.sasTableName);
        this.setLayout(new GridBagLayout());
        scrDescription.setMinimumSize(scrDescription.getPreferredSize());
        this.add(lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.name, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(lblDescription, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(scrDescription, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(lblLocation, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.location, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(selectLocation, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(libLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.library, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(newLibrary, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(lblsasTableName, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.sasTableName, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToStore() throws MdException, RemoteException {
        SASLibrary lib;
        String id = this.folder.getRepositoryID();
        String tableTrimName = this.name.getText().trim();
        PhysicalTable newTable = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(this.store, tableTrimName, "PhysicalTable", id);
        newTable.setPublicType("Table");
        newTable.setUsageVersion(OMRPhysicalTable.CURRENT_VERSION.encode());
        WsMetadataUtil.updateModifiedByFor((Root)newTable);
        newTable.setDesc(this.description.getText());
        newTable.setMemberType(MEMBER_TYPE);
        newTable.setIsCompressed(0);
        newTable.setIsEncrypted(0);
        newTable.setSASTableName(this.sasTableName.getText().trim());
        newTable.setTableName(tableTrimName);
        newTable.setName(tableTrimName);
        newTable.setNumRows(-1.0);
        Role role = (Role)Workspace.getMdFactory().createComplexMetadataObject(this.store, "OLAPRole", "Role", id);
        role.setObjectRole("OLAP CUBE PERMISSIONS");
        AssociationList roles = newTable.getRoles();
        roles.add((Object)role);
        SASLibrary mySchema = lib = this.getLib();
        AssociationList schemas = lib.getUsingPackages();
        int thirdPartyDB = lib.getIsDBMSLibname();
        if (thirdPartyDB == 1 && !schemas.isEmpty() && schemas.get(0) instanceof RelationalSchema) {
            mySchema = (RelationalSchema)schemas.get(0);
        }
        newTable.getTablePackages().add((Object)mySchema);
        newTable.getTrees().add((Object)this.folder);
        AssociationList columns = newTable.getColumns();
        this.createColumn(id, columns, "fullname", 32);
        this.createColumn(id, columns, "olapschema", 32);
        this.createColumn(id, columns, "cube", 32);
        this.createColumn(id, columns, "dimension", 32);
        this.createColumn(id, columns, "items", 32);
        this.createColumn(id, columns, "permission", 32);
        this.createColumn(id, columns, "perm_type", 2);
        this.createColumn(id, columns, "mdx_condition", 32000);
        this.createColumn(id, columns, "remove_ace", 1);
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.addWizardData("MASTEROBJECT", (Object)newTable);
    }

    private void createColumn(String id, AssociationList columns, String colName, int length) throws RemoteException {
        Column newColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(this.store, colName, "Column", id);
        newColumn.setColumnLength(length);
        newColumn.setSASColumnLength(length);
        newColumn.setColumnName(colName);
        newColumn.setSASColumnName(colName);
        newColumn.setSASColumnType("C");
        newColumn.setPublicType("Column");
        newColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
        newColumn.setIsNullable(1);
        columns.add((Object)newColumn);
    }

    public void moveDataToView() {
        try {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            this.store = (MdObjectStore)parent.getWizardData("OBJECTSTORE");
            this.folder = WsMetadataUtil.getDefaultFolder((MdObjectStore)this.store);
            MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
            if (this.folder != null) {
                String pathFolder = mdUtil.getObjectPath((MdObjectStore)this.folder.getObjectStore(), (PrimaryType)this.folder, false);
                this.location.setText(pathFolder);
            }
            this.populateLibraryBox();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)se);
        }
    }

    private void populateLibraryBox() {
        try {
            Filter filter = new Filter("PublicType", 0, "Library");
            filter.setType("SASLibrary");
            filter.setOMRTemplate(m_browseFilter.getOMRTemplate());
            filter.setOMRFlags(m_browseFilter.getOMRFlags() | 0x80 | 0x100 | 0x2000);
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            List lObjects = server.browseSearch((FilterInterface)filter);
            ArrayList<ComparableObject> comparableObjects = new ArrayList<ComparableObject>();
            ComparableObject selectedObject = null;
            for (BrowseMetadataInterface browseObj : lObjects) {
                SimpleBrowseObjectImpl simpleObj = new SimpleBrowseObjectImpl(browseObj);
                ComparableObject thisObj = new ComparableObject((SimpleBrowseObject)simpleObj);
                comparableObjects.add(thisObj);
                String thisID = simpleObj.getID();
                if (!thisID.equalsIgnoreCase(this.selectedID)) continue;
                selectedObject = thisObj;
            }
            Collections.sort(comparableObjects);
            this.library.addItems(comparableObjects);
            if (selectedObject != null) {
                this.library.setSelectedItem(selectedObject);
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public boolean validateData() {
        String message = null;
        String nameStr = this.name.getText();
        String currentTableName = this.sasTableName.getText();
        StringBuffer validSASName = ModelUtilities.getSasName((String)currentTableName);
        SASLibrary libraryObject = this.getLib();
        try {
            MdFactory factory;
            MdSecurityUtil securityUtil;
            ModelUtilities.verifyPublicTypeName((String)nameStr);
            if (this.folder == null) {
                message = bundle.getString("NewPermTableWizard.General.NoFolderLocation.txt");
            }
            if (!(securityUtil = (factory = this.store.getFactory()).getSecurityUtil()).isFolderWriteAuthorized(this.folder.getId())) {
                message = bundle.formatString("NewPermTableWizard.General.OLAPCube.NoWriteFolder.fmt.txt", (Object)this.folder.getName());
            } else if (!WsMetadataNameUtil.isNameUniqueInFolder((String)this.name.getText(), (Tree)this.folder, (String)"PhysicalTable")) {
                message = bundle.getString("NewPermTableWizard.General.DuplicateName.txt");
            } else if (libraryObject == null) {
                message = bundle.getString("NewPermTableWizard.General.NoLibrary.txt");
            } else if (!securityUtil.isWriteAuthorized("SASLibrary", libraryObject.getId())) {
                message = bundle.formatString("NewPermTableWizard.General.OLAPCube.NoWriteLibrary.fmt.txt", (Object)libraryObject.getName());
            } else if (Utilities.isBlank((String)currentTableName)) {
                message = bundle.getString("NewPermTableWizard.General.NoSASTableName.txt");
            } else if (currentTableName.length() > 32) {
                message = bundle.getString("NewPermTableWizard.General.SASTableName.NotValid.txt");
            } else if (!currentTableName.equalsIgnoreCase(validSASName.toString())) {
                message = bundle.getString("NewPermTableWizard.General.SASTableName.NotValidChars.txt");
            }
        }
        catch (RemoteException remote) {
            message = remote.getLocalizedMessage();
        }
        catch (MdException md) {
            message = md.getLocalizedMessage();
        }
        catch (OLAPException e) {
            message = e.getLocalizedMessage();
        }
        boolean dataOK = Utilities.isBlank((String)message);
        if (!dataOK) {
            Utilities.displayNonCriticalMessage((String)message);
        }
        return dataOK;
    }

    static {
        m_browseFilter.setOMRTemplate("<Templates><Root Name=\"\" PublicType=\"\" ChangeState=\"\" LockedBy=\"\" /></Templates>");
        m_browseFilter.setOMRFlags(-2147483628);
    }

    private class SelectFolderButtonsListener
    implements ActionListener {
        private SelectFolderButtonsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                try {
                    PathUrl pathUrl;
                    ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                    String sPathWithType = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)PermTableGeneralTab.this.folder.getObjectStore(), (PrimaryType)PermTableGeneralTab.this.folder, true);
                    PathUrl m_pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)sPathWithType);
                    String sInitialPath = null;
                    if (m_pathUrl != null) {
                        sInitialPath = m_pathUrl.toString();
                    }
                    if ((pathUrl = WsMetadataUtil.promptForPathUrl((String)sInitialPath, (boolean)false, null)) != null) {
                        MetadataInterface metadataObject = Workspace.getWorkspace().getInformationService().getObjectByPath(Workspace.getWorkspace().getUserContext(), pathUrl);
                        PermTableGeneralTab.this.folder = (Tree)metadataObject.getRepositoryEntity();
                        MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                        if (PermTableGeneralTab.this.folder != null) {
                            String pathFolder = mdUtil.getObjectPath((MdObjectStore)PermTableGeneralTab.this.folder.getObjectStore(), (PrimaryType)PermTableGeneralTab.this.folder, false);
                            PermTableGeneralTab.this.location.setText(pathFolder);
                        }
                    }
                }
                catch (RemoteException e) {
                    ExceptionHandler.handleException((Exception)e);
                }
                catch (MdException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
                catch (ServiceException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
        }
    }

    private class NewLibraryButtonListener
    implements ActionListener {
        private NewLibraryButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                MdObjectStore store = null;
                try {
                    Library library;
                    Workspace workspace = Workspace.getWorkspace();
                    store = Workspace.getMdFactory().createObjectStore(null, "newLibraryWizardStore");
                    Tree folder = WsMetadataUtil.getDefaultFolder((MdObjectStore)store);
                    String repositoryID = "";
                    repositoryID = folder == null ? Workspace.getMdFactory().getOMIUtil().getFoundationReposID() : Workspace.getMdFactory().getOMIUtil().getReposIdFromMetadataObject((CMetadata)folder);
                    LibraryWizard dialog = new LibraryWizard((JFrame)workspace, repositoryID, null, null, store, null, folder);
                    dialog.show();
                    if (!(dialog.getReturnValue() != 1 && dialog.getReturnValue() != 3 || (library = (Library)dialog.getWizardData("Library")) == null || library.getDeployedDataPackage().isNewObject())) {
                        SASLibrary sasLibraryObject = (SASLibrary)library.getDeployedDataPackage();
                        PermTableGeneralTab.this.selectedID = sasLibraryObject.getFQID();
                        PermTableGeneralTab.this.populateLibraryBox();
                    }
                }
                catch (RemoteException e) {
                    ExceptionHandler.handleException((Exception)e);
                }
                catch (MdException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                catch (ServiceException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
                finally {
                    try {
                        if (store != null) {
                            store.dispose();
                        }
                    }
                    catch (RemoteException e) {
                        ExceptionHandler.handleException((Exception)e);
                    }
                }
            }
        }
    }
}

