/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.batchsec.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.olapadmin.batchsec.model.GenerateCode;
import com.sas.olapadmin.batchsec.visuals.PhysicalTablePanelEdit;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.ExportCodeDialog;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.wadmin.viewdata2.DataManager;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataTable;
import com.sas.wadmin.viewdata2.impl.PhysicalTableEditFactory;
import com.sas.wadmin.viewdata2.impl.PhysicalTablePanel;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ModifyBulkPermissions
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(ModifyBulkPermissions.class);
    private PhysicalTable table;
    private boolean loadFromCube;
    private String nameOfLoadObject;
    private JButton reloadButton;
    private JButton runButton;
    private JButton removeButton;
    private JButton exportCode;
    protected PhysicalTablePanelEdit permission;
    private Cube cubeObject;
    private OLAPSchema schemaObject;
    private SASLibrary library;
    private String tableName;
    private String libref;

    public ModifyBulkPermissions(PhysicalTable inTable) {
        this.table = inTable;
        this.setLayout(new GridBagLayout());
        this.initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    protected void initialize() {
        try {
            CustomAssociation customAss;
            AssociationList assObjects;
            AssociationList listOfCustomAssociations = this.table.getCustomAssociations();
            if (!listOfCustomAssociations.isEmpty() && !(assObjects = (customAss = (CustomAssociation)listOfCustomAssociations.get(0)).getAssociatedObjects()).isEmpty()) {
                CMetadata whichObject = (CMetadata)assObjects.get(0);
                if (whichObject instanceof Cube) {
                    this.loadFromCube = true;
                    this.cubeObject = (Cube)whichObject;
                } else if (whichObject instanceof OLAPSchema) {
                    this.schemaObject = (OLAPSchema)whichObject;
                }
                this.nameOfLoadObject = whichObject.getName();
            }
            this.tableName = this.table.getSASTableName();
            this.library = LibraryUtil.getLibrary((DataTable)this.table, null);
            this.libref = this.library.getLibref();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
    }

    public PhysicalTablePanelEdit getPermissionPanel() {
        return this.permission;
    }

    public void moveDataToView() {
        try {
            this.permission.moveDataToView();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
    }

    private void _layoutWidgets() {
        TitledBorder titledBorder1 = new TitledBorder(bundle.getString("ModifyBulkPermissions.Reload.groupbox.title"));
        WAPanel reload = new WAPanel();
        reload.setLayout((LayoutManager)new GridBagLayout());
        reload.setBorder((Border)titledBorder1);
        JLabel label_loadFrom = new JLabel();
        this.reloadButton = new JButton();
        this.reloadButton.setName("reload");
        this.reloadButton.setToolTipText(bundle.getString("ModifyBulkPermissions.Reload.action.label.tip"));
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.reloadButton, (String)bundle.getString("ModifyBulkPermissions.Reload.action.label"));
        this.reloadButton.addActionListener(new ReloadListener());
        if (ModelUtilities.isBlank((String)this.nameOfLoadObject)) {
            label_loadFrom.setText(bundle.getString("ModifyBulkPermissions.LoadFromNothing.txt"));
            reload.add((Component)label_loadFrom, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.reloadButton.setEnabled(false);
        } else {
            if (this.loadFromCube) {
                label_loadFrom.setText(bundle.getString("ModifyBulkPermissions.LoadFromCube.txt"));
            } else {
                label_loadFrom.setText(bundle.getString("ModifyBulkPermissions.LoadFromOLAPSchema.txt"));
            }
            JLabel label_Name = new JLabel(this.nameOfLoadObject);
            reload.add((Component)label_loadFrom, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            reload.add((Component)label_Name, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        JLabel table_label = new JLabel(bundle.getString("ModifyBulkPermissions.TableName.txt"));
        JLabel tableName_Label = new JLabel(this.libref + "." + this.tableName);
        reload.add((Component)table_label, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        reload.add((Component)tableName_Label, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        reload.add((Component)this.reloadButton, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        TitledBorder titledBorder2 = new TitledBorder(bundle.getString("ModifyBulkPermissions.BulkPermissionTable.groupbox.title"));
        this.permission = new PhysicalTablePanelEdit(this.table, PhysicalTablePanel.Mode.EDIT);
        this.permission.setPreferredSize(new Dimension(500, 500));
        this.permission.setLayout(new GridBagLayout());
        this.permission.setBorder(titledBorder2);
        this.runButton = new JButton();
        this.runButton.setName("runPermission");
        this.runButton.setToolTipText(bundle.getString("ModifyBulkPermissions.Run.action.label.tip"));
        this.runButton.addActionListener(new RunListener());
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.runButton, (String)bundle.getString("ModifyBulkPermissions.Run.action.label.txt"));
        this.exportCode = new JButton();
        this.exportCode.setName("exportcodePermission");
        this.exportCode.setToolTipText(bundle.getString("ModifyBulkPermissions.ExportCode.action.label.tip"));
        this.exportCode.addActionListener(new ExportCodeListener());
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.exportCode, (String)bundle.getString("ModifyBulkPermissions.ExportCode.action.label.txt"));
        this.removeButton = new JButton();
        this.removeButton.setName("removePermission");
        this.removeButton.setToolTipText(bundle.getString("ModifyBulkPermissions.Remove.action.label.tip"));
        this.removeButton.addActionListener(new RemoveListener());
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.removeButton, (String)bundle.getString("ModifyBulkPermissions.Remove.action.label"));
        WAPanel runExport = new WAPanel();
        runExport.setLayout((LayoutManager)new GridBagLayout());
        runExport.add((Component)this.runButton, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        runExport.add((Component)this.exportCode, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 20, 0, 5), 0, 0));
        WAPanel buttonPanel = new WAPanel();
        buttonPanel.setLayout((LayoutManager)new GridBagLayout());
        buttonPanel.add((Component)this.removeButton, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)reload, new GridBagConstraints(0, 0, 3, 3, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)((Object)this.permission), new GridBagConstraints(0, 3, 3, 3, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)runExport, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    public void onParentOK() {
        ViewDataTable table = this.permission.getFactory().getDefaultTable();
        if (table != null) {
            table.commitEditRow();
        }
    }

    private void handleNoServer(StringBuffer code) {
        String message = bundle.getString("ModifyBulkPermissions.ApplicationServer.down.txt");
        int optionSelected = MessageUtil.displayMessage((String)message, (String)Utilities.getMessageWindowTitle(), (int)1, (int)0);
        if (optionSelected == 0) {
            ExportCodeDialog dialog = new ExportCodeDialog(bundle.getString("Common.ExportCodePanel.instructions.txt"), code, null);
            dialog.show();
        }
    }

    class UpdateMetadata
    implements Runnable {
        private PhysicalTable table;
        private boolean status;

        public UpdateMetadata(PhysicalTable metadata) {
            this.table = metadata;
        }

        @Override
        public void run() {
            try {
                this.table.updateMetadataAll();
                this.status = true;
            }
            catch (RemoteException e) {
                this.status = false;
            }
            catch (MdException e) {
                this.status = false;
            }
        }

        public boolean getStatus() {
            return this.status;
        }
    }

    private class ExportCodeListener
    implements ActionListener {
        private ExportCodeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Vector paths = Utilities.getBatchSecurityPaths();
            Class<?> thisClass = this.getClass();
            StringBuffer code = GenerateCode.getImportCode((SASLibrary)ModifyBulkPermissions.this.library, (String)ModifyBulkPermissions.this.tableName, thisClass, (boolean)false);
            ExportCodeDialog dialog = new ExportCodeDialog(bundle.getString("Common.ExportCodePanel.Import.instructions.txt"), code, paths);
            dialog.show();
            Utilities.setBatchSecurityPaths((Vector)paths);
        }
    }

    private class RunListener
    implements ActionListener {
        private RunListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                ViewDataTable table = ModifyBulkPermissions.this.permission.getFactory().getDefaultTable();
                if (table != null) {
                    table.commitEditRow();
                }
                ModifyBulkPermissions.this.setCursor(Cursor.getPredefinedCursor(3));
                ModifyBulkPermissions.this.permission.clearAllEdit();
                WsAppServer server = WsRunCode.getServer();
                if (server == null) {
                    StringBuffer code = GenerateCode.getImportCode((SASLibrary)ModifyBulkPermissions.this.library, (String)ModifyBulkPermissions.this.tableName, this.getClass(), (boolean)false);
                    ModifyBulkPermissions.this.handleNoServer(code);
                } else {
                    StringBuffer code = GenerateCode.getImportCode((SASLibrary)ModifyBulkPermissions.this.library, (String)ModifyBulkPermissions.this.tableName, this.getClass(), (boolean)true);
                    WsRunCode runCode = new WsRunCode(server);
                    if (runCode.hasSubmitError) {
                        ModifyBulkPermissions.this.handleNoServer(code);
                    } else {
                        runCode.showLogMessagesInDetails(true);
                        String str1 = bundle.getString("NewPermTableWizard.RegisterProgress.window.title");
                        String str2 = bundle.getString("NewPermTableWizard.RegisterProgress.txt");
                        boolean submitError = runCode.executeCode(code, str2, str1);
                        String processingProblems = server.getMacroVariableValue("ErrorProcessing");
                        if (!submitError && processingProblems != null) {
                            if (processingProblems.equals("0")) {
                                Utilities.displayNonCriticalMessage((String)bundle.getString("ManagePermissionTab.Apply.RanSuccessful.txt"));
                            } else if (processingProblems.equals("1")) {
                                Utilities.displayNonCriticalMessage((String)bundle.getString("ModifyBulkPermissions.Apply.ProcessingErrors.txt"));
                            }
                        }
                    }
                }
                ModifyBulkPermissions.this.permission.moveDataToView();
                ModifyBulkPermissions.this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (SQLException e) {
                ExceptionHandler.handleException((Exception)e);
                ModifyBulkPermissions.this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (WsAppServerFailException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
                ModifyBulkPermissions.this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                ModifyBulkPermissions.this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                ModifyBulkPermissions.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PhysicalTableEditFactory factory = (PhysicalTableEditFactory)ModifyBulkPermissions.this.permission.getFactory();
            ViewDataTable table = factory.getDefaultTable();
            ViewDataModel model = factory.getDefaultModel();
            int[] rowsSelected = table.getSelectedRowsFromSelectedCells();
            int howManySelected = rowsSelected.length;
            if (howManySelected < 1) {
                MessageUtil.displayMessage((String)bundle.getString("ModifyBulkPermissions.Remove.NothingSelected.txt"), (String)Utilities.getMessageWindowTitle(), (int)1, (int)-1);
            } else {
                int whereRemove = model.getColumnCount();
                int removeColumn = whereRemove - 1;
                DataManager manager = model.getDataManager();
                int maxRowCount = manager.getMaxRowCountYet();
                for (int i = 0; i < howManySelected; ++i) {
                    int row = rowsSelected[i];
                    if (row >= maxRowCount) {
                        i = howManySelected;
                        return;
                    }
                    String currentValue = (String)model.getValueAt(row, removeColumn);
                    if (!currentValue.equalsIgnoreCase("Y")) {
                        model.setValueAt((Object)"Y", row, removeColumn);
                        continue;
                    }
                    model.setValueAt((Object)"N", row, removeColumn);
                }
            }
        }
    }

    private class ReloadListener
    implements ActionListener {
        private ReloadListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int option = MessageUtil.displayMessage((String)bundle.getString("ModifyBulkPermissions.Reload.action.warning.txt"), (int)1, (int)0);
            if (option == 0) {
                try {
                    ModifyBulkPermissions.this.permission.clearAllEdit();
                    ModifyBulkPermissions.this.setCursor(Cursor.getPredefinedCursor(3));
                    String tableName = ModifyBulkPermissions.this.table.getSASTableName();
                    SASLibrary lib = LibraryUtil.getLibrary((DataTable)ModifyBulkPermissions.this.table, null);
                    String cubeName = null;
                    String schemaName = null;
                    if (ModifyBulkPermissions.this.cubeObject != null) {
                        cubeName = ModifyBulkPermissions.this.nameOfLoadObject;
                        schemaName = ModifyBulkPermissions.this.cubeObject.getAssociatedOLAPSchema().getName();
                    } else {
                        schemaName = ModifyBulkPermissions.this.nameOfLoadObject;
                    }
                    WsAppServer server = WsRunCode.getServer();
                    if (server == null) {
                        StringBuffer code = GenerateCode.getExportCode((SASLibrary)lib, (String)tableName, (String)cubeName, (String)schemaName, this.getClass(), (boolean)false);
                        ModifyBulkPermissions.this.handleNoServer(code);
                    } else {
                        WsRunCode runCode = new WsRunCode(server);
                        if (runCode.hasSubmitError) {
                            StringBuffer code = GenerateCode.getExportCode((SASLibrary)lib, (String)tableName, (String)cubeName, (String)schemaName, this.getClass(), (boolean)false);
                            ModifyBulkPermissions.this.handleNoServer(code);
                        } else {
                            StringBuffer code = GenerateCode.getExportCode((SASLibrary)lib, (String)tableName, (String)cubeName, (String)schemaName, this.getClass(), (boolean)true);
                            runCode.showLogMessagesInDetails(true);
                            String str1 = bundle.getString("ModifyBulkPermissions.ReloadProgress.window.title");
                            String str2 = bundle.getString("ModifyBulkPermissions.ReloadProgress.txt");
                            boolean submitError = runCode.executeCode(code, str2, str1);
                            if (!submitError) {
                                Utilities.displayNonCriticalMessage((String)bundle.getString("ModifyBulkPermssionTables.ReloadCodeRanSuccessful.txt"));
                            }
                        }
                    }
                    ModifyBulkPermissions.this.permission.moveDataToView();
                    ModifyBulkPermissions.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                    ModifyBulkPermissions.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                    ModifyBulkPermissions.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }
}

