/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.localsvc;

import com.sas.batch.core.AbstractBatchUtility2;
import com.sas.batch.localsvc.RB;
import com.sas.codepolicy.SASScopeExtension;
import com.sas.services.ServiceException;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.deployment.Environment;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.security.ConnectionProfile;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

@SASScopeExtension(value="sas")
public abstract class LocalServicesBatchUtility2
extends AbstractBatchUtility2 {
    public static final String OPTION_HOST = "host";
    public static final String OPTION_PORT = "port";
    public static final String OPTION_USER = "user";
    public static final String OPTION_PASSWORD = "password";
    public static final String OPTION_DOMAIN = "domain";
    public static final String OPTION_PROFILE = "profile";
    private LocalServicesBatchUtility2 parent = null;
    protected SessionContextInterface session;
    protected MetadataServerInterface metadataServer;
    protected UserContextInterface user;
    private ConnectionProfile connectionProfile = null;
    private boolean isPrivateServiceDeployment = false;

    public void setConnection(String host, String port) {
        this.connectionProfile = ConnectionProfile.newProfile((String)host, (String)port);
    }

    public void setConnection(SessionContextInterface session) throws ServiceException, RemoteException {
        this.session = session;
    }

    public void setConnectionProfile(String profile) throws IOException {
        this.connectionProfile = ConnectionProfile.loadProfile((String)profile);
    }

    public void setCredential(String user, String password) {
        if (this.connectionProfile == null) {
            throw new IllegalStateException("Connection profile has not been initialized.");
        }
        this.connectionProfile.setProperty("userid", user);
        this.connectionProfile.setProperty(OPTION_PASSWORD, password);
    }

    public void setDomain(String domain) {
        if (this.connectionProfile == null) {
            throw new IllegalStateException("Connection profile has not been initialized.");
        }
        this.connectionProfile.setProperty("authenticationdomain", domain);
    }

    public void setParent(LocalServicesBatchUtility2 parent) {
        this.parent = parent;
    }

    public abstract int execute() throws Exception;

    public void executeBatch(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        try {
            if (!this.parse(args)) {
                return;
            }
            this.initializeBatchLogging();
            this.logStart();
            this.execute();
        }
        catch (Exception e) {
            this.logException(e);
        }
        this.logCompletion();
        this.terminateBatchLogging();
        System.exit(this.getReturnCode());
    }

    protected String getApplicationNameForLogging() {
        String version = ((Object)((Object)this)).getClass().getPackage().getSpecificationVersion();
        if (version == null) {
            version = Message.class.getPackage().getSpecificationVersion();
        }
        if (version == null) {
            return this.utilityName + " (unknown)";
        }
        return this.utilityName + " " + version;
    }

    protected void initializeBatchLogging() {
        super.initializeBatchLogging();
        if (this.debug) {
            Configurator.setLevel((String)"com.sas.services", (Level)Level.DEBUG);
        }
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_HOST, true, RB.getStringResource("LocalServicesBatchUtility.Host.Desc.txt"));
        option.setArgName(RB.getStringResource("LocalServicesBatchUtility.Host.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PORT, true, RB.getStringResource("LocalServicesBatchUtility.Port.Desc.txt"));
        option.setArgName(RB.getStringResource("LocalServicesBatchUtility.Port.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_USER, true, RB.getStringResource("LocalServicesBatchUtility.User.Desc.txt"));
        option.setArgName(RB.getStringResource("LocalServicesBatchUtility.User.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PASSWORD, true, RB.getStringResource("LocalServicesBatchUtility.Pass.Desc.txt"));
        option.setArgName(RB.getStringResource("LocalServicesBatchUtility.Pass.ArgName.txt"));
        commandLineOptions.addOption(option);
        if (!forHelpText) {
            option = new Option(OPTION_DOMAIN, true, RB.getStringResource("LocalServicesBatchUtility.Domain.Desc.txt"));
            option.setArgName(RB.getStringResource("LocalServicesBatchUtility.Domain.ArgName.txt"));
            option.setRequired(false);
            commandLineOptions.addOption(option);
        }
        option = new Option(OPTION_PROFILE, true, RB.getStringResource("LocalServicesBatchUtility.Profile.Desc.txt"));
        option.setArgName(RB.getStringResource("LocalServicesBatchUtility.Profile.ArgName.txt"));
        commandLineOptions.addOption(option);
        return commandLineOptions;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        if (this.commandLine.hasOption(OPTION_PROFILE)) {
            try {
                this.setConnectionProfile(this.commandLine.getOptionValue(OPTION_PROFILE));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.commandLine.hasOption(OPTION_USER)) {
                this.setCredential(this.commandLine.getOptionValue(OPTION_USER), this.commandLine.getOptionValue(OPTION_PASSWORD));
            }
        } else {
            if (!this.commandLine.hasOption(OPTION_HOST)) {
                throw new MissingOptionException(RB.getStringResource("LocalServicesBatchUtility.MissingHostOption.txt"));
            }
            if (!this.commandLine.hasOption(OPTION_PORT)) {
                throw new MissingOptionException(RB.getStringResource("LocalServicesBatchUtility.MissingPortOption.txt"));
            }
            if (!this.commandLine.hasOption(OPTION_USER) || !this.commandLine.hasOption(OPTION_PASSWORD)) {
                throw new MissingOptionException(RB.getStringResource("LocalServicesBatchUtility.MissingUserOption.txt"));
            }
            this.setConnection(this.commandLine.getOptionValue(OPTION_HOST), this.commandLine.getOptionValue(OPTION_PORT));
            this.setCredential(this.commandLine.getOptionValue(OPTION_USER), this.commandLine.getOptionValue(OPTION_PASSWORD));
        }
        if (this.commandLine.hasOption(OPTION_DOMAIN)) {
            this.setDomain(this.commandLine.getOptionValue(OPTION_DOMAIN));
        }
        return true;
    }

    protected void initialize() throws ServiceException {
        this.isPrivateServiceDeployment = false;
        try {
            if (this.parent != null) {
                this.session = this.parent.session;
                this.user = this.parent.user;
                this.logger = this.parent.logger;
            } else if (this.session == null) {
                block12: {
                    this.isPrivateServiceDeployment = true;
                    CorePlatformServices.setEnvironment((Environment)this.connectionProfile.getEnvironment());
                    CorePlatformServices.setDefaultServicesConfigurationWithMinimumLogging();
                    CorePlatformServices.startLocalServices();
                    InformationServiceInterface infoService = CorePlatformServices.getInformationService();
                    if (infoService != null) {
                        infoService.setIsolated();
                    }
                    UserServiceInterface userService = CorePlatformServices.getUserService();
                    userService.setGroupLoginEnabled(true);
                    this.user = null;
                    try {
                        String userName = this.connectionProfile.getProperty("userid");
                        if (userName == null || userName.length() == 0) {
                            this.user = userService.newUser(null, this.getApplicationNameForLogging());
                            break block12;
                        }
                        String domain = this.connectionProfile.getDomain();
                        this.user = userService.newUser(this.connectionProfile.getProperty("userid"), this.connectionProfile.getProperty(OPTION_PASSWORD), domain, null, this.getApplicationNameForLogging());
                        if (!this.isLogDecorations() || this.user == null) break block12;
                        this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"LocalServicesBatchUtility.LogConnectionInfo.fmt.txt", (Object)this.connectionProfile.getProperty(OPTION_HOST), (Object)this.connectionProfile.getProperty(OPTION_PORT), (Object)this.connectionProfile.getProperty("userid")));
                    }
                    catch (UserInitializationException e) {
                        this.user = e.getUser();
                        if (!this.debug) break block12;
                        Exception[] exceptions = e.getExceptions();
                        for (int i = 0; i < exceptions.length; ++i) {
                            Exception exception = exceptions[i];
                            exception.printStackTrace(System.out);
                        }
                    }
                }
                if (this.user == null) {
                    throw new ServiceException(RB.getStringResource("LocalServicesBatchUtility.InitError.NoUser.txt"));
                }
                this.session = CorePlatformServices.getSessionService().newSessionContext(this.user);
            } else {
                this.user = this.session.getUserContext();
            }
            this.metadataServer = (MetadataServerInterface)this.user.getAuthServer();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    protected void terminate() throws ServiceException {
        if (this.parent != null) {
            return;
        }
        if (this.isPrivateServiceDeployment) {
            try {
                if (this.session != null) {
                    UserServiceInterface userService = CorePlatformServices.getUserService();
                    if (userService != null) {
                        userService.removeUser(this.session.getUserContext());
                    }
                    this.session.destroy();
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.session = null;
                this.user = null;
                this.metadataServer = null;
            }
            CorePlatformServices.terminateServices();
            this.isPrivateServiceDeployment = false;
        }
    }
}

