/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.io.InputStreamAdapter;
import com.sas.services.ParseException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.HttpServerInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.publish.AbstractTransport;
import com.sas.services.publish.BinaryFileEntryInterface;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.HTMLEncodingParser;
import com.sas.services.publish.HTMLEntryInterface;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.LibraryMemberEntryInterface;
import com.sas.services.publish.ReferenceEntryInterface;
import com.sas.services.publish.ResultPackageEventBuilder;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TextFileEntryInterface;
import com.sas.services.publish.TransportFactory;
import com.sas.services.publish.ViewerEntryInterface;
import com.sas.services.publish.archive.ArchiveTransport;
import com.sas.services.publish.archive.ArchiveTransportInterface;
import com.sas.services.publish.metadata.PackageUtil;
import com.sas.services.publish.webdav.DAVBinaryFileEntry;
import com.sas.services.publish.webdav.DAVDatasetEntry;
import com.sas.services.publish.webdav.DAVEntry;
import com.sas.services.publish.webdav.DAVHTMLEntry;
import com.sas.services.publish.webdav.DAVHTMLFile;
import com.sas.services.publish.webdav.DAVLibraryMemberEntry;
import com.sas.services.publish.webdav.DAVReferenceEntry;
import com.sas.services.publish.webdav.DAVResultPackage;
import com.sas.services.publish.webdav.DAVTextFileEntry;
import com.sas.services.publish.webdav.DAVTransportInterface;
import com.sas.services.publish.webdav.DAVViewerEntry;
import com.sas.services.publish.webdav.RB;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.AttributeMap;
import com.sas.services.util.AttributeMapInterface;
import com.sas.services.util.DateUtil;
import com.sas.services.util.Names;
import com.sas.services.util.URIUtil;
import com.sas.services.webdav.Collection;
import com.sas.services.webdav.CollectionInterface;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.ResourceFactory;
import com.sas.services.webdav.ResourceInterface;
import com.sas.services.webdav.SharedResourceInterface;
import com.sas.text.Message;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class DAVTransport
extends AbstractTransport
implements DAVTransportInterface {
    private static final int V8_ENTRY_VERSION = 15;
    private String _url;
    private String _username;
    private String _password;
    private String _currentUsername;
    private String _currentPassword;
    private int _currRef = 1;
    private String _domain;
    private UserIdentityInterface _userIdentity;
    private Iterator _userIdentities;
    private Map _namespaces;
    private String _proxyUrlStr;
    private URL _proxyUrl;
    private int _role = 1;
    private boolean _asArchive;
    private String _archiveName;
    private InputStream _archiveStream;
    private int _creationMode = 1;
    private static final long DEFAULT_EXPIRATION = 253402318799000L;
    private List repositories;
    private String _authenticationType = "user/password";
    private Logger logger = LogManager.getLogger(DAVTransport.class);

    public DAVTransport(String url, String username, String password, SessionContextInterface sessionContext) throws TransportException, IllegalStateException {
        this(url, username, password, null, sessionContext);
    }

    @Deprecated
    public DAVTransport(String url, String username, String password, Logger logger, SessionContextInterface sessionContext) throws TransportException, IllegalStateException {
        this._url = url;
        this._username = username;
        this._password = password;
        this.setSessionContext(sessionContext);
        if (logger != null) {
            this.setLogger(logger);
        }
    }

    public DAVTransport(String url, String domain, SessionContextInterface sessionContext) throws TransportException, IllegalStateException {
        this(url, domain, (Logger)null, sessionContext);
    }

    @Deprecated
    public DAVTransport(String url, String domain, Logger logger, SessionContextInterface sessionContext) throws TransportException, IllegalStateException {
        this._url = url;
        this.setSessionContext(sessionContext);
        this._domain = domain;
        if (logger != null) {
            this.setLogger(logger);
        }
    }

    public DAVTransport(ContentDestination content, SessionContextInterface sessionContext) throws TransportException, IllegalStateException {
        this(content, null, sessionContext);
    }

    @Deprecated
    public DAVTransport(ContentDestination content, Logger logger, SessionContextInterface sessionContext) throws TransportException, IllegalStateException {
        this.setSessionContext(sessionContext);
        try {
            HttpServerInterface httpServer = (HttpServerInterface)content.getServer();
            if (httpServer == null) {
                throw new IllegalArgumentException(RB.getStringResource("DAVTransport.noHttpServer.ex.txt"));
            }
            String authType = httpServer.getAuthenticationType();
            if (authType != null) {
                if (authType.equalsIgnoreCase("metadata")) {
                    this._authenticationType = "metadata";
                } else if (authType.equalsIgnoreCase("none")) {
                    this._authenticationType = "none";
                }
            }
            URL u = PackageUtil.getServerURL(content);
            this._url = u.toExternalForm();
            Iterator domainIt = httpServer.getDomains().iterator();
            if (domainIt.hasNext()) {
                this._domain = (String)domainIt.next();
            }
            this._proxyUrlStr = httpServer.getProxyUrl();
            if (logger != null) {
                this.setLogger(logger);
            }
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.initError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.initError.ex.txt"));
        }
    }

    public DAVTransport(String url, String username, String password, SessionContextInterface sessionContext, InputStream archiveStream) throws TransportException, IllegalStateException {
        this(url, username, password, null, sessionContext, archiveStream);
    }

    @Deprecated
    public DAVTransport(String url, String username, String password, Logger logger, SessionContextInterface sessionContext, InputStream archiveStream) throws TransportException, IllegalStateException {
        this(url, username, password, logger, sessionContext);
        this._archiveStream = archiveStream;
    }

    public DAVTransport(String url, String domain, SessionContextInterface sessionContext, InputStream archiveStream) throws TransportException, IllegalStateException {
        this(url, domain, (Logger)null, sessionContext, archiveStream);
    }

    @Deprecated
    public DAVTransport(String url, String domain, Logger logger, SessionContextInterface sessionContext, InputStream archiveStream) throws TransportException, IllegalStateException {
        this(url, domain, logger, sessionContext);
        this._archiveStream = archiveStream;
    }

    @Override
    public String getUserName() {
        return this._username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setUserName(String userName) {
        this._username = userName;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public String getURL() {
        return this._url;
    }

    @Override
    public String getDomain() {
        return this._domain;
    }

    @Override
    public int getCreationMode() {
        return this._creationMode;
    }

    @Override
    public void setCreationMode(int mode) throws IllegalArgumentException {
        if (mode != 1 && mode != 2 && mode != 3 && mode != 4) {
            throw new IllegalArgumentException(RB.getStringResource("DAVTransport.invalidMode.ex.txt"));
        }
        this._creationMode = mode;
    }

    @Override
    public EventDataInterface publishResultPackage(ResultPackageInterface rpkg, boolean buildEvent) throws TransportException {
        String theArchiveName = null;
        String packageUrl = this._url;
        CollectionInterface collection = null;
        EventDataInterface eventData = null;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(RB.getStringResource("DAVTransport.publish.txt"));
        }
        try {
            this.validateResultPackage(rpkg);
        }
        catch (IllegalStateException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.pubError.ex.txt"));
        }
        this.initializeTransport();
        if (this._asArchive && (this._creationMode == 3 || this._creationMode == 4)) {
            throw new TransportException(RB.getStringResource("DAVTransport.archiveUpdate.ex.txt"));
        }
        boolean donePub = false;
        while (!donePub) {
            try {
                if (this._archiveStream != null && !this._asArchive) {
                    throw new TransportException(RB.getStringResource("DAVTransport.archiveStreamErr.ex.txt"));
                }
                if (this._asArchive) {
                    ResourceInterface resource = this.bindToServer(packageUrl);
                    if (!(resource instanceof CollectionInterface)) {
                        throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.notCollection.ex.fmt.txt", (Object)packageUrl));
                    }
                    theArchiveName = this.publishPackageAsArchive((CollectionInterface)resource, rpkg);
                    donePub = true;
                } else {
                    collection = this.createNewCollection();
                    if (collection == null) {
                        throw new TransportException(RB.getStringResource("DAVTransport.noCollection.ex.txt"));
                    }
                    this._currRef = 1;
                    this._currRef = 1;
                    this.publishPackage(collection, rpkg, 0, true);
                    donePub = true;
                }
                if (this.logger == null || !this.logger.isDebugEnabled()) continue;
                this.logger.debug(RB.getStringResource("DAVTransport.pkgPub.txt"));
            }
            catch (DAVException e) {
                block21: {
                    if (this._role == 2 && !this._asArchive && collection != null) {
                        try {
                            collection.delete();
                            collection = null;
                        }
                        catch (Exception delEx) {
                            if (this.logger == null) break block21;
                            this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.deleteErr.fmt.txt", (Object)packageUrl, (Object)delEx.getMessage()));
                        }
                    }
                }
                if (this._authenticationType.equalsIgnoreCase("user/password") && this._username == null && this._userIdentities != null && this._userIdentities.hasNext()) {
                    if (this.logger != null && this.logger.isInfoEnabled()) {
                        this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.retry.fmt.txt", (Object)packageUrl, (Object)e.getMessage()));
                    }
                    this._userIdentity = (UserIdentityInterface)this._userIdentities.next();
                    this._currentUsername = (String)this._userIdentity.getPrincipal();
                    this._currentPassword = (String)this._userIdentity.getCredential();
                    continue;
                }
                donePub = true;
                throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.pubError.ex.txt"));
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.pubError.ex.txt"));
            }
        }
        if (buildEvent) {
            if (this._asArchive) {
                StringBuffer b = new StringBuffer();
                b.append(packageUrl);
                if (!packageUrl.endsWith("/")) {
                    b.append("/");
                }
                b.append(theArchiveName);
                packageUrl = b.toString();
            }
            ResultPackageEventBuilder builder = new ResultPackageEventBuilder();
            eventData = builder.buildEvent(rpkg, packageUrl, null, "webdav", this._namespaces);
        }
        return eventData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CollectionInterface createNewCollection() throws TransportException, DAVException {
        String url = this._url;
        CollectionInterface collection = null;
        Object info = null;
        ResourceInterface r = null;
        try {
            if (this._role == 2 && !this._asArchive) {
                boolean done = false;
                while (!done) {
                    String name = Names.generateName((int)0);
                    StringBuffer buf = new StringBuffer();
                    buf.append(this._url);
                    if (this._url.endsWith("/")) {
                        buf.append(name);
                    } else {
                        buf.append("/");
                        buf.append(name);
                    }
                    if ((r = this.makeConnection(url = buf.toString())).exists()) continue;
                    done = true;
                }
            } else {
                r = this.makeConnection(url);
            }
            if (this._creationMode == 2) {
                if (r.exists()) {
                    throw new TransportException(RB.getStringResource("DAVTransport.noreplace.ex.txt"));
                }
                collection = ResourceFactory.createCollection((ResourceInterface)r, (String)url);
            } else if (this._creationMode == 3) {
                if (r.exists()) {
                    if (!(r instanceof CollectionInterface)) throw new TransportException(RB.getStringResource("DAVTransport.updateColl.ex.txt"));
                    collection = (CollectionInterface)r;
                    PropertyMap p = collection.getProperties();
                    String type = (String)p.get((Object)this.getURI("type"));
                    if (type == null || !type.equals("package")) {
                        throw new TransportException(RB.getStringResource("DAVTransport.updateColl.ex.txt"));
                    }
                } else {
                    collection = ResourceFactory.createCollection((ResourceInterface)r, (String)url);
                }
            } else if (this._creationMode == 4) {
                if (r.exists()) {
                    if (!(r instanceof CollectionInterface)) throw new TransportException(RB.getStringResource("DAVTransport.updateColl.ex.txt"));
                    collection = (CollectionInterface)r;
                } else {
                    collection = ResourceFactory.createCollection((ResourceInterface)r, (String)url);
                }
            } else {
                collection = ResourceFactory.createCollection((ResourceInterface)r, (String)url);
            }
        }
        catch (TransportException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.noCollection.ex.txt"));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.noCollection.ex.txt"));
        }
        if (this.logger == null || !this.logger.isDebugEnabled()) return collection;
        if (this._proxyUrl != null) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.createCollWithProxy.fmt.txt", (Object)url, (Object)this._proxyUrl));
            return collection;
        } else {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.createCollection.fmt.txt", (Object)url));
        }
        return collection;
    }

    private ResourceInterface makeConnection(String url) throws RemoteException, DAVException, TransportException, ServiceException {
        ConnectionInfo info = null;
        Object r = null;
        if (this._authenticationType.equalsIgnoreCase("metadata")) {
            UserContextInterface uc = this.getSessionContext().getUserContext();
            if (uc == null) {
                throw new TransportException(RB.getStringResource("DAVTransport.otpFail.ex.txt"));
            }
            UserIdentityInterface ui = uc.getAuthServer().generatePassword(null);
            info = new ConnectionInfo(url, (String)ui.getPrincipal(), (String)ui.getCredential());
        } else if (this._authenticationType.equalsIgnoreCase("user/password")) {
            info = new ConnectionInfo(url, this._currentUsername, this._currentPassword);
        }
        if (this._proxyUrl != null) {
            info.setProxyURL(this._proxyUrl);
        }
        r = null;
        SharedResourceInterface sharedResource = this.findSuitableSharedResource(url);
        if (sharedResource != null) {
            return ResourceFactory.bindResource((SharedResourceInterface)sharedResource, (String)this.getPath(url));
        }
        return ResourceFactory.bindResource((ConnectionInfo)info);
    }

    private CollectionInterface createNestedCollection(CollectionInterface coll, String nestedName) throws TransportException {
        CollectionInterface collection = null;
        try {
            if (this._creationMode == 1) {
                collection = Collection.createCollection((CollectionInterface)coll, (String)nestedName);
            } else {
                String cUrl = coll.getURL();
                StringBuffer buf = new StringBuffer();
                buf.append(cUrl);
                if (!cUrl.endsWith("/")) {
                    buf.append("/");
                }
                buf.append(nestedName);
                ResourceInterface r = ResourceFactory.bindResource((ResourceInterface)coll, (String)nestedName);
                collection = r instanceof CollectionInterface ? (CollectionInterface)r : Collection.createCollection((CollectionInterface)coll, (String)nestedName);
            }
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.noNestedCollection.ex.fmt.txt", (Object)nestedName));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.noNestedCollection.ex.fmt.txt", (Object)nestedName));
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            if (this._proxyUrl != null) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.createNestedWithProxy.fmt.txt", (Object)nestedName, (Object)this._proxyUrl));
            } else {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.createNested.fmt.txt", (Object)nestedName));
            }
        }
        return collection;
    }

    private ResourceInterface createTheResource(CollectionInterface collection, String name) throws TransportException {
        ResourceInterface resource = null;
        try {
            resource = Collection.createResource((CollectionInterface)collection, (String)name);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.createResource.fmt.txt", (Object)name));
            }
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.createResourceTransportException.ex.fmt.txt", (Object)name));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.createResourceTransportException.ex.fmt.txt", (Object)name));
        }
        return resource;
    }

    ResourceInterface bindToServer(String url) throws DAVException, TransportException {
        ResourceInterface resource = null;
        try {
            SharedResourceInterface sharedResource = this.findSuitableSharedResource(url);
            if (sharedResource != null) {
                return ResourceFactory.bindResource((SharedResourceInterface)sharedResource, (String)this.getPath(url));
            }
            if (this._currentUsername == null) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.bindNoCredentials.fmt.txt", (Object)url));
                }
            } else if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.bindCredentials.fmt.txt", (Object)url));
            }
            ConnectionInfo info = new ConnectionInfo(url, this._currentUsername, this._currentPassword);
            if (this._proxyUrl != null) {
                info.setProxyURL(this._proxyUrl);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.bindProxy.fmt.txt", (Object)this._proxyUrl));
                }
            }
            resource = ResourceFactory.bindResource((ConnectionInfo)info);
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVCommon.bindFailure.ex.txt"));
        }
        if (resource == null) {
            throw new TransportException(RB.getStringResource("DAVCommon.bindFailure.ex.txt"));
        }
        return resource;
    }

    @Override
    public ResultPackageInterface getResultPackage() throws TransportException {
        DAVResultPackage davPkg;
        block17: {
            ResourceInterface resource = null;
            davPkg = null;
            int version = 0;
            SessionContextInterface sessionContext = this.getSessionContext();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(RB.getStringResource("DAVTransport.get.txt"));
            }
            this.initializeTransport();
            boolean done = false;
            String type = null;
            PropertyMap p = null;
            while (!done) {
                try {
                    resource = this.bindToServer(this._url);
                    p = resource.getProperties();
                    type = (String)p.get((Object)this.getURI("type"));
                    done = true;
                }
                catch (DAVException e) {
                    if (this._username == null && this._userIdentities != null && this._userIdentities.hasNext()) {
                        if (this.logger != null && this.logger.isInfoEnabled()) {
                            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.retry.fmt.txt", (Object)this._url, (Object)e.getMessage()));
                        }
                        this._userIdentity = (UserIdentityInterface)this._userIdentities.next();
                        this._currentUsername = (String)this._userIdentity.getPrincipal();
                        this._currentPassword = (String)this._userIdentity.getCredential();
                        continue;
                    }
                    done = true;
                    throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.retrieveError.ex.txt"));
                }
                catch (RemoteException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.retrieveError.ex.txt"));
                }
            }
            if (type == null || !type.equals("package") && !type.equals("binarypackage")) {
                throw new TransportException(RB.getStringResource("DAVTransport.notPackage.ex.txt"));
            }
            String strVersion = (String)p.get((Object)this.getURI("version"));
            if (strVersion != null) {
                Integer versionInt = Integer.valueOf(strVersion);
                version = versionInt;
            }
            try {
                if (!(resource instanceof CollectionInterface)) {
                    ArchiveTransport archiveT = new ArchiveTransport(resource, sessionContext);
                    ResultPackageInterface rPkg = archiveT.getResultPackage();
                    return rPkg;
                }
                davPkg = new DAVResultPackage(this, this._url, version, resource);
                this.setPropsOnEntry(davPkg, p);
                this.getEntries(davPkg, (CollectionInterface)resource);
                davPkg.setIsNested(false);
                davPkg.setResource(resource);
                davPkg.setIsReadOnly(true);
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.retrieveError.ex.txt"));
            }
            if (sessionContext != null) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(RB.getStringResource("DAVTransport.trackInSession.txt"));
                }
                try {
                    String key = "com.sas.services.publish." + davPkg.getUniqueId();
                    sessionContext.setAttribute(key, (Object)davPkg);
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug(RB.getStringResource("DAVTransport.trackInSession.txt"));
                    }
                }
                catch (RemoteException e) {
                    if (this.logger == null) break block17;
                    this.logger.warn(RB.getStringResource("DAVTransport.failedToTrackInSession.txt"), (Throwable)e);
                }
            }
        }
        return davPkg;
    }

    @Override
    public Map getNamespaces() {
        return this._namespaces;
    }

    @Override
    public void setNamespaces(Map namespaces) throws IllegalArgumentException {
        for (String name : namespaces.keySet()) {
            if (!name.equals("sas")) continue;
            throw new IllegalArgumentException(RB.getStringResource("DAVTransport.sasPrefix.ex.txt"));
        }
        this._namespaces = namespaces;
    }

    private void validateResultPackage(ResultPackageInterface rpkg) throws TransportException {
        EntryInterface[] entries = null;
        try {
            entries = rpkg.getEntries();
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.pubError.ex.txt"));
        }
        for (int i = 0; i < entries.length; ++i) {
            EntryInterface entry = entries[i];
            if (entry instanceof LibraryMemberEntryInterface) {
                throw new TransportException(RB.getStringResource("DAVTransport.libMemberNotSupportedTransportException.ex.txt"));
            }
            if (!(entry instanceof ResultPackageInterface)) continue;
            this.validateResultPackage((ResultPackageInterface)entry);
        }
    }

    @Override
    public String getProxyURL() {
        return this._proxyUrlStr;
    }

    @Override
    public void setProxyURL(String proxyUrl) {
        this._proxyUrlStr = proxyUrl;
        this._proxyUrl = null;
    }

    @Override
    public int getURLRole() {
        return this._role;
    }

    @Override
    public void setURLRole(int role) throws IllegalArgumentException {
        if (role != 1 && role != 2) {
            throw new IllegalArgumentException(RB.getStringResource("DAVTransport.invalidRole.ex.txt"));
        }
        this._role = role;
    }

    private void getEntries(ResultPackageInterface pkg, CollectionInterface collection) throws TransportException, RemoteException {
        int version = 0;
        HashMap<String, ArrayList<EntryInterface>> map = new HashMap<String, ArrayList<EntryInterface>>();
        Map propMap = null;
        int position = -1;
        String strPosition = null;
        try {
            propMap = collection.getDavChildrenProperties();
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.getProperties.ex.txt"));
        }
        catch (ParserConfigurationException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.getProperties.ex.txt"));
        }
        Iterator children = propMap.entrySet().iterator();
        Map.Entry mapEntry = null;
        while (children.hasNext()) {
            ArrayList<EntryInterface> l;
            String path;
            EntryInterface entry;
            String strVersion;
            version = 0;
            mapEntry = children.next();
            String urlKey = (String)mapEntry.getKey();
            PropertyMap p = (PropertyMap)mapEntry.getValue();
            String type = (String)p.get((Object)this.getURI("type"));
            if (type == null) {
                type = (String)p.get((Object)this.getURI("htmlset"));
                if (type == null) continue;
                type = "htmlset";
            }
            if ((strVersion = (String)p.get((Object)this.getURI("version"))) != null) {
                Integer versionInt = Integer.valueOf(strVersion);
                version = versionInt;
            }
            if ((strPosition = (String)p.get((Object)this.getURI("position"))) != null) {
                Integer positionInt = Integer.valueOf(strPosition);
                position = positionInt;
            }
            if ((entry = this.getEntry(collection, pkg, urlKey, type, p, version)) == null) continue;
            if (entry instanceof DAVEntry) {
                DAVEntry _entry = (DAVEntry)entry;
                _entry.setPosition(position);
                path = null;
                int plen = urlKey.indexOf("://");
                path = plen > 0 ? ((plen = urlKey.indexOf("/", plen + 3)) > 0 ? urlKey.substring(plen) : "") : urlKey;
                if (path != null) {
                    try {
                        _entry.setResource(ResourceFactory.bindResource((ResourceInterface)collection, (String)path, (PropertyMap)p));
                    }
                    catch (DAVException e) {
                        throw new TransportException((Throwable)e, RB.getStringResource("DAVCommon.error.ex.txt"));
                    }
                }
            }
            if ((l = (ArrayList<EntryInterface>)map.get(strPosition)) == null) {
                l = new ArrayList<EntryInterface>();
            }
            l.add(entry);
            map.put(strPosition, l);
            if (!(entry instanceof ResultPackageInterface)) continue;
            try {
                path = null;
                String urlstr = ((DAVResultPackage)entry).getURL();
                int plen = urlstr.indexOf("://");
                path = plen > 0 ? ((plen = urlstr.indexOf("/", plen + 3)) > 0 ? urlstr.substring(plen) : "") : urlstr;
                ResourceInterface r = path != null ? ResourceFactory.bindResource((ResourceInterface)collection, (String)path, (PropertyMap)p) : this.bindToServer(((DAVResultPackage)entry).getURL());
                this.getEntries((ResultPackageInterface)entry, (CollectionInterface)r);
                ((DAVResultPackage)entry).setIsReadOnly(true);
            }
            catch (DAVException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVCommon.bindFailure.ex.txt"));
            }
        }
        int bugOffset = 0;
        for (int i = 0; i < map.size() + bugOffset; ++i) {
            List list = (List)map.get(Integer.toString(i));
            if (list != null) {
                for (int ll = 0; ll < list.size(); ++ll) {
                    EntryInterface e = (EntryInterface)list.get(ll);
                    if (e == null) continue;
                    if (e instanceof DAVHTMLEntry) {
                        DAVHTMLFile df = (DAVHTMLFile)((DAVHTMLEntry)e).getFile();
                        if (df == null) {
                            HTMLFileInterface[] files = ((DAVHTMLEntry)e).getCompanionFiles();
                            int c = 0;
                            while (i < files.length) {
                                HTMLFileInterface cfile = files[c];
                                if (cfile instanceof DAVHTMLFile) {
                                    df = (DAVHTMLFile)cfile;
                                    break;
                                }
                                ++c;
                            }
                        }
                        if (df != null) {
                            ((DAVHTMLEntry)e).setResource(df.getResource());
                        }
                        ((DAVHTMLEntry)e).setIsReadOnly(true);
                    }
                    pkg.addEntry(e);
                }
                continue;
            }
            if (map.size() <= 0) continue;
            ++bugOffset;
        }
    }

    @Override
    public void asArchive(boolean asArchive) {
        this._asArchive = asArchive;
    }

    @Override
    public void setArchiveName(String name) {
        this._archiveName = name;
    }

    @Override
    public String getArchiveName() {
        return this._archiveName;
    }

    private EntryInterface getEntry(CollectionInterface collection, ResultPackageInterface rPkg, String url, String type, PropertyMap p, int version) throws TransportException, RemoteException {
        String name = null;
        String encoding = null;
        encoding = ((DAVResultPackage)rPkg).getTextEncoding();
        String path = null;
        int plen = url.indexOf("://");
        path = plen > 0 ? ((plen = url.indexOf("/", plen + 3)) > 0 ? url.substring(plen) : "") : url;
        File f = new File(path);
        name = f.getName();
        if (type.equals("binfile")) {
            DAVBinaryFileEntry davFile = new DAVBinaryFileEntry(this, url, version, name);
            this.setPropsOnEntry(davFile, p);
            davFile.setIsReadOnly(true);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.binaryRetrieve.fmt.txt", (Object)name));
            }
            return davFile;
        }
        if (type.equals("html")) {
            DAVHTMLEntry davHtml = this.getHTMLEntry(collection, url, p, name, version, (DAVResultPackage)rPkg);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.htmlRetrieve.fmt.txt", (Object)name));
            }
            if (davHtml == null) {
                return null;
            }
            this.setPropsOnEntry(davHtml, p);
            return davHtml;
        }
        if (type.equals("htmlset")) {
            DAVHTMLEntry davHtml = this.getHTMLSet(url, version);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.htmlRetrieve.fmt.txt", (Object)name));
            }
            if (davHtml == null) {
                return null;
            }
            this.setPropsOnEntry(davHtml, p);
            return davHtml;
        }
        if (type.equals("package")) {
            DAVResultPackage nested = new DAVResultPackage(this, url, version);
            this.setPropsOnEntry(nested, p);
            nested.setIsNested(true);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.nestedPkgRetrieve.fmt.txt", (Object)name));
            }
            return nested;
        }
        if (type.equals("referen")) {
            String refType = (String)p.get((Object)this.getURI("referenceType"));
            DAVReferenceEntry davRef = new DAVReferenceEntry(this, url, version, refType, encoding);
            this.setPropsOnEntry(davRef, p);
            davRef.setIsReadOnly(true);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.referenceRetrieve.fmt.txt", (Object)name));
            }
            return davRef;
        }
        if (type.equals("txtfile")) {
            DAVTextFileEntry davFile = new DAVTextFileEntry(this, url, version, name);
            this.setPropsOnEntry(davFile, p);
            davFile.setEncoding(encoding);
            davFile.setIsReadOnly(true);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.textRetrieve.fmt.txt", (Object)name));
            }
            return davFile;
        }
        if (type.equals("viewer")) {
            String viewerType = (String)p.get((Object)this.getURI("viewer"));
            DAVViewerEntry viewer = null;
            if (viewerType.equals("text")) {
                viewer = new DAVViewerEntry(this, url, version, name, 2);
                viewer.setEncoding(encoding);
            } else {
                viewer = new DAVViewerEntry(this, url, version, name, 1);
            }
            this.setPropsOnEntry(viewer, p);
            viewer.setIsReadOnly(true);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.viewerRetrieve.fmt.txt", (Object)name));
            }
            return viewer;
        }
        if (type.equals("catalog") || type.equals("dataset") || type.equals("fdb") || type.equals("mddb") || type.equals("view")) {
            int index = name.indexOf(46);
            if (index > 0) {
                name = name.substring(0, index);
            }
            DAVLibraryMemberEntry libEntry = null;
            if (type.equals("catalog")) {
                libEntry = new DAVLibraryMemberEntry(this, url, version, 2, name);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.catalogRetrieve.fmt.txt", (Object)name));
                }
            } else if (type.equals("dataset")) {
                libEntry = new DAVDatasetEntry(this, url, version, name);
                String obs = (String)p.get((Object)this.getURI("observations"));
                if (obs != null) {
                    ((DAVDatasetEntry)libEntry).setNobs(Integer.parseInt(obs));
                }
                ((DAVDatasetEntry)libEntry).setTextEncoding(encoding);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.datasetRetrieve.fmt.txt", (Object)name));
                }
            } else if (type.equals("mddb")) {
                libEntry = new DAVLibraryMemberEntry(this, url, version, 3, name);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.mddbRetrieve.fmt.txt", (Object)name));
                }
            } else if (type.equals("fdb")) {
                libEntry = new DAVLibraryMemberEntry(this, url, version, 4, name);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.fdbRetrieve.fmt.txt", (Object)name));
                }
            } else if (type.equals("view")) {
                libEntry = new DAVLibraryMemberEntry(this, url, version, 5, name);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.sqlViewRetrieve.fmt.txt", (Object)name));
                }
            }
            this.setPropsOnEntry(libEntry, p);
            libEntry.setIsReadOnly(true);
            return libEntry;
        }
        return null;
    }

    private void setPropsOnEntry(EntryInterface entry, PropertyMap p) throws RemoteException, TransportException {
        double creation = 0.0;
        double expiration = 0.0;
        for (Map.Entry pm : p.entrySet()) {
            String key = (String)pm.getKey();
            String value = (String)pm.getValue();
            int index = key.indexOf(125);
            if (index > 0) {
                Map namespaces;
                String subStr = key.substring(1, index);
                if (subStr.equals("http://www.sas.com/rnd/itech/WebDAV")) {
                    String prop = key.substring(index + 1);
                    if (prop.equals("description")) {
                        if (value.length() > 0 && value.charAt(0) == '\"') {
                            if (value.charAt(value.length() - 1) == '\"') {
                                entry.setDescription(value.substring(1, value.length() - 1));
                                continue;
                            }
                            entry.setDescription(value);
                            continue;
                        }
                        entry.setDescription(value);
                        continue;
                    }
                    if (prop.equals("abstract")) {
                        if (value.length() > 0 && value.charAt(0) == '\"') {
                            if (value.charAt(value.length() - 1) == '\"') {
                                ((DAVResultPackage)entry).setAbstract(value.substring(1, value.length() - 1));
                                continue;
                            }
                            ((DAVResultPackage)entry).setAbstract(value);
                            continue;
                        }
                        ((DAVResultPackage)entry).setAbstract(value);
                        continue;
                    }
                    if (prop.equals("creationDatetime") || prop.equals("expirationDatetime")) {
                        SimpleDateFormat simple = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
                        simple.setTimeZone(TimeZone.getTimeZone("GMT"));
                        Date theDateTime = null;
                        try {
                            theDateTime = simple.parse(value);
                        }
                        catch (java.text.ParseException e) {
                            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.retrieveError.ex.txt"));
                        }
                        if (prop.equals("creationDatetime")) {
                            ((DAVResultPackage)entry).setCreationDateTime(theDateTime.getTime());
                            continue;
                        }
                        ((ResultPackageInterface)entry).setExpirationDateTime(theDateTime.getTime());
                        continue;
                    }
                    if (prop.equals("creationDatetimeNumeric") || prop.equals("expirationDatetimeNumeric")) {
                        if (prop.equals("creationDatetimeNumeric")) {
                            creation = Double.valueOf(value);
                            continue;
                        }
                        expiration = Double.valueOf(value);
                        continue;
                    }
                    if (prop.equals("encoding")) {
                        if (!(entry instanceof ViewerEntryInterface)) continue;
                        ((ViewerEntryInterface)entry).setEncoding(value);
                        continue;
                    }
                    if (prop.equals("mimeType")) {
                        String tmpMIMEType = value;
                        if (value.length() > 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                            tmpMIMEType = value.substring(1, value.length() - 1);
                        }
                        if (entry instanceof ViewerEntryInterface) {
                            ((ViewerEntryInterface)entry).setMIMEType(tmpMIMEType);
                            continue;
                        }
                        if (entry instanceof TextFileEntryInterface) {
                            ((TextFileEntryInterface)entry).setMIMEType(tmpMIMEType);
                            continue;
                        }
                        if (!(entry instanceof BinaryFileEntryInterface)) continue;
                        ((BinaryFileEntryInterface)entry).setMIMEType(tmpMIMEType);
                        continue;
                    }
                    if (!prop.equals("maximumLength")) continue;
                    if (entry instanceof ReferenceEntryInterface) {
                        ((DAVReferenceEntry)entry).setLength(Integer.valueOf(value));
                        continue;
                    }
                    if (entry instanceof TextFileEntryInterface) {
                        ((DAVTextFileEntry)entry).setMaximumLineLength(Integer.valueOf(value));
                        continue;
                    }
                    if (!(entry instanceof ViewerEntryInterface)) continue;
                    ((DAVViewerEntry)entry).setMaximumLineLength(Integer.valueOf(value));
                    continue;
                }
                if (subStr.equals("")) {
                    this.setThisNameValue(entry, key.substring(index + 1), value);
                    continue;
                }
                if (subStr.equals("DAV:") || (namespaces = this.getNamespaces()) == null) continue;
                Iterator it = namespaces.entrySet().iterator();
                Map.Entry mapEntry = null;
                while (it.hasNext()) {
                    mapEntry = it.next();
                    String n = (String)mapEntry.getKey();
                    String v = (String)mapEntry.getValue();
                    if (!subStr.equals(v)) continue;
                    StringBuffer buf = new StringBuffer();
                    buf.append(n);
                    buf.append(":");
                    buf.append(key.substring(index + 1));
                    this.setThisNameValue(entry, buf.toString(), value);
                }
                continue;
            }
            this.setThisNameValue(entry, key, value);
        }
        if (expiration != 0.0) {
            ((DAVResultPackage)entry).setExpirationDateTime(DateUtil.SASDateTimeToJavaDate((double)expiration, (TimeZone)TimeZone.getTimeZone("GMT")));
        }
        if (creation != 0.0) {
            ((DAVResultPackage)entry).setCreationDateTime(DateUtil.SASDateTimeToJavaDate((double)creation, (TimeZone)TimeZone.getTimeZone("GMT")));
        }
    }

    private void setThisNameValue(EntryInterface entry, String name, String value) throws TransportException, RemoteException {
        block3: {
            AttributeMapInterface namevalues = entry.getNameValuePairs();
            if (namevalues == null) {
                namevalues = new AttributeMap();
                entry.setNameValuePairs(namevalues);
            }
            try {
                AttributeMap.parseValues((AttributeMapInterface)namevalues, (String)name, (String)value);
            }
            catch (ParseException e) {
                if (this.logger == null) break block3;
                this.logger.warn(RB.getStringResource("DAVTransport.nameValueParseError.txt"), (Throwable)e);
            }
        }
    }

    private DAVHTMLEntry getHTMLEntry(CollectionInterface collection, String url, PropertyMap p, String name, int version, DAVResultPackage rPkg) throws RemoteException, TransportException {
        String frame = null;
        String body = null;
        String frameset = null;
        String contents = null;
        String pages = null;
        DAVHTMLEntry davEntry = null;
        boolean alreadyExists = false;
        String mimeType = null;
        String encoding = null;
        int position = -1;
        String loose = (String)p.get((Object)this.getURI("htmllooseset"));
        HashMap<String, DAVHTMLEntry> pkgLoose = rPkg.getLooseMap();
        if (pkgLoose == null) {
            pkgLoose = new HashMap<String, DAVHTMLEntry>();
            rPkg.setLooseMap(pkgLoose);
            davEntry = new DAVHTMLEntry(this, null, version);
            pkgLoose.put(loose, davEntry);
        } else if (pkgLoose.containsKey(loose)) {
            davEntry = (DAVHTMLEntry)pkgLoose.get(loose);
            alreadyExists = true;
        } else {
            davEntry = new DAVHTMLEntry(this, null, version);
            pkgLoose.put(loose, davEntry);
        }
        frame = (String)p.get((Object)this.getURI("frame"));
        body = (String)p.get((Object)this.getURI("body"));
        pages = (String)p.get((Object)this.getURI("pages"));
        contents = (String)p.get((Object)this.getURI("contents"));
        frameset = (String)p.get((Object)this.getURI("frameset"));
        mimeType = (String)p.get((Object)this.getURI("mimeType"));
        encoding = (String)p.get((Object)this.getURI("encoding"));
        String strPosition = (String)p.get((Object)this.getURI("position"));
        if (strPosition != null) {
            Integer positionInt = Integer.valueOf(strPosition);
            position = positionInt;
        }
        if (mimeType != null && mimeType.length() > 0 && mimeType.charAt(0) == '\"' && mimeType.charAt(mimeType.length() - 1) == '\"') {
            mimeType = mimeType.substring(1, mimeType.length() - 1);
        }
        String path = null;
        ResourceInterface r = null;
        int plen = url.indexOf("://");
        path = plen > 0 ? ((plen = url.indexOf("/", plen + 3)) > 0 ? url.substring(plen) : "") : url;
        if (path != null) {
            try {
                r = ResourceFactory.bindResource((ResourceInterface)collection, (String)path, (PropertyMap)p);
            }
            catch (DAVException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVCommon.error.ex.txt"));
            }
        }
        if (body != null) {
            if (davEntry.getFile() == null) {
                DAVHTMLFile davFile = new DAVHTMLFile(this, url, 1, name);
                davFile.setPosition(position);
                davFile.setEncoding(encoding);
                if (mimeType != null) {
                    davFile.setMIMEType(mimeType);
                } else {
                    davFile.setMIMEType("text/html");
                }
                davFile.setIsReadOnly(true);
                davEntry.setFile(davFile);
                if (r != null) {
                    davEntry.setResource(r);
                    davFile.setResource(r);
                }
            } else {
                int oldPos;
                DAVHTMLFile oldFile;
                boolean exchangeEm = false;
                if (position != -1 && (oldFile = (DAVHTMLFile)davEntry.getFile()).getRole() == 1 && (oldPos = oldFile.getPosition()) != -1 && oldPos > position) {
                    exchangeEm = true;
                }
                if (exchangeEm) {
                    oldFile = (DAVHTMLFile)davEntry.getFile();
                    oldFile.setIsReadOnly(false);
                    oldFile.setRole(2);
                    oldFile.setIsReadOnly(true);
                    davEntry.addCompanionFile(oldFile);
                    DAVHTMLFile davFile = new DAVHTMLFile(this, url, 1, name);
                    davFile.setPosition(position);
                    davFile.setEncoding(encoding);
                    if (mimeType != null) {
                        davFile.setMIMEType(mimeType);
                    } else {
                        davFile.setMIMEType("text/html");
                    }
                    davFile.setIsReadOnly(true);
                    davEntry.setFile(davFile);
                    if (r != null) {
                        davFile.setResource(r);
                        davEntry.setResource(r);
                    }
                } else {
                    DAVHTMLFile davFile = new DAVHTMLFile(this, url, 2, name);
                    davFile.setPosition(position);
                    davFile.setEncoding(encoding);
                    if (mimeType != null) {
                        davFile.setMIMEType(mimeType);
                    } else {
                        davFile.setMIMEType("text/html");
                    }
                    davFile.setIsReadOnly(true);
                    davEntry.addCompanionFile(davFile);
                    if (r != null) {
                        davFile.setResource(r);
                    }
                }
            }
        } else if (frame != null) {
            HTMLFileInterface f = davEntry.getFile();
            DAVHTMLFile davFile = new DAVHTMLFile(this, url, 7, name);
            if (f != null) {
                ((DAVHTMLFile)f).setIsReadOnly(false);
                ((DAVHTMLFile)f).setRole(2);
                ((DAVHTMLFile)f).setIsReadOnly(true);
                davEntry.addCompanionFile(f);
            }
            davFile.setPosition(position);
            davFile.setEncoding(encoding);
            if (mimeType != null) {
                davFile.setMIMEType(mimeType);
            } else {
                davFile.setMIMEType("text/html");
            }
            davFile.setIsReadOnly(true);
            davEntry.setFile(davFile);
            if (r != null) {
                davEntry.setResource(r);
                davFile.setResource(r);
            }
        } else if (contents != null) {
            DAVHTMLFile davFile = new DAVHTMLFile(this, url, 4, name);
            davFile.setPosition(position);
            davFile.setEncoding(encoding);
            if (mimeType != null) {
                davFile.setMIMEType(mimeType);
            } else {
                davFile.setMIMEType("text/html");
            }
            davFile.setIsReadOnly(true);
            if (r != null) {
                davFile.setResource(r);
            }
            davEntry.addCompanionFile(davFile);
        } else if (pages != null) {
            DAVHTMLFile davFile = new DAVHTMLFile(this, url, 5, name);
            davFile.setPosition(position);
            davFile.setEncoding(encoding);
            if (mimeType != null) {
                davFile.setMIMEType(mimeType);
            } else {
                davFile.setMIMEType("text/html");
            }
            davFile.setIsReadOnly(true);
            if (r != null) {
                davFile.setResource(r);
            }
            davEntry.addCompanionFile(davFile);
        } else if (frameset != null) {
            DAVHTMLFile davCompanion = new DAVHTMLFile(this, url, 6, name);
            davCompanion.setPosition(position);
            davCompanion.setEncoding(encoding);
            davCompanion.setMIMEType(mimeType);
            davCompanion.setIsReadOnly(true);
            if (r != null) {
                davCompanion.setResource(r);
            }
            davEntry.addCompanionFile(davCompanion);
        }
        return alreadyExists ? null : davEntry;
    }

    private DAVHTMLEntry getHTMLSet(String url, int version) throws RemoteException, TransportException {
        String frame = null;
        String body = null;
        String frameset = null;
        String contents = null;
        String pages = null;
        DAVHTMLEntry davEntry = null;
        String mimeType = null;
        String encoding = null;
        Map propMap = null;
        String name = null;
        String urlKey = null;
        int position = -1;
        try {
            ResourceInterface r = this.bindToServer(url);
            propMap = ((CollectionInterface)r).getDavChildrenProperties();
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.getProperties.ex.txt"));
        }
        catch (ParserConfigurationException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.getProperties.ex.txt"));
        }
        davEntry = new DAVHTMLEntry(this, null, version);
        Iterator children = propMap.entrySet().iterator();
        Map.Entry mapEntry = null;
        while (children.hasNext()) {
            DAVHTMLFile davFile;
            DAVHTMLFile davFile2;
            version = 0;
            mapEntry = children.next();
            urlKey = (String)mapEntry.getKey();
            PropertyMap p = (PropertyMap)mapEntry.getValue();
            String type = (String)p.get((Object)this.getURI("type"));
            if (!type.equals("html")) continue;
            String path = null;
            int plen = urlKey.indexOf("://");
            path = plen > 0 ? ((plen = urlKey.indexOf("/", plen + 3)) > 0 ? urlKey.substring(plen) : "") : urlKey;
            File file = new File(path);
            name = file.getName();
            frame = (String)p.get((Object)this.getURI("frame"));
            body = (String)p.get((Object)this.getURI("body"));
            pages = (String)p.get((Object)this.getURI("pages"));
            contents = (String)p.get((Object)this.getURI("contents"));
            frameset = (String)p.get((Object)this.getURI("frameset"));
            mimeType = (String)p.get((Object)this.getURI("mimeType"));
            encoding = (String)p.get((Object)this.getURI("encoding"));
            String strPosition = (String)p.get((Object)this.getURI("position"));
            if (strPosition != null) {
                Integer positionInt = Integer.valueOf(strPosition);
                position = positionInt;
            }
            if (mimeType != null && mimeType.length() > 0 && mimeType.charAt(0) == '\"' && mimeType.charAt(mimeType.length() - 1) == '\"') {
                mimeType = mimeType.substring(1, mimeType.length() - 1);
            }
            if (body != null) {
                int oldPos;
                DAVHTMLFile oldFile;
                if (davEntry.getFile() == null) {
                    davFile2 = new DAVHTMLFile(this, urlKey, 1, name);
                    davFile2.setPosition(position);
                    davFile2.setEncoding(encoding);
                    davFile2.setMIMEType(mimeType);
                    davFile2.setIsReadOnly(true);
                    davEntry.setFile(davFile2);
                    continue;
                }
                boolean exchangeEm = false;
                if (position != -1 && (oldFile = (DAVHTMLFile)davEntry.getFile()).getRole() == 1 && (oldPos = oldFile.getPosition()) != -1 && oldPos > position) {
                    exchangeEm = true;
                }
                if (exchangeEm) {
                    oldFile = (DAVHTMLFile)davEntry.getFile();
                    oldFile.setIsReadOnly(false);
                    oldFile.setRole(2);
                    oldFile.setIsReadOnly(true);
                    davEntry.addCompanionFile(oldFile);
                    DAVHTMLFile davFile3 = new DAVHTMLFile(this, urlKey, 1, name);
                    davFile3.setPosition(position);
                    davFile3.setEncoding(encoding);
                    davFile3.setMIMEType(mimeType);
                    davFile3.setIsReadOnly(true);
                    davEntry.setFile(davFile3);
                    continue;
                }
                davFile = new DAVHTMLFile(this, urlKey, 2, name);
                davFile.setPosition(position);
                davFile.setEncoding(encoding);
                davFile.setMIMEType(mimeType);
                davFile.setIsReadOnly(true);
                davEntry.addCompanionFile(davFile);
                continue;
            }
            if (frame != null) {
                HTMLFileInterface f = davEntry.getFile();
                davFile = new DAVHTMLFile(this, urlKey, 7, name);
                if (f != null) {
                    ((DAVHTMLFile)f).setIsReadOnly(false);
                    ((DAVHTMLFile)f).setRole(2);
                    ((DAVHTMLFile)f).setIsReadOnly(true);
                    davEntry.addCompanionFile(f);
                }
                davFile.setPosition(position);
                davFile.setEncoding(encoding);
                davFile.setMIMEType(mimeType);
                davFile.setIsReadOnly(true);
                davEntry.setFile(davFile);
                continue;
            }
            if (contents != null) {
                davFile2 = new DAVHTMLFile(this, urlKey, 4, name);
                davFile2.setPosition(position);
                davFile2.setEncoding(encoding);
                davFile2.setMIMEType(mimeType);
                davFile2.setIsReadOnly(true);
                davEntry.addCompanionFile(davFile2);
                continue;
            }
            if (pages != null) {
                davFile2 = new DAVHTMLFile(this, urlKey, 5, name);
                davFile2.setPosition(position);
                davFile2.setEncoding(encoding);
                davFile2.setMIMEType(mimeType);
                davFile2.setIsReadOnly(true);
                davEntry.addCompanionFile(davFile2);
                continue;
            }
            if (frameset == null) continue;
            DAVHTMLFile davCompanion = new DAVHTMLFile(this, urlKey, 6, name);
            davCompanion.setPosition(position);
            davCompanion.setEncoding(encoding);
            davCompanion.setMIMEType(mimeType);
            davCompanion.setIsReadOnly(true);
            davEntry.addCompanionFile(davCompanion);
        }
        return davEntry;
    }

    private void publishPackage(CollectionInterface collection, ResultPackageInterface rPkg, int position, boolean mainPackage) throws RemoteException, TransportException, DAVException {
        StringBuffer buf;
        int looseSet = 1;
        UserContextInterface uc = null;
        SimpleDateFormat simple = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
        simple.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date creationDate = new Date();
        PropertyMap p = new PropertyMap();
        p.put((Object)this.getURI("type"), (Object)"package");
        p.put((Object)this.getURI("creationDatetime"), (Object)simple.format(creationDate));
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.setTime(creationDate);
        double sasCreation = DateUtil.javaDateToSASDateTime((long)calendar.getTime().getTime(), (TimeZone)TimeZone.getTimeZone("GMT"));
        Double d = sasCreation;
        p.put((Object)this.getURI("creationDatetimeNumeric"), (Object)Long.toString(d.longValue()));
        if (this.getSessionContext() != null) {
            try {
                uc = this.getSessionContext().getUserContext();
                if (uc != null) {
                    IdentityInterface ident = uc.getPerson();
                    if (ident != null) {
                        p.put((Object)this.getURI("publisherURI"), (Object)ident.getEntityURL());
                    } else {
                        RepositoryInterface r;
                        PersonInterface person;
                        List l = uc.getRepositories();
                        if (l != null && l.size() > 0 && (person = (r = (RepositoryInterface)l.get(0)).getUser()) != null) {
                            p.put((Object)this.getURI("publisherURI"), (Object)person.getEntityURL());
                        }
                    }
                }
            }
            catch (ServiceException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.pubError.ex.txt"));
            }
        }
        if (uc != null) {
            buf = new StringBuffer();
            buf.append('\"');
            buf.append(System.getProperty("user.name"));
            buf.append("\" \"");
            buf.append(uc.getName());
            buf.append('\"');
            p.put((Object)this.getURI("publisherAlias"), (Object)buf.toString());
        } else if (this._currentUsername != null) {
            buf = new StringBuffer();
            buf.append('\"');
            buf.append(System.getProperty("user.name"));
            buf.append("\" \"");
            buf.append(this._currentUsername);
            buf.append('\"');
            p.put((Object)this.getURI("publisherAlias"), (Object)buf.toString());
        }
        this.setCommonEntryProperties(p, rPkg, position);
        long l = rPkg.getExpirationDateTime();
        if (l > 0L) {
            p.put((Object)this.getURI("expirationDatetime"), (Object)simple.format(new Date(rPkg.getExpirationDateTime())));
            calendar.clear();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.setTime(new Date(l));
            double sasExpiration = DateUtil.javaDateToSASDateTime((long)calendar.getTime().getTime(), (TimeZone)TimeZone.getTimeZone("GMT"));
            Double dbl = sasExpiration;
            p.put((Object)this.getURI("expirationDatetimeNumeric"), (Object)Long.toString(dbl.longValue()));
        } else {
            SimpleDateFormat s = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
            p.put((Object)this.getURI("expirationDatetime"), (Object)s.format(new Date(253402318799000L)));
            calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(9999, 11, 31, 23, 59, 59);
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            double sasExpiration = DateUtil.javaDateToSASDateTime((long)calendar.getTime().getTime(), (TimeZone)TimeZone.getTimeZone("GMT"));
            Double dbl = sasExpiration;
            p.put((Object)this.getURI("expirationDatetimeNumeric"), (Object)Long.toString(dbl.longValue()));
        }
        p.put((Object)this.getURI("version"), (Object)Integer.toString(2));
        if (rPkg.getAbstract() != null) {
            StringBuffer buf2 = new StringBuffer();
            buf2.append('\"');
            buf2.append(rPkg.getAbstract());
            buf2.append('\"');
            p.put((Object)this.getURI("abstract"), (Object)buf2.toString());
        }
        try {
            collection.setProperties(p);
        }
        catch (DAVException e) {
            if (mainPackage) {
                throw e;
            }
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.setProperties.ex.txt"));
        }
        this.publishEntries(collection, rPkg, looseSet);
    }

    private String publishPackageAsArchive(CollectionInterface collection, ResultPackageInterface rPkg) throws RemoteException, TransportException, DAVException {
        StringBuffer buf;
        StringBuffer buf2;
        File f = null;
        FileInputStream fis = null;
        String thePkgName = null;
        String uniqueName = Names.generateName((int)0);
        UserContextInterface uc = null;
        if (this._archiveStream == null) {
            try {
                f = File.createTempFile(uniqueName, ".spk");
            }
            catch (IOException e) {
                if (f != null) {
                    f.delete();
                }
                throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.archiveErr.ex.txt"));
            }
            TransportFactory factory = new TransportFactory();
            ArchiveTransportInterface archiveT = factory.getArchiveTransport(f, this.getSessionContext());
            archiveT.publishResultPackage(rPkg, false);
        }
        SimpleDateFormat simple = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
        simple.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date creationDate = new Date();
        PropertyMap p = new PropertyMap();
        p.put((Object)this.getURI("type"), (Object)"binarypackage");
        p.put((Object)this.getURI("creationDatetime"), (Object)simple.format(creationDate));
        if (this.getSessionContext() != null) {
            try {
                uc = this.getSessionContext().getUserContext();
                if (uc != null) {
                    IdentityInterface ident = uc.getPerson();
                    if (ident != null) {
                        p.put((Object)this.getURI("publisherURI"), (Object)ident.getEntityURL());
                    } else {
                        RepositoryInterface r;
                        PersonInterface person;
                        List l = uc.getRepositories();
                        if (l != null && l.size() > 0 && (person = (r = (RepositoryInterface)l.get(0)).getUser()) != null) {
                            p.put((Object)this.getURI("publisherURI"), (Object)person.getEntityURL());
                        }
                    }
                }
            }
            catch (ServiceException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.pubError.ex.txt"));
            }
        }
        if (uc != null) {
            buf2 = new StringBuffer();
            buf2.append('\"');
            buf2.append(System.getProperty("user.name"));
            buf2.append("\" \"");
            buf2.append(uc.getName());
            buf2.append('\"');
            p.put((Object)this.getURI("publisherAlias"), (Object)buf2.toString());
        } else if (this._currentUsername != null) {
            buf2 = new StringBuffer();
            buf2.append('\"');
            buf2.append(System.getProperty("user.name"));
            buf2.append("\" \"");
            buf2.append(this._currentUsername);
            buf2.append('\"');
            p.put((Object)this.getURI("publisherAlias"), (Object)buf2.toString());
        }
        this.setCommonEntryProperties(p, rPkg, 0);
        long l = rPkg.getExpirationDateTime();
        if (l > 0L) {
            p.put((Object)this.getURI("expirationDatetime"), (Object)simple.format(new Date(rPkg.getExpirationDateTime())));
        } else {
            SimpleDateFormat s = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
            p.put((Object)this.getURI("expirationDatetime"), (Object)s.format(new Date(253402318799000L)));
        }
        p.put((Object)this.getURI("version"), (Object)Integer.toString(2));
        if (rPkg.getAbstract() != null) {
            buf = new StringBuffer();
            buf.append('\"');
            buf.append(rPkg.getAbstract());
            buf.append('\"');
            p.put((Object)this.getURI("abstract"), (Object)buf.toString());
        }
        try {
            buf = new StringBuffer();
            if (this._archiveName == null) {
                boolean done = false;
                while (!done) {
                    if (!this.resourceExists(collection, uniqueName)) {
                        done = true;
                        continue;
                    }
                    uniqueName = Names.generateName((int)0);
                }
                buf.append(uniqueName);
                buf.append(".spk");
            } else {
                buf.append(this._archiveName);
                if (!this._archiveName.endsWith(".spk")) {
                    buf.append(".spk");
                }
                if (this.resourceExists(collection, buf.toString()) && this._creationMode == 2) {
                    throw new TransportException(RB.getStringResource("DAVTransport.noreplaceArchive.ex.txt"));
                }
            }
            thePkgName = buf.toString();
            ResourceInterface resource = this.createTheResource(collection, thePkgName);
            if (this._archiveStream != null) {
                resource.setContents((InputStream)new InputStreamAdapter(this._archiveStream));
            } else {
                fis = new FileInputStream(f);
                resource.setContents((InputStream)new InputStreamAdapter((InputStream)fis));
            }
            resource.setProperties(p);
        }
        catch (FileNotFoundException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.archiveResource.ex.txt"));
        }
        finally {
            if (f != null) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
                if (!f.delete() && this.logger != null) {
                    this.logger.warn(RB.getStringResource("DAVTransport.archiveDelete.txt"));
                }
            }
        }
        return thePkgName;
    }

    private void publishEntries(CollectionInterface collection, ResultPackageInterface rPkg, int looseSet) throws RemoteException, TransportException {
        int position = 0;
        EntryInterface[] entries = null;
        entries = rPkg.getEntries();
        if (this._creationMode == 3) {
            Map m = this.getUpdateProps(collection);
            String s = (String)m.get("position");
            position = Integer.parseInt(s);
            s = (String)m.get("htmllooseset");
            looseSet = Integer.parseInt(s);
        }
        for (int i = 0; i < entries.length; ++i) {
            EntryInterface entry = entries[i];
            if (entry instanceof ResultPackageInterface) {
                CollectionInterface nestedCollection;
                String name = ((ResultPackageInterface)entry).getName();
                if (name == null) {
                    boolean done = false;
                    while (!done) {
                        name = Names.generateName((int)0);
                        if (this.resourceExists(collection, name)) continue;
                        done = true;
                    }
                }
                if ((nestedCollection = this.createNestedCollection(collection, name)) == null) {
                    throw new TransportException(RB.getStringResource("DAVTransport.noCollection.ex.txt"));
                }
                try {
                    this.publishPackage(nestedCollection, (ResultPackageInterface)entry, position, false);
                }
                catch (DAVException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.pubError.ex.txt"));
                }
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(RB.getStringResource("DAVTransport.nestedPkgPub.txt"));
                }
            } else if (entry instanceof HTMLEntryInterface) {
                position = this.publishHTMLSet(collection, entry, position, looseSet);
                ++looseSet;
            } else if (entry instanceof ReferenceEntryInterface) {
                this.publishReference(collection, entry, position);
            } else if (entry instanceof BinaryFileEntryInterface) {
                this.publishBinaryFile(collection, entry, position);
            } else if (entry instanceof TextFileEntryInterface) {
                this.publishTextFile(collection, entry, position);
            } else if (entry instanceof ViewerEntryInterface) {
                this.publishViewer(collection, entry, position);
            }
            ++position;
        }
    }

    private void setCommonEntryProperties(PropertyMap p, EntryInterface entry, int position) throws TransportException, RemoteException {
        AttributeMapInterface namevalues;
        p.put((Object)this.getURI("position"), (Object)Integer.toString(position));
        ++position;
        p.put((Object)this.getURI("version"), (Object)Integer.toString(15));
        if (entry.getDescription() != null) {
            StringBuffer buf = new StringBuffer();
            buf.append('\"');
            buf.append(entry.getDescription());
            buf.append('\"');
            p.put((Object)this.getURI("description"), (Object)buf.toString());
        }
        if ((namevalues = entry.getNameValuePairs()) != null) {
            try {
                StringBuffer b = null;
                String n = null;
                String ns = null;
                String value = null;
                Map namespaces = null;
                String[] names = namevalues.listAttributeNames();
                for (int i = 0; i < names.length; ++i) {
                    n = names[i];
                    String[] values = namevalues.getAttributes(n);
                    value = AttributeMap.buildValue((String[])values);
                    namespaces = this.getNamespaces();
                    int pos = n.indexOf(":");
                    if (pos < 0) {
                        p.put((Object)n, (Object)value);
                        continue;
                    }
                    if (namespaces == null) {
                        throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.invalidPrefix.ex.fmt.txt", (Object)n));
                    }
                    String prefix = n.substring(0, pos);
                    String namespaceToUse = null;
                    Iterator mItor = namespaces.entrySet().iterator();
                    Map.Entry mapEntry = null;
                    while (mItor.hasNext()) {
                        mapEntry = mItor.next();
                        ns = (String)mapEntry.getKey();
                        if (!ns.startsWith(prefix)) continue;
                        namespaceToUse = (String)mapEntry.getValue();
                        n = n.substring(pos + 1, n.length());
                        break;
                    }
                    if (namespaceToUse != null) {
                        b = new StringBuffer();
                        b.append("{");
                        b.append(namespaceToUse);
                        b.append("}");
                        b.append(n);
                        p.put((Object)b.toString(), (Object)value);
                        continue;
                    }
                    throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.invalidPrefix.ex.fmt.txt", (Object)n));
                }
            }
            catch (ParseException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.setEntryNVProperties.ex.txt"));
            }
        }
    }

    private void publishReference(CollectionInterface collection, EntryInterface entry, int position) throws RemoteException, TransportException {
        PropertyMap p = new PropertyMap();
        p.put((Object)this.getURI("type"), (Object)"referen");
        this.setCommonEntryProperties(p, entry, position);
        ReferenceEntryInterface ref = (ReferenceEntryInterface)entry;
        if (ref.getReferenceType().equals("HTML")) {
            p.put((Object)this.getURI("referenceType"), (Object)"HTML");
        } else {
            p.put((Object)this.getURI("referenceType"), (Object)"URL");
        }
        boolean done = false;
        StringBuffer buf = null;
        while (!done) {
            buf = new StringBuffer();
            buf.append("sas");
            if (this._currRef < 10) {
                buf.append("00");
            } else if (this._currRef < 100) {
                buf.append("0");
            }
            buf.append(Integer.toString(this._currRef));
            buf.append(".ref");
            ++this._currRef;
            if (this.resourceExists(collection, buf.toString())) continue;
            done = true;
        }
        String reference = ref.getReference();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter outWriter = null;
        try {
            outWriter = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            outWriter.write(reference);
            outWriter.write(10);
            outWriter.flush();
            ResourceInterface resource = this.createTheResource(collection, buf.toString());
            p.put((Object)this.getURI("maximumLength"), (Object)Integer.toString(reference.length()));
            if (baos != null) {
                resource.setContents(baos.toByteArray());
            }
            resource.setProperties(p);
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.referenceError.ex.txt"));
        }
        catch (UnsupportedEncodingException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.referenceError.ex.txt"));
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.referenceError.ex.txt"));
        }
        finally {
            if (outWriter != null) {
                try {
                    outWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(RB.getStringResource("DAVTransport.referencePub.txt"));
        }
    }

    private void publishTextFile(CollectionInterface collection, EntryInterface entry, int position) throws RemoteException, TransportException {
        PropertyMap p = new PropertyMap();
        this.setCommonEntryProperties(p, entry, position);
        TextFileEntryInterface file = (TextFileEntryInterface)entry;
        p.put((Object)this.getURI("type"), (Object)"txtfile");
        String mimeType = file.getMIMEType();
        if (mimeType != null) {
            StringBuffer buf = new StringBuffer();
            buf.append('\"');
            buf.append(mimeType);
            buf.append('\"');
            p.put((Object)this.getURI("mimeType"), (Object)buf.toString());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedReader buffered = null;
        BufferedWriter bufferedWriter = null;
        try {
            buffered = new BufferedReader(file.getReader());
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            String line = null;
            int maxLength = 0;
            while ((line = buffered.readLine()) != null) {
                bufferedWriter.write(line, 0, line.length());
                bufferedWriter.write(10);
                if (line.length() + 1 <= maxLength) continue;
                maxLength = line.length() + 1;
            }
            bufferedWriter.flush();
            p.put((Object)this.getURI("maximumLength"), (Object)Integer.toString(maxLength));
            ResourceInterface resource = this.createTheResource(collection, file.getName());
            resource.setContents(baos.toByteArray());
            resource.setProperties(p);
        }
        catch (UnsupportedEncodingException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.textError.ex.fmt.txt", (Object)file.getName()));
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.textError.ex.fmt.txt", (Object)file.getName()));
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.textError.ex.fmt.txt", (Object)file.getName()));
        }
        finally {
            if (buffered != null) {
                try {
                    buffered.close();
                }
                catch (IOException iOException) {}
                buffered = null;
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
                bufferedWriter = null;
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
                baos = null;
            }
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(RB.getStringResource("DAVTransport.textPub.txt"));
        }
    }

    private void publishBinaryFile(CollectionInterface collection, EntryInterface entry, int position) throws RemoteException, TransportException {
        PropertyMap p = new PropertyMap();
        this.setCommonEntryProperties(p, entry, position);
        BinaryFileEntryInterface file = (BinaryFileEntryInterface)entry;
        p.put((Object)this.getURI("type"), (Object)"binfile");
        String mimeType = file.getMIMEType();
        if (mimeType != null) {
            StringBuffer buf = new StringBuffer();
            buf.append('\"');
            buf.append(mimeType);
            buf.append('\"');
            p.put((Object)this.getURI("mimeType"), (Object)buf.toString());
        }
        try {
            this.publishTheFile(file.getInputStream(), file.getName(), file.getName(), collection, p);
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.fileError.ex.fmt.txt", (Object)file.getName()));
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(RB.getStringResource("DAVTransport.binaryPub.txt"));
        }
    }

    private void publishViewer(CollectionInterface collection, EntryInterface entry, int position) throws RemoteException, TransportException {
        PropertyMap p = new PropertyMap();
        this.setCommonEntryProperties(p, entry, position);
        ViewerEntryInterface viewer = (ViewerEntryInterface)entry;
        p.put((Object)this.getURI("type"), (Object)"viewer");
        String mimeType = viewer.getMIMEType();
        if (mimeType != null) {
            StringBuffer buf = new StringBuffer();
            buf.append('\"');
            buf.append(mimeType);
            buf.append('\"');
            p.put((Object)this.getURI("mimeType"), (Object)buf.toString());
        }
        if (viewer.getViewerType() == 1) {
            p.put((Object)this.getURI("viewer"), (Object)"html");
            HTMLEncodingParser parser = new HTMLEncodingParser();
            Map m = null;
            try {
                m = parser.parse(viewer);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (m == null) {
                p.put((Object)this.getURI("encodingOffset"), (Object)Integer.toString(0));
                String userEncoding = viewer.getEncoding();
                if (userEncoding != null) {
                    p.put((Object)this.getURI("encoding"), (Object)userEncoding);
                } else {
                    p.put((Object)this.getURI("encoding"), (Object)"ISO-8859-1");
                }
            } else {
                Integer eOffset = (Integer)m.get("OFFSET");
                p.put((Object)this.getURI("encodingOffset"), (Object)eOffset.toString());
                p.put((Object)this.getURI("encoding"), m.get("ENCODING"));
            }
            try {
                this.publishTheFile(viewer.getInputStream(), viewer.getName(), viewer.getName(), collection, p);
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.fileError.ex.fmt.txt", (Object)viewer.getName()));
            }
        }
        BufferedReader buffered = null;
        BufferedWriter bufferedWriter = null;
        ByteArrayOutputStream baos = null;
        try {
            String line;
            p.put((Object)this.getURI("viewer"), (Object)"text");
            baos = new ByteArrayOutputStream();
            buffered = null;
            bufferedWriter = null;
            buffered = new BufferedReader(viewer.getReader());
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            int maxLength = 0;
            while ((line = buffered.readLine()) != null) {
                bufferedWriter.write(line, 0, line.length());
                bufferedWriter.write(10);
                if (line.length() + 1 <= maxLength) continue;
                maxLength = line.length() + 1;
            }
            bufferedWriter.flush();
            p.put((Object)this.getURI("maximumLength"), (Object)Integer.toString(maxLength));
            ResourceInterface resource = this.createTheResource(collection, viewer.getName());
            resource.setContents(baos.toByteArray());
            resource.setProperties(p);
        }
        catch (UnsupportedEncodingException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.viewerError.ex.fmt.txt", (Object)viewer.getName()));
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.viewerError.ex.fmt.txt", (Object)viewer.getName()));
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.viewerError.ex.fmt.txt", (Object)viewer.getName()));
        }
        finally {
            try {
                if (buffered != null) {
                    buffered.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(RB.getStringResource("DAVTransport.viewerPub.txt"));
        }
    }

    private int publishHTMLSet(CollectionInterface collection, EntryInterface entry, int position, int looseSet) throws RemoteException, TransportException {
        PropertyMap p = new PropertyMap();
        HTMLFileInterface file = ((HTMLEntryInterface)entry).getFile();
        if (file != null) {
            this.setHTMLProperties(file, p, looseSet);
            this.setCommonEntryProperties(p, entry, position);
            ++position;
            String name = null;
            name = file.getURL();
            if (name == null) {
                name = file.getName();
            }
            try {
                this.publishTheFile(file.getInputStream(), file.getName(), name, collection, p);
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.fileError.ex.fmt.txt", (Object)file.getName()));
            }
        }
        HTMLFileInterface[] files = ((HTMLEntryInterface)entry).getCompanionFiles();
        for (int f = 0; f < files.length; ++f) {
            file = files[f];
            p.clear();
            this.setHTMLProperties(file, p, looseSet);
            this.setCommonEntryProperties(p, entry, position);
            ++position;
            String name = null;
            name = file.getURL();
            if (name == null) {
                name = file.getName();
            }
            try {
                this.publishTheFile(file.getInputStream(), file.getName(), name, collection, p);
                continue;
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.fileError.ex.fmt.txt", (Object)file.getName()));
            }
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(RB.getStringResource("DAVTransport.htmlPub.txt"));
        }
        return position - 1;
    }

    private void setHTMLProperties(HTMLFileInterface file, PropertyMap p, int looseSet) throws RemoteException {
        p.put((Object)this.getURI("type"), (Object)"html");
        p.put((Object)this.getURI("htmllooseset"), (Object)Integer.toString(looseSet));
        String mimeType = file.getMIMEType();
        if (mimeType != null) {
            StringBuffer buf = new StringBuffer();
            buf.append('\"');
            buf.append(mimeType);
            buf.append('\"');
            p.put((Object)this.getURI("mimeType"), (Object)buf.toString());
        }
        HTMLEncodingParser parser = new HTMLEncodingParser();
        Map m = null;
        try {
            m = parser.parse(file);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (m == null) {
            p.put((Object)this.getURI("encodingOffset"), (Object)Integer.toString(0));
            String userEncoding = file.getEncoding();
            if (userEncoding != null) {
                p.put((Object)this.getURI("encoding"), (Object)userEncoding);
            } else {
                p.put((Object)this.getURI("encoding"), (Object)"ISO-8859-1");
            }
        } else {
            Integer eOffset = (Integer)m.get("OFFSET");
            p.put((Object)this.getURI("encodingOffset"), (Object)eOffset.toString());
            p.put((Object)this.getURI("encoding"), m.get("ENCODING"));
        }
        int role = file.getRole();
        if (role == 7 || role == 3) {
            p.put((Object)this.getURI("frame"), null);
        } else if (role == 1 || role == 2) {
            p.put((Object)this.getURI("body"), null);
        } else if (role == 5) {
            p.put((Object)this.getURI("pages"), null);
        } else if (role == 4) {
            p.put((Object)this.getURI("contents"), null);
        } else {
            p.put((Object)this.getURI("frameset"), null);
        }
    }

    private Map getUpdateProps(CollectionInterface coll) throws TransportException {
        int position = 0;
        int loose = 0;
        try {
            Iterator it = coll.getDavChildrenProperties().entrySet().iterator();
            Map.Entry mapEntry = null;
            while (it.hasNext()) {
                int i;
                mapEntry = it.next();
                PropertyMap p = (PropertyMap)mapEntry.getValue();
                String v = (String)p.get((Object)this.getURI("position"));
                if (v != null && (i = Integer.parseInt(v)) > position) {
                    position = i;
                }
                if ((v = (String)p.get((Object)this.getURI("htmllooseset"))) == null || (i = Integer.parseInt(v)) <= loose) continue;
                loose = i;
            }
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.setProperties.ex.txt"));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.setProperties.ex.txt"));
        }
        catch (ParserConfigurationException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.setProperties.ex.txt"));
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (position > 0) {
            ++position;
        }
        returnMap.put("position", String.valueOf(position));
        returnMap.put("htmllooseset", String.valueOf(++loose));
        return returnMap;
    }

    private boolean resourceExists(CollectionInterface collection, String name) throws TransportException {
        boolean exists = false;
        String finalUrl = null;
        try {
            StringBuffer b;
            String cUrl = collection.getURL();
            if (!cUrl.endsWith("/")) {
                b = new StringBuffer();
                b.append(cUrl);
                b.append("/");
                b.append(name);
                finalUrl = b.toString();
            } else {
                b = new StringBuffer();
                b.append(cUrl);
                b.append(name);
                finalUrl = b.toString();
            }
            String path = null;
            try {
                URL __url = new URL(finalUrl);
                path = __url.getPath();
            }
            catch (MalformedURLException mue) {
                throw new TransportException((Throwable)mue, RB.getStringResource("DAVTransport.pubError.ex.txt"));
            }
            ResourceInterface r = ResourceFactory.bindResource((ResourceInterface)collection, (String)path);
            if (r != null) {
                exists = r.exists();
            }
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.pubError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.pubError.ex.txt"));
        }
        return exists;
    }

    private void publishTheFile(InputStream instream, String streamName, String resourceName, CollectionInterface collection, PropertyMap p) throws TransportException {
        DataInputStream stream = new DataInputStream(instream);
        try {
            ResourceInterface resource = this.createTheResource(collection, resourceName);
            resource.setContents((InputStream)new InputStreamAdapter((InputStream)stream));
            resource.setProperties(p);
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.fileError.ex.fmt.txt", (Object)streamName));
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTransport.fileError.ex.fmt.txt", (Object)streamName));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                stream = null;
            }
        }
    }

    private void initializeTransport() throws TransportException {
        block16: {
            SessionContextInterface sessionContext = this.getSessionContext();
            if (sessionContext != null) {
                try {
                    final UserContextInterface userContext = sessionContext.getUserContext();
                    if (userContext != null) {
                        this.repositories = userContext.getRepositories();
                    }
                    if (this._domain == null) break block16;
                    PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return userContext.getIdentitiesByDomain(DAVTransport.this._domain, true, "");
                        }
                    };
                    if (userContext == null) break block16;
                    try {
                        List ilist = (List)AccessController.doPrivileged(action);
                        this._userIdentities = ilist.iterator();
                        if (this._userIdentities.hasNext()) {
                            this._userIdentity = (UserIdentityInterface)this._userIdentities.next();
                        }
                    }
                    catch (PrivilegedActionException pae) {
                        Throwable t = pae.getCause();
                        throw new TransportException(t, RB.getStringResource("DAVTransport.pubError.ex.txt"));
                    }
                }
                catch (ServiceException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.pubError.ex.txt"));
                }
                catch (RemoteException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.pubError.ex.txt"));
                }
            }
        }
        if (this._proxyUrlStr != null && this._proxyUrlStr.length() > 0) {
            try {
                this._proxyUrl = new URL(this._proxyUrlStr);
            }
            catch (MalformedURLException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVTransport.proxyErr.ex.txt"));
            }
        }
        if (this._username != null) {
            this._currentUsername = this._username;
            this._currentPassword = this._password;
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(RB.getStringResource("DAVTransport.bindUserPass.txt"));
            }
        } else if (this._userIdentity != null) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(RB.getStringResource("DAVTransport.bindUserContext.txt"));
            }
            this._currentUsername = (String)this._userIdentity.getPrincipal();
            this._currentPassword = (String)this._userIdentity.getCredential();
        }
    }

    private String getURI(String resourceName) {
        String uriStr = "{http://www.sas.com/rnd/itech/WebDAV}" + resourceName;
        return uriStr;
    }

    private String getPath(String urlStr) {
        String path = null;
        int p = urlStr.indexOf("://");
        if (p > 0) {
            path = (p = urlStr.indexOf("/", p + 3)) > 0 ? urlStr.substring(p) : "";
        }
        return path;
    }

    private SharedResourceInterface findSuitableSharedResource(String url) {
        try {
            if (this.repositories == null) {
                return null;
            }
            for (RepositoryInterface r : this.repositories) {
                if (!(r instanceof DAVRepositoryInterface)) continue;
                DAVRepositoryInterface dri = (DAVRepositoryInterface)r;
                if (URIUtil.url1StartsWithUrl2((String)this.quoteURI(url), (String)this.quoteURI(dri.getHttpUrl())) == null) continue;
                SharedResourceInterface sri = dri.getSharedResource();
                return sri;
            }
        }
        catch (RemoteException reposItems) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    private String quoteURI(String url) {
        String scheme = null;
        String path = null;
        String authority = null;
        int p1 = url.indexOf("://");
        if (p1 != -1) {
            scheme = url.substring(0, p1);
            int p2 = url.indexOf("/", p1 + 3);
            if (p2 != -1) {
                authority = url.substring(p1 + 3, p2);
                path = url.substring(p2);
            } else {
                authority = url.substring(p1 + 3);
                path = "/";
            }
        } else {
            path = url;
        }
        try {
            URI _uri = new URI(scheme, authority, path, null, null);
            return _uri.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return "";
        }
    }
}

