/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.TransportException;
import com.sas.services.publish.AbstractEntry;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.HTMLEntryInterface;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.webdav.DAVHTMLFile;
import com.sas.services.publish.webdav.DAVTransport;
import com.sas.services.publish.webdav.DAVTransportInterface;
import com.sas.services.publish.webdav.RB;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.ResourceInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
class DAVEntry
extends AbstractEntry
implements EntryInterface {
    private boolean _isReadOnly = false;
    private ResourceInterface _resource = null;
    private String _url = null;
    private int _version;
    private DAVTransport _transport;
    private int _position;

    DAVEntry(DAVTransport transport, String url, int version) throws RemoteException {
        this(transport, url, version, null, DAVEntry.class);
    }

    DAVEntry(DAVTransport transport, String url, int version, ResourceInterface resource) throws RemoteException {
        this(transport, url, version, resource, DAVEntry.class);
    }

    protected DAVEntry(DAVTransport transport, String url, int version, Class theClass) throws RemoteException {
        this(transport, url, version, null, theClass);
    }

    protected DAVEntry(DAVTransport transport, String url, int version, ResourceInterface resource, Class theClass) throws RemoteException {
        super(theClass);
        this._url = url;
        this._version = version;
        this._resource = resource;
        this._transport = transport;
    }

    protected final void setIsReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    @Override
    public boolean isReadOnly() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._isReadOnly;
    }

    protected void setResource(ResourceInterface resource) {
        this._resource = resource;
    }

    protected ResourceInterface getResource() throws TransportException {
        if (this._resource == null) {
            try {
                this._resource = this._transport.bindToServer(this._url);
            }
            catch (DAVException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVCommon.bindFailure.ex.txt"));
            }
        }
        return this._resource;
    }

    protected void setURL(String url) {
        this._url = url;
    }

    @Override
    public String getURL() throws IllegalStateException, TransportException {
        return this._url;
    }

    protected void setVersion(int version) {
        this._version = version;
    }

    protected int getVersion() {
        return this._version;
    }

    protected DAVTransportInterface getTransport() {
        return this._transport;
    }

    protected void closeEntry(boolean isThisMainPkg) {
        if (this instanceof HTMLEntryInterface) {
            try {
                DAVHTMLFile file = (DAVHTMLFile)((HTMLEntryInterface)((Object)this)).getFile();
                if (file != null) {
                    file.closeEntry();
                }
            }
            catch (TransportException e) {
                this.printCloseErrorMsg((Exception)((Object)e));
            }
            catch (RemoteException e) {
                this.printCloseErrorMsg(e);
            }
            try {
                HTMLFileInterface[] companions = ((HTMLEntryInterface)((Object)this)).getCompanionFiles();
                for (int i = 0; i < companions.length; ++i) {
                    DAVHTMLFile file = (DAVHTMLFile)companions[i];
                    file.closeEntry();
                }
            }
            catch (TransportException e) {
                this.printCloseErrorMsg((Exception)((Object)e));
            }
            catch (RemoteException e) {
                this.printCloseErrorMsg(e);
            }
        } else if (!isThisMainPkg && this instanceof ResultPackageInterface) {
            ResultPackageInterface rpkg = (ResultPackageInterface)((Object)this);
            EntryInterface[] _entries = null;
            try {
                _entries = rpkg.getEntries();
                for (int i = 0; i < _entries.length; ++i) {
                    DAVEntry e = (DAVEntry)_entries[i];
                    e.closeEntry(false);
                }
            }
            catch (RemoteException e) {
                this.printCloseErrorMsg(e);
            }
            catch (TransportException e) {
                this.printCloseErrorMsg((Exception)((Object)e));
            }
        } else if (isThisMainPkg) {
            try {
                this._resource.close();
            }
            catch (DAVException e) {
                this.printCloseErrorMsg((Exception)((Object)e));
            }
            catch (RemoteException e) {
                this.printCloseErrorMsg(e);
            }
        }
        this._resource = null;
        this._transport = null;
        this.setClosed(true);
    }

    protected int getPosition() {
        return this._position;
    }

    protected void setPosition(int position) {
        this._position = position;
    }

    private void printCloseErrorMsg(Exception e) {
        Logger logger = LogManager.getLogger(DAVEntry.class);
        String errMsg = null;
        String string = errMsg = this._url == null ? RB.getStringResource("DAVEntry.closeEntryError.txt") : Message.format((ResourceBundle)RB.getResources(), (String)"DAVEntry.closeEntryError.fmt.txt", (Object)this._url);
        if (logger != null) {
            logger.warn(errMsg, (Throwable)e);
        } else {
            System.err.println(errMsg);
        }
    }
}

