/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.TransportException;
import com.sas.services.publish.AnnotatedServiceResultSet;
import com.sas.services.publish.DatasetEntryInterface;
import com.sas.services.publish.DatasetRetriever;
import com.sas.services.publish.RemoteResultSet;
import com.sas.services.publish.RemoteResultSetInterface;
import com.sas.services.publish.ServiceResultSet;
import com.sas.services.publish.webdav.DAVLibraryMemberEntry;
import com.sas.services.publish.webdav.DAVTransport;
import com.sas.services.publish.webdav.RB;
import com.sas.services.webdav.DAVException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.sql.ResultSet;

@SASScope
class DAVDatasetEntry
extends DAVLibraryMemberEntry
implements DatasetEntryInterface {
    private String _encoding = null;
    private static final ResultSet DUMMY_RESULTSET = new ServiceResultSet(null);
    private int _nobs = -1;

    DAVDatasetEntry(DAVTransport transport, String url, int version, String memberName) throws RemoteException {
        this(transport, url, version, memberName, DAVDatasetEntry.class);
    }

    private DAVDatasetEntry(DAVTransport transport, String url, int version, String memberName, Class theClass) throws RemoteException {
        super(transport, url, version, 1, memberName, theClass);
    }

    protected void setTextEncoding(String encoding) {
        this._encoding = encoding;
    }

    void setNobs(int nobs) {
        this._nobs = nobs;
    }

    InputStream getInputStream() throws TransportException {
        InputStream stream = null;
        if (this.getVersion() > 34) {
            throw new TransportException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        try {
            stream = this.getResource().getContents();
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVDatasetEntry.getContentsTransportException.ex.txt"));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVDatasetEntry.getContentsTransportException.ex.txt"));
        }
        return stream;
    }

    @Override
    public ResultSet getResultSet() throws TransportException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 34) {
            throw new TransportException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        DatasetRetriever retriever = new DatasetRetriever(new DataInputStream(new BufferedInputStream(this.getInputStream())), this._encoding, this.getVersion(), this._nobs);
        ServiceResultSet resultSet = null;
        resultSet = this.getVersion() >= 34 ? new AnnotatedServiceResultSet(retriever, this._nobs) : new ServiceResultSet(retriever, this._nobs);
        retriever.initialize();
        retriever.readVariableDefinitions();
        resultSet.setNumColumns(retriever.getColumnCount());
        resultSet.setColumns(retriever.getColumns());
        return resultSet;
    }

    @Override
    public RemoteResultSetInterface getRemoteResultSet() throws RemoteException, IllegalStateException, TransportException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 34) {
            throw new TransportException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        return new RemoteResultSet(this.getResultSet());
    }

    @Override
    public Object hasResultSet() throws UnmarshalException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_RESULTSET;
    }
}

