/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.requester;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IResultPackage;
import com.sas.iom.SAS.IResultPackageService;
import com.sas.iom.SAS.IResultPackageServiceHelper;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IUtilitiesHelper;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.services.TransportException;
import com.sas.services.publish.AbstractTransport;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.requester.RB;
import com.sas.services.publish.requester.RequesterResultPackage;
import com.sas.services.publish.requester.RequesterTransportInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;

@SASScope
public class RequesterTransport
extends AbstractTransport
implements RequesterTransportInterface {
    private IResultPackage _iResultPackage;
    private IWorkspace _iWorkspace;
    private String _transportInformation;
    private String[][] _properties;
    private int _whichConstructor;
    private static final int RESULTPACKAGE_CONSTRUCTOR = 0;
    private static final int TRANSPORTINFO_CONSTRUCTOR = 1;

    public RequesterTransport(IResultPackage iResultPackage, Logger logger, SessionContextInterface sessionContext) throws TransportException {
        this._iResultPackage = iResultPackage;
        this._whichConstructor = 0;
        this.setSessionAndLogger(logger, sessionContext);
    }

    public RequesterTransport(IResultPackage iResultPackage, SessionContextInterface sessionContext) throws TransportException {
        this(iResultPackage, null, sessionContext);
    }

    public RequesterTransport(IWorkspace iWorkspace, String transportInformation, String[][] properties, SessionContextInterface sessionContext) throws TransportException {
        this(iWorkspace, transportInformation, properties, null, sessionContext);
    }

    public RequesterTransport(IWorkspace iWorkspace, String transportInformation, String[][] properties, Logger logger, SessionContextInterface sessionContext) throws TransportException {
        this._iWorkspace = iWorkspace;
        this._transportInformation = transportInformation;
        this._properties = properties;
        if (this._properties == null) {
            this._properties = new String[0][0];
        }
        this._whichConstructor = 1;
        this.setSessionAndLogger(logger, sessionContext);
    }

    @Override
    public ResultPackageInterface getResultPackage() throws TransportException {
        RequesterResultPackage resultPackage;
        block9: {
            resultPackage = null;
            if (this._whichConstructor == 1) {
                try {
                    IUtilities obj = this._iWorkspace.Utilities();
                    IUtilities utilities = IUtilitiesHelper.narrow((Object)obj);
                    obj = utilities.ResultPackageService();
                    IResultPackageService resultPackageService = IResultPackageServiceHelper.narrow((Object)obj);
                    this._iResultPackage = resultPackageService.BrowseResultPackage("ARCHIVE", this._transportInformation, this._properties);
                }
                catch (GenericError e) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
                    throw new TransportException((Throwable)e, msg);
                }
            }
            try {
                boolean parentInfoKnown = this._whichConstructor == 1;
                resultPackage = new RequesterResultPackage(this, this._iWorkspace, this._iResultPackage, null, parentInfoKnown);
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("RT.remEx.ex.txt"));
            }
            SessionContextInterface sessionContext = this.getSessionContext();
            Logger logger = LogManager.getLogger(RequesterTransport.class);
            if (sessionContext != null) {
                try {
                    String key = "com.sas.services.publish." + resultPackage.getUniqueId();
                    sessionContext.setAttribute(key, (java.lang.Object)resultPackage);
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug(RB.getStringResource("RT.trkInSessn.txt"));
                    }
                }
                catch (RemoteException e) {
                    if (logger == null) break block9;
                    logger.warn(RB.getStringResource("RT.errTrkInSessn.txt"), (Throwable)e);
                }
            }
        }
        return resultPackage;
    }

    @Override
    public EventDataInterface publishResultPackage(ResultPackageInterface rpkg, boolean buildEvent) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(RB.getStringResource("COM.unsup.ex.txt"));
    }
}

