/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.requester;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.ReaderAdapter;
import com.sas.io.RemoteReaderInterface;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.ITextStreamHelper;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.services.publish.TextFileEntryInterface;
import com.sas.services.publish.requester.RB;
import com.sas.services.publish.requester.RequesterFileEntry;
import com.sas.services.publish.requester.RequesterIOMReader;
import com.sas.services.publish.requester.RequesterTextFileSupport;
import com.sas.text.Message;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.omg.CORBA.Object;

@SASScope
class RequesterTextFileEntry
extends RequesterFileEntry
implements TextFileEntryInterface {
    static CharArrayReader dummyReader = new CharArrayReader(new char[1]);
    static final int MAX_LINE_SIZE = 4096;

    RequesterTextFileEntry(Object iomEntry) throws RemoteException {
        super(iomEntry, RequesterTextFileEntry.class);
    }

    @Override
    public java.lang.Object hasReader() {
        return dummyReader;
    }

    @Override
    public Reader getReader(java.lang.Object streamID) throws ChainedIOException {
        this.throwExceptionIfClosed();
        try {
            StreamOpenMode readmode = StreamOpenMode.StreamOpenModeForReading;
            Object fo = this._iomEntry.Open(readmode, 4096);
            ITextStream inStream = ITextStreamHelper.narrow((Object)fo);
            return new RequesterIOMReader(inStream);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
    }

    @Override
    public RemoteReaderInterface getRemoteReader(java.lang.Object streamID) throws IOException, RemoteException {
        this.throwExceptionIfClosed();
        return RequesterTextFileSupport.getRemoteReader(this);
    }

    @Override
    public Reader getReader() throws IOException, RemoteException, IllegalStateException {
        return this.getReader(4096);
    }

    @Override
    public Reader getReader(int dataLength) throws IOException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        try {
            StreamOpenMode readmode = StreamOpenMode.StreamOpenModeForReading;
            Object fo = this._iomEntry.Open(readmode, dataLength);
            ITextStream inStream = ITextStreamHelper.narrow((Object)fo);
            return new ReaderAdapter((Reader)new RequesterIOMReader(inStream));
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
    }

    @Override
    public void setEncoding(String encoding) throws IllegalStateException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }
}

