/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.requester;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.InputStreamAdapter;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IResultPackage;
import com.sas.iom.SAS.IResultPackageHelper;
import com.sas.iom.SAS.IResultPackageLibraryMemberEntry;
import com.sas.iom.SAS.IResultPackageLibraryMemberEntryHelper;
import com.sas.iom.SAS.IResultPackageService;
import com.sas.iom.SAS.IResultPackageServiceHelper;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IUtilitiesHelper;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SAS.PackageType;
import com.sas.iom.SAS.PackageTypeSeqHolder;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.net.util.DateConverter;
import com.sas.services.TransportException;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.ResultPackageEventBuilder;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.requester.RB;
import com.sas.services.publish.requester.RequesterAbstractEntry;
import com.sas.services.publish.requester.RequesterBinaryFileEntry;
import com.sas.services.publish.requester.RequesterBinaryFileSupport;
import com.sas.services.publish.requester.RequesterDatasetEntry;
import com.sas.services.publish.requester.RequesterHTMLEntry;
import com.sas.services.publish.requester.RequesterIOMInputStream;
import com.sas.services.publish.requester.RequesterLibraryMemberEntry;
import com.sas.services.publish.requester.RequesterReferenceEntry;
import com.sas.services.publish.requester.RequesterTextFileEntry;
import com.sas.services.publish.requester.RequesterTransport;
import com.sas.services.publish.requester.RequesterViewerEntry;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionContextStateChangedEvent;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

@SASScope
class RequesterResultPackage
extends RequesterAbstractEntry
implements ResultPackageInterface,
RemoteSessionContextStateChangedListener {
    private IResultPackage _resultPackage;
    private IWorkspace _workspace;
    private String _abstract;
    private long _creationDateTime = -1L;
    private long _expirationDateTime = -1L;
    private boolean _gotEntriesInEntriesArray;
    private PackageType[] _types;
    private String[] _entryDescriptions;
    private RequesterAbstractEntry[] _entries;
    private int _entryCount;
    boolean _triedToObtainNestedName;
    private RequesterResultPackage _parentRequesterResultPackage;
    private String _uniqueId = new VMID().toString();
    private Logger logger = LogManager.getLogger(RequesterResultPackage.class);
    private SessionContextInterface _sessionContext;
    private Map _allMyEntries = new HashMap();
    private boolean _parentInfoKnown;
    private boolean _isNested;
    private boolean _isNestedDetermined;
    static ByteArrayInputStream dummyInputStream = new ByteArrayInputStream(new byte[1]);

    RequesterResultPackage(RequesterTransport transport, IWorkspace workspace, IResultPackage resultPackage, RequesterResultPackage parentRequesterResultPackage, boolean parentInfoKnown) throws TransportException, RemoteException {
        super(RequesterResultPackage.class);
        this._workspace = workspace;
        this._resultPackage = resultPackage;
        this._parentRequesterResultPackage = parentRequesterResultPackage;
        this._parentInfoKnown = parentInfoKnown;
        this._sessionContext = transport.getSessionContext();
        String description = this._resultPackage.Description();
        this.setDescriptionEvenThoughItsBrowseOnly(description);
        try {
            this.getTypesArray();
        }
        catch (UNKNOWN e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RRP.invPkg.ex.txt", (java.lang.Object)e.toString());
            throw new TransportException((Throwable)e, msg);
        }
        this.isNested();
    }

    private RequesterResultPackage(SessionContextInterface sessionContext, IWorkspace workspace, IResultPackage resultPackage, RequesterResultPackage parentRequesterResultPackage) throws TransportException, RemoteException {
        this._workspace = workspace;
        this._resultPackage = resultPackage;
        this._parentRequesterResultPackage = parentRequesterResultPackage;
        this._sessionContext = sessionContext;
        this._parentInfoKnown = true;
        try {
            this.getTypesArray();
        }
        catch (UNKNOWN e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RRP.invPkg.ex.txt", (java.lang.Object)e.toString());
            throw new TransportException((Throwable)e, msg);
        }
        this.isNested();
    }

    @Override
    public java.lang.Object hasInputStream() {
        this.throwExceptionIfClosed();
        return dummyInputStream;
    }

    @Override
    public InputStream getInputStream(java.lang.Object streamID) throws ChainedIOException {
        this.throwExceptionIfClosed();
        if (this.isNested()) {
            throw new IllegalStateException(RB.getStringResource("RRP.inpStrmNestd.ex.txt"));
        }
        try {
            String filename = this._resultPackage.TransportInformation();
            IFileService fileService = this.getWorkspace().FileService();
            StringHolder assName = new StringHolder();
            IFileref fileref = fileService.AssignFileref("", "DISK", filename, "", assName);
            StreamOpenMode readmode = StreamOpenMode.StreamOpenModeForReading;
            IBinaryStream inStream = fileref.OpenBinaryStream(readmode);
            return new RequesterIOMInputStream(inStream);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(java.lang.Object streamID) throws IOException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isNested()) {
            throw new IllegalStateException(RB.getStringResource("RRP.inpStrmNestd.ex.txt"));
        }
        return RequesterBinaryFileSupport.getRemoteInputStream(this);
    }

    @Override
    public InputStream getInputStream() throws ChainedIOException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isNested()) {
            throw new IllegalStateException(RB.getStringResource("RRP.inpStrmNestd.ex.txt"));
        }
        try {
            String filename = this._resultPackage.TransportInformation();
            IFileService fileService = this.getWorkspace().FileService();
            StringHolder assName = new StringHolder();
            IFileref fileref = fileService.AssignFileref("", "DISK", filename, "", assName);
            StreamOpenMode readmode = StreamOpenMode.StreamOpenModeForReading;
            IBinaryStream inStream = fileref.OpenBinaryStream(readmode);
            RequesterIOMInputStream is = new RequesterIOMInputStream(inStream);
            return new InputStreamAdapter((InputStream)is);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
    }

    @Override
    public String getAbstract() throws TransportException {
        this.throwExceptionIfClosed();
        if (this._abstract == null) {
            try {
                this._abstract = this._resultPackage.Abstract();
            }
            catch (SystemException e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
                throw new TransportException((Throwable)e, msg);
            }
        }
        return this._abstract;
    }

    @Override
    public void setAbstract(String pkgAbstract) throws IllegalStateException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    public long getExpirationDateTime() throws TransportException {
        this.throwExceptionIfClosed();
        if (this._expirationDateTime == -1L) {
            try {
                long temp = this._resultPackage.ExpirationDateTime();
                this._expirationDateTime = DateConverter.corbaToJavaGMT((long)temp).getTime();
            }
            catch (SystemException e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
                throw new TransportException((Throwable)e, msg);
            }
        }
        return this._expirationDateTime;
    }

    @Override
    public void setExpirationDateTime(long expirationDateTime) throws IllegalStateException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    public long getCreationDateTime() throws TransportException {
        this.throwExceptionIfClosed();
        if (this._creationDateTime == -1L) {
            try {
                long temp = this._resultPackage.CreationDateTime();
                this._creationDateTime = DateConverter.corbaToJavaGMT((long)temp).getTime();
            }
            catch (SystemException e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
                throw new TransportException((Throwable)e, msg);
            }
        }
        return this._creationDateTime;
    }

    public void setCreationDateTime(long creationDateTime) throws IllegalStateException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    public String getName() {
        this.throwExceptionIfClosed();
        return null;
    }

    @Override
    public void setName(String name) throws IllegalStateException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    public EntryInterface getEntry(int index) throws TransportException, RemoteException {
        this.throwExceptionIfClosed();
        if (index >= this._entryCount) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RRP.noEntry.ex.fmt.txt", (java.lang.Object)index, (java.lang.Object)this._entryCount);
            throw new ArrayIndexOutOfBoundsException(msg);
        }
        RequesterAbstractEntry retVal = this._entries[index];
        try {
            if (retVal == null) {
                Object iomEntry = this._resultPackage.GetEntry(index);
                int type = this._types[index].value();
                RequesterAbstractEntry entry = null;
                switch (type) {
                    case 0: {
                        IResultPackage resultPackage = IResultPackageHelper.narrow((Object)iomEntry);
                        entry = new RequesterResultPackage(this._sessionContext, this._workspace, resultPackage, this);
                        break;
                    }
                    case 1: {
                        entry = new RequesterHTMLEntry(iomEntry);
                        break;
                    }
                    case 2: {
                        IResultPackageLibraryMemberEntry le = IResultPackageLibraryMemberEntryHelper.narrow((Object)iomEntry);
                        String memberType = le.MemberType();
                        if (memberType.equalsIgnoreCase("catalog")) {
                            entry = new RequesterLibraryMemberEntry(iomEntry, 2);
                            break;
                        }
                        if (memberType.equalsIgnoreCase("data")) {
                            entry = new RequesterDatasetEntry(this, iomEntry);
                            break;
                        }
                        if (memberType.equalsIgnoreCase("fdb")) {
                            entry = new RequesterLibraryMemberEntry(iomEntry, 4);
                            break;
                        }
                        if (memberType.equalsIgnoreCase("mddb")) {
                            entry = new RequesterLibraryMemberEntry(iomEntry, 3);
                            break;
                        }
                        if (!memberType.equalsIgnoreCase("view")) break;
                        entry = new RequesterLibraryMemberEntry(iomEntry, 5);
                        break;
                    }
                    case 3: {
                        entry = new RequesterTextFileEntry(iomEntry);
                        break;
                    }
                    case 4: {
                        entry = new RequesterBinaryFileEntry(iomEntry);
                        break;
                    }
                    case 5: {
                        entry = new RequesterReferenceEntry(iomEntry);
                        break;
                    }
                    case 6: {
                        entry = new RequesterViewerEntry(iomEntry);
                        break;
                    }
                    default: {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RRP.unkTyp.ex.fmt.txt", (java.lang.Object)type);
                        throw new TransportException(msg);
                    }
                }
                entry.setDescriptionEvenThoughItsBrowseOnly(this._entryDescriptions[index]);
                this._allMyEntries.put(entry.getEntityKey(), entry);
                this._entries[index] = retVal = entry;
            }
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new TransportException((Throwable)e, msg);
        }
        return retVal;
    }

    @Override
    public EntryInterface getEntry(String uniqueId) throws IllegalStateException, RemoteException, TransportException {
        this.throwExceptionIfClosed();
        return this.findEntry(uniqueId);
    }

    private EntryInterface findEntry(String uniqueId) throws TransportException, RemoteException {
        EntryInterface foundEntry = (EntryInterface)this._allMyEntries.get(uniqueId);
        if (foundEntry == null) {
            for (int i = 0; i < this._entryCount && foundEntry == null; ++i) {
                RequesterAbstractEntry entry = this._entries[i];
                if (!(entry instanceof ResultPackageInterface)) continue;
                RequesterResultPackage nestedPkg = (RequesterResultPackage)entry;
                foundEntry = nestedPkg.findEntry(uniqueId);
            }
        }
        return foundEntry;
    }

    @Override
    public EntryInterface[] getEntries() throws TransportException, RemoteException {
        this.throwExceptionIfClosed();
        if (!this._gotEntriesInEntriesArray) {
            for (int i = 0; i < this._entryCount; ++i) {
                this.getEntry(i);
            }
            this._gotEntriesInEntriesArray = true;
        }
        EntryInterface[] retEntries = new EntryInterface[this._entryCount];
        System.arraycopy(this._entries, 0, retEntries, 0, this._entryCount);
        return retEntries;
    }

    @Override
    public void addEntry(EntryInterface entry) throws IllegalStateException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    public boolean isNested() {
        this.throwExceptionIfClosed();
        if (!this._isNestedDetermined) {
            IResultPackage rp;
            Object parent;
            IResultPackage possibleRp;
            this._isNested = this._parentInfoKnown ? this._parentRequesterResultPackage != null : (possibleRp = IResultPackageHelper.narrow((Object)(parent = (rp = this._resultPackage).Container()))) != null;
            this._isNestedDetermined = true;
        }
        return this._isNested;
    }

    @Override
    public void close() {
        block4: {
            this.throwExceptionIfClosed();
            if (this.isNested()) {
                throw new IllegalStateException(RB.getStringResource("RRP.clsNestd.ex.txt"));
            }
            this.closeEntry();
            if (this._sessionContext != null) {
                try {
                    this._sessionContext.removeAttribute("com.sas.services.publish." + this._uniqueId);
                }
                catch (RemoteException e) {
                    if (this.logger == null || !this.logger.isDebugEnabled()) break block4;
                    this.logger.debug(RB.getStringResource("RRP.errRmvngFrmSessn.txt"), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException(RB.getStringResource("COM.unsup.ex.txt"));
    }

    @Override
    protected void closeEntry() {
        for (int i = 0; i < this._entryCount; ++i) {
            if (this._entries[i] == null) continue;
            this._entries[i].closeEntry();
        }
        super.closeEntry();
        this._resultPackage = null;
        this._workspace = null;
        this._abstract = null;
        this._entryDescriptions = null;
        this._entries = null;
        this._parentRequesterResultPackage = null;
    }

    private void getTypesArray() throws TransportException {
        try {
            PackageTypeSeqHolder packageTypesHolder = new PackageTypeSeqHolder();
            StringSeqHolder descriptionsHolder = new StringSeqHolder();
            LongSeqHolder indexHolder = new LongSeqHolder();
            this._resultPackage.ListEntries("", packageTypesHolder, descriptionsHolder, indexHolder);
            this._types = packageTypesHolder.value;
            this._entryDescriptions = descriptionsHolder.value;
            this._entryCount = this._types.length;
            this._entries = new RequesterAbstractEntry[this._entryCount];
            if (this.logger != null && this.logger.isInfoEnabled()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RRP.entryCnt.fmt.txt", (java.lang.Object)this._entryCount);
                this.logger.info(msg);
                for (int i = 0; i < this._entryCount; ++i) {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"RRP.entry.fmt.txt", (java.lang.Object)Integer.toString(i), (java.lang.Object)Integer.toString(this._types[i].value()), (java.lang.Object)this._entryDescriptions[i]);
                    this.logger.info(msg);
                }
            }
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new TransportException((Throwable)e, msg);
        }
    }

    @Override
    protected void subSetNameValuePairs() throws TransportException, RemoteException {
        try {
            VariableArray2dOfStringHolder holder = new VariableArray2dOfStringHolder();
            this._resultPackage.GetNameValuePairs(holder);
            this.setNameValuePairs(holder);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new TransportException((Throwable)e, msg);
        }
    }

    IWorkspace getWorkspace() {
        if (this._workspace == null && this._parentRequesterResultPackage != null) {
            this._workspace = this._parentRequesterResultPackage.getWorkspace();
        }
        if (this._workspace == null) {
            this.setWorkspace();
        }
        return this._workspace;
    }

    private void setWorkspace() {
        Object parent;
        IResultPackage possibleRp;
        IResultPackage rp = this._resultPackage;
        while ((possibleRp = IResultPackageHelper.narrow((Object)(parent = rp.Container()))) != null) {
            rp = possibleRp;
        }
        IResultPackageService resultPackageService = IResultPackageServiceHelper.narrow((Object)parent);
        parent = resultPackageService.Parent();
        IUtilities utilities = IUtilitiesHelper.narrow((Object)parent);
        this._workspace = IWorkspaceHelper.narrow((Object)utilities.Parent());
    }

    protected String getUniqueId() {
        return this._uniqueId;
    }

    public void contextStateChanged(SessionContextStateChangedEvent event) throws RemoteException {
        int state = event.getStateChange();
        if (state == 2) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(RB.getStringResource("RRP.sessnDstryd.txt"));
            }
            this._sessionContext = null;
            try {
                this.close();
            }
            catch (IllegalStateException e) {
                if (this.logger != null) {
                    this.logger.warn(RB.getStringResource("RRP.unexpDstryErr.txt"), (Throwable)e);
                }
            }
        } else if (state == 1 && this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(RB.getStringResource("RRP.rmvdFrmSessn.txt"));
        }
    }

    @Override
    public EventDataInterface getEventData() throws TransportException, RemoteException {
        EventDataInterface eventData = null;
        ResultPackageEventBuilder builder = new ResultPackageEventBuilder();
        eventData = builder.buildEvent(this, this.getName(), null, "requester", null);
        return eventData;
    }
}

