/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.requester;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.rio.MVAConnection;
import com.sas.rio.MVAResultSet;
import com.sas.rio.MVAResultSetMetaData;
import com.sas.rio.MVAStatement;
import com.sas.rio.RIOException;
import com.sas.services.TransportException;
import com.sas.services.publish.AnnotatedServiceResultSet;
import com.sas.services.publish.CharacterObsValue;
import com.sas.services.publish.Column;
import com.sas.services.publish.DatasetEntryCallbackInterface;
import com.sas.services.publish.DatasetEntryInterface;
import com.sas.services.publish.DateTimeObsValue;
import com.sas.services.publish.ExtendedAttributeData;
import com.sas.services.publish.NumericObsValue;
import com.sas.services.publish.ObsValue;
import com.sas.services.publish.RemoteResultSet;
import com.sas.services.publish.RemoteResultSetInterface;
import com.sas.services.publish.ServiceResultSet;
import com.sas.services.publish.requester.RB;
import com.sas.services.publish.requester.RequesterLibraryMemberEntry;
import com.sas.services.publish.requester.RequesterResultPackage;
import com.sas.sql.AnnotatedResultSet;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;

@SASScope
class RequesterDatasetEntry
extends RequesterLibraryMemberEntry
implements DatasetEntryInterface {
    private IWorkspace _iWorkspace;
    RequesterResultPackage _requesterResultPackage;
    private static final ResultSet DUMMY_RESULTSET = new ServiceResultSet(null);

    RequesterDatasetEntry(RequesterResultPackage requesterResultPackage, Object iomEntry) throws RemoteException {
        super(iomEntry, 1, RequesterDatasetEntry.class);
        this._requesterResultPackage = requesterResultPackage;
    }

    private IWorkspace getWorkspace() {
        if (this._iWorkspace == null) {
            this._iWorkspace = this._requesterResultPackage.getWorkspace();
        }
        return this._iWorkspace;
    }

    @Override
    public ResultSet getResultSet() throws TransportException {
        this.throwExceptionIfClosed();
        Retriever retriever = new Retriever();
        retriever.establishConnection();
        retriever.setVariableDefinitions();
        ServiceResultSet resultSet = null;
        try {
            resultSet = retriever.hasExtendedAttributes() ? new AnnotatedServiceResultSet(retriever, retriever.getNumRows()) : new ServiceResultSet(retriever, retriever.getNumRows());
        }
        catch (SQLException e) {
            throw new TransportException(e.getMessage());
        }
        resultSet.setNumColumns(retriever._numColumns);
        resultSet.setColumns(retriever._columns);
        return resultSet;
    }

    @Override
    public RemoteResultSetInterface getRemoteResultSet() throws TransportException, RemoteException {
        this.throwExceptionIfClosed();
        return new RemoteResultSet(this.getResultSet());
    }

    @Override
    public java.lang.Object hasResultSet() {
        this.throwExceptionIfClosed();
        return DUMMY_RESULTSET;
    }

    @SASScope
    private class Retriever
    implements DatasetEntryCallbackInterface {
        int _numRows;
        int _numColumns;
        Column[] _columns;
        MVAResultSet _mvaRS;
        ExtendedAttributeData _extendedAttributeData = new ExtendedAttributeData();

        private Retriever() {
        }

        public boolean hasExtendedAttributes() throws SQLException {
            return this._mvaRS.isWrapperFor(AnnotatedResultSet.class);
        }

        @Override
        public synchronized void close() {
            block3: {
                if (this._mvaRS != null) {
                    try {
                        this._mvaRS.close();
                        this._mvaRS = null;
                    }
                    catch (Exception e) {
                        Logger logger = LogManager.getLogger(RequesterDatasetEntry.class);
                        if (logger == null) break block3;
                        logger.warn(RB.getStringResource("RDE.clsRS.ex.txt"), (Throwable)e);
                    }
                }
            }
        }

        public int getNumRows() throws TransportException {
            return this._numRows;
        }

        @Override
        public Vector getObservations() throws TransportException {
            ObsValue[] currentRow = this.getObservation();
            if (currentRow == null) {
                return null;
            }
            Vector<ObsValue[]> v = new Vector<ObsValue[]>();
            v.addElement(currentRow);
            return v;
        }

        void establishConnection() throws TransportException {
            MVAStatement statement;
            MVAConnection connection;
            String library = RequesterDatasetEntry.this._iomEntry.Libname();
            String member = RequesterDatasetEntry.this._iomEntry.Member();
            IWorkspace workspace = RequesterDatasetEntry.this.getWorkspace();
            IDataService rio = workspace.DataService();
            try {
                connection = new MVAConnection(rio, new Properties());
                if (connection == null) {
                    throw new TransportException(RB.getStringResource("RDE.noConn.ex.txt"));
                }
            }
            catch (SQLException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("RDE.sql.ex.txt"));
            }
            try {
                statement = (MVAStatement)connection.createStatement();
                if (statement == null) {
                    throw new TransportException(RB.getStringResource("RDE.noStmt.ex.txt"));
                }
            }
            catch (SQLException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("RDE.sql.ex.txt"));
            }
            try {
                ResultSet result = statement.executeQuery("SELECT COUNT(*) from " + library + '.' + member + ';');
                if (result.next()) {
                    this._numRows = result.getInt(1);
                }
                this._mvaRS = (MVAResultSet)statement.executeQuery("SELECT * from " + library + '.' + member + ';');
                if (this._mvaRS == null) {
                    throw new TransportException(RB.getStringResource("RDE.noRS.ex.txt"));
                }
            }
            catch (SQLException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("RDE.sql.ex.txt"));
            }
        }

        void setVariableDefinitions() throws TransportException {
            try {
                String key;
                boolean missing;
                MVAResultSetMetaData rsm = (MVAResultSetMetaData)this._mvaRS.getMetaData();
                if (rsm == null) {
                    throw new TransportException(RB.getStringResource("RDE.noMeta.ex.txt"));
                }
                AnnotatedResultSet attrs = null;
                if (this._mvaRS.isWrapperFor(AnnotatedResultSet.class) && (attrs = (AnnotatedResultSet)this._mvaRS.unwrap(AnnotatedResultSet.class)).hasResultSetAnnotations()) {
                    Map dsattrs = attrs.getResultSetAnnotations();
                    String[] missingAttrs = attrs.wasAnnotationsNull();
                    Map<String, String> dsCharAttrs = this._extendedAttributeData.getDataSetCharacterAttributes();
                    Map<String, Double> dsNumAttrs = this._extendedAttributeData.getDataSetNumericAttributes();
                    Map<String, Character> dsMissingAttrs = this._extendedAttributeData.getDataSetMissingValueAttributes();
                    Iterator it = dsattrs.entrySet().iterator();
                    while (it.hasNext()) {
                        missing = false;
                        Map.Entry pairs = it.next();
                        key = (String)pairs.getKey();
                        for (int i = 0; i < missingAttrs.length; ++i) {
                            if (!key.equals(missingAttrs[i])) continue;
                            dsMissingAttrs.put(key, Character.valueOf('.'));
                            missing = true;
                            break;
                        }
                        if (missing) continue;
                        if (pairs.getValue() instanceof String) {
                            dsCharAttrs.put(key, (String)pairs.getValue());
                            continue;
                        }
                        if (!(pairs.getValue() instanceof Double)) continue;
                        dsNumAttrs.put(key, (Double)pairs.getValue());
                    }
                }
                this._numColumns = rsm.getColumnCount();
                this._columns = new Column[this._numColumns];
                for (int ci = 1; ci <= this._numColumns; ++ci) {
                    Column currentCol;
                    this._columns[ci - 1] = currentCol = new Column();
                    currentCol.setName(rsm.getColumnName(ci));
                    String colFormat = rsm.getColumnFormatName(ci);
                    if (colFormat != null && 0 == colFormat.length()) {
                        colFormat = null;
                    }
                    currentCol.setFormat(colFormat);
                    currentCol.setInformat(rsm.getColumnInformatName(ci));
                    currentCol.setLabel(rsm.getColumnLabel(ci));
                    int columnType = rsm.getColumnType(ci);
                    switch (columnType) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 91: 
                        case 92: 
                        case 93: {
                            currentCol.setType((byte)1);
                            break;
                        }
                        default: {
                            currentCol.setType((byte)2);
                        }
                    }
                    currentCol.setLength(rsm.getColumnDisplaySize(ci));
                    currentCol.setFormatFieldLength((byte)rsm.getColumnFormatLength(ci));
                    currentCol.setFormatDecimal((byte)rsm.getColumnFormatDecimal(ci));
                    currentCol.setInformatFieldLength((short)rsm.getColumnInformatLength(ci));
                    currentCol.setInformatDecimal((short)rsm.getColumnInformatDecimal(ci));
                    currentCol.setSQLType();
                    if (null == attrs || !attrs.hasColumnAnnotations(currentCol.getName())) continue;
                    Map colAttrs = attrs.getColumnAnnotations(currentCol.getName());
                    String[] missingAttrs = attrs.wasAnnotationsNull();
                    Iterator it = colAttrs.entrySet().iterator();
                    while (it.hasNext()) {
                        missing = false;
                        Map.Entry pairs = it.next();
                        key = (String)pairs.getKey();
                        for (int i = 0; i < missingAttrs.length; ++i) {
                            if (!key.equals(missingAttrs[i])) continue;
                            currentCol.getMissingValueAttributes().put(key, Character.valueOf('.'));
                            missing = true;
                            break;
                        }
                        if (missing) continue;
                        if (pairs.getValue() instanceof String) {
                            currentCol.getCharacterAttributes().put(key, (String)pairs.getValue());
                            continue;
                        }
                        if (!(pairs.getValue() instanceof Double)) continue;
                        currentCol.getNumericAttributes().put(key, (Double)pairs.getValue());
                    }
                }
            }
            catch (SQLException ex) {
                throw new TransportException(RB.getStringResource("RDE.sql.ex.txt"));
            }
            catch (RIOException ex) {
                throw new TransportException(RB.getStringResource("RDE.rio.ex.txt"));
            }
        }

        ObsValue[] getObservation() throws TransportException {
            try {
                this._mvaRS.next();
            }
            catch (SQLException ex) {
                throw new TransportException(RB.getStringResource("RDE.sql.ex.txt"));
            }
            int nvars = this._columns.length;
            ObsValue[] currentRow = new ObsValue[nvars];
            for (int y = 0; y < nvars; ++y) {
                int sqltype = this._columns[y].getSQLType();
                try {
                    int index = this._mvaRS.findColumn(this._columns[y].getName());
                    if (sqltype == 93) {
                        currentRow[y] = new DateTimeObsValue(this._columns[y], true, true);
                        ((NumericObsValue)currentRow[y]).setValue(this._mvaRS.getDouble(index));
                    } else if (sqltype == 92) {
                        currentRow[y] = new DateTimeObsValue(this._columns[y], false, true);
                        ((NumericObsValue)currentRow[y]).setValue(this._mvaRS.getDouble(index));
                    } else if (sqltype == 91) {
                        currentRow[y] = new DateTimeObsValue(this._columns[y], true, false);
                        ((NumericObsValue)currentRow[y]).setValue(this._mvaRS.getDouble(index));
                    } else if (sqltype == 12) {
                        currentRow[y] = new CharacterObsValue(this._columns[y]);
                        ((CharacterObsValue)currentRow[y]).setString(this._mvaRS.getString(index));
                    } else {
                        currentRow[y] = new NumericObsValue(this._columns[y]);
                        ((NumericObsValue)currentRow[y]).setValue(this._mvaRS.getDouble(index));
                    }
                    currentRow[y].setMissing(this._mvaRS.wasNull());
                    continue;
                }
                catch (SQLException ex) {
                    throw new TransportException(RB.getStringResource("RDE.sql.ex.txt"));
                }
            }
            return currentRow;
        }

        @Override
        public ExtendedAttributeData getExtendedAttributes() throws TransportException {
            return this._extendedAttributeData;
        }
    }
}

