/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.ArchiveFile;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.ExternalIdentity;
import com.sas.metadata.remote.ITChannel;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Timestamp;
import com.sas.metadata.remote.impl.ArchiveFileImpl;
import com.sas.metadata.remote.impl.ArchiveFileImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.OMRChannel;
import com.sas.services.information.metadata.OMRPerson;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.archive.ArchiveTransport;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.services.publish.metadata.PackageUtil;
import com.sas.services.publish.metadata.RB;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.AttributeMap;
import com.sas.services.util.AttributeMapInterface;
import com.sas.services.util.DateUtil;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class OMRPackage
extends Metadata
implements PackageInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRPackage() throws RemoteException {
        super(OMRPackage.class);
    }

    public OMRPackage(ArchiveFile o) throws RemoteException {
        super((Object)o, OMRPackage.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPackage(ArchiveFileImpl o) throws RemoteException {
        super((Object)o, OMRPackage.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPackage(ArchiveFileImpl_Stub o) throws RemoteException {
        super((Object)o, OMRPackage.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRPackage(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected OMRPackage(ArchiveFile o, Class theClass) throws RemoteException {
        super((Object)o, theClass);
    }

    protected OMRPackage(ArchiveFileImpl o, Class theClass) throws RemoteException {
        super((Object)o, theClass);
    }

    public void setName(String name) throws RemoteException {
    }

    public String getName() throws RemoteException {
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        return arc.getFileName();
    }

    public void setDescription(String description) throws RemoteException {
    }

    public String getType() throws RemoteException {
        return "Package";
    }

    @Override
    public ChannelInterface getChannel() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            ITChannel itChannel = arc.getOwningChannel();
            if (itChannel != null) {
                OMRChannel channel = new OMRChannel(itChannel);
                channel.setRepository(this._repository);
                return channel;
            }
        }
        catch (MdException mdex) {
            this.handleException((Exception)((Object)mdex));
        }
        return null;
    }

    @Override
    public PersonInterface getPublisher() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            AssociationList ass = arc.getResponsibleParties();
            for (ResponsibleParty rp : ass) {
                AssociationList al;
                Iterator enu;
                String role = rp.getRole();
                if (!role.equalsIgnoreCase("owner") && !role.equalsIgnoreCase("publisher") || !(enu = (al = rp.getPersons()).iterator()).hasNext()) continue;
                Person person = (Person)enu.next();
                OMRPerson op = new OMRPerson(person);
                op.setRepository(this._repository);
                return op;
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return null;
    }

    @Override
    public String getPublisherAlias() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            AssociationList ass = arc.getResponsibleParties();
            for (ResponsibleParty rp : ass) {
                AssociationList al;
                Iterator enu;
                String role = rp.getRole();
                if (!role.equalsIgnoreCase("owner") && !role.equalsIgnoreCase("publisher") || !(enu = (al = rp.getPersons()).iterator()).hasNext()) continue;
                Person person = (Person)enu.next();
                OMRPerson op = new OMRPerson(person);
                op.setRepository(this._repository);
                StringBuffer buf = new StringBuffer(op.getName().length() + 5);
                buf.append("\"\" \"");
                buf.append(op.getName());
                buf.append('\"');
                return buf.toString();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return null;
    }

    @Override
    public long getCreationDate() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            AssociationList ass = arc.getTimestamps();
            for (Timestamp timestamp : ass) {
                long l;
                String role = timestamp.getTimestampRole();
                if (!role.equalsIgnoreCase("Creation")) continue;
                double time = timestamp.getDateandTime();
                long javaDate = DateUtil.SASDateTimeToJavaDate((double)time, (TimeZone)TimeZone.getTimeZone("GMT"));
                if (javaDate < 0L && (l = SASDateTimeFormat.SASDateToJavaDate((double)time)) >= 0L) {
                    javaDate = l;
                }
                return javaDate;
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return -1L;
    }

    @Override
    public String getCreationDateString() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        long creat = this.getCreationDate();
        if (creat < 0L) {
            return null;
        }
        Date date = new Date(creat);
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd:HH:mm:ss");
        TimeZone tz = TimeZone.getTimeZone("GMT");
        format.setTimeZone(tz);
        String dateString = format.format(date);
        return dateString;
    }

    @Override
    public long getExpirationDate() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            AssociationList ass = arc.getTimestamps();
            for (Timestamp timestamp : ass) {
                long l;
                String role = timestamp.getTimestampRole();
                if (!role.equalsIgnoreCase("Expiration")) continue;
                double time = timestamp.getDateandTime();
                long javaDate = DateUtil.SASDateTimeToJavaDate((double)time, (TimeZone)TimeZone.getTimeZone("GMT"));
                if (javaDate < 0L && (l = SASDateTimeFormat.SASDateToJavaDate((double)time)) >= 0L) {
                    javaDate = l;
                }
                return javaDate;
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return -1L;
    }

    @Override
    public String getExpirationDateString() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        long expir = this.getExpirationDate();
        if (expir < 0L) {
            return null;
        }
        Date date = new Date(expir);
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd:HH:mm:ss");
        TimeZone tz = TimeZone.getTimeZone("GMT");
        format.setTimeZone(tz);
        String dateString = format.format(date);
        return dateString;
    }

    @Override
    public String getAbstract() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            AssociationList ass = arc.getNotes();
            for (TextStore text : ass) {
                String role = text.getTextRole();
                if (!role.equalsIgnoreCase("Abstract")) continue;
                return text.getStoredText();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return null;
    }

    @Override
    public AttributeMapInterface getProperties() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        AttributeMap result = null;
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            AssociationList ass = arc.getProperties();
            Iterator it = ass.iterator();
            if (it.hasNext()) {
                result = new AttributeMap();
            }
            while (it.hasNext()) {
                Property prop = (Property)it.next();
                result.addAttribute(prop.getPropertyName(), prop.getDefaultValue());
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result;
    }

    @Override
    public ContentDestination getContentDestination() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        ServerInterface si = null;
        String relPath = null;
        String basePath = null;
        DirectoryInterface dir = null;
        DirectoryInterface baseDir = null;
        try {
            Directory cd;
            AssociationList directories = arc.getDirectories();
            if (directories.size() > 0 && (cd = (Directory)directories.get(0)) != null) {
                dir = (DirectoryInterface)this._repository.factoryProcess((Object)cd);
                relPath = cd.getDirectoryName();
                Directory parentDir = cd.getParent();
                if (parentDir != null) {
                    baseDir = (DirectoryInterface)this._repository.factoryProcess((Object)parentDir);
                    basePath = parentDir.getDirectoryName();
                    AssociationList servers = parentDir.getDeployedComponents();
                    if (servers != null && servers.size() > 0) {
                        DeployedComponent dc = (DeployedComponent)servers.get(0);
                        si = (ServerInterface)this._repository.factoryProcess((Object)dc);
                    }
                } else {
                    baseDir = dir;
                    AssociationList servers = cd.getDeployedComponents();
                    for (DeployedComponent dc : servers) {
                        String cid = dc.getClassIdentifier();
                        if (!cid.equals("CBA26437-1577-4FF8-93F6-9B68B4DD8D2E") && !cid.equals("DAC0D7F0-10DA-11D6-8816-AA0004006D06")) continue;
                        si = (ServerInterface)this._repository.factoryProcess((Object)dc);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return new ContentDestination(dir, relPath, basePath, si, baseDir);
    }

    public void delete() throws ServiceException, RemoteException {
        this.checkPulse(false);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            ResultPackageInterface rpkg = (ResultPackageInterface)this.newServiceObject();
            rpkg.delete();
        }
        catch (ServiceException ex) {
            this.handleDeleteException((Exception)((Object)ex));
        }
        catch (RemoteException ex) {
            this.handleDeleteException(ex);
        }
        catch (ClassCastException ex) {
            this.handleDeleteException(ex);
        }
        try {
            OMIRepositoryInterface ri = (OMIRepositoryInterface)this._repository;
            ArrayList tstamps = new ArrayList(arc.getTimestamps());
            for (Timestamp timestamp : tstamps) {
                AssociationList objAss = timestamp.getObjects();
                if (objAss.size() > 1) continue;
                ri.deleteEntity((CMetadata)timestamp);
            }
            ArrayList noteList = new ArrayList(arc.getNotes());
            for (TextStore text : noteList) {
                AssociationList objAss = text.getObjects();
                if (objAss.size() > 1) continue;
                ri.deleteEntity((CMetadata)text);
            }
            ArrayList guidList = new ArrayList(arc.getExternalIdentities());
            for (ExternalIdentity ei : guidList) {
                ri.deleteEntity((CMetadata)ei);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        super.delete();
    }

    public Object newServiceObject() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        UserContextInterface uc = this._repository.getUserContext();
        ArchiveTransport archiveT = new ArchiveTransport((PackageInterface)this, uc.getSessionContext());
        ResultPackageInterface rpkg = archiveT.getResultPackage();
        return rpkg;
    }

    @Override
    public String getDisplayName() throws ServiceException, RemoteException {
        String name = null;
        String desc = this.getDescription();
        name = desc == null || desc.equals("") ? this.getName() : desc;
        return name;
    }

    @Override
    public String getDisplayDescription() throws ServiceException, RemoteException {
        return this.getAbstract();
    }

    @Override
    public boolean isExpired() throws RemoteException, ServiceException {
        return PackageUtil.isExpired(this.getExpirationDate());
    }

    public PathUrl getPathUrl() throws IllegalStateException, ServiceException, RemoteException {
        ChannelInterface myChannel = this.getChannel();
        if (myChannel == null) {
            return super.getPathUrl();
        }
        PathUrl channelPath = (PathUrl)myChannel.getPathUrl().clone();
        channelPath.setName(PathUrl.encodeString((String)channelPath.getName()));
        channelPath.setExtendedPath(PathUrl.encodeString((String)this.getName()) + "(" + this.getType() + ")");
        return channelPath;
    }

    private void handleException(Exception ex) throws ServiceException, RemoteException {
        Logger logger = LogManager.getLogger(OMRPackage.class);
        if (logger != null) {
            logger.warn(RB.getStringResource("Metadata.accessexcept.msg.txt"), (Throwable)ex);
        }
    }

    private void handleDeleteException(Exception ex) throws ServiceException, RemoteException {
        Logger logger = LogManager.getLogger(OMRPackage.class);
        if (logger != null) {
            logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OMRPackage.deletePkgErr.fmt.txt", (Object)this.getName()), (Throwable)ex);
        }
    }
}

