/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.ArchiveFile;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ITChannel;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Timestamp;
import com.sas.metadata.remote.impl.ArchiveFileImpl;
import com.sas.metadata.remote.impl.ArchiveFileImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.publish.metadata.ArchiveInterface;
import com.sas.services.publish.metadata.OMRPackage;
import com.sas.services.publish.metadata.RB;
import com.sas.services.util.AttributeMapInterface;
import com.sas.services.util.DateUtil;
import java.rmi.RemoteException;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class OMRArchive
extends OMRPackage
implements ArchiveInterface {
    public OMRArchive() throws RemoteException {
        super(OMRArchive.class);
    }

    public OMRArchive(ArchiveFile o) throws RemoteException {
        super(o, OMRArchive.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRArchive(ArchiveFileImpl o) throws RemoteException {
        super(o, OMRArchive.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRArchive(ArchiveFileImpl_Stub o) throws RemoteException {
        super((ArchiveFile)o, OMRArchive.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRArchive(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block6: {
            super(OMRArchive.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                ArchiveFile archive = (ArchiveFile)omirepository.createMetadata(name, "ArchiveFile");
                archive.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = archive;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent != null) {
                    try {
                        parent.addItem((MetadataInterface)this);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable t) {
                Logger logger = LogManager.getLogger(OMRArchive.class);
                if (logger == null) break block6;
                logger.warn(RB.getStringResource("Metadata.accessexcept.msg.txt"), t);
            }
        }
    }

    @Override
    public void setChannel(ChannelInterface channel) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        arc.setOwningChannel((ITChannel)channel.getRepositoryEntity());
    }

    @Override
    public void setAbstract(String text) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            AssociationList ass = arc.getNotes();
            for (TextStore textStore : ass) {
                String role = textStore.getTextRole();
                if (!role.equalsIgnoreCase("Abstract")) continue;
                textStore.setStoredText(text);
                return;
            }
            MdObjectStore store = (MdObjectStore)arc.getObjectStore();
            MdFactory factory = store.getFactory();
            TextStore textStore = (TextStore)factory.createComplexMetadataObject(store, null, "Abstract", "TextStore", arc.getRepositoryID());
            textStore.setTextRole("Abstract");
            textStore.setStoredText(text);
            ass.add((Object)textStore);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setDescription(String description) throws RemoteException {
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            arc.setDesc(description);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setName(String name) throws RemoteException {
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            arc.setName(name);
            arc.setFileName(name);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setProperties(AttributeMapInterface map) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            AssociationList propList = arc.getProperties();
            propList.clear();
            MdObjectStore store = (MdObjectStore)arc.getObjectStore();
            MdFactory factory = store.getFactory();
            PropertyType type = (PropertyType)factory.createComplexMetadataObject(store, null, "StringType", "PropertyType", arc.getRepositoryID());
            type.setSQLType(12);
            String[] names = map.listAttributeNames();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                String[] values = map.getAttributes(name);
                for (int j = 0; j < values.length; ++j) {
                    String value = values[j];
                    Property prop = (Property)factory.createComplexMetadataObject(store, null, "property", "Property", arc.getRepositoryID());
                    prop.setName(name);
                    prop.setPropertyName(name);
                    prop.setDefaultValue(value);
                    prop.setOwningType(type);
                    propList.add((Object)prop);
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setCreationDate(long date) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        double sasDate = DateUtil.javaDateToSASDateTime((long)date, (TimeZone)TimeZone.getTimeZone("GMT"));
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            AssociationList ass = arc.getTimestamps();
            for (Timestamp timestamp : ass) {
                String role = timestamp.getTimestampRole();
                if (!role.equalsIgnoreCase("Creation")) continue;
                timestamp.setDateandTime(sasDate);
                return;
            }
            MdObjectStore store = (MdObjectStore)arc.getObjectStore();
            MdFactory factory = store.getFactory();
            Timestamp timestamp = (Timestamp)factory.createComplexMetadataObject(store, null, "Creation", "Timestamp", arc.getRepositoryID());
            timestamp.setTimestampRole("Creation");
            timestamp.setDateandTime(sasDate);
            ass.add((Object)timestamp);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setExpirationDate(long date) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        double sasDate = DateUtil.javaDateToSASDateTime((long)date, (TimeZone)TimeZone.getTimeZone("GMT /* I18nOK:EMS */"));
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            AssociationList ass = arc.getTimestamps();
            for (Timestamp timestamp : ass) {
                String role = timestamp.getTimestampRole();
                if (!role.equalsIgnoreCase("Expiration")) continue;
                timestamp.setDateandTime(sasDate);
                return;
            }
            MdObjectStore store = (MdObjectStore)arc.getObjectStore();
            MdFactory factory = store.getFactory();
            Timestamp timestamp = (Timestamp)factory.createComplexMetadataObject(store, null, "Expiration", "Timestamp", arc.getRepositoryID());
            timestamp.setTimestampRole("Expiration");
            timestamp.setDateandTime(sasDate);
            ass.add((Object)timestamp);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setDirectory(DirectoryInterface directory) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            AssociationList ass = arc.getDirectories();
            ass.clear();
            ass.add(directory.getRepositoryEntity());
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setPublisher(PersonInterface publisher) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArchiveFile arc = (ArchiveFile)this._repositoryObject;
        try {
            MdObjectStore store = (MdObjectStore)arc.getObjectStore();
            MdFactory factory = store.getFactory();
            ResponsibleParty rp = factory.getOMIUtil().getResponsibleParty(store, publisher.getName(), "publisher", "", 2056);
            AssociationList ass = arc.getResponsibleParties();
            ass.clear();
            ass.add((Object)rp);
            arc.setResponsibleParties(ass);
        }
        catch (MdException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    private void handleException(Exception ex) throws RemoteException {
        Logger logger = LogManager.getLogger(OMRArchive.class);
        if (logger != null) {
            logger.warn(RB.getStringResource("Metadata.accessexcept.msg.txt"), (Throwable)ex);
        }
    }
}

